/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.db.JAutoCompComboBox;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.tests.forms.TestDataObj;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class PickListTestApp {
    private static final Logger log = Logger.getLogger(PickListTestApp.class);
    protected JPanel contentPane;
    protected JFrame mainFrame;
    protected String currViewSetName;
    protected int currFormId;
    protected Object dataObj = null;
    protected TestDataObj testDataObj = null;
    protected List<TestDataObj> list = new ArrayList<TestDataObj>();

    public PickListTestApp() {
        HibernateUtil.initialize();
    }

    private void initialize() {
        SpecifyAppPrefs.initialPrefs();
        try {
            if (!System.getProperty("os.name").equals("Mac OS X")) {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PickListTestApp.class, e);
            log.error((Object)"Can't change L&F: ", (Throwable)e);
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.mainFrame = new JFrame("Specify Form Editor");
        this.mainFrame.setDefaultCloseOperation(3);
        UIRegistry.setTopWindow(this.mainFrame);
        this.contentPane = this.buildContentPane();
        this.contentPane.setOpaque(true);
        this.mainFrame.setContentPane(this.contentPane);
        JMenuBar menuBar = this.createMenus();
        if (menuBar != null) {
            this.mainFrame.setJMenuBar(menuBar);
        }
        this.mainFrame.pack();
        UIHelper.centerAndShow(this.mainFrame);
    }

    private JPanel buildContentPane() {
        FormLayout formLayout = new FormLayout("p,1dlu,p,1dlu,p", "p,2dlu,p,2dlu,p,2dlu,p");
        PanelBuilder builder = new PanelBuilder(formLayout);
        CellConstraints cc = new CellConstraints();
        JAutoCompComboBox cb = JAutoCompComboBox.create("test_combobox", false, 50, true);
        cb.setEditable(true);
        int y = 1;
        builder.add((Component)new JLabel("Enter Value:"), cc.xy(1, y));
        builder.add((Component)cb, cc.xy(3, y));
        builder.add((Component)new JLabel(" (Editable)"), cc.xy(5, y));
        cb = JAutoCompComboBox.create("AccessionStatus", true, 50, false);
        cb.setEditable(true);
        cb.setCaseInsensitive(true);
        cb.setEnableAdditions(false);
        builder.add((Component)new JLabel("Enter Status:"), cc.xy(1, y += 2));
        builder.add((Component)cb, cc.xy(3, y));
        builder.add((Component)new JLabel(" (Not Editable)"), cc.xy(5, y));
        JAutoCompTextField text = JAutoCompTextField.create("test_textfield", false, 2, true);
        text.setAskBeforeSave(false);
        builder.add((Component)new JLabel("Enter Text:"), cc.xy(1, y += 2));
        builder.add((Component)text, cc.xy(3, y));
        builder.add((Component)new JLabel(" (Editable)"), cc.xy(5, y));
        Component valCBX = null;
        builder.add((Component)new JLabel("Enter ValCBX:"), cc.xy(1, y += 2));
        builder.add(valCBX, cc.xy(3, y));
        builder.add((Component)new JLabel(" (Editable)"), cc.xy(5, y));
        y += 2;
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return builder.getPanel();
    }

    public JMenuBar createMenus() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = this.createMenu(mb, "FileMenu", "FileMneu");
        JMenuItem mi = this.createMenuItem(menu, "Exit", "x", "Exit Appication", false, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PickListTestApp.this.doExit();
            }
        });
        menu = this.createMenu(mb, "EditMenu", "EditMneu");
        mi = this.createMenuItem(menu, "Preferences", "P", "Preferences", false, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        return mb;
    }

    protected JMenu createMenu(JMenuBar menuBar, String labelKey, String mneuKey) {
        JMenu menu = null;
        try {
            menu = menuBar.add(new JMenu(UIRegistry.getResourceString(labelKey)));
            menu.setMnemonic(UIRegistry.getResourceString(mneuKey).charAt(0));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PickListTestApp.class, ex);
            ex.printStackTrace();
            log.info((Object)("Couldn't create menu for " + labelKey + "  " + mneuKey));
        }
        return menu;
    }

    protected void doExit() {
        System.exit(0);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    protected JMenuItem createMenuItem(JMenu aMenu, String aLabel, String aMnemonic, String aAccessibleDescription, boolean aEnabled, AbstractAction aAction) {
        JMenuItem mi = aMenu.add(new JMenuItem(aLabel));
        if (aMnemonic.length() > 0) {
            mi.setMnemonic(aMnemonic.charAt(0));
        }
        mi.getAccessibleContext().setAccessibleDescription(aAccessibleDescription);
        mi.addActionListener(aAction);
        if (aAction != null) {
            aAction.addPropertyChangeListener(this.createActionChangeListener(mi));
            aAction.setEnabled(aEnabled);
        }
        return mi;
    }

    public static void loadData() {
        Session session = HibernateUtil.getCurrentSession();
        try {
            try {
                HibernateUtil.beginTransaction();
                String[] states = new String[]{"AL", "Alabama - AL", "AK", "Alaska - AK", "AZ", "Arizona - AZ", "AR", "Arkansas - AR", "CA", "California - CA", "CO", "Colorado - CO", "CT", "Connecticut - CT", "DC", "Dist. of Columbia - DC", "DE", "Delaware - DE", "FL", "Florida - FL", "GA", "Georgia - GA", "HI", "Hawaii - HI", "ID", "Idaho - ID", "IL", "Illinois - IL", "IN", "Indiana - IN", "IA", "Iowa - IA", "KS", "Kansas - KS", "KY", "Kentucky - KY", "LA", "Louisiana - LA", "ME", "Maine - ME", "MD", "Maryland - MD", "MA", "Massachusetts - MA ", "MI", "Michigan - MI", "MN", "Minnesota - MN", "MS", "Mississippi - MS", "MO", "Missouri - MO", "MT", "Montana - MT", "NE", "Nebraska - NE", "NV", "Nevada - NV", "NH", "New Hampshire - NH", "NJ", "New Jersey - NJ", "NM", "New Mexico - NM", "NY", "New York - NY", "NC", "North Carolina - NC", "ND", "North Dakota - ND", "OH", "Ohio - OH", "OK", "Oklahoma - OK", "OR", "Oregon - OR", "PA", "Pennsylvania - PA", "PR", "Puerto Rico - PR", "RI", "Rhode Island - RI", "SC", "South Carolina - SC", "SD", "South Dakota - SD", "TN", "Tennessee - TN", "TX", "Texas - TX", "UT", "Utah - UT", "VT", "Vermont - VT", "VA", "Virginia - VA", "WA", "Washington - WA", "WV", "West Virginia - WV", "WI", "Wisconsin - WI", "WY", "Wyoming - WY"};
                PickList pl = new PickList();
                pl.initialize();
                pl.setName("states");
                pl.setSizeLimit(50);
                pl.setReadOnly(true);
                int i = 0;
                while (i < states.length) {
                    pl.addItem(states[i], states[i + 1]);
                    System.out.println("[" + states[++i] + "][" + states[i + 1] + "]");
                    ++i;
                }
                session.save((Object)pl);
                HibernateUtil.commitTransaction();
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PickListTestApp.class, e);
                HibernateUtil.rollbackTransaction();
                e.printStackTrace();
                HibernateUtil.closeSession();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    protected static void testLookUpDB() {
        try {
            Connection dbConnection = DBConnection.getInstance().createConnection();
            Statement dbStatement = dbConnection.createStatement();
            Vector<String> list = new Vector<String>();
            long start = System.currentTimeMillis();
            ResultSet rs = dbStatement.executeQuery(" select taxon from taxon where taxon like 's%'");
            rs.first();
            do {
                list.addElement(rs.getString(1));
            } while (rs.next());
            long end = System.currentTimeMillis();
            System.out.println(String.valueOf(end - start) + " Items: " + list.size());
            dbStatement.close();
            dbConnection.close();
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(PickListTestApp.class, ex);
            ex.printStackTrace();
        }
    }

    public static File getIndexDirPath() {
        File path = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "Specify" + File.separator + "taxa-index-dir");
        if (!path.exists() && !path.mkdirs()) {
            String msg = "unable to create directory [" + path.getAbsolutePath() + "]";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return path;
    }

    public static void main(String[] args) {
        DBConnection dbConn = DBConnection.getInstance();
        dbConn.setUsernamePassword("rods", "rods");
        dbConn.setDriver("com.mysql.jdbc.Driver");
        dbConn.setConnectionStr("jdbc:mysql://localhost/");
        dbConn.setDatabaseName("demo_fish3");
        PickListTestApp pickListTestApp = new PickListTestApp();
        pickListTestApp.initialize();
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }
}

