/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.util.LatLonConverter;
import java.math.BigDecimal;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class LatLonConversionTest
extends TestCase {
    protected static final Logger log = Logger.getLogger(LatLonConversionTest.class);
    protected int decimalLen = 10;

    public void testConvertToDDMMSS() {
        BigDecimal before = new BigDecimal("38.95402");
        String str = LatLonConverter.convertToDDMMSS(before, this.decimalLen);
        BigDecimal after = LatLonConverter.convertDDMMSSStrToDDDDBD(str, "N");
        LatLonConversionTest.assertEquals((String)str, (String)"38 57 14.472");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Latitude, LatLonConverter.FORMAT.DDMMSS, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57 14.472 N");
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Longitude, LatLonConverter.FORMAT.DDMMSS, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57 14.472 E");
        before = new BigDecimal("-38.95402");
        str = LatLonConverter.convertToDDMMSS(before, this.decimalLen);
        after = LatLonConverter.convertDDMMSSStrToDDDDBD(str, "S");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Latitude, LatLonConverter.FORMAT.DDMMSS, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57 14.472 S");
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Longitude, LatLonConverter.FORMAT.DDMMSS, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57 14.472 W");
        before = new BigDecimal("38.95402");
        str = LatLonConverter.convertToDDMMSS(before, this.decimalLen);
        after = LatLonConverter.convertDDMMSSStrToDDDDBD(str, "E");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        before = new BigDecimal("-38.95402");
        str = LatLonConverter.convertToDDMMSS(before, this.decimalLen);
        after = LatLonConverter.convertDDMMSSStrToDDDDBD(str, "W");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
    }

    public void testConvertToDDMMMM() {
        BigDecimal before = new BigDecimal("38.95402");
        String str = LatLonConverter.convertToDDMMMM(before, this.decimalLen);
        BigDecimal after = LatLonConverter.convertDDMMMMStrToDDDDBD(str, "N");
        LatLonConversionTest.assertEquals((String)str, (String)"38 57.2412");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Latitude, LatLonConverter.FORMAT.DDMMMM, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57.2412 N");
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Longitude, LatLonConverter.FORMAT.DDMMMM, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57.2412 E");
        before = new BigDecimal("-38.95402");
        str = LatLonConverter.convertToDDMMMM(before, this.decimalLen);
        after = LatLonConverter.convertDDMMMMStrToDDDDBD(str, "S");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Latitude, LatLonConverter.FORMAT.DDMMMM, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57.2412 S");
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Longitude, LatLonConverter.FORMAT.DDMMMM, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38 57.2412 W");
        before = new BigDecimal("38.95402");
        str = LatLonConverter.convertToDDMMMM(before, this.decimalLen);
        after = LatLonConverter.convertDDMMMMStrToDDDDBD(str, "E");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        before = new BigDecimal("-38.95402");
        str = LatLonConverter.convertToDDMMMM(before, this.decimalLen);
        after = LatLonConverter.convertDDMMMMStrToDDDDBD(str, "W");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
    }

    public void testOneMinute() {
        BigDecimal latitude = LatLonConverter.convertDDMMMMStrToDDDDBD("1 1", "N");
        String ddmmVal = LatLonConverter.convertToDDMMMM(latitude, this.decimalLen);
        String s1 = String.format("%10.7f", latitude);
        String s2 = String.format("%10.7f", 1.01666666667);
        log.info((Object)(String.valueOf(s1) + "  " + s2 + "  " + ddmmVal));
        LatLonConversionTest.assertTrue((boolean)s1.equals(s2));
    }

    public void testConvertDDDDToDDDDString() {
        BigDecimal before = new BigDecimal("38.95402");
        String str = LatLonConverter.convertToDDDDDD(before, this.decimalLen);
        BigDecimal after = LatLonConverter.convertDDDDStrToDDDDBD(str, "N");
        LatLonConversionTest.assertEquals((String)str, (String)"38.95402");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Latitude, LatLonConverter.FORMAT.DDDDDD, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38.95402 N");
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Longitude, LatLonConverter.FORMAT.DDDDDD, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38.95402 E");
        before = new BigDecimal("-38.95402");
        str = LatLonConverter.convertToDDDDDD(before, this.decimalLen);
        after = LatLonConverter.convertDDDDStrToDDDDBD(str, "S");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Latitude, LatLonConverter.FORMAT.DDDDDD, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38.95402 S");
        LatLonConversionTest.assertEquals((String)LatLonConverter.format(before, LatLonConverter.LATLON.Longitude, LatLonConverter.FORMAT.DDDDDD, LatLonConverter.DEGREES_FORMAT.String, this.decimalLen), (String)"38.95402 W");
        before = new BigDecimal("38.95402");
        str = LatLonConverter.convertToDDDDDD(before, this.decimalLen);
        after = LatLonConverter.convertDDDDStrToDDDDBD(str, "E");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        before = new BigDecimal("-38.95402");
        str = LatLonConverter.convertToDDDDDD(before, this.decimalLen);
        after = LatLonConverter.convertDDDDStrToDDDDBD(str, "W");
        before = new BigDecimal("0.0");
        str = LatLonConverter.convertToDDDDDD(before, this.decimalLen);
        after = LatLonConverter.convertDDDDStrToDDDDBD(str, "W");
        LatLonConversionTest.assertEquals((String)str, (String)"0.0");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
        before = new BigDecimal("-0.0");
        str = LatLonConverter.convertToDDDDDD(before, this.decimalLen);
        after = LatLonConverter.convertDDDDStrToDDDDBD(str, "W");
        LatLonConversionTest.assertEquals((String)str, (String)"0.0");
        LatLonConversionTest.assertEquals((Object)before.doubleValue(), (Object)after.doubleValue());
    }

    public void testDegreesSymbol() {
        BigDecimal before = new BigDecimal("38.95402");
        String str = LatLonConverter.convertToDDDDDD(before, LatLonConverter.DEGREES_FORMAT.Symbol, LatLonConverter.DIRECTION.NorthSouth, this.decimalLen);
        log.info((Object)str);
        str = LatLonConverter.convertToDDDDDD(before, LatLonConverter.DEGREES_FORMAT.String, LatLonConverter.DIRECTION.NorthSouth, this.decimalLen);
        log.info((Object)str);
        str = LatLonConverter.convertToDDDDDD(before, LatLonConverter.DEGREES_FORMAT.Symbol, LatLonConverter.DIRECTION.EastWest, this.decimalLen);
        log.info((Object)str);
        str = LatLonConverter.convertToDDDDDD(before, LatLonConverter.DEGREES_FORMAT.String, LatLonConverter.DIRECTION.EastWest, this.decimalLen);
        log.info((Object)str);
        LatLonConversionTest.assertTrue((boolean)true);
    }
}

