/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.SearchFieldConfig;
import junit.framework.TestCase;

public class ExpressSearchConfigTest
extends TestCase {
    protected DisplayFieldConfig createDisplayField(String fieldName, String formatter, Integer order) {
        return new DisplayFieldConfig(fieldName, formatter, order);
    }

    protected SearchFieldConfig createSearchField(String fieldName, Boolean isSortable, Boolean isAscending) {
        return new SearchFieldConfig(fieldName, isSortable, isAscending);
    }

    public void testToFromXML() {
        SearchConfig config = new SearchConfig();
        config.addDisplayField("Agent", this.createDisplayField("lastName", "", 0));
        config.addDisplayField("Agent", this.createDisplayField("firstName", "", 1));
        config.addDisplayField("Agent", this.createDisplayField("name", "", 2));
        config.addDisplayField("Taxon", this.createDisplayField("fullName", "", 0));
        config.addSearchField("Taxon", this.createSearchField("fullName", false, true));
        config.addSearchField("Agent", this.createSearchField("lastName", true, true));
        config.addSearchField("Agent", this.createSearchField("name", true, true));
        XStream xstream = new XStream();
        SearchConfig.configXStream(xstream);
        String xmlStr = xstream.toXML((Object)config);
        System.out.println(xmlStr);
        SearchConfig config2 = (SearchConfig)xstream.fromXML(xmlStr);
        ExpressSearchConfigTest.assertTrue((boolean)config2.isDisplayFieldInList("Agent", "lastName"));
        ExpressSearchConfigTest.assertTrue((boolean)config2.isSearchFieldInList("Agent", "lastName"));
        ExpressSearchConfigTest.assertTrue((boolean)config2.isDisplayFieldInList("Taxon", "fullName"));
        ExpressSearchConfigTest.assertTrue((boolean)config2.isSearchFieldInList("Taxon", "fullName"));
    }

    public void testRemove() {
        SearchConfig config = new SearchConfig();
        config.addDisplayField("Agent", this.createDisplayField("lastName", "", 0));
        config.addDisplayField("Agent", this.createDisplayField("firstName", "", 1));
        config.addDisplayField("Agent", this.createDisplayField("name", "", 2));
        config.addDisplayField("Taxon", this.createDisplayField("fullName", "", 0));
        config.addSearchField("Taxon", this.createSearchField("fullName", false, true));
        config.addSearchField("Agent", this.createSearchField("lastName", true, true));
        config.addSearchField("Agent", this.createSearchField("name", true, true));
        ExpressSearchConfigTest.assertTrue((boolean)config.isDisplayFieldInList("Agent", "lastName"));
        ExpressSearchConfigTest.assertTrue((boolean)config.isSearchFieldInList("Agent", "lastName"));
        ExpressSearchConfigTest.assertTrue((boolean)config.isDisplayFieldInList("Taxon", "fullName"));
        ExpressSearchConfigTest.assertTrue((boolean)config.isSearchFieldInList("Taxon", "fullName"));
        config.removeDisplayField("Agent", "lastName");
        config.removeSearchField("Agent", "firstName");
        config.removeSearchField("Taxon", "fullName");
        config.removeDisplayField("Taxon", "fullName");
        ExpressSearchConfigTest.assertFalse((boolean)config.isDisplayFieldInList("Agent", "lastName"));
        ExpressSearchConfigTest.assertFalse((boolean)config.isSearchFieldInList("Agent", "firstName"));
        ExpressSearchConfigTest.assertFalse((boolean)config.isDisplayFieldInList("Taxon", "fullName"));
        ExpressSearchConfigTest.assertFalse((boolean)config.isSearchFieldInList("Taxon", "fullName"));
    }
}

