/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.ui.DateParser;
import junit.framework.TestCase;

public class DateParserTests
extends TestCase {
    public void testDateType() {
        DateParser.DateFormatType[] types = new DateParser.DateFormatType[]{DateParser.DateFormatType.YYYY_AA_BB, DateParser.DateFormatType.YYYY_A_BB, DateParser.DateFormatType.YYYY_AA_B, DateParser.DateFormatType.YYYY_A_B, DateParser.DateFormatType.AA_BB_YYYY, DateParser.DateFormatType.A_BB_YYYY, DateParser.DateFormatType.AA_B_YYYY, DateParser.DateFormatType.A_B_YYYY};
        String[] format = new String[]{"yyyy/MM/dd", "yyyy/M/dd", "yyyy/MM/d", "yyyy/M/d", "MM/dd/yyyy", "M/dd/yyyy", "MM/d/yyyy", "M/d/yyyy"};
        int i = 0;
        while (i < 8) {
            System.out.println((Object)((Object)types[i]) + " " + format[i] + " " + (DateParser.getDateFormatType(format[i]) == types[i]));
            if (DateParser.getDateFormatType(format[i]) != types[i]) {
                DateParser.getDateFormatType(format[i]);
                int x = 0;
                ++x;
            }
            DateParserTests.assertTrue((DateParser.getDateFormatType(format[i]) == types[i] ? 1 : 0) != 0);
            ++i;
        }
        int x = 0;
        ++x;
    }

    public void testDateStrs() {
        String[] defaultFormatters;
        String[] stringArray = defaultFormatters = new String[]{"yyyy/MM/dd", "yyyy/M/dd", "yyyy/MM/d", "yyyy/M/d", "MM/dd/yyyy", "M/dd/yyyy", "MM/d/yyyy", "M/d/yyyy", "yyyy-MM-dd", "yyyy-M-dd", "yyyy-MM-d", "yyyy-M-d", "MM-dd-yyyy", "M-dd-yyyy", "MM-d-yyyy", "M-d-yyyy", "yyyy.MM.dd", "yyyy.M.dd", "yyyy.MM.d", "yyyy.M.d", "MM.dd.yyyy", "M.dd.yyyy", "MM.d.yyyy", "M.d.yyyy"};
        int n = defaultFormatters.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultFormat = stringArray[n2];
            String[] dateStrs = new String[]{"2001/01/11", "2001/1/11", "2001/01/1", "2001/1/1", "01/11/2001", "1/11/2001", "01/1/2001", "1/1/2001", "2001.01.11", "2001.1.11", "2001.01.1", "2001.1.1", "01.11.2001", "1.11.2001", "01.1.2001", "1.1.2001", "2001-01-11", "2001-1-11", "2001-01-1", "2001-1-1", "01-11-2001", "1-11-2001", "01-1-2001", "1-1-2001"};
            DateParser dd = new DateParser(defaultFormat);
            String[] stringArray2 = dateStrs;
            int n3 = dateStrs.length;
            int n4 = 0;
            while (n4 < n3) {
                String dStr = stringArray2[n4];
                System.out.println(String.valueOf(dStr) + " " + (dd.parseDate(dStr) != null));
                ++n4;
            }
            ++n2;
        }
    }

    public void testValid() {
        String[] dateStrs;
        String defaultFormat = "yyyy/MM/dd";
        DateParser dd = new DateParser(defaultFormat);
        String[] stringArray = dateStrs = new String[]{"2001/0D/11", "d001/1/11", "201/01/1", "2001//1", "2001/13/11", "2001/12/32", "2001/2/29", "2001/00/00"};
        int n = dateStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String dateStr = stringArray[n2];
            System.out.println(String.valueOf(dateStr) + " " + dd.parseDate(dateStr));
            if (dateStr.equals("2001/12/32")) {
                int x = 0;
                ++x;
            }
            DateParserTests.assertTrue((dd.parseDate(dateStr) == null ? 1 : 0) != 0);
            ++n2;
        }
        DateParserTests.assertTrue((dd.parseDate("02/29/2000") != null ? 1 : 0) != 0);
        DateParserTests.assertTrue((dd.parseDate("02/29/2004") != null ? 1 : 0) != 0);
        DateParserTests.assertTrue((dd.parseDate("00/29/2000", true, false) != null ? 1 : 0) != 0);
        DateParserTests.assertTrue((dd.parseDate("00/00/2004", true, true) != null ? 1 : 0) != 0);
        System.out.println(dd.parseDate("00/29/2000", true, true));
        System.out.println(dd.parseDate("00/00/2004", true, true));
    }
}

