/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tests;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import org.apache.log4j.Logger;

public class AppPreferenceHelper {
    private static final String databaseName = "fish";
    private static final Logger log = Logger.getLogger(AppPreferenceHelper.class);

    public static void setupPreferences() {
        log.info((Object)"Setup - Loading preferences...");
        UIRegistry.getInstance();
        if (UIRegistry.getAppName() == null) {
            System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
            System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
            System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
            System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
            System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
            System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
            UIRegistry.getInstance();
            UIRegistry.setAppName("Specify");
            AppPreferences localPrefs = AppPreferences.getLocalPrefs();
            localPrefs.setDirPath(UIRegistry.getAppDataDir());
            localPrefs.load();
            String hostName = "localhost";
            Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
            if (!UIHelper.tryLogin("com.mysql.jdbc.Driver", "org.hibernate.dialect.MySQLDialect", databaseName, "jdbc:mysql://" + hostName + "/" + databaseName, (String)usernamePassword.first, (String)usernamePassword.second)) {
                throw new RuntimeException("Couldn't login into [fish] " + DBConnection.getInstance().getErrorMsg());
            }
            HibernateUtil.getCurrentSession();
            AppPreferences.getRemote().load();
            log.info((Object)"Loaded preferences");
        }
    }

    public static void main(String[] args) {
    }
}

