/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.TreeMapElement;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDef;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDefRel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDefTree;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.util.DatamodelHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WorkbenchUploadMapper {
    protected static boolean debugging = true;
    protected static final Logger log = Logger.getLogger(WorkbenchUploadMapper.class);
    protected final Collection<WorkbenchTemplateMappingItem> wbtItems;
    protected Vector<Short> mappedItems = null;
    protected Vector<UploadMappingDef> maps = null;
    protected Map<String, DefInfo> defs;
    protected Map<String, TreeLevelInfo> taxonLevels;
    protected Map<String, TreeLevelInfo> geoLevels;
    protected Map<String, TreeLevelInfo> lithoLevels;
    protected Map<String, TreeLevelInfo> chronoLevels;
    protected Map<String, TreeLevelInfo> storageLevels;

    protected Map<String, DefInfo> buildDefs() {
        Element xmlDef = this.getXMLDef();
        if (xmlDef != null) {
            HashMap<String, DefInfo> result = new HashMap<String, DefInfo>();
            Iterator i = xmlDef.elementIterator("field");
            while (i.hasNext()) {
                Element fld = (Element)i.next();
                try {
                    result.put(String.valueOf(fld.attributeValue("table").toLowerCase()) + "." + fld.attributeValue("name").toLowerCase(), new DefInfo(fld));
                }
                catch (NumberFormatException numEx) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(WorkbenchUploadMapper.class, numEx);
                    log.error((Object)("Bad number format in workbench upload def file: " + DatamodelHelper.getDatamodelFilePath()));
                    return null;
                }
            }
            return result;
        }
        log.error((Object)(String.valueOf(this.getClass().getName()) + ": unable to build defs"));
        return null;
    }

    public WorkbenchUploadMapper(Collection<WorkbenchTemplateMappingItem> wbtItems) {
        this.wbtItems = wbtItems;
        this.mappedItems = new Vector();
        this.defs = this.buildDefs();
        this.taxonLevels = this.buildTreeLevels("taxon");
        this.geoLevels = this.buildTreeLevels("geography");
        this.lithoLevels = this.buildTreeLevels("lithostrat");
        this.chronoLevels = this.buildTreeLevels("geologictimeperiod");
        this.storageLevels = this.buildTreeLevels("storage");
        this.maps = new Vector();
    }

    public WorkbenchUploadMapper(WorkbenchTemplate wbt) {
        this(wbt.getWorkbenchTemplateMappingItems());
    }

    protected Map<String, TreeLevelInfo> buildTreeLevels(String treeName) {
        if (this.defs != null) {
            HashMap<String, TreeLevelInfo> result = new HashMap<String, TreeLevelInfo>();
            for (DefInfo def : this.defs.values()) {
                if (!treeName.equals(def.treeName)) continue;
                result.put(def.name, new TreeLevelInfo(def.rankId, this.getTreeLevelFieldRequirement(def), def.oneToManySequence, def.mapToField));
            }
            return result;
        }
        return null;
    }

    protected boolean getTreeLevelFieldRequirement(DefInfo defInfo) {
        return defInfo.mapToField.equalsIgnoreCase("name");
    }

    protected final Element getXMLDef() {
        try {
            File inputFile = new File(DatamodelHelper.getWorkbenchUploadDefFilePath());
            FileInputStream fileInputStream = new FileInputStream(inputFile);
            SAXReader reader = new SAXReader();
            reader.setValidation(false);
            Document doc = reader.read((InputStream)fileInputStream);
            return doc.getRootElement();
        }
        catch (FileNotFoundException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchUploadMapper.class, ex);
            log.error((Object)ex);
            return null;
        }
        catch (DocumentException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchUploadMapper.class, (Exception)((Object)ex));
            log.error((Object)ex);
            return null;
        }
    }

    public Vector<UploadMappingDef> getImporterMapping() throws UploaderException {
        try {
            this.mapTrees();
            this.mapRelationships();
            this.mapLeftovers();
            return this.maps;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchUploadMapper.class, ex);
            if (ex instanceof UploaderException) {
                throw (UploaderException)ex;
            }
            throw new UploaderException(ex, 20);
        }
    }

    protected void mapLeftovers() {
        for (WorkbenchTemplateMappingItem wbi : this.wbtItems) {
            if (this.isMapped(wbi.getViewOrder())) continue;
            DefInfo def = this.findDef(wbi);
            String fld = def == null ? wbi.getFieldName() : def.actualName;
            this.maps.add(new UploadMappingDef(wbi.getTableName(), fld, wbi.getViewOrder().shortValue(), wbi.getCaption()));
            this.mappedItems.add(wbi.getViewOrder());
        }
    }

    protected void mapRelationships() throws UploaderException {
        for (WorkbenchTemplateMappingItem wbi : this.wbtItems) {
            DefInfo def;
            if (this.isMapped(wbi.getViewOrder()) || (def = this.findDef(wbi)) == null || def.relationshipName == null) continue;
            this.mapRelationship(wbi, def);
            this.mappedItems.add(wbi.getViewOrder());
        }
    }

    protected final DefInfo findDef(WorkbenchTemplateMappingItem wbi) {
        if (this.defs != null) {
            return this.defs.get(String.valueOf(wbi.getTableName().toLowerCase()) + "." + wbi.getFieldName().toLowerCase());
        }
        return null;
    }

    protected void mapRelationship(WorkbenchTemplateMappingItem wbi, DefInfo def) throws UploaderException {
        DBRelationshipInfo rel = DBTableIdMgr.getInstance().getByShortClassName(def.actualTable).getRelationshipByName(def.relationshipName);
        if (rel == null) {
            log.debug((Object)("relationship '" + def.relationshipName + "' for table '" + def.actualTable + "' not found in database schema."));
            throw new UploaderException("relationship '" + def.relationshipName + "' for table '" + def.actualTable + "' not found in database schema.", 20);
        }
        DBTableInfo relTbl = DBTableIdMgr.getInstance().getByClassName(rel.getClassName());
        UploadMappingDefRel map = this.findRelMap(def, rel.getColName(), relTbl.getShortClassName());
        if (map == null) {
            map = new UploadMappingDefRel(def.actualTable, rel.getColName(), relTbl.getShortClassName(), def.oneToManySequence, def.sequenceField, wbi.getCaption());
            this.maps.add(map);
        }
        if (def.relatedFieldName != null) {
            map.addRelatedField(def.relatedFieldName, wbi.getViewOrder().shortValue(), wbi.getCaption());
        } else {
            map.addLocalField(def.actualName, wbi.getViewOrder().shortValue(), wbi.getCaption());
        }
    }

    protected final UploadMappingDefRel findRelMap(DefInfo def, String foreignKey, String relatedTable) {
        for (UploadMappingDef map : this.maps) {
            UploadMappingDefRel relMap;
            if (map.getClass() != UploadMappingDefRel.class || !(relMap = (UploadMappingDefRel)map).getTable().equals(def.actualTable) || !relMap.getField().equals(foreignKey) || !relMap.getRelatedTable().equals(relatedTable)) continue;
            Integer mapSeq = relMap.getSequence();
            if (mapSeq != null && mapSeq.equals(def.oneToManySequence)) {
                return relMap;
            }
            if (mapSeq != null || def.oneToManySequence != null) continue;
            return relMap;
        }
        return null;
    }

    protected void mapTrees() throws Exception {
        Vector<WorkbenchTemplateMappingItem> taxTreeItems = new Vector<WorkbenchTemplateMappingItem>();
        Vector<WorkbenchTemplateMappingItem> geoTreeItems = new Vector<WorkbenchTemplateMappingItem>();
        Vector<WorkbenchTemplateMappingItem> lithoTreeItems = new Vector<WorkbenchTemplateMappingItem>();
        Vector<WorkbenchTemplateMappingItem> chronoTreeItems = new Vector<WorkbenchTemplateMappingItem>();
        Vector<WorkbenchTemplateMappingItem> storageTreeItems = new Vector<WorkbenchTemplateMappingItem>();
        for (WorkbenchTemplateMappingItem wbi : this.wbtItems) {
            if (this.isMapped(wbi.getViewOrder())) continue;
            if (this.isTaxTreeItem(wbi)) {
                taxTreeItems.add(wbi);
                continue;
            }
            if (this.isGeoTreeItem(wbi)) {
                geoTreeItems.add(wbi);
                continue;
            }
            if (this.isLithoTreeItem(wbi)) {
                lithoTreeItems.add(wbi);
                continue;
            }
            if (this.isChronoTreeItem(wbi)) {
                chronoTreeItems.add(wbi);
                continue;
            }
            if (!this.isStorageTreeItem(wbi)) continue;
            storageTreeItems.add(wbi);
        }
        this.mapTaxTreeItems(taxTreeItems);
        this.mapGeoTreeItems(geoTreeItems);
        this.mapLithoTreeItems(lithoTreeItems);
        this.mapChronoTreeItems(chronoTreeItems);
        this.mapStorageTreeItems(storageTreeItems);
    }

    protected void mapTaxTreeItems(Vector<WorkbenchTemplateMappingItem> treeItems) throws Exception {
        Vector<Vector<TreeMapElement>> levels;
        if (treeItems.size() > 0 && (levels = this.mapTreeItems(treeItems, this.taxonLevels)).size() > 0) {
            this.maps.add(new UploadMappingDefTree("taxon", "name", "parentId", null, levels, "Taxon"));
        }
    }

    protected Vector<TreeMapElement> findTreeMapElement(Vector<TreeMapElement> tmeVector, SortedSet<Vector<TreeMapElement>> elements) {
        SortedSet<Vector<TreeMapElement>> tail = elements.tailSet(tmeVector);
        if (tail != null && tail.size() > 0 && elements.comparator().compare(tmeVector, tail.first()) == 0) {
            return tail.first();
        }
        return null;
    }

    protected void mapGeoTreeItems(Vector<WorkbenchTemplateMappingItem> treeItems) throws Exception {
        Vector<Vector<TreeMapElement>> levels;
        log.debug((Object)"geoTreeItems:");
        for (WorkbenchTemplateMappingItem wbi : treeItems) {
            log.debug((Object)(String.valueOf(wbi.getCaption()) + ": " + wbi.getTableName() + "." + wbi.getFieldName()));
        }
        log.debug((Object)"");
        if (treeItems.size() > 0 && (levels = this.mapTreeItems(treeItems, this.geoLevels)).size() > 0) {
            this.maps.add(new UploadMappingDefTree("geography", "name", "parentId", null, levels, "geography"));
        }
    }

    protected void mapLithoTreeItems(Vector<WorkbenchTemplateMappingItem> treeItems) throws Exception {
        Vector<Vector<TreeMapElement>> levels;
        log.debug((Object)"lithoTreeItems:");
        for (WorkbenchTemplateMappingItem wbi : treeItems) {
            log.debug((Object)(String.valueOf(wbi.getCaption()) + ": " + wbi.getTableName() + "." + wbi.getFieldName()));
        }
        log.debug((Object)"");
        if (treeItems.size() > 0 && (levels = this.mapTreeItems(treeItems, this.lithoLevels)).size() > 0) {
            this.maps.add(new UploadMappingDefTree("lithostrat", "name", "parentId", null, levels, "lithostrat"));
        }
    }

    protected void mapChronoTreeItems(Vector<WorkbenchTemplateMappingItem> treeItems) throws Exception {
        Vector<Vector<TreeMapElement>> levels;
        log.debug((Object)"chronoTreeItems:");
        for (WorkbenchTemplateMappingItem wbi : treeItems) {
            log.debug((Object)(String.valueOf(wbi.getCaption()) + ": " + wbi.getTableName() + "." + wbi.getFieldName()));
        }
        log.debug((Object)"");
        if (treeItems.size() > 0 && (levels = this.mapTreeItems(treeItems, this.chronoLevels)).size() > 0) {
            this.maps.add(new UploadMappingDefTree("geologictimeperiod", "name", "parentId", null, levels, "geologictimeperiod"));
        }
    }

    protected void mapStorageTreeItems(Vector<WorkbenchTemplateMappingItem> treeItems) throws Exception {
        Vector<Vector<TreeMapElement>> levels;
        log.debug((Object)"storageTreeItems:");
        for (WorkbenchTemplateMappingItem wbi : treeItems) {
            log.debug((Object)(String.valueOf(wbi.getCaption()) + ": " + wbi.getTableName() + "." + wbi.getFieldName()));
        }
        log.debug((Object)"");
        if (treeItems.size() > 0 && (levels = this.mapTreeItems(treeItems, this.storageLevels)).size() > 0) {
            this.maps.add(new UploadMappingDefTree("storage", "name", "parentId", null, levels, "storage"));
        }
    }

    protected void logDebug(Object toDebug) {
        if (debugging) {
            log.debug(toDebug);
        }
    }

    protected Vector<Vector<TreeMapElement>> mapTreeItems(Vector<WorkbenchTemplateMappingItem> treeItems, Map<String, TreeLevelInfo> ranks) {
        TreeSet<TreeLevelInfo> levels = new TreeSet<TreeLevelInfo>();
        for (WorkbenchTemplateMappingItem wbi : treeItems) {
            this.logDebug(String.valueOf(wbi.getCaption()) + ", " + wbi.getFieldName());
            TreeLevelInfo levelInfo = ranks.get(wbi.getFieldName());
            levelInfo.setIndex(wbi.getViewOrder().shortValue());
            levelInfo.setWbFldName(wbi.getCaption());
            levels.add(levelInfo);
            this.mappedItems.add(wbi.getViewOrder());
        }
        Vector<Vector<TreeMapElement>> result = new Vector<Vector<TreeMapElement>>(levels.size());
        Iterator levelsIter = levels.iterator();
        int currentRank = -1;
        Vector<TreeMapElement> currentElement = null;
        while (levelsIter.hasNext()) {
            TreeLevelInfo level = (TreeLevelInfo)levelsIter.next();
            this.logDebug(String.valueOf(level.getWbFldName()) + ", " + level.getIndex() + ", " + level.getRank());
            if (currentElement == null || level.getRank() != currentRank) {
                currentElement = new Vector<TreeMapElement>();
                result.add(currentElement);
                currentRank = level.getRank();
            }
            currentElement.add(new TreeMapElement(level.getIndex(), level.getFldName(), level.getWbFldName(), level.getRank(), level.getSequence(), level.isRequired()));
        }
        return result;
    }

    protected TreeMapElement getTreeMapElement(WorkbenchTemplateMappingItem wbi, Map<String, TreeLevelInfo> levels) {
        TreeLevelInfo level = levels.get(wbi.getFieldName());
        TreeMapElement result = new TreeMapElement(wbi.getViewOrder().shortValue(), wbi.getFieldName(), wbi.getCaption(), level.getRank(), level.getSequence(), level.isRequired());
        return result;
    }

    protected boolean isMapped(short itemIdx) {
        return this.mappedItems.contains(itemIdx);
    }

    protected boolean isTaxTreeItem(WorkbenchTemplateMappingItem wbi) {
        return (wbi.getSrcTableId().equals(4) || wbi.getSrcTableId().equals(4000) || wbi.getTableName().equals("determination")) && this.taxonLevels.containsKey(wbi.getFieldName());
    }

    protected boolean isGeoTreeItem(WorkbenchTemplateMappingItem wbi) {
        return wbi.getTableName().equals("geography") && this.geoLevels.containsKey(wbi.getFieldName());
    }

    protected boolean isLithoTreeItem(WorkbenchTemplateMappingItem wbi) {
        return wbi.getTableName().equals("lithostrat") && this.lithoLevels.containsKey(wbi.getFieldName());
    }

    protected boolean isStorageTreeItem(WorkbenchTemplateMappingItem wbi) {
        return (wbi.getTableName().equals("storage") || wbi.getTableName().equals("preparation")) && this.storageLevels.containsKey(wbi.getFieldName());
    }

    protected boolean isChronoTreeItem(WorkbenchTemplateMappingItem wbi) {
        return wbi.getTableName().equals("geologictimeperiod") && this.chronoLevels.containsKey(wbi.getFieldName());
    }

    private class DefInfo {
        public String table;
        public String name;
        public Integer oneToManySequence;
        public String sequenceField;
        public String actualTable;
        public String actualName;
        public String relationshipName;
        public String relatedFieldName;
        public String treeName;
        public String mapToField;
        public Integer rankId;

        public DefInfo(Element xmlNode) {
            this.table = xmlNode.attributeValue("table");
            this.name = xmlNode.attributeValue("name");
            this.oneToManySequence = xmlNode.attributeValue("onetomanysequence") == null ? null : new Integer(xmlNode.attributeValue("onetomanysequence"));
            this.sequenceField = xmlNode.attributeValue("sequencefield");
            this.actualTable = xmlNode.attributeValue("actualtable");
            if (this.actualTable == null) {
                this.actualTable = this.table;
            }
            this.actualName = xmlNode.attributeValue("actualname");
            if (this.actualName == null) {
                this.actualName = this.name;
            }
            this.relationshipName = xmlNode.attributeValue("relationshipname");
            this.relatedFieldName = xmlNode.attributeValue("relatedfieldname");
            this.treeName = xmlNode.attributeValue("treename");
            this.mapToField = xmlNode.attributeValue("maptofield");
            this.rankId = xmlNode.attributeValue("rankid") == null ? null : new Integer(xmlNode.attributeValue("rankid"));
        }

        public String toString() {
            String result = new String(String.valueOf(this.table == null ? "null" : this.table) + "." + (this.name == null ? "null" : this.name) + ": 1-many: " + (this.oneToManySequence == null ? "null" : this.oneToManySequence.toString()) + ", sequenceField: " + (this.sequenceField == null ? "null" : this.sequenceField) + ", actualTable: " + (this.actualTable == null ? "null" : this.actualTable) + ", actualName: " + (this.actualName == null ? "null" : this.actualName) + ", relName: " + (this.relationshipName == null ? "null" : this.relationshipName) + ", relFld: " + (this.relatedFieldName == null ? "null" : this.relatedFieldName) + ", treeName: " + (this.treeName == null ? "null" : this.treeName) + ", mapTo: " + (this.mapToField == null ? "null" : this.mapToField) + ", rankID: " + (this.rankId == null ? "null" : this.rankId.toString()));
            return result;
        }
    }

    private class TreeLevelInfo
    implements Comparable<TreeLevelInfo> {
        protected int rank;
        protected boolean required;
        protected Integer sequence;
        protected int index;
        protected String wbFldName;
        protected String fldName;

        public TreeLevelInfo(int rank, boolean required, Integer sequence, String fldName) {
            this.rank = rank;
            this.required = required;
            this.sequence = sequence;
            this.fldName = fldName;
        }

        @Override
        public int compareTo(TreeLevelInfo info) {
            if (this.rank < info.rank) {
                return -1;
            }
            if (this.rank > info.rank) {
                return 1;
            }
            if (this.index < info.index) {
                return -1;
            }
            if (this.index > info.index) {
                return 1;
            }
            if (this.getSequence() != null && info.getSequence() != null) {
                return this.getSequence().compareTo(info.getSequence());
            }
            return 0;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int index) {
            this.index = index;
        }

        public final int getRank() {
            return this.rank;
        }

        public final boolean isRequired() {
            return this.required;
        }

        public final Integer getSequence() {
            return this.sequence;
        }

        public final String getWbFldName() {
            return this.wbFldName;
        }

        public final void setWbFldName(String wbFldName) {
            this.wbFldName = wbFldName;
        }

        public String getFldName() {
            return this.fldName;
        }
    }
}

