/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.ui.UIRegistry;
import java.util.List;
import java.util.Vector;

public class UploaderMatchSkipException
extends UploaderException {
    protected Vector<Object> matchIds = new Vector();
    protected UploadTable uploadTable;
    protected int row;

    public Vector<Object> getMatchIds() {
        return this.matchIds;
    }

    public UploaderMatchSkipException(String msg, List<DataModelObjBase> matches, int row, UploadTable uploadTable) {
        super(msg, 10);
        for (DataModelObjBase match : matches) {
            this.matchIds.add(match.getId());
        }
        this.row = row;
        this.uploadTable = uploadTable;
    }

    public int getRow() {
        return this.row;
    }

    public UploadTable getUploadTable() {
        return this.uploadTable;
    }

    public void setMatchIds(Vector<Object> matchIds) {
        this.matchIds = matchIds;
    }

    public static String makeMsg(Vector<UploadTable.MatchRestriction> cellVals, int valsToShow, int row) {
        int maxValsToShow = 2;
        StringBuilder msg = new StringBuilder();
        msg.append(UIRegistry.getResourceString("WB_ROW"));
        msg.append(" ");
        msg.append(String.valueOf(row + 1));
        msg.append(": ");
        msg.append(UIRegistry.getResourceString("WB_MULTIPLE_MATCH_SKIP"));
        msg.append(" (");
        int f = 0;
        while (f < maxValsToShow && f < valsToShow) {
            msg.append(cellVals.get(f).getFieldName());
            msg.append(" = ");
            msg.append(cellVals.get(f++).getRestriction());
            if (f < cellVals.size() && f < valsToShow) {
                msg.append(", ");
                continue;
            }
            if (f >= cellVals.size()) continue;
            msg.append("...");
        }
        msg.append(")");
        return msg.toString();
    }
}

