/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ServiceInfo;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.FieldNotebook;
import edu.ku.brc.specify.datamodel.FieldNotebookPage;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSet;
import edu.ku.brc.specify.datamodel.GeoCoordDetail;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.LocalityDetail;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchRowExportedRelationship;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.tasks.DataEntryTask;
import edu.ku.brc.specify.tasks.InteractionsTask;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraph;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraphException;
import edu.ku.brc.specify.tasks.subpane.wb.graph.Edge;
import edu.ku.brc.specify.tasks.subpane.wb.graph.Vertex;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.BaseUploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DB;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DefaultFieldEntry;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.InvalidStructure;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.MissingDataResolver;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.RelatedClassSetter;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.TreeMapElement;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.TreeMapElements;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadField;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadInfoRenderable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadLocker;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMainPanel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDef;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDefRel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDefTree;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMatchSettingsBasicPanel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadRetriever;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadSettingsPanel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableInvalidValue;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableMatchInfo;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableTree;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecordInfo;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderMatchSkipException;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Uploader
implements ActionListener,
KeyListener {
    private static boolean debugging = false;
    protected static final String INITIAL_STATE = "WB_UPLOAD_INITIAL_STATE";
    protected static final String CHECKING_REQS = "WB_UPLOAD_CHECKING_REQS";
    protected static final String VALIDATING_DATA = "WB_UPLOAD_VALIDATING_DATA";
    public static final String READY_TO_UPLOAD = "WB_UPLOAD_READY_TO_UPLOAD";
    protected static final String UPLOADING = "WB_UPLOAD_UPLOADING";
    public static final String SUCCESS = "WB_UPLOAD_SUCCESS";
    protected static final String SUCCESS_PARTIAL = "WB_UPLOAD_SUCCESS_PARTIAL";
    protected static final String RETRIEVING_UPLOADED_DATA = "WB_RETRIEVING_UPLOADED_DATA";
    protected static final String FAILURE = "WB_UPLOAD_FAILURE";
    protected static final String USER_INPUT = "WB_UPLOAD_USER_INPUT";
    protected static final String UNDOING_UPLOAD = "WB_UPLOAD_UNDO";
    protected static final String CLEANING_UP = "WB_UPLOAD_CLEANUP";
    protected static final String WB_CELL_LENGTH_EXCEPTION = "WB_CELL_LENGTH_EXCEPTION";
    protected static final String WB_TOO_MANY_ERRORS = "WB_TOO_MANY_ERRORS";
    protected static final String WB_UPLOAD_FORM_TITLE = "WB_UPLOAD_FORM_TITLE";
    protected static final String WB_UPLOAD_ROW_SKIPPED = "WB_UPLOAD_ROW_SKIPPED";
    protected static final String WB_UPLOAD_VIEW_RESULTS_TITLE = "WB_UPLOAD_VIEW_RESULTS_TITLE";
    public static final int NO_LOCK = 0;
    public static final int LOCK_REMOVED = 1;
    public static final int LOCK_IGNORED = 2;
    public static final int LOCKED = 3;
    public static final int LOCK_FAILED = 4;
    protected static final int MAX_MSG_DISPLAY_COUNT = 800;
    protected String currentOp;
    protected String previousOp = null;
    protected Exception opKiller;
    protected DB.BogusViewer bogusViewer = null;
    protected DB db;
    protected UploadData uploadData;
    protected WorkbenchPaneSS wbSS;
    protected java.util.Collection<WorkbenchTemplateMappingItem> workbenchTemplateMappingItems = null;
    protected Vector<UploadField> uploadFields;
    protected Vector<UploadTable> uploadTables;
    protected DirectedGraph<Table, Relationship> uploadGraph;
    boolean verbose = false;
    boolean dataValidated = false;
    protected UploadMainPanel mainPanel;
    protected List<Component> keyListeningTo = new LinkedList<Component>();
    protected Vector<UploadTableInvalidValue> validationIssues = null;
    MissingDataResolver resolver;
    protected Vector<RelatedClassSetter> missingRequiredClasses;
    protected Vector<DefaultFieldEntry> missingRequiredFields;
    protected Vector<RecordSet> recordSets = null;
    protected static Uploader currentUpload = null;
    protected String identifier = "uploader";
    protected Calendar uploadTime = null;
    protected UploaderTask currentTask = null;
    protected int rowUploading;
    protected int uploadStartRow;
    protected AtomicInteger updateTableId = new AtomicInteger(-1);
    protected List<WorkbenchRowImage> imagesForRow = new Vector<WorkbenchRowImage>();
    protected List<UploadedRecordInfo> newAttachments = new Vector<UploadedRecordInfo>();
    protected UploadRetriever uploadedObjectViewer = null;
    protected boolean additionalLocksSet = false;
    protected static final Logger log = Logger.getLogger(Uploader.class);
    protected Vector<SkippedRow> skippedRows;
    protected Vector<UploadMessage> messages;
    protected Vector<UploadMessage> newMessages;
    protected boolean indeterminateProgress = false;
    protected boolean useAppStatBar = false;
    protected int maxProgVal = 0;
    protected int minProgVal = 0;
    int thirdTime = 0;
    protected static boolean isLockIgnored = false;

    public boolean getDataValidated() {
        return this.dataValidated;
    }

    public static Uploader getCurrentUpload() {
        return currentUpload;
    }

    public List<ServiceInfo> filterServices(List<ServiceInfo> services) {
        Vector<ServiceInfo> result = new Vector<ServiceInfo>();
        int s = 0;
        while (s < services.size()) {
            block5: {
                ServiceInfo service = services.get(s);
                if (this.includeService(service)) {
                    if (service.getTask() instanceof DataEntryTask || service.getTask() instanceof InteractionsTask) {
                        try {
                            ServiceInfo newService = (ServiceInfo)service.clone();
                            newService.getCommandAction().setProperty("readonly", true);
                            service = newService;
                        }
                        catch (CloneNotSupportedException ex) {
                            log.error((Object)ex);
                            break block5;
                        }
                    }
                    result.add(service);
                }
            }
            ++s;
        }
        return result;
    }

    protected boolean includeService(ServiceInfo service) {
        return !(service.getTask() instanceof RecordSetTask);
    }

    public int getRow() {
        return this.rowUploading;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public Calendar getUploadTime() {
        return this.uploadTime;
    }

    protected void buildIdentifier() {
        this.uploadTime = new GregorianCalendar();
        this.identifier = String.valueOf(this.uploadData.getWbRow(0).getWorkbench().getName()) + "_" + this.uploadTime.get(1) + "-" + (this.uploadTime.get(2) + 1) + "-" + this.uploadTime.get(5) + "_" + this.uploadTime.get(11) + ":" + this.uploadTime.get(13);
    }

    protected UploadTable getUploadTable(UploadField f) {
        for (UploadTable result : this.uploadTables) {
            if (!result.getTable().getName().equals(f.getField().getTable().getName()) || (result.getRelationship() != null || f.getRelationship() != null) && (result.getRelationship() == null || f.getRelationship() == null || !result.getRelationship().equals(f.getRelationship()))) continue;
            return result;
        }
        return null;
    }

    public UploadTable getUploadTableByName(String name) {
        for (UploadTable result : this.uploadTables) {
            if (!result.getTable().getName().equalsIgnoreCase(name)) continue;
            return result;
        }
        return null;
    }

    public UploadTable getUploadTableByNameRel(String name, String relTblName) {
        for (UploadTable result : this.uploadTables) {
            if (!result.getTable().getName().equalsIgnoreCase(name)) continue;
            if (relTblName == null) {
                return result;
            }
            Relationship rel = result.getRelationship();
            if (rel == null || !rel.getRelatedField().getTable().getTableInfo().getName().equalsIgnoreCase(relTblName)) continue;
            return result;
        }
        return null;
    }

    protected void buildUploadTables() throws UploaderException {
        this.uploadTables = new Vector();
        for (UploadField f : this.uploadFields) {
            boolean addIt;
            this.logDebug(f.getWbFldName());
            if (f.getField() == null) continue;
            UploadTable it = this.getUploadTable(f);
            boolean bl = addIt = it == null;
            if (addIt && (it = new UploadTable(this, f.getField().getTable(), f.getRelationship())) != null) {
                it.init();
            }
            if (it == null) {
                throw new UploaderException(UIRegistry.getResourceString("WB_UPLOAD_UPLOADTBL_BUILD_FAIL"), 20);
            }
            it.addField(f);
            if (!addIt) continue;
            this.uploadTables.add(it);
        }
        for (UploadTable ut : this.uploadTables) {
            ut.findPrecisionDateFields();
        }
    }

    protected void logDebug(Object toLog) {
        if (debugging) {
            log.debug(toLog);
        }
    }

    protected void addMappingRelFlds(UploadMappingDefRel mapping) throws UploaderException {
        if (mapping.getSequenceFld() != null) {
            Field fld = this.db.getSchema().getField(mapping.getTable(), mapping.getSequenceFld());
            if (fld == null) {
                this.logDebug("could not find field in db: " + mapping.getTable() + "." + mapping.getField());
            }
            UploadField newFld = new UploadField(fld, -1, mapping.getWbFldName(), null);
            newFld.setSequence(mapping.getSequence());
            newFld.setValue(mapping.getSequence().toString());
            this.uploadFields.add(newFld);
        }
        Table t1 = this.db.getSchema().getTable(mapping.getTable());
        Table t2 = this.db.getSchema().getTable(mapping.getRelatedTable());
        for (UploadMappingDefRel.ImportMappingRelFld fld : mapping.getLocalFields()) {
            Field dbFld = t1.getField(fld.getFieldName());
            if (dbFld == null) {
                this.logDebug("could not find field in db: " + t1.getName() + "." + fld.getFieldName());
            }
            UploadField newFld = new UploadField(dbFld, fld.getFldIndex(), fld.getWbFldName(), null);
            newFld.setSequence(mapping.getSequence());
            this.uploadFields.add(newFld);
        }
        if (mapping.getRelatedFields().size() > 0) {
            Vector<Relationship> rs;
            try {
                rs = this.db.getGraph().getAllEdgeData(t1, t2);
                if (rs.size() == 0) {
                    rs = this.db.getGraph().getAllEdgeData(t2, t1);
                }
            }
            catch (DirectedGraphException ex) {
                throw new UploaderException(ex, 20);
            }
            int r = rs.size() - 1;
            while (r > -1) {
                if (rs.get(r).getRelatedField().getName().equalsIgnoreCase("modifiedbyagentid") || rs.get(r).getRelatedField().getName().equalsIgnoreCase("createdbyagentid")) {
                    rs.remove(r);
                }
                --r;
            }
            if (rs.size() > 0) {
                for (Relationship r2 : rs) {
                    if (!r2.getRelatedField().getName().equalsIgnoreCase(mapping.getField())) continue;
                    Vector<UploadMappingDefRel.ImportMappingRelFld> relFlds = mapping.getRelatedFields();
                    int relF = 0;
                    while (relF < relFlds.size()) {
                        Field fld = this.db.getSchema().getField(t2.getName(), relFlds.get(relF).getFieldName());
                        int fldIdx = relFlds.get(relF).getFldIndex();
                        String wbFldName = relFlds.get(relF).getWbFldName();
                        UploadField newFld = new UploadField(fld, fldIdx, wbFldName, r2);
                        newFld.setSequence(mapping.getSequence());
                        this.uploadFields.add(newFld);
                        ++relF;
                    }
                    return;
                }
            }
            throw new UploaderException("could not find relationship for mapping.", 20);
        }
    }

    protected void buildUploadFields() throws UploaderException {
        int f = 0;
        while (f < this.uploadData.getCols()) {
            UploadMappingDef m = this.uploadData.getMapping(f);
            if (m.getClass() != UploadMappingDefTree.class) {
                Field fld = this.db.getSchema().getField(m.getTable(), m.getField());
                if (fld == null) {
                    this.logDebug("could not find field in db: " + m.getTable() + "." + m.getField());
                }
                UploadField newFld = new UploadField(fld, m.getIndex(), m.getWbFldName(), null);
                this.uploadFields.add(newFld);
                if (m.getClass() == UploadMappingDefRel.class) {
                    UploadMappingDefRel relM = (UploadMappingDefRel)m;
                    newFld.setSequence(relM.getSequence());
                    this.addMappingRelFlds(relM);
                    newFld.setIndex(-1);
                }
            }
            ++f;
        }
    }

    public Vector<String> printUploadFields() {
        Vector<String> lines = new Vector<String>();
        for (UploadField impF : this.uploadFields) {
            lines.add(String.valueOf(impF.getField().getTable().getName()) + "." + impF.getField().getName() + " [" + Integer.toString(impF.getIndex()) + "] " + (impF.getSequence() == null ? "" : " (" + impF.getSequence().toString() + ")"));
        }
        return lines;
    }

    public Vector<String> printGraphInfo() throws DirectedGraphException {
        Vector<String> lines = new Vector<String>();
        lines.add("vertices:");
        for (Vertex<Table> v : this.uploadGraph.getVertices()) {
            lines.add("   " + v.getLabel());
        }
        Vector<String> graphEdges = this.uploadGraph.listEdges();
        lines.add("");
        lines.add("edges:");
        for (String e : graphEdges) {
            lines.add(e);
        }
        lines.add("");
        lines.add("Graph sources:");
        Set<Vertex<Table>> sources = this.uploadGraph.sources();
        for (Vertex<Table> tbl : sources) {
            lines.add("   " + tbl.getLabel());
        }
        lines.add("");
        if (this.uploadGraph.isStronglyConnected()) {
            lines.add("graph is strongly connected.");
        } else {
            lines.add("graph is not strongly connected.");
        }
        return lines;
    }

    public Vector<String> printUploadTables() {
        Vector<String> lines = new Vector<String>();
        for (UploadTable impT : this.uploadTables) {
            lines.add(impT.getTable().getName());
            for (Vector<UploadField> seq : impT.getUploadFields()) {
                for (UploadField f : seq) {
                    lines.add("       " + f.getField().getName() + (f.getSequence() == null ? "" : " (" + f.getSequence().toString() + ")"));
                }
            }
        }
        return lines;
    }

    public Uploader(DB db, UploadData importData, WorkbenchPaneSS wbSS, boolean isValidator) throws UploaderException {
        this(db, importData, wbSS, wbSS.getWorkbench().getWorkbenchTemplate().getWorkbenchTemplateMappingItems(), isValidator);
    }

    public Uploader(DB db, UploadData importData, WorkbenchPaneSS wbSS, java.util.Collection<WorkbenchTemplateMappingItem> wbItems, boolean isValidator) throws UploaderException {
        this.db = db;
        this.uploadData = importData;
        this.wbSS = wbSS;
        this.workbenchTemplateMappingItems = wbItems;
        this.uploadFields = new Vector(importData.getCols());
        this.missingRequiredClasses = new Vector();
        this.missingRequiredFields = new Vector();
        this.skippedRows = new Vector();
        this.messages = new Vector();
        this.newMessages = new Vector();
        this.buildUploadFields();
        this.buildUploadTables();
        this.addEmptyUploadTables();
        this.addRequiredUploadTables();
        this.buildUploadGraph();
        this.processTreeMaps();
        for (UploadTable ut : this.uploadTables) {
            this.logDebug("assigningFldSetters: " + ut.getTable().getName());
            ut.assignFldSetters();
        }
        this.orderUploadTables();
        this.buildUploadTableParents();
        this.reOrderUploadTables();
        if (!isValidator) {
            currentUpload = this;
        }
    }

    protected void processParentsForRootTableSearch(UploadTable ut, Set<UploadTable> rps) {
        for (Vector<ParentTableEntry> ptes : ut.getParentTables()) {
            for (ParentTableEntry pte : ptes) {
                UploadTable p = pte.getImportTable();
                if (p.getSpecialChildren().contains(ut)) continue;
                rps.add(p);
                this.processParentsForRootTableSearch(p, rps);
            }
        }
    }

    protected UploadTable getRootTable() {
        HashSet<UploadTable> ruledChildrenAndTheirReqs = new HashSet<UploadTable>();
        for (UploadTable ut : this.uploadTables) {
            if (!ut.isMatchChild()) continue;
            ruledChildrenAndTheirReqs.add(ut);
            this.processParentsForRootTableSearch(ut, ruledChildrenAndTheirReqs);
        }
        int t = this.uploadTables.size() - 1;
        while (t >= 0) {
            if (!this.uploadTables.get(t).isMatchChild() && !ruledChildrenAndTheirReqs.contains(this.uploadTables.get(t))) {
                return this.uploadTables.get(t);
            }
            --t;
        }
        return null;
    }

    protected boolean isDetTaxLevelMapping(WorkbenchTemplateMappingItem mapI) {
        if (!mapI.getTableName().equalsIgnoreCase("determination")) {
            return false;
        }
        String fldName = mapI.getFieldName();
        return fldName.startsWith("kingdom") || fldName.startsWith("phylum") || fldName.startsWith("subphylum") || fldName.startsWith("superclass") || fldName.startsWith("class") || fldName.startsWith("subclass") || fldName.startsWith("infraclass") || fldName.startsWith("superorder") || fldName.startsWith("order") || fldName.startsWith("suborder") || fldName.startsWith("infraorder") || fldName.startsWith("superfamily") || fldName.startsWith("family") || fldName.startsWith("subfamily") || fldName.startsWith("tribe") || fldName.startsWith("subtribe") || fldName.startsWith("genus") || fldName.startsWith("subgenus") || fldName.startsWith("species") || fldName.startsWith("subspecies") || fldName.startsWith("variety") || fldName.startsWith("forma");
    }

    protected void addEmptyUploadTables() throws UploaderException {
        boolean genSpPresent = false;
        boolean detPresent = false;
        boolean locPresent = false;
        boolean coPresent = false;
        boolean cePresent = false;
        for (UploadTable ut : this.uploadTables) {
            if (ut.getTblClass().equals(Determination.class)) {
                detPresent = true;
            }
            if (ut.getTblClass().equals(Locality.class)) {
                locPresent = true;
            }
            if (ut.getTblClass().equals(CollectionObject.class)) {
                coPresent = true;
            }
            if (!ut.getTblClass().equals(CollectingEvent.class)) continue;
            cePresent = true;
        }
        if (!detPresent) {
            int maxSeq = 0;
            for (WorkbenchTemplateMappingItem mapI : this.workbenchTemplateMappingItems) {
                if (!this.isDetTaxLevelMapping(mapI)) continue;
                genSpPresent = true;
                try {
                    String fldName = mapI.getFieldName();
                    if (Integer.valueOf(fldName.substring(fldName.length() - 1)) <= maxSeq) continue;
                    maxSeq = Integer.valueOf(fldName.substring(fldName.length() - 1));
                }
                catch (NumberFormatException e) {
                    genSpPresent = false;
                }
            }
            if (genSpPresent) {
                UploadTable det = new UploadTable(this, this.db.getSchema().getTable("Determination"), null);
                int seq = 0;
                while (seq < maxSeq) {
                    UploadField fld = new UploadField(this.db.getSchema().getField("determination", "collectionobjectid"), -1, null, null);
                    fld.setSequence(seq);
                    det.addField(fld);
                    ++seq;
                }
                det.init();
                this.uploadTables.add(det);
            }
        }
        if (!cePresent && locPresent && coPresent) {
            UploadTable ce = new UploadTable(this, this.db.getSchema().getTable("CollectingEvent"), null);
            ce.init();
            ce.addField(new UploadField(this.db.getSchema().getField("collectingevent", "stationfieldnumber"), -1, null, null));
            this.uploadTables.add(ce);
        }
    }

    protected void reOrderUploadTables() throws UploaderException {
        TreeSet<Pair<UploadTable, UploadTable>> moves = new TreeSet<Pair<UploadTable, UploadTable>>(new Comparator<Pair<UploadTable, UploadTable>>(){

            private boolean isAncestorOf(UploadTable t1, UploadTable t2) {
                Uploader.this.logDebug("isAncestorOf(" + t1 + ", " + t2 + ")");
                if (t1.equals(t2)) {
                    return true;
                }
                for (Vector<ParentTableEntry> ptes : t2.getParentTables()) {
                    for (ParentTableEntry pte : ptes) {
                        if (!this.isAncestorOf(t1, pte.getImportTable())) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int compare(Pair<UploadTable, UploadTable> p1, Pair<UploadTable, UploadTable> p2) {
                if (p1.getFirst() == p2.getFirst() && p1.getSecond() == p2.getSecond()) {
                    return 0;
                }
                if (this.isAncestorOf(p1.getSecond(), p2.getSecond())) {
                    return -1;
                }
                if (this.isAncestorOf(p2.getSecond(), p1.getSecond())) {
                    return 1;
                }
                return 0;
            }
        });
        if (debugging) {
            this.logDebug("reOrderUploadTables(): initial order:");
            for (UploadTable uploadTable : this.uploadTables) {
                this.logDebug("   " + uploadTable.getTable().getName());
            }
        }
        for (UploadTable uploadTable : this.uploadTables) {
            this.logDebug("Table: " + uploadTable.getTable().getName());
            for (UploadTable mc : uploadTable.getSpecialChildren()) {
                if (!uploadTable.needToMatchChild(mc.getTblClass())) continue;
                this.logDebug("  Child: " + mc.getTable().getName());
                for (ParentTableEntry pte : mc.getAncestors()) {
                    if (this.uploadTables.indexOf(uploadTable) >= this.uploadTables.indexOf(pte.getImportTable())) continue;
                    this.logDebug("reordering: " + pte.getImportTable().getTable().getName() + " must precede " + uploadTable.getTable().getName());
                    moves.add(new Pair<UploadTable, UploadTable>(uploadTable, pte.getImportTable()));
                }
            }
        }
        for (Pair pair : moves) {
            int fromIdx = this.uploadTables.indexOf(pair.getSecond());
            int toIdx = this.uploadTables.indexOf(pair.getFirst());
            this.logDebug("reording: " + ((UploadTable)pair.getSecond()).getTable().getName() + "(" + fromIdx + ") -> " + ((UploadTable)pair.getFirst()).getTable().getName() + "(" + toIdx + ")");
            if (toIdx > fromIdx) {
                log.error((Object)("Can't meet ordering constraints: " + ((UploadTable)pair.getSecond()).getTable().getName() + "," + ((UploadTable)pair.getFirst()).getTable().getName()));
                throw new UploaderException("The Dataset is not uploadable.", 20);
            }
            this.uploadTables.remove(fromIdx);
            this.uploadTables.insertElementAt((UploadTable)pair.getSecond(), toIdx);
        }
    }

    protected void buildUploadGraph() throws UploaderException {
        this.uploadGraph = new DirectedGraph();
        try {
            for (UploadTable uploadTable : this.uploadTables) {
                String label = uploadTable.getTable().getName();
                if (this.uploadGraph.getVertexByLabel(label) != null) continue;
                this.uploadGraph.addVertex(new Vertex<Table>(label, uploadTable.getTable()));
            }
            for (Edge edge : this.db.getGraph().getEdges()) {
                Vector<UploadTable> its1 = this.getUploadTable((Table)edge.getPointA().getData());
                Vector<UploadTable> its2 = this.getUploadTable((Table)edge.getPointB().getData());
                if (its1.size() <= 0 || its2.size() <= 0) continue;
                this.uploadGraph.addEdge(edge.getPointA().getLabel(), edge.getPointB().getLabel(), (Relationship)edge.getData());
            }
        }
        catch (DirectedGraphException directedGraphException) {
            this.logDebug(directedGraphException);
            throw new UploaderException(directedGraphException, 20);
        }
    }

    protected String getTreeTableName(UploadMappingDefTree treeMap, int level) {
        return String.valueOf(treeMap.getTable()) + Integer.toString(treeMap.getLevels().get(level).getRank());
    }

    protected void processTreeMap(UploadMappingDefTree treeMap) throws UploaderException {
        Table baseTbl = this.db.getSchema().getTable(treeMap.getTable());
        if (baseTbl == null) {
            throw new UploaderException("Could not find base table for tree mapping.", 20);
        }
        Table parentTbl = null;
        UploadTableTree parentImpTbl = null;
        int level = 0;
        while (level < treeMap.getLevels().size()) {
            this.logDebug(treeMap.getLevels().get(level).getWbFldName());
            Table rankTbl = new Table(this.getTreeTableName(treeMap, level), baseTbl);
            try {
                this.uploadGraph.addVertex(new Vertex<Table>(rankTbl.getName(), rankTbl));
                if (parentTbl != null) {
                    Relationship rankRel = new Relationship(parentTbl.getKey(), rankTbl.getField(treeMap.getParentField()), "OneToMany");
                    this.uploadGraph.addEdge(parentTbl.getName(), rankTbl.getName(), rankRel);
                }
            }
            catch (DirectedGraphException ex) {
                throw new UploaderException(ex);
            }
            parentTbl = rankTbl;
            UploadTableTree it = new UploadTableTree(this, rankTbl, baseTbl, parentImpTbl, treeMap.getLevels().get(level).isRequired(), treeMap.getLevels().get(level).getRank(), treeMap.getLevels().get(level).getWbFldName());
            it.init();
            int prevSeq = -1;
            int i = 0;
            while (i < treeMap.getLevels().get(level).size()) {
                TreeMapElement item = treeMap.getLevels().get(level).getElement(i);
                int seq = item.getSequence();
                Field fld = rankTbl.getField(item.getFldName());
                int fldIdx = item.getIndex();
                String wbFldName = item.getWbFldName();
                UploadField newFld1 = new UploadField(fld, fldIdx, wbFldName, null);
                if (item.isRequired()) {
                    newFld1.setRequired(true);
                }
                newFld1.setSequence(seq);
                this.uploadFields.add(newFld1);
                UploadField newFld2 = null;
                if (prevSeq != seq) {
                    newFld2 = new UploadField(rankTbl.getField("rankId"), -1, null, null);
                    newFld2.setRequired(true);
                    newFld2.setValue(Integer.toString(item.getRank()));
                    newFld2.setSequence(seq);
                    this.uploadFields.add(newFld2);
                }
                it.addField(newFld1);
                if (newFld2 != null) {
                    it.addField(newFld2);
                }
                prevSeq = seq;
                ++i;
            }
            this.uploadTables.add(it);
            parentImpTbl = it;
            ++level;
        }
        if (parentTbl != null) {
            for (Edge<Table, Relationship> e : this.db.getGraph().getEdges()) {
                String relFld1Name;
                Relationship rel;
                Vertex<Table> relTblVertex;
                if (!e.getPointA().getData().equals(baseTbl) || (relTblVertex = this.uploadGraph.getVertexByLabel(e.getPointB().getLabel())) == null || !this.isRelationshipImplemented(rel = new Relationship(parentTbl.getField(relFld1Name = e.getData().getField().getName()), e.getData().getRelatedField(), e.getData().getRelType()), relTblVertex.getData())) continue;
                try {
                    this.uploadGraph.addEdge(parentTbl.getName(), relTblVertex.getLabel(), rel);
                }
                catch (DirectedGraphException ex) {
                    throw new UploaderException(ex, 20);
                }
            }
        }
    }

    protected void processTreeMaps() throws UploaderException {
        int m = 0;
        while (m < this.uploadData.getCols()) {
            if (this.uploadData.getMapping(m).getClass() == UploadMappingDefTree.class) {
                UploadMappingDefTree treeMap = (UploadMappingDefTree)this.uploadData.getMapping(m);
                this.processTreeMap(treeMap);
            }
            ++m;
        }
    }

    protected Vector<UploadTable> getUploadTable(Table t) {
        TreeSet<UploadTable> its = new TreeSet<UploadTable>();
        for (UploadTable it : this.uploadTables) {
            if (!it.getTable().equals(t)) continue;
            its.add(it);
        }
        return new Vector<UploadTable>(its);
    }

    protected boolean isRelationshipImplemented(Relationship r, Table t) {
        boolean result = true;
        if (t.getName().equalsIgnoreCase("collectingeventattribute")) {
            if (r.getRelatedField().getName().equalsIgnoreCase("HostTaxonID")) {
                result = false;
            }
        } else if (t.getName().equalsIgnoreCase("paleocontext")) {
            if (r.getRelatedField().getName().equalsIgnoreCase("ChrnosStratID")) {
                result = false;
            }
        } else if (t.getName().equalsIgnoreCase("determination") && r.getRelatedField().getName().equalsIgnoreCase("PreferredTaxonID")) {
            result = false;
        }
        if (!result) {
            log.debug((Object)("Ignoring relationship: " + r.getField().getName() + ":" + r.getRelatedField().getName()));
        }
        return result;
    }

    protected void buildUploadTableParents() throws UploaderException {
        for (UploadTable it : this.uploadTables) {
            Vector<Vector<ParentTableEntry>> parentTables = new Vector<Vector<ParentTableEntry>>();
            Set<Vertex<Table>> tbls = this.uploadGraph.into(it.getTable());
            for (Vertex<Table> tv : tbls) {
                try {
                    Vector<Relationship> rs = this.uploadGraph.getAllEdgeData(tv.getData(), it.getTable());
                    for (Relationship r : rs) {
                        if (!this.isRelationshipImplemented(r, tv.getData())) continue;
                        Vector<UploadTable> impTs = this.getUploadTable(tv.getData());
                        Vector<ParentTableEntry> entries = new Vector<ParentTableEntry>();
                        for (UploadTable impT : impTs) {
                            if (impT.getRelationship() != null && !r.equals(impT.getRelationship())) continue;
                            impT.setHasChildren(true);
                            entries.add(new ParentTableEntry(impT, r));
                        }
                        parentTables.add(entries);
                    }
                }
                catch (DirectedGraphException ex) {
                    throw new UploaderException(ex, 20);
                }
            }
            try {
                it.setParentTables(parentTables);
            }
            catch (ClassNotFoundException ex) {
                throw new UploaderException(ex, 20);
            }
            catch (NoSuchMethodException ex) {
                throw new UploaderException(ex, 20);
            }
        }
    }

    protected void orderUploadTables() throws UploaderException {
        try {
            Vector<Vertex<Table>> topoSort = this.uploadGraph.getTopoSort();
            Vector<UploadTable> newTables = new Vector<UploadTable>();
            for (Vertex<Table> v : topoSort) {
                Vector<UploadTable> its = this.getUploadTable(v.getData());
                for (UploadTable it : its) {
                    newTables.add(it);
                    this.uploadTables.remove(it);
                }
                if (this.uploadTables.size() == 0) break;
            }
            this.uploadTables = newTables;
        }
        catch (DirectedGraphException ex) {
            throw new UploaderException(ex);
        }
    }

    protected void addRequiredUploadTables() throws UploaderException {
        if (AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent().booleanValue()) {
            boolean hasCO = false;
            boolean hasCE = false;
            for (UploadTable t : this.uploadTables) {
                if (t.getTblClass().equals(CollectionObject.class)) {
                    hasCO = true;
                    continue;
                }
                if (!t.getTblClass().equals(CollectingEvent.class)) continue;
                hasCE = true;
            }
            if (!hasCE && hasCO) {
                UploadTable ce = new UploadTable(this, this.db.getSchema().getTable("CollectingEvent"), null);
                ce.init();
                ce.addField(new UploadField(this.db.getSchema().getField("collectingevent", "stationfieldnumber"), -1, null, null));
                this.uploadTables.add(ce);
            }
        }
    }

    protected Vector<UploadTableInvalidValue> validateLengths(UploadTable uploadTable, int rowToValidate, int colToValidate) {
        Vector<UploadTableInvalidValue> result = new Vector<UploadTableInvalidValue>();
        int startRow = rowToValidate != -1 ? rowToValidate : 0;
        int endRow = rowToValidate != -1 ? rowToValidate + 1 : this.wbSS.getSpreadSheet().getRowCount();
        for (Vector<UploadField> ufs : uploadTable.getUploadFields()) {
            for (UploadField uf : ufs) {
                if (uf.getIndex() == -1) continue;
                int r = startRow;
                while (r < endRow) {
                    String value = this.wbSS.getSpreadSheet().getValueAt(r, uf.getIndex()).toString();
                    if (value.length() > this.wbSS.getColumnMaxWidth(uf.getIndex())) {
                        result.add(new UploadTableInvalidValue(null, uploadTable, uf, r, (Exception)new UploaderException(UIRegistry.getResourceString(WB_CELL_LENGTH_EXCEPTION), 30)));
                    }
                    ++r;
                }
            }
        }
        return result;
    }

    public Vector<UploadTableInvalidValue> validateData(int row, int col) {
        Vector<UploadTableInvalidValue> result = new Vector<UploadTableInvalidValue>();
        for (UploadTable tbl : this.uploadTables) {
            result.addAll(this.validateLengths(tbl, row, col));
            tbl.validateRowValues(row, this.uploadData, result);
        }
        return result;
    }

    public Vector<UploadField> checkChangedData(int row) throws Exception {
        this.getRootTable().loadExportedRecord(this.wbSS.getWorkbench().getRow(row).getRecordId());
        Vector<UploadField> result = new Vector<UploadField>();
        for (UploadTable ut : this.uploadTables) {
            result.addAll(ut.getChangedFields(row));
        }
        if (result.size() > 0) {
            for (UploadField uploadField : result) {
            }
        }
        return result;
    }

    public boolean recIsShared(UploadTable ut, Integer recID) {
        int utIndex = -1;
        boolean result = false;
        int t = 0;
        while (t < this.uploadTables.size()) {
            if (ut == this.uploadTables.get(t)) {
                utIndex = t;
                break;
            }
            ++t;
        }
        if (utIndex != -1) {
            t = utIndex + 1;
            while (t < this.uploadTables.size()) {
                UploadTable tbl = this.uploadTables.get(t);
                ParentTableEntry pte = tbl.getParentTableEntry(ut);
                if (pte != null) {
                    String sql = "select count(*) from " + tbl.getTblClass().getSimpleName().toLowerCase() + " where " + pte.getParentRel().getRelatedField() + " = " + ut.getExportedRecord().getId() + " and " + tbl.getTable().getTableInfo().getPrimaryKeyName() + " != " + tbl.getExportedRecord().getId();
                    Integer cnt = BasicSQLUtils.getCount(sql);
                    if (cnt != null && cnt > 0) {
                        return true;
                    }
                    if (this.recIsShared(tbl, tbl.getExportedRecord().getId())) {
                        return true;
                    }
                }
                ++t;
            }
        }
        return result;
    }

    protected Vector<Pair<Integer, UploadTable>> getUploadTablesForColForMatch(int col, List<UploadTableInvalidValue> invalidCols) {
        Vector<Pair<Integer, UploadTable>> result = new Vector<Pair<Integer, UploadTable>>();
        HashSet<Integer> badCols = new HashSet<Integer>();
        for (UploadTableInvalidValue utiv : invalidCols) {
            badCols.add(utiv.getCol());
        }
        if (col == -1) {
            for (UploadTable ut : this.uploadTables) {
                int seq = 0;
                while (seq < ut.getUploadFields().size()) {
                    if (ut.isMatchable(badCols, seq) && (!(ut instanceof UploadTableTree) || ((UploadTableTree)ut).getChild() == null)) {
                        result.add(new Pair<Integer, UploadTable>(seq, ut));
                    }
                    ++seq;
                }
            }
            return result;
        }
        for (UploadTable ut : this.uploadTables) {
            int seq = 0;
            for (Vector<UploadField> flds : ut.getUploadFields()) {
                if (ut.isMatchable(badCols, seq)) {
                    for (UploadField fld : flds) {
                        if (fld.getIndex() != col) continue;
                        result.add(new Pair<Integer, UploadTable>(seq, ut));
                        return result;
                    }
                }
                ++seq;
            }
        }
        return result;
    }

    public List<UploadTableMatchInfo> matchData(int row, int col, List<UploadTableInvalidValue> invalidCols) throws UploaderException, InvocationTargetException, IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, SQLException {
        int matchCol = -1;
        HashSet<Integer> invalidColNums = new HashSet<Integer>();
        for (UploadTableInvalidValue iv : invalidCols) {
            invalidColNums.add(iv.getCol());
        }
        if (matchCol == -1) {
            List<UploadTableMatchInfo> result = this.getRootTable().getMatchInfo(row, 0, invalidColNums);
            return result;
        }
        return null;
    }

    public DBFieldInfo getFieldInfoForCol(int col) {
        for (UploadTable ut : this.uploadTables) {
            for (Vector<UploadField> ufs : ut.getUploadFields()) {
                for (UploadField uf : ufs) {
                    if (uf.getIndex() != col || uf.getField() == null) continue;
                    return uf.getField().getFieldInfo();
                }
            }
        }
        return null;
    }

    public void setDefaultMatchStatus() {
        for (UploadTable t : this.uploadTables) {
            if (t instanceof UploadTableTree) {
                t.setCheckMatchInfo(true);
                continue;
            }
            if (Agent.class.isAssignableFrom(t.getTblClass())) {
                t.setCheckMatchInfo(true);
                continue;
            }
            if (Locality.class.isAssignableFrom(t.getTblClass()) || LocalityDetail.class.isAssignableFrom(t.getTblClass()) || GeoCoordDetail.class.isAssignableFrom(t.getTblClass())) {
                if (!AppPreferences.getRemote().getBoolean("WB_HighlightNewLocRecs", true).booleanValue() && !AppPreferences.getRemote().getBoolean("WB_HighlightNewCERecs", false).booleanValue()) continue;
                t.setCheckMatchInfo(true);
                continue;
            }
            if (CollectingEvent.class.isAssignableFrom(t.getTblClass())) {
                if (!AppPreferences.getRemote().getBoolean("WB_HighlightNewCERecs", false).booleanValue()) continue;
                t.setCheckMatchInfo(true);
                continue;
            }
            t.setCheckMatchInfo(false);
        }
    }

    public boolean validateData(boolean doInBackground) {
        this.dataValidated = false;
        this.setOpKiller(null);
        final Vector issues = new Vector();
        UploaderTask validateTask = new UploaderTask(true, "WB_UPLOAD_CANCEL_MSG"){

            @Override
            public Object doInBackground() {
                this.start();
                try {
                    int progress = 0;
                    Uploader.this.initProgressBar(0, Uploader.this.uploadTables.size(), true, String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_VALIDATING")) + " " + UIRegistry.getResourceString("ERD_TABLE"), false);
                    for (UploadTable tbl : Uploader.this.uploadTables) {
                        Uploader.this.setCurrentOpProgress(++progress);
                        issues.addAll(Uploader.this.validateLengths(tbl, -1, -1));
                        issues.addAll(tbl.validateValues(Uploader.this.uploadData));
                    }
                    Collections.sort(issues);
                    Uploader.this.dataValidated = issues.size() == 0;
                    return Uploader.this.dataValidated;
                }
                catch (Exception ex) {
                    Uploader.this.setOpKiller(ex);
                    return false;
                }
            }

            @Override
            public void done() {
                super.done();
                Uploader.this.validationIssues = issues;
                this.statusBar.setText("");
                if (this.cancelled) {
                    Uploader.this.setCurrentOp(Uploader.INITIAL_STATE);
                } else if (Uploader.this.dataValidated && Uploader.this.resolver.isResolved() && Uploader.this.mainPanel != null) {
                    Uploader.this.mainPanel.addMsg(new BaseUploadMessage(UIRegistry.getResourceString("WB_DATASET_VALIDATED")));
                    Uploader.this.setCurrentOp(Uploader.READY_TO_UPLOAD);
                } else if (Uploader.this.mainPanel != null) {
                    Uploader.this.mainPanel.addMsg(new BaseUploadMessage(UIRegistry.getResourceString("WB_INVALID_DATASET")));
                    Uploader.this.setCurrentOp(Uploader.USER_INPUT);
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIRegistry.getStatusBar().setText(UIRegistry.getResourceString(Uploader.VALIDATING_DATA));
            }
        });
        boolean result = true;
        validateTask.execute();
        if (!doInBackground) {
            try {
                result = (Boolean)validateTask.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    protected synchronized void cancelTask(UploaderTask task) {
        boolean tooLate = true;
        if (!task.isDone()) {
            tooLate = false;
            if (!task.isDone()) {
                task.setUndo(false);
                task.cancelTask();
            } else {
                tooLate = true;
            }
        }
        if (tooLate) {
            UIRegistry.displayErrorDlg(UIRegistry.getResourceString("WB_UPLOAD_TASK_ALREADY_COMPLETE"));
        }
    }

    public Set<Table> checkForMissingTables() {
        HashSet<Table> result = new HashSet<Table>();
        for (UploadTable t : this.uploadTables) {
            Set<Vertex<Table>> ins = this.uploadGraph.into(t.getTable());
            for (Vertex<Table> in : ins) {
                if (this.uploadTableIsPresent(in.getData())) continue;
                result.add(in.getData());
            }
        }
        return result;
    }

    public UploadData getUploadData() {
        return this.uploadData;
    }

    protected boolean uploadTableIsPresent(Table t) {
        for (UploadTable it : this.uploadTables) {
            if (it.getTable() != t) continue;
            return true;
        }
        return false;
    }

    protected boolean isInWBSchema(Table tbl) {
        return WorkbenchTask.getDatabaseSchema().getInfoById(tbl.getTableInfo().getTableId()) != null;
    }

    protected boolean isInUploadGraph(Vertex<Table> tbl) {
        return this.uploadGraph.getVertexByLabel(tbl.getLabel()) != null;
    }

    protected boolean isTreeable(Table tbl) {
        return Treeable.class.isAssignableFrom(tbl.getTableInfo().getClassObj());
    }

    protected Vertex<Table> getMatchingVertexInUpload(Table toMatch) {
        if (this.isTreeable(toMatch)) {
            UploadTable treeTbl = null;
            for (UploadTable ut : this.uploadTables) {
                UploadTableTree utt;
                if (!(ut instanceof UploadTableTree) || !(utt = (UploadTableTree)ut).getBaseTable().equals(toMatch) || treeTbl != null && ((UploadTableTree)treeTbl).getRank() >= utt.getRank()) continue;
                treeTbl = utt;
            }
            if (treeTbl == null) {
                return null;
            }
            return this.uploadGraph.getVertexByData(treeTbl.getTable());
        }
        return this.uploadGraph.getVertexByData(toMatch);
    }

    protected Vector<Vector<Table>> connectUploadGraph(int depth) throws DirectedGraphException {
        Vector<Vector<Table>> result = new Vector<Vector<Table>>();
        DirectedGraph<Table, Relationship> dbGraph = this.db.getSchema().getGraph();
        for (Vertex<Table> newTbl : dbGraph.getVertices()) {
            Vertex<Table> endPt;
            if (this.isTreeable(newTbl.getData()) || !this.isInWBSchema(newTbl.getData()) || this.isInUploadGraph(newTbl)) continue;
            this.uploadGraph.addVertex(newTbl);
            for (Vertex<Table> adj : dbGraph.getAdjacentVertices(newTbl)) {
                endPt = this.getMatchingVertexInUpload(adj.getData());
                if (endPt == null) continue;
                this.uploadGraph.addEdge(newTbl.getLabel(), endPt.getLabel());
            }
            for (Vertex<Table> adj : dbGraph.into(newTbl.getData())) {
                endPt = this.getMatchingVertexInUpload(adj.getData());
                if (endPt == null) continue;
                this.uploadGraph.addEdge(endPt.getLabel(), newTbl.getLabel());
            }
            if (this.uploadGraph.isConnected()) {
                Vector<Table> newTblResult = new Vector<Table>();
                newTblResult.add(newTbl.getData());
                result.add(newTblResult);
            } else if (depth - 1 > 0) {
                Vector<Vector<Table>> results = this.connectUploadGraph(depth - 1);
                for (Vector<Table> tbls : results) {
                    tbls.add(newTbl.getData());
                    result.add(tbls);
                }
            }
            this.uploadGraph.removeVertex(newTbl);
        }
        return result;
    }

    public boolean isUpdateUpload() {
        UploadTable root = this.getRootTable();
        return this.wbSS.getWorkbench().getExportedFromTableName() != null && root != null && root.isUpdateMatches();
    }

    protected boolean isValidUpdateUpload() {
        return true;
    }

    protected Vector<Vector<Table>> getMissingTbls() throws DirectedGraphException {
        Vector<Vector<Table>> result = new Vector<Vector<Table>>();
        int depth = 1;
        while (result.size() == 0 && depth < 4) {
            result.addAll(this.connectUploadGraph(depth++));
        }
        if (result.size() == 0) {
            result.add(null);
        }
        return this.removeDuplicateSolutions(result);
    }

    protected Vector<Vector<Table>> removeDuplicateSolutions(Vector<Vector<Table>> solutions) {
        TreeSet<Vector<Table>> sorted = new TreeSet<Vector<Table>>(new Comparator<Vector<Table>>(){

            @Override
            public int compare(Vector<Table> o1, Vector<Table> o2) {
                if (o1.size() == o2.size()) {
                    int id2;
                    if (o1.containsAll(o2)) {
                        return 0;
                    }
                    if (o1.size() == 0) {
                        return 0;
                    }
                    int id1 = o1.get(0).getTableInfo().getTableId();
                    return id1 < (id2 = o2.get(0).getTableInfo().getTableId()) ? -1 : (id1 == id2 ? 0 : 1);
                }
                return o1.size() < o2.size() ? -1 : 1;
            }
        });
        for (Vector<Table> solution : solutions) {
            sorted.add(solution);
        }
        Vector<Vector<Table>> result = new Vector<Vector<Table>>();
        result.addAll(sorted);
        return result;
    }

    protected boolean attachmentsPresent() {
        int r = 0;
        while (r < this.uploadData.getRows()) {
            Set<WorkbenchRowImage> images = this.uploadData.getWbRow(r).getWorkbenchRowImages();
            if (images != null && images.size() > 0) {
                return true;
            }
            ++r;
        }
        return false;
    }

    protected Vector<Class<?>> getAttachableTables() {
        Vector result = new Vector(8);
        result.add(FieldNotebook.class);
        result.add(FieldNotebookPageSet.class);
        result.add(FieldNotebookPage.class);
        result.add(Taxon.class);
        result.add(Accession.class);
        result.add(Locality.class);
        result.add(CollectingEvent.class);
        result.add(CollectionObject.class);
        return result;
    }

    public List<UploadTable> getAttachableTablesInUse() {
        Vector<UploadTable> result = new Vector<UploadTable>();
        for (UploadTable ut : this.uploadTables) {
            if (!AttachmentOwnerIFace.class.isAssignableFrom(ut.getTblClass()) || !this.attachmentsSupported(ut.getTblClass())) continue;
            result.add(ut);
        }
        return result;
    }

    protected boolean attachmentsSupported(Class<?> tblClass) {
        if (tblClass.equals(Agent.class)) {
            for (UploadTable ut : this.uploadTables) {
                if (ut.getTblClass().equals(Agent.class) || ut.getTblClass().equals(Address.class)) continue;
                return false;
            }
            return true;
        }
        if (tblClass.equals(Taxon.class)) {
            for (UploadTable ut : this.uploadTables) {
                if (ut.getTblClass().equals(Taxon.class)) continue;
                return false;
            }
            return true;
        }
        return !tblClass.equals(Preparation.class);
    }

    protected String getAttachableStr() {
        String result = "";
        HashSet clss = new HashSet();
        List<UploadTable> uts = this.getAttachableTablesInUse();
        for (UploadTable uploadTable : uts) {
            clss.add(uploadTable.getTblClass());
        }
        for (Class clazz : clss) {
            DBTableInfo info = DBTableIdMgr.getInstance().getByClassName(clazz.getName());
            if (info == null) continue;
            if (!StringUtils.isBlank((String)result)) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + info.getTitle();
        }
        return result;
    }

    public UploadTable getAttachToTable() {
        int priority = -1;
        Vector<Class<?>> attachable = this.getAttachableTables();
        UploadTable result = null;
        boolean isAgentOnly = true;
        for (UploadTable ut : this.uploadTables) {
            int newPriority;
            if (!ut.getTblClass().equals(Agent.class) || ut.getTblClass().equals(Address.class)) {
                isAgentOnly = false;
            }
            if ((newPriority = attachable.indexOf(ut.getTblClass())) <= priority) continue;
            priority = newPriority;
            result = ut;
        }
        if (result instanceof UploadTableTree) {
            while (((UploadTableTree)result).getChild() != null) {
                result = ((UploadTableTree)result).getChild();
            }
        }
        if (result == null && isAgentOnly) {
            for (UploadTable ut : this.uploadTables) {
                if (!ut.getTblClass().equals(Agent.class)) continue;
                return ut;
            }
        }
        return result;
    }

    public UploadTable getAttachToTable(WorkbenchRowImage wri) {
        String relTblName;
        if (wri.getAttachToTableName() == null) {
            return this.getAttachToTable();
        }
        String[] attachToStrs = wri.getAttachToTableName().split("\\.");
        String tblName = attachToStrs[0];
        UploadTable result = this.getUploadTableByNameRel(tblName, relTblName = attachToStrs.length > 1 ? attachToStrs[1] : null);
        if (result == null) {
            result = this.getAttachToTable();
            String msg = "row " + this.rowUploading + ": " + wri.getAttachToTableName() + " is not mapped." + " Attaching image to " + (result != null ? result.toString() : "default") + " table.";
            log.warn((Object)msg);
        }
        return result;
    }

    protected boolean verifyAttachments() {
        if (!this.attachmentsPresent()) {
            return true;
        }
        return this.getAttachToTable() != null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Vector<UploadMessage> verifyUploadability() throws UploaderException, ClassNotFoundException {
        errors = new Vector<UploadMessage>();
        try {
            missingTbls = new Vector<Object>();
            for (UploadTable t : this.uploadTables) {
                if (!t.isOneToOneChild() || t.getHasChildren() || t.getTblClass().equals(LocalityDetail.class) || t.getTblClass().equals(GeoCoordDetail.class)) continue;
                vs = this.db.getGraph().getAdjacentVertices(new Vertex<Table>(t.getTable().getName(), t.getTable()));
                tbls = new Vector<E>();
                for (Vertex<Table> vertex : vs) {
                    tbls.add(vertex.getData());
                }
                missingTbls.add(tbls);
            }
            if (!this.uploadGraph.isConnected()) {
                missingTbls.addAll(this.getMissingTbls());
            }
            if (missingTbls.size() > 0) {
                missingTblHints = new Vector<Pair<String, Vector>>();
                h = 1;
                for (Vector tbls : missingTbls) {
                    msg = "";
                    if (tbls != null && tbls.size() > 0) {
                        msg = String.valueOf(msg) + " ";
                        t = 0;
                        while (t < tbls.size()) {
                            if (t > 0) {
                                msg = String.valueOf(msg) + ", ";
                            }
                            msg = String.valueOf(msg) + ((Table)tbls.get(t)).getTableInfo().getTitle();
                            ++t;
                        }
                    }
                    if (msg.equals("")) continue;
                    missingTblHints.add(new Pair<String, Vector>(String.format(UIRegistry.getResourceString("WB_UPLOAD_MISSING_TBL_HINT"), new Object[]{h++, msg}), tbls));
                }
                if (missingTblHints.size() > 0) {
                    errors.add(new BaseUploadMessage(UIRegistry.getResourceString("WB_UPLOAD_MISSING_TBL_HINTS")));
                    for (Iterator<RelatedClassSetter> hint : missingTblHints) {
                        errors.add(new InvalidStructure("   " + (String)hint.getFirst(), hint.getSecond()));
                    }
                } else {
                    errors.add(new BaseUploadMessage(UIRegistry.getResourceString("WB_UPLOAD_MISSING_TBL_NO_HINTS")));
                }
            }
        }
        catch (DirectedGraphException ex) {
            throw new UploaderException(ex, 20);
        }
        errors.addAll(this.validateConsistency());
        if (!this.verifyAttachments()) {
            msg = String.format(UIRegistry.getResourceString("WB_UPLOAD_NO_ATTACHABLES"), new Object[]{this.getAttachableStr()});
            errors.add(new BaseUploadMessage(msg));
        }
        if (errors.size() != 0) {
            return errors;
        }
        this.missingRequiredClasses.clear();
        this.missingRequiredFields.clear();
        for (UploadTable t : this.uploadTables) {
            try {
                rces = t.getRelatedClassDefaults();
                if (true) ** GOTO lbl69
            }
            catch (ClassNotFoundException ex) {
                Uploader.log.error((Object)ex);
                return null;
            }
            do {
                this.missingRequiredClasses.add(rces.next());
lbl69:
                // 2 sources

            } while (rces.hasNext());
            try {
                dfes = t.getMissingRequiredFlds();
                if (true) ** GOTO lbl79
            }
            catch (NoSuchMethodException ex) {
                Uploader.log.error((Object)ex);
                return null;
            }
            do {
                this.missingRequiredFields.add(dfes.next());
lbl79:
                // 2 sources

            } while (dfes.hasNext());
        }
        this.resolver = new MissingDataResolver(this.missingRequiredClasses, this.missingRequiredFields);
        for (RelatedClassSetter rcs : this.missingRequiredClasses) {
            if (rcs.isDefined()) continue;
            tblName = DBTableIdMgr.getInstance().getByShortClassName(rcs.getRelatedClass().getSimpleName()).getTitle();
            msg = String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MISSING_DBDATA")) + ": " + (String)tblName;
            errors.add(new InvalidStructure(msg, this));
        }
        undefinedDfes = new Vector<DefaultFieldEntry>();
        for (DefaultFieldEntry dfe : this.missingRequiredFields) {
            if (dfe.isDefined()) continue;
            undefinedDfes.add(dfe);
        }
        Collections.sort(undefinedDfes, new Comparator<DefaultFieldEntry>(){

            @Override
            public int compare(DefaultFieldEntry o1, DefaultFieldEntry o2) {
                boolean o2IsUserFld;
                int result = o1.getUploadTbl().getTable().getName().compareTo(o2.getUploadTbl().getTable().getName());
                if (result != 0) {
                    return result;
                }
                boolean o1IsUserFld = o1.getUploadFld() == null || o1.getUploadFld().getIndex() != -1;
                boolean bl = o2IsUserFld = o2.getUploadFld() == null || o2.getUploadFld().getIndex() != -1;
                if (o1IsUserFld == o2IsUserFld) {
                    return o1.getFldName().compareTo(o2.getFldName());
                }
                if (o1IsUserFld) {
                    return -1;
                }
                return 1;
            }
        });
        currentTbl = null;
        dfes4Tbl = new Vector<DefaultFieldEntry>();
        dfes2Remove = new Vector<DefaultFieldEntry>();
        for (DefaultFieldEntry dfe : undefinedDfes) {
            if (dfe.getUploadTbl() != currentTbl) {
                if (dfes4Tbl.size() > 1) {
                    gotAUserFld = false;
                    for (DefaultFieldEntry tblDfe : dfes4Tbl) {
                        isAUserFld = tblDfe.getUploadFld() == null || tblDfe.getUploadFld().getIndex() != -1;
                        v0 = gotAUserFld = gotAUserFld != false || isAUserFld != false;
                        if (isAUserFld || !gotAUserFld) continue;
                        dfes2Remove.add(tblDfe);
                    }
                }
                dfes4Tbl.clear();
                currentTbl = dfe.getUploadTbl();
            }
            dfes4Tbl.add(dfe);
        }
        if (dfes4Tbl.size() > 1) {
            gotAUserFld = false;
            for (DefaultFieldEntry tblDfe : dfes4Tbl) {
                isAUserFld = tblDfe.getUploadFld() == null || tblDfe.getUploadFld().getIndex() != -1;
                v1 = gotAUserFld = gotAUserFld != false || isAUserFld != false;
                if (isAUserFld || !gotAUserFld) continue;
                dfes2Remove.add(tblDfe);
            }
        }
        for (DefaultFieldEntry dfe : dfes2Remove) {
            undefinedDfes.remove(dfe);
        }
        for (DefaultFieldEntry dfe : undefinedDfes) {
            msg = String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MISSING_DBDATA")) + ": " + dfe.getUploadTbl().getTable().getTableInfo().getTitle() + "." + dfe.getFldName();
            errors.add(new InvalidStructure(msg, this));
        }
        for (UploadTable t : this.uploadTables) {
            errors.addAll(t.verifyUploadability());
        }
        return errors;
    }

    public Vector<UploadMessage> validateConsistency() {
        Vector<UploadMessage> result = new Vector<UploadMessage>();
        try {
            TreeMapElements maxTaxSeqLevel = null;
            int m = 0;
            while (m < this.uploadData.getCols()) {
                if (this.uploadData.getMapping(m).getTable().equalsIgnoreCase("taxon")) {
                    TreeMapElements tmes;
                    UploadMappingDefTree tmap = (UploadMappingDefTree)this.uploadData.getMapping(m);
                    boolean seqSizeInconsistent = false;
                    int l = 0;
                    while (l < tmap.getLevels().size()) {
                        tmes = tmap.getLevels().get(l);
                        if (tmes.getMaxSeq() > 0 || maxTaxSeqLevel != null && maxTaxSeqLevel.getRank() < tmes.getRank()) {
                            if (maxTaxSeqLevel == null) {
                                maxTaxSeqLevel = tmes;
                            } else if (maxTaxSeqLevel.getMaxSeq() != tmes.getMaxSeq()) {
                                seqSizeInconsistent = true;
                                if (maxTaxSeqLevel.getMaxSeq() < tmes.getMaxSeq()) {
                                    maxTaxSeqLevel = tmes;
                                }
                            }
                        }
                        boolean[] seqs = tmes.getSeqs();
                        int s = 0;
                        while (s < seqs.length) {
                            if (!seqs[s]) {
                                String msg = String.format(UIRegistry.getResourceString("WB_UPLOAD_MISSING_SEQ"), tmes.getWbFldName());
                                result.add(new InvalidStructure(msg, null));
                            }
                            ++s;
                        }
                        ++l;
                    }
                    if (seqSizeInconsistent && maxTaxSeqLevel != null) {
                        l = 0;
                        while (l < tmap.getLevels().size()) {
                            tmes = tmap.getLevels().get(l);
                            if (tmes.getRank() > maxTaxSeqLevel.getRank() && tmes.getMaxSeq() < maxTaxSeqLevel.getMaxSeq()) {
                                int s = tmes.getMaxSeq() + 1;
                                while (s <= maxTaxSeqLevel.getMaxSeq()) {
                                    String msg = String.format(UIRegistry.getResourceString("WB_UPLOAD_MISSING_SEQ"), tmes.getWbFldName());
                                    result.add(new InvalidStructure(msg, null));
                                    ++s;
                                }
                            }
                            ++l;
                        }
                    }
                }
                ++m;
            }
            if (maxTaxSeqLevel != null && maxTaxSeqLevel.size() > 1) {
                int isCurrentCount = 0;
                boolean[] isCurrentPresent = new boolean[maxTaxSeqLevel.size()];
                int b = 0;
                while (b < isCurrentPresent.length) {
                    isCurrentPresent[b] = false;
                    ++b;
                }
                String isCurrentCaptionSample = null;
                int m2 = 0;
                while (m2 < this.uploadData.getCols()) {
                    if (this.uploadData.getMapping(m2).getTable().equalsIgnoreCase("determination") && this.uploadData.getMapping(m2).getField().equalsIgnoreCase("iscurrent")) {
                        ++isCurrentCount;
                        isCurrentPresent[((UploadMappingDefRel)this.uploadData.getMapping((int)m2)).getSequence().intValue()] = true;
                        isCurrentCaptionSample = this.uploadData.getMapping(m2).getWbFldName();
                    }
                    ++m2;
                }
                if (isCurrentCount != 0 && isCurrentCount != maxTaxSeqLevel.size()) {
                    int c = 0;
                    while (c < isCurrentPresent.length) {
                        if (!isCurrentPresent[c]) {
                            String fldName = isCurrentCaptionSample != null ? isCurrentCaptionSample.substring(0, isCurrentCaptionSample.length() - 2).trim() : "Is Current";
                            String msg = String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MISSING_FLD")) + ": " + fldName + " " + Integer.toString(c + 1);
                            result.add(new InvalidStructure(msg, null));
                        }
                        ++c;
                    }
                }
            }
            Vector<UploadMessage> vector = result;
            return vector;
        }
        finally {
            if (result.size() > 0) {
                currentUpload = null;
            }
        }
    }

    public synchronized Integer getRowRecordId(int row) throws UploaderException {
        try {
            return this.wbSS.getWorkbench().getRow(row).getRecordId();
        }
        catch (Exception ex) {
            throw new UploaderException(ex, 20);
        }
    }

    protected void setUpdateTableId(Integer updateTblId) {
        this.updateTableId.set(updateTblId == null ? -1 : updateTblId);
    }

    protected Integer getUpdateTableId() {
        int got = this.updateTableId.get();
        return got >= 0 ? Integer.valueOf(got) : null;
    }

    protected void prepareToUpload() throws UploaderException {
        Integer updateTblId = this.isUpdateUpload() ? Integer.valueOf(DBTableIdMgr.getInstance().getIdByClassName(this.wbSS.getWorkbench().getExportedFromTableName())) : null;
        this.setUpdateTableId(updateTblId);
        if (this.currentOp != SUCCESS_PARTIAL) {
            for (UploadTable t : this.uploadTables) {
                t.setMatchRecordId(t.isMatchRecordId() || updateTblId != null && updateTblId.intValue() == t.getTable().getTableInfo().getTableId());
                if (updateTblId != null && updateTblId == CollectionObject.getClassTableId() && t.getTable().getTableInfo().getTableId() == CollectingEvent.getClassTableId() && AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent().booleanValue()) {
                    t.setMatchRecordId(true);
                }
                t.setUpdateMatches(this.isUpdateUpload());
                t.prepareToUpload();
            }
            this.newAttachments.clear();
            this.skippedRows.clear();
            this.messages.clear();
            this.uploadStartRow = 0;
        } else {
            this.uploadStartRow = this.rowUploading;
            if (this.wbSS.getWorkbench().getRow(this.rowUploading).getUploadStatus() == 1) {
                ++this.uploadStartRow;
            }
        }
        if (this.uploadedObjectViewer != null) {
            this.uploadedObjectViewer.closeView();
        }
        this.newMessages.clear();
    }

    public synchronized void setCurrentOp(String opName) {
        this.previousOp = this.currentOp;
        this.currentOp = opName;
        if (this.mainPanel == null) {
            log.error((Object)"UI does not exist.");
            return;
        }
        this.setupUI(this.currentOp);
        this.setOpKiller(null);
    }

    protected synchronized void setOpKiller(Exception killer) {
        this.opKiller = killer;
    }

    protected synchronized Exception getOpKiller() {
        return this.opKiller;
    }

    protected void initProgressBar(final int min, final int max, final boolean paintString, final String itemName, final boolean useAppProgress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!Uploader.this.useAppStatBar && Uploader.this.mainPanel == null) {
                    log.error((Object)"UI does not exist.");
                    return;
                }
                Uploader.this.minProgVal = min;
                Uploader.this.maxProgVal = max;
                Uploader.this.indeterminateProgress = Uploader.this.minProgVal == 0 && Uploader.this.maxProgVal == 0;
                Uploader.this.useAppStatBar = useAppProgress;
                if (Uploader.this.useAppStatBar) {
                    if (Uploader.this.indeterminateProgress) {
                        UIRegistry.getStatusBar().setIndeterminate("UPLOADER", Uploader.this.indeterminateProgress);
                    } else {
                        UIRegistry.getStatusBar().setProgressRange("UPLOADER", Uploader.this.minProgVal, Uploader.this.maxProgVal);
                    }
                } else {
                    JProgressBar pb = Uploader.this.mainPanel.getCurrOpProgress();
                    pb.setVisible(true);
                    if (Uploader.this.indeterminateProgress) {
                        pb.setIndeterminate(true);
                        pb.setString("");
                    } else {
                        if (pb.isIndeterminate()) {
                            pb.setIndeterminate(false);
                        }
                        pb.setStringPainted(paintString);
                        if (paintString) {
                            pb.setName(itemName);
                        }
                        pb.setMinimum(Uploader.this.minProgVal);
                        pb.setMaximum(Uploader.this.maxProgVal);
                        pb.setValue(Uploader.this.minProgVal);
                    }
                }
            }
        });
    }

    protected void setCurrentOpProgress(final int val) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Uploader.this.mainPanel == null && !Uploader.this.useAppStatBar) {
                    log.error((Object)"UI does not exist.");
                    return;
                }
                if (!Uploader.this.indeterminateProgress) {
                    if (Uploader.this.useAppStatBar && !Uploader.this.indeterminateProgress) {
                        if (val == -1) {
                            UIRegistry.getStatusBar().incrementValue("UPLOADER");
                        } else {
                            UIRegistry.getStatusBar().setValue("UPLOADER", val);
                        }
                    } else {
                        JProgressBar pb = Uploader.this.mainPanel.getCurrOpProgress();
                        int newVal = val == -1 ? Math.min(pb.getValue() + 1, pb.getMaximum()) : val;
                        pb.setValue(newVal);
                        if (pb.isStringPainted()) {
                            pb.setString(String.format(UIRegistry.getResourceString("WB_UPLOAD_PROGRESSBAR_TEXT"), pb.getName(), Integer.toString(newVal), Integer.toString(pb.getMaximum())));
                        }
                    }
                }
            }
        });
    }

    protected void showUploadProgress(final int val) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Uploader.this.mainPanel == null) {
                    log.error((Object)"UI does not exist.");
                    return;
                }
                Uploader.this.setCurrentOpProgress(val);
                Uploader uploader = Uploader.this;
                synchronized (uploader) {
                    for (UploadMessage newMsg : Uploader.this.newMessages) {
                        Uploader.this.mainPanel.addMsg(newMsg);
                        Uploader.this.messages.add(newMsg);
                    }
                    Uploader.this.newMessages.clear();
                }
            }
        });
    }

    public void undoStep() {
        this.setCurrentOpProgress(-1);
    }

    protected void updateObjectsCreated() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Uploader.this.mainPanel.updateObjectsCreated();
            }
        });
    }

    protected void initUI(String initOp) {
        this.buildMainUI();
        this.setCurrentOp(initOp);
    }

    public void startUI() {
        if (this.mainPanel == null) {
            log.error((Object)"Upload ui is null");
            return;
        }
        this.mainPanel.clearMsgs(new Class[]{BaseUploadMessage.class});
        this.setCurrentOp(INITIAL_STATE);
    }

    public void getDefaultsForMissingRequirements() {
        this.setOpKiller(null);
        UploaderTask uploadTask = new UploaderTask(false, ""){
            boolean success;
            {
                this.success = false;
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object doInBackground() {
                this.start();
                try {
                    Uploader.this.missingRequiredClasses.clear();
                    Uploader.this.missingRequiredFields.clear();
                    var4_1 = Uploader.this.uploadTables.iterator();
lbl6:
                    // 2 sources

                    while (true) {
                        if (!var4_1.hasNext()) {
                            Uploader.this.resolver = new MissingDataResolver(Uploader.this.missingRequiredClasses, Uploader.this.missingRequiredFields);
                            return null;
                        }
                        t = var4_1.next();
                        try {
                            rces = t.getRelatedClassDefaults();
                            ** GOTO lbl17
                        }
                        catch (ClassNotFoundException ex) {
                            Uploader.log.error((Object)ex);
                            return null;
lbl17:
                            // 1 sources

                            if (true) ** GOTO lbl24
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    Uploader.this.setOpKiller(ex);
                    return false;
                }
                do {
                    Uploader.this.missingRequiredClasses.add(rces.next());
lbl24:
                    // 2 sources

                } while (rces.hasNext());
                try {
                    dfes = t.getMissingRequiredFlds();
                    if (true) ** GOTO lbl34
                }
                catch (NoSuchMethodException ex) {
                    Uploader.log.error((Object)ex);
                    return null;
                }
                do {
                    Uploader.this.missingRequiredFields.add(dfes.next());
lbl34:
                    // 2 sources

                } while (dfes.hasNext());
                this.success = true;
                ** while (true)
            }

            @Override
            public void done() {
                super.done();
                this.statusBar.setText("");
                if (this.success) {
                    Uploader.this.mainPanel.addMsg(new BaseUploadMessage(UIRegistry.getResourceString("WB_REQUIRED_RETRIEVED")));
                } else {
                    Uploader.this.mainPanel.addMsg(new BaseUploadMessage(UIRegistry.getResourceString("WB_REQUIRED_RETRIEVED")));
                    Uploader.this.setCurrentOp(Uploader.FAILURE);
                }
            }
        };
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString(CHECKING_REQS));
        uploadTask.execute();
        this.initUI(CHECKING_REQS);
    }

    public void refresh() {
        if (this.currentOp.equals(USER_INPUT)) {
            this.uploadData.refresh(this.wbSS.getWorkbench().getWorkbenchRowsAsList());
            this.validateData(true);
        }
    }

    public boolean closing(WorkbenchPaneSS shutter) {
        if (shutter != this.wbSS) {
            return false;
        }
        if (this.mainPanel != null) {
            this.closeMainForm(false);
        }
        return true;
    }

    protected Integer getUploadedObjects() {
        Integer result = 0;
        for (UploadTable ut : this.uploadTables) {
            result = result + ut.getUploadedRecs().size();
        }
        return result;
    }

    public void closeMainForm(boolean notifyWB) {
        try {
            this.logDebug("closing main form");
            this.mainPanel.setVisible(false);
            this.mainPanel = null;
            this.closeUploadedDataViewers();
            for (Component c : this.keyListeningTo) {
                this.logDebug("removing key listener");
                c.removeKeyListener(this);
            }
            this.keyListeningTo.clear();
            if (notifyWB) {
                this.wbSS.uploadDone();
            }
        }
        finally {
            currentUpload = null;
        }
    }

    public UploadMainPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.initUI(INITIAL_STATE);
        }
        return this.mainPanel;
    }

    protected void closeUploadedDataViewers() {
        if (this.bogusViewer != null) {
            this.bogusViewer.closeViewers();
            this.bogusViewer = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("VALIDATE_CONTENT")) {
            this.validateData(true);
        } else if (e.getActionCommand().equals("DO_UPLOAD")) {
            if (this.isUpdateUpload()) {
                if (!this.isValidUpdateUpload()) {
                    UIRegistry.showError("This dataset contains mappings which are not updateable");
                    return;
                }
                if (!UIRegistry.displayConfirm("Ready to Update", "This update cannot be undone. Are you sure you want to continue?", "Yes", "No", 2)) {
                    return;
                }
            }
            this.uploadIt(true);
        } else if (e.getActionCommand().equals("VIEW_UPLOAD")) {
            if (this.currentOp.equals(SUCCESS) || this.currentOp.equals(SUCCESS_PARTIAL)) {
                this.viewAllObjectsCreatedByUpload();
            }
        } else if (e.getActionCommand().equals("VIEW_SETTINGS")) {
            this.showSettings();
            if (this.currentOp.equals(READY_TO_UPLOAD) && !this.resolver.isResolved()) {
                this.setCurrentOp(USER_INPUT);
            } else if (this.currentOp.equals(USER_INPUT) && this.resolver.isResolved()) {
                this.setCurrentOp(READY_TO_UPLOAD);
            }
        } else if (e.getActionCommand().equals("CLOSE_UI")) {
            if (this.aboutToShutdown(null)) {
                this.closeMainForm(true);
            }
        } else if (e.getActionCommand().equals("UNDO_UPLOAD")) {
            if (UIRegistry.displayConfirm(UIRegistry.getResourceString(WB_UPLOAD_FORM_TITLE), UIRegistry.getResourceString("WB_UNDO_UPLOAD_MSG"), UIRegistry.getResourceString("OK"), UIRegistry.getResourceString("CANCEL"), 3)) {
                this.undoUpload(true, false, true);
            }
        } else if (e.getActionCommand().equals("TBL_DBL_CLICK")) {
            this.mainPanel.getViewUploadBtn().setEnabled(this.canViewUpload(this.currentOp));
            if (this.currentOp.equals(SUCCESS) || this.currentOp.equals(SUCCESS_PARTIAL)) {
                this.viewAllObjectsCreatedByUpload();
            }
        } else if (e.getActionCommand().equals("TBL_CLICK")) {
            this.mainPanel.getViewUploadBtn().setEnabled(this.canViewUpload(this.currentOp));
        } else if (e.getActionCommand().equals("MSG_CLICK")) {
            this.goToMsgWBCell((Component)e.getSource(), false);
        } else if (e.getActionCommand().equals("PRINT_INVALID")) {
            this.printInvalidValReport();
        } else if (e.getActionCommand().equals("CANCEL_OPERATION")) {
            if (this.currentTask != null && this.currentTask.isCancellable()) {
                this.cancelTask(this.currentTask);
            } else {
                log.info((Object)("ignoring action: " + e.getActionCommand()));
            }
        } else {
            log.error((Object)("Unrecognized action: " + e.getActionCommand()));
        }
    }

    public boolean aboutToShutdown(WorkbenchPaneSS shuttingDownSS) {
        if (shuttingDownSS != null && shuttingDownSS != this.wbSS) {
            return true;
        }
        if (this.currentTask != null || shuttingDownSS != null && (this.currentOp.equals(SUCCESS) || this.currentOp.equals(SUCCESS_PARTIAL)) && this.getUploadedObjects() > 0) {
            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("WB_UPLOAD_BUSY_CANNOT_CLOSE"));
            return false;
        }
        boolean result = true;
        if (this.uploadedObjectViewer != null) {
            this.uploadedObjectViewer.closeView();
        }
        if (result && shuttingDownSS == null && (this.currentOp.equals(SUCCESS) || this.currentOp.equals(SUCCESS_PARTIAL)) && this.getUploadedObjects() > 0 && !this.isUpdateUpload()) {
            result = false;
            String msg = String.format(UIRegistry.getResourceString("WB_UPLOAD_CONFIRM_SAVE"), this.wbSS.getWorkbench().getName());
            JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
            int rv = JOptionPane.showConfirmDialog(topFrame, msg, UIRegistry.getResourceString(WB_UPLOAD_FORM_TITLE), 1);
            if (rv == 0) {
                this.saveRecordSets();
                result = true;
                this.wbSS.saveObject();
            } else if (rv == 1) {
                this.undoUpload(shuttingDownSS == null, true, true);
                result = true;
            }
            if (result) {
                for (UploadTable ut : this.uploadTables) {
                    try {
                        ut.shutdown();
                    }
                    catch (UploaderException ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(Uploader.class, ex);
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        if (this.additionalLocksSet) {
            this.freeAdditionalLocks();
        }
        return result;
    }

    protected void showSettings() {
        boolean readOnly = !this.currentOp.equals(READY_TO_UPLOAD) && !this.currentOp.equals(SUCCESS_PARTIAL) && !this.currentOp.equals(USER_INPUT);
        UploadSettingsPanel usp = new UploadSettingsPanel(this.uploadTables);
        usp.buildUI(this.resolver, readOnly);
        CustomDialog cwin = !readOnly ? new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WB_UPLOAD_SETTINGS"), true, usp) : new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WB_UPLOAD_SETTINGS"), true, 1, usp, 1);
        cwin.setModal(true);
        UIHelper.centerAndShow(cwin);
        if (!cwin.isCancelled()) {
            usp.getMatchPanel().apply();
        }
        cwin.dispose();
    }

    protected void printInvalidValReport() {
        if (this.validationIssues == null || this.validationIssues.size() == 0) {
            log.error((Object)"no validationIssues");
            return;
        }
        InvalidValueJRDataSource src = new InvalidValueJRDataSource(this.validationIssues);
        CommandAction cmd = new CommandAction("Reports", "RPT.PrintReport", src);
        cmd.setProperty("title", "Validation Issues");
        cmd.setProperty("file", "upload_problem_report.jrxml");
        CommandDispatcher.dispatch(cmd);
    }

    protected void goToMsgWBCell(Component c, boolean stopEdit) {
        if (this.mainPanel == null) {
            throw new RuntimeException("Upload form does not exist.");
        }
        if (this.wbSS != null) {
            UploadMessage msg = c == this.mainPanel.getValidationErrorList() ? (UploadMessage)this.mainPanel.getValidationErrorList().getSelectedValue() : (UploadMessage)this.mainPanel.getMsgList().getSelectedValue();
            if (msg == null) {
                this.logDebug("gotToMsgWBCell: null message");
                return;
            }
            if (msg.getRow() != -1) {
                if (msg.getCol() == -1) {
                    this.wbSS.getSpreadSheet().scrollToRow(msg.getRow());
                    this.wbSS.getSpreadSheet().getSelectionModel().clearSelection();
                    this.wbSS.getSpreadSheet().getSelectionModel().setSelectionInterval(msg.getRow(), msg.getRow());
                } else {
                    this.wbSS.getSpreadSheet().getSelectionModel().clearSelection();
                    Rectangle rect = this.wbSS.getSpreadSheet().getCellRect(msg.getRow(), msg.getCol(), false);
                    this.wbSS.getSpreadSheet().scrollRectToVisible(rect);
                    if (msg instanceof UploadTableInvalidValue && msg.getCol() != -1) {
                        if (!stopEdit) {
                            this.wbSS.getSpreadSheet().editCellAt(msg.getRow(), msg.getCol(), null);
                            Component editor = this.wbSS.getSpreadSheet().getEditorComponent();
                            boolean addListener = true;
                            KeyListener[] listeners = editor.getKeyListeners();
                            int k = 0;
                            while (k < listeners.length) {
                                if (listeners[k] instanceof Uploader) {
                                    if (listeners[k] == this) {
                                        this.logDebug("already listening to spreadsheet editor");
                                        addListener = false;
                                        break;
                                    }
                                    this.logDebug("removing previous listener");
                                    editor.removeKeyListener(listeners[k]);
                                }
                                ++k;
                            }
                            if (addListener) {
                                this.logDebug("adding this as listener to spreadsheet editor");
                                editor.addKeyListener(this);
                                this.keyListeningTo.add(editor);
                            }
                            editor.requestFocusInWindow();
                        } else if (this.wbSS.getSpreadSheet().getCellEditor() != null) {
                            this.wbSS.getSpreadSheet().getCellEditor().stopCellEditing();
                        }
                    }
                }
            }
        }
        if (this.mainPanel == null) {
            throw new RuntimeException("Upload form does not exist.");
        }
    }

    protected void goToNextInvalidCell() {
        this.logDebug("goToNextInvalidCell");
        int sel = this.mainPanel.getValidationErrorList().getSelectedIndex() + 1;
        if (sel >= this.mainPanel.getValidationErrorList().getModel().getSize()) {
            sel = 1;
        }
        if (sel != -1) {
            boolean stopEditing = sel == this.mainPanel.getValidationErrorList().getSelectedIndex();
            this.mainPanel.getValidationErrorList().setSelectedIndex(sel);
            this.logDebug("Going to msg " + sel);
            this.goToMsgWBCell(this.mainPanel.getValidationErrorList(), stopEditing);
        }
    }

    protected void goToPrevInvalidCell() {
        int sel = this.mainPanel.getValidationErrorList().getSelectedIndex() - 1;
        if (sel < 1) {
            sel = this.mainPanel.getValidationErrorList().getModel().getSize() - 1;
        }
        if (sel != -1) {
            boolean stopEdit = sel == this.mainPanel.getValidationErrorList().getSelectedIndex();
            this.mainPanel.getValidationErrorList().setSelectedIndex(sel);
            this.goToMsgWBCell(this.mainPanel.getValidationErrorList(), stopEdit);
        }
    }

    protected void goToFirstInvalidCell() {
        if (this.mainPanel.getValidationErrorList().getModel().getSize() > 0) {
            this.mainPanel.getValidationErrorList().setSelectedIndex(0);
            this.goToMsgWBCell(this.mainPanel.getValidationErrorList(), false);
        }
    }

    protected void goToLastInvalidCell() {
        if (this.mainPanel.getValidationErrorList().getModel().getSize() > 0) {
            this.mainPanel.getValidationErrorList().setSelectedIndex(this.mainPanel.getValidationErrorList().getModel().getSize() - 1);
            this.goToMsgWBCell(this.mainPanel.getValidationErrorList(), false);
        }
    }

    protected void buildMainUI() {
        this.mainPanel = new UploadMainPanel(this.isUpdateUpload());
        TreeSet<UploadInfoRenderable> uts = new TreeSet<UploadInfoRenderable>();
        block0: for (UploadTable ut : this.uploadTables) {
            UploadInfoRenderable render = new UploadInfoRenderable(ut);
            if (uts.contains(render)) {
                for (UploadInfoRenderable r : uts) {
                    if (!r.equals(render)) continue;
                    r.addTable(ut);
                    continue block0;
                }
                continue;
            }
            uts.add(new UploadInfoRenderable(ut));
        }
        this.mainPanel.addAffectedTables(uts.iterator());
        this.mainPanel.setActionListener(this);
    }

    protected void setupUI(String op) {
        if (this.mainPanel == null) {
            log.error((Object)"UI does not exist.");
            return;
        }
        if (op.equals(RETRIEVING_UPLOADED_DATA)) {
            return;
        }
        int uploadedObjects = this.getUploadedObjects();
        if ((op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL)) && this.mainPanel.getUploadTbls().getSelectedIndex() == -1) {
            this.mainPanel.getUploadTbls().setSelectedIndex(0);
        }
        if (op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL)) {
            if (uploadedObjects > 0 && !this.isUpdateUpload()) {
                this.mainPanel.closeBtn.setText(UIRegistry.getResourceString("WB_UPLOAD.COMMIT"));
            } else {
                this.mainPanel.closeBtn.setText(UIRegistry.getResourceString("CLOSE"));
            }
        }
        if (op.equals(READY_TO_UPLOAD)) {
            this.mainPanel.closeBtn.setText(UIRegistry.getResourceString("CLOSE"));
        }
        if (op.equals(UPLOADING) || op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL)) {
            this.mainPanel.showUploadTblTbl();
        } else if (uploadedObjects == 0 || op.equals(READY_TO_UPLOAD)) {
            this.mainPanel.showUploadTblList();
        }
        this.mainPanel.getValidateContentBtn().setEnabled(this.canValidateContent(op));
        this.mainPanel.getCancelBtn().setEnabled(this.canCancel(op));
        if (this.mainPanel.getCancelBtn().isEnabled()) {
            if (op.equals(UPLOADING)) {
                this.mainPanel.getCancelBtn().setText(UIRegistry.getResourceString("WB_UPLOAD_PAUSE"));
            } else {
                this.mainPanel.getCancelBtn().setText(UIRegistry.getResourceString("WB_UPLOAD_CANCEL"));
            }
        }
        this.mainPanel.getCancelBtn().setVisible(this.mainPanel.getCancelBtn().isEnabled());
        this.mainPanel.getDoUploadBtn().setEnabled(this.canUpload(op));
        this.mainPanel.getViewSettingsBtn().setEnabled(this.canViewSettings(op));
        this.mainPanel.getViewUploadBtn().setEnabled(this.canViewUpload(op) && uploadedObjects > 0);
        this.mainPanel.getViewUploadBtn().setVisible(this.mainPanel.getViewUploadBtn().isEnabled());
        this.mainPanel.getUndoBtn().setEnabled(this.canUndo(op) && uploadedObjects > 0);
        this.mainPanel.getUndoBtn().setVisible(this.mainPanel.getUndoBtn().isEnabled());
        this.mainPanel.getCloseBtn().setEnabled(this.canClose(op));
        this.mainPanel.getCurrOpProgress().setVisible(this.mainPanel.getCancelBtn().isVisible());
        String statText = this.previousOp != null && this.previousOp.equals(UNDOING_UPLOAD) && op.equals(FAILURE) ? UIRegistry.getResourceString("WB_UPLOAD_UNDO_FAILURE") : UIRegistry.getResourceString(op);
        Exception killer = this.getOpKiller();
        if (op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL)) {
            statText = String.valueOf(statText) + ". " + this.getUploadedObjects().toString() + " " + UIRegistry.getResourceString("WB_UPLOAD_OBJECT_COUNT") + ".";
            if (killer != null) {
                this.logDebug("Hey. Wait a minute. The operation succeeded while dead. Is that not creepy?");
            }
        } else if (op.equals(FAILURE) && killer != null) {
            statText = StringUtils.isNotEmpty((String)killer.getLocalizedMessage()) ? String.valueOf(statText) + ": " + killer : String.valueOf(statText) + ": " + killer.getClass().getName();
        }
        if (this.dotDotDot(op)) {
            statText = String.valueOf(statText) + "...";
        }
        this.mainPanel.clearMsgs(new Class[]{UploadTableInvalidValue.class});
        if (op.equals(USER_INPUT)) {
            this.mainPanel.addMsg(new UploadTableInvalidValue(statText, null, -1, null));
        } else {
            this.mainPanel.addMsg(new BaseUploadMessage(statText));
        }
        if (this.validationIssues != null) {
            int m = 0;
            while (m < this.validationIssues.size() && m < 800) {
                this.mainPanel.addMsg(this.validationIssues.get(m));
                ++m;
            }
            if (this.validationIssues.size() > 800) {
                log.info((Object)("Only displaying " + String.valueOf(800) + " of " + String.valueOf(this.validationIssues.size()) + " validation errors "));
                ++this.thirdTime;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString(Uploader.WB_TOO_MANY_ERRORS), String.valueOf(800), String.valueOf(Uploader.this.validationIssues.size())), UIRegistry.getResourceString(Uploader.WB_UPLOAD_FORM_TITLE), 2, null);
                    }
                });
            }
        }
        this.mainPanel.getPrintBtn().setEnabled(this.validationIssues != null && this.validationIssues.size() > 0);
    }

    protected void viewAllObjectsCreatedByUpload() {
        if (this.currentOp.equals(SUCCESS) || this.currentOp.equals(SUCCESS_PARTIAL) || this.currentOp.equals(RETRIEVING_UPLOADED_DATA)) {
            this.viewUploadsAll();
        }
    }

    protected void viewUploadsAll() {
        if (this.uploadedObjectViewer == null) {
            this.uploadedObjectViewer = new UploadRetriever();
        }
        this.uploadedObjectViewer.viewUploads(this.uploadTables, this.wbSS.getTask(), UIRegistry.getResourceString(WB_UPLOAD_VIEW_RESULTS_TITLE));
    }

    protected void viewUpload(UploadTable uploadTable) {
        LinkedList<UploadTable> lst = new LinkedList<UploadTable>();
        lst.add(uploadTable);
        new UploadRetriever().viewUploads(lst, this.wbSS.getTask(), UIRegistry.getResourceString(WB_UPLOAD_VIEW_RESULTS_TITLE));
    }

    protected boolean dotDotDot(String op) {
        return op.equals(UPLOADING) || op.equals(CHECKING_REQS) || op.equals(CLEANING_UP) || op.equals(RETRIEVING_UPLOADED_DATA) || op.equals(VALIDATING_DATA) || op.equals(USER_INPUT) || op.equals(UNDOING_UPLOAD);
    }

    protected boolean canUndo(String op) {
        return (op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL)) && !this.isUpdateUpload();
    }

    protected boolean canCancel(String op) {
        return op.equals(UPLOADING) || op.equals(CHECKING_REQS) || op.equals(VALIDATING_DATA) || op.equals(RETRIEVING_UPLOADED_DATA);
    }

    protected boolean canUpload(String op) {
        return op.equals(READY_TO_UPLOAD) || op.equals(SUCCESS_PARTIAL);
    }

    protected boolean canValidateContent(String op) {
        return op.equals(INITIAL_STATE) || op.equals(FAILURE);
    }

    protected boolean canClose(String op) {
        return op.equals(READY_TO_UPLOAD) || op.equals(USER_INPUT) || op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL) || op.equals(INITIAL_STATE) || op.equals(FAILURE);
    }

    protected boolean canViewSettings(String op) {
        return op.equals(READY_TO_UPLOAD) || op.equals(USER_INPUT) || op.equals(SUCCESS_PARTIAL) || op.equals(FAILURE);
    }

    public List<UploadTable> getChildren(UploadTable parent) {
        Vector<UploadTable> result = new Vector<UploadTable>();
        block0: for (UploadTable ut : this.uploadTables) {
            if (ut == parent) continue;
            for (Vector<ParentTableEntry> ptes : ut.getParentTables()) {
                boolean broke = false;
                for (ParentTableEntry pte : ptes) {
                    if (pte.getImportTable() != parent) continue;
                    result.add(ut);
                    broke = true;
                    break;
                }
                if (broke) continue block0;
            }
        }
        return result;
    }

    protected boolean canViewUpload(String op) {
        return (op.equals(SUCCESS) || op.equals(SUCCESS_PARTIAL)) && this.mainPanel.getUploadTbls().getSelectedIndex() != -1;
    }

    public void uploadIt(boolean doInBackground) {
        try {
            this.buildIdentifier();
            this.setOpKiller(null);
            this.prepareToUpload();
            UploaderTask uploadTask = new UploaderTask(true, "WB_CANCEL_UPLOAD_MSG"){
                boolean success;
                boolean paused;
                Integer updateTblId;
                UploadTable exportedTable;
                {
                    this.success = false;
                    this.paused = false;
                    this.updateTblId = null;
                    this.exportedTable = null;
                }

                protected void setupExportedTable() throws UploaderException {
                    if (this.updateTblId != null) {
                        for (UploadTable ut : Uploader.this.uploadTables) {
                            if (ut.getTable().getTableInfo().getTableId() != this.updateTblId.intValue()) continue;
                            if (this.exportedTable == null) {
                                this.exportedTable = ut;
                                continue;
                            }
                            throw new UploaderException("Unable to determine base exported table", 20);
                        }
                    }
                }

                protected void setExportedRecordIds() throws Exception {
                    DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                    Class<?> cls = DBTableIdMgr.getInstance().getInfoById(this.updateTblId).getClassObj();
                    try {
                        DataModelObjBase obj = (DataModelObjBase)session.get(cls, Uploader.this.getRowRecordId(Uploader.this.rowUploading));
                        if (obj != null) {
                            obj.forceLoad();
                        }
                        this.exportedTable.setExportedRecordId(obj);
                    }
                    finally {
                        session.close();
                    }
                }

                @Override
                public Object doInBackground() {
                    this.start();
                    Uploader.this.initProgressBar(0, Uploader.this.uploadData.getRows(), true, String.valueOf(UIRegistry.getResourceString(Uploader.UPLOADING)) + " " + UIRegistry.getResourceString("WB_ROW"), false);
                    try {
                        this.updateTblId = Uploader.this.getUpdateTableId();
                        this.setupExportedTable();
                        Uploader.this.rowUploading = Uploader.this.uploadStartRow;
                        while (Uploader.this.rowUploading < Uploader.this.uploadData.getRows()) {
                            boolean rowAborted = false;
                            if (this.cancelled) {
                                this.paused = true;
                                break;
                            }
                            Uploader.this.logDebug("uploading row " + String.valueOf(Uploader.this.rowUploading));
                            if (Uploader.this.rowUploading == 0) {
                                Uploader.this.showUploadProgress(1);
                            }
                            if (!Uploader.this.uploadData.isEmptyRow(Uploader.this.rowUploading)) {
                                Uploader.this.imagesForRow.clear();
                                if (this.updateTblId != null) {
                                    this.setExportedRecordIds();
                                }
                                Uploader.this.imagesForRow.addAll(Uploader.this.uploadData.getWbRow(Uploader.this.rowUploading).getWorkbenchRowImages());
                                for (UploadTable t : Uploader.this.uploadTables) {
                                    block15: {
                                        if (this.cancelled) break;
                                        try {
                                            if (Uploader.this.wbSS.getWorkbench().getRow(Uploader.this.rowUploading).getUploadStatus() != 1) {
                                                Uploader.this.uploadRow(t, Uploader.this.rowUploading);
                                                break block15;
                                            }
                                            throw new UploaderException(UIRegistry.getResourceString("WB_UPLOAD_ROW_ALREADY_UPLOADED"), 10);
                                        }
                                        catch (UploaderException ex) {
                                            if (ex.getStatus() == 10) {
                                                Uploader.this.logDebug(ex.getMessage());
                                                Uploader.this.abortRow(ex, Uploader.this.rowUploading);
                                                rowAborted = true;
                                                break;
                                            }
                                            throw ex;
                                        }
                                    }
                                    Uploader.this.updateObjectsCreated();
                                }
                            }
                            if (!rowAborted) {
                                Uploader.this.wbSS.getWorkbench().getRow(Uploader.this.rowUploading).setUploadStatus((byte)1);
                            }
                            if (!this.cancelled) {
                                ++Uploader.this.rowUploading;
                            }
                            Uploader.this.showUploadProgress(Uploader.this.rowUploading);
                        }
                    }
                    catch (Exception ex) {
                        Uploader.this.setOpKiller(ex);
                        return false;
                    }
                    this.success = !this.cancelled || this.cancelled && this.paused;
                    return this.success;
                }

                @Override
                public void done() {
                    try {
                        int t = Uploader.this.uploadTables.size() - 1;
                        while (t >= 0) {
                            Uploader.this.uploadTables.get(t).finishUpload(this.cancelled && !this.paused);
                            --t;
                        }
                    }
                    catch (Exception ex) {
                        this.success = false;
                        Uploader.this.setOpKiller(ex);
                    }
                    super.done();
                    this.statusBar.setText("");
                    if (this.success) {
                        if (!this.paused) {
                            Uploader.this.setCurrentOp(Uploader.SUCCESS);
                        } else {
                            Uploader.this.setCurrentOp(Uploader.SUCCESS_PARTIAL);
                        }
                    } else {
                        Uploader.this.mainPanel.clearObjectsCreated();
                        Exception savedOpKiller = Uploader.this.getOpKiller();
                        Uploader.this.undoUpload(false, false, this.undo);
                        Uploader.this.setOpKiller(savedOpKiller);
                        if (!this.cancelled) {
                            Uploader.this.setCurrentOp(Uploader.FAILURE);
                        }
                    }
                }
            };
            UIRegistry.getStatusBar().setText(UIRegistry.getResourceString(UPLOADING));
            uploadTask.execute();
            if (this.mainPanel == null) {
                this.initUI(UPLOADING);
            } else {
                this.setCurrentOp(UPLOADING);
            }
            if (!doInBackground) {
                try {
                    uploadTask.get();
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (UploaderException ex) {
            this.setOpKiller(ex);
        }
    }

    protected synchronized void abortRow(UploaderException cause, int row) throws UploaderException {
        this.logDebug("undoing writes which have already occurred while processing aborted row");
        try {
            List<UploadTable> fixedUp = this.reorderUploadTablesForUndo();
            boolean isEmbeddedCE = AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent();
            try {
                AppContextMgr.getInstance().getClassObject(Collection.class).setIsEmbeddedCollectingEvent(false);
                int ut = fixedUp.size() - 1;
                while (ut >= 0) {
                    this.logDebug("aborting " + fixedUp.get(ut).getTable().getName());
                    fixedUp.get(ut).abortRow(row);
                    --ut;
                }
                this.updateObjectsCreated();
            }
            finally {
                AppContextMgr.getInstance().getClassObject(Collection.class).setIsEmbeddedCollectingEvent(isEmbeddedCE);
            }
        }
        catch (Exception e) {
            throw new UploaderException(e, 20);
        }
        if (cause instanceof UploaderMatchSkipException) {
            this.wbSS.getWorkbench().getRow(this.rowUploading).setUploadStatus((byte)2);
        } else {
            WorkbenchRow wbr = this.wbSS.getWorkbench().getRow(this.rowUploading);
            if (wbr.getUploadStatus() != 1) {
                wbr.setUploadStatus((byte)3);
            }
        }
        SkippedRow sr = new SkippedRow(cause, row);
        this.skippedRows.add(sr);
        this.newMessages.add(sr);
    }

    public synchronized void addMsg(UploadMessage msg) {
        this.newMessages.add(msg);
    }

    protected List<UploadTable> reorderUploadTablesForUndo() {
        return this.uploadTables;
    }

    public void undoUpload(final boolean isUserCmd, final boolean shuttingDown, boolean completeUndo) {
        this.setOpKiller(null);
        UploaderTask undoTask = new UploaderTask(false, "", completeUndo){
            boolean success;
            boolean removeObjects;
            Vector<UploadTable> undone;
            {
                super($anonymous0, $anonymous1);
                this.success = false;
                this.removeObjects = bl;
                this.undone = new Vector();
            }

            @Override
            public Object doInBackground() {
                this.start();
                if (this.removeObjects) {
                    if (isUserCmd) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Uploader.this.initProgressBar(0, Uploader.this.getUploadedObjects(), true, String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_UNDOING")) + " " + UIRegistry.getResourceString("WB_UPLOAD_OBJECT"), shuttingDown);
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Uploader.this.initProgressBar(0, Uploader.this.getUploadedObjects(), true, String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_CLEANING_UP")) + " " + UIRegistry.getResourceString("WB_UPLOAD_OBJECT"), shuttingDown);
                            }
                        });
                    }
                    List<UploadTable> fixedUp = Uploader.this.reorderUploadTablesForUndo();
                    boolean isEmbeddedCE = AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent();
                    Uploader.this.undoAttachments();
                    try {
                        AppContextMgr.getInstance().getClassObject(Collection.class).setIsEmbeddedCollectingEvent(false);
                        int ut = fixedUp.size() - 1;
                        while (ut >= 0) {
                            Uploader.this.logDebug("undoing " + fixedUp.get(ut).getTable().getName());
                            fixedUp.get(ut).undoUpload(true);
                            this.undone.add(fixedUp.get(ut));
                            --ut;
                        }
                        this.success = true;
                        Boolean bl = this.success;
                        AppContextMgr.getInstance().getClassObject(Collection.class).setIsEmbeddedCollectingEvent(isEmbeddedCE);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            AppContextMgr.getInstance().getClassObject(Collection.class).setIsEmbeddedCollectingEvent(isEmbeddedCE);
                            throw throwable;
                        }
                        catch (Exception ex) {
                            Uploader.this.setOpKiller(ex);
                            return false;
                        }
                    }
                }
                this.success = true;
                return this.success;
            }

            @Override
            public void done() {
                if (this.removeObjects) {
                    try {
                        for (UploadTable ut : this.undone) {
                            ut.finishUndoUpload();
                        }
                    }
                    catch (Exception ex) {
                        Uploader.this.setOpKiller(ex);
                        this.success = false;
                    }
                }
                super.done();
                if (this.removeObjects) {
                    for (WorkbenchRow wbRow : Uploader.this.wbSS.getWorkbench().getWorkbenchRows()) {
                        wbRow.setUploadStatus((byte)0);
                    }
                    Uploader.this.wbSS.setChanged(false);
                }
                this.statusBar.setText("");
                this.statusBar.setProgressDone("UPLOADER");
                if (shuttingDown) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.clearSimpleGlassPaneMsg();
                        }
                    });
                }
                if (Uploader.this.getOpKiller() != null) {
                    JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), String.format(UIRegistry.getResourceString("WB_UPLOAD_CLEANUP_FAILED"), UIRegistry.getResourceString(isUserCmd ? "WB_UPLOAD_UNDO_BTN" : Uploader.CLEANING_UP), Uploader.this.wbSS.getWorkbench().getName(), Uploader.this.wbSS.getWorkbench().getName()), UIRegistry.getResourceString("WARNING"), 2);
                }
                if (Uploader.this.mainPanel != null) {
                    Uploader.this.mainPanel.clearObjectsCreated();
                    if (this.success) {
                        if (this.removeObjects) {
                            Uploader.this.setCurrentOp(Uploader.READY_TO_UPLOAD);
                        } else {
                            Uploader.this.setCurrentOp(Uploader.SUCCESS_PARTIAL);
                        }
                    } else {
                        Uploader.this.setCurrentOp(Uploader.FAILURE);
                    }
                }
                if (shuttingDown && !isUserCmd) {
                    Uploader.this.wbSS.decShutdownLock();
                    Uploader.this.wbSS.shutdown();
                }
            }
        };
        if (this.recordSets != null) {
            this.recordSets.clear();
            this.recordSets = null;
        }
        UIRegistry.displayStatusBarText(UIRegistry.getResourceString(isUserCmd ? UNDOING_UPLOAD : CLEANING_UP));
        if (shuttingDown) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.writeSimpleGlassPaneMsg(String.format(String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_CLEANING_UP")) + "...", Uploader.this.wbSS.getWorkbench().getName()), 20);
                }
            });
        }
        if (shuttingDown && !isUserCmd) {
            this.wbSS.incShutdownLock();
        }
        undoTask.execute();
        this.setCurrentOp(isUserCmd ? UNDOING_UPLOAD : CLEANING_UP);
    }

    public void printUpload() throws IllegalAccessException, InvocationTargetException {
        for (UploadTable ut : this.uploadTables) {
            System.out.println(ut.getWriteTable().getName());
            Vector<Vector<String>> vals = ut.printUpload();
            for (Vector<String> row : vals) {
                for (String val : row) {
                    System.out.print(String.valueOf(val) + ", ");
                }
                System.out.println();
            }
        }
    }

    public void retrieveUploadedData() {
        final String savedOp = this.currentOp;
        this.setOpKiller(null);
        UploaderTask retrieverTask = new UploaderTask(true, "WB_CANCEL_UPLOAD_MSG"){

            @Override
            public Object doInBackground() {
                this.start();
                try {
                    return true;
                }
                catch (Exception ex) {
                    Uploader.this.setOpKiller(ex);
                    return false;
                }
            }

            @Override
            public void done() {
                super.done();
                this.statusBar.setText("");
                Uploader.this.setCurrentOp(savedOp);
                if (!this.cancelled) {
                    Uploader.this.viewAllObjectsCreatedByUpload();
                    Uploader.this.mainPanel.addMsg(new BaseUploadMessage(UIRegistry.getResourceString("WB_UPLOAD_DATA_FETCHED")));
                } else {
                    Uploader.this.mainPanel.addMsg(new BaseUploadMessage(UIRegistry.getResourceString("RetrievalWB_UPLOAD_FETCH_CANCELLED cancelled")));
                }
            }
        };
        if (this.mainPanel == null) {
            this.initUI(RETRIEVING_UPLOADED_DATA);
        } else {
            this.setCurrentOp(RETRIEVING_UPLOADED_DATA);
        }
        UIRegistry.getStatusBar().setText(UIRegistry.getResourceString(RETRIEVING_UPLOADED_DATA));
        retrieverTask.execute();
    }

    public void loadRow(UploadTable t, int row) {
        for (UploadField field : this.uploadFields) {
            this.logDebug("   uploading field: " + field.getWbFldName());
            System.out.println("   uploading field: " + field.getWbFldName());
            if (!field.getField().getTable().equals(t.getTable()) || field.getIndex() == -1) continue;
            this.uploadCol(field, this.uploadData.get(row, field.getIndex()));
        }
    }

    protected void uploadRow(UploadTable t, int row) throws UploaderException {
        this.loadRow(t, row);
        try {
            this.writeRow(t, row);
        }
        catch (UploaderException ex) {
            this.logDebug(String.valueOf(ex.getMessage()) + " (" + t.getTable().getName() + ", row " + Integer.toString(row) + ")");
            throw ex;
        }
    }

    protected void uploadCol(UploadField f, String val) {
        if (f != null) {
            f.setValue(val);
        }
    }

    protected void writeRow(UploadTable t, int row) throws UploaderException {
        t.writeRow(row);
        HashSet<WorkbenchRowImage> imagesToAttach = new HashSet<WorkbenchRowImage>();
        int i = this.imagesForRow.size() - 1;
        while (i >= 0) {
            WorkbenchRowImage wri = this.imagesForRow.get(i);
            if (this.getAttachToTable(wri) == t) {
                imagesToAttach.add(wri);
                this.imagesForRow.remove(i);
            }
            --i;
        }
        this.attachImages(t, imagesToAttach);
    }

    protected ObjectAttachmentIFace<? extends DataModelObjBase> getAttachmentObject(Class<?> cls) {
        ObjectAttachmentIFace result = null;
        ReflectiveOperationException ex = null;
        String className = String.valueOf(cls.getName()) + "Attachment";
        try {
            Class<?> createClass = Class.forName(className);
            result = (ObjectAttachmentIFace)createClass.newInstance();
            if (result != null) {
                ((DataModelObjBase)((Object)result)).initialize();
            }
        }
        catch (ClassNotFoundException e) {
            ex = e;
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            ex = e;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            ex = e;
            e.printStackTrace();
        }
        if (ex != null) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(Uploader.class, ex);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    protected void attachImages(UploadTable t, Set<WorkbenchRowImage> images) throws UploaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void undoAttachments() {
        for (UploadedRecordInfo uri : this.newAttachments) {
            BasicSQLUtils.update("delete from " + uri.getTblName().toLowerCase() + "attachment where attachmentid = " + uri.getKey());
            BasicSQLUtils.update("delete from attachment where attachmentid = " + uri.getKey());
        }
    }

    protected void createRecordSets() {
        if (this.recordSets != null) {
            this.recordSets.clear();
        } else {
            this.recordSets = new Vector(this.uploadTables.size());
        }
        UploadTable root = this.getRootTable();
        Iterator<UploadTable> iterator = this.uploadTables.iterator();
        while (iterator.hasNext()) {
            UploadTable ut;
            RecordSet rs = ut.getRecordSet((ut = iterator.next()) == root);
            if (rs.getNumItems() <= 0) continue;
            this.recordSets.add(rs);
        }
        Collections.sort(this.recordSets, new Comparator<RecordSet>(){

            @Override
            public int compare(RecordSet rs1, RecordSet rs2) {
                return rs1.getName().compareTo(rs2.getName());
            }
        });
        int rs = this.recordSets.size() - 1;
        while (rs > 0) {
            if (this.recordSets.get(rs).getName().equals(this.recordSets.get(rs - 1).getName())) {
                this.recordSets.get(rs - 1).addAll(this.recordSets.get(rs).getItems());
                for (RecordSetItemIFace rsi : this.recordSets.get(rs).getItems()) {
                    this.recordSets.get(rs - 1).addItem(rsi);
                }
                this.recordSets.remove(rs);
            }
            --rs;
        }
    }

    protected void saveRecordSets() {
        if (this.recordSets == null || this.recordSets.size() == 0) {
            this.createRecordSets();
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                UploadTable root = this.getRootTable();
                for (RecordSet rs : this.recordSets) {
                    BusinessRulesIFace busRule = DBTableIdMgr.getInstance().getBusinessRule(RecordSet.class);
                    if (busRule != null) {
                        busRule.beforeSave(rs, session);
                    }
                    session.beginTransaction();
                    try {
                        session.save(rs);
                        if (busRule != null && !busRule.beforeSaveCommit(rs, session)) {
                            session.rollback();
                            throw new Exception("Business rules processing failed");
                        }
                        session.commit();
                        if (busRule != null) {
                            busRule.afterSaveCommit(rs, session);
                        }
                        if (rs.getType() != RecordSet.GLOBAL || rs.getDbTableId().intValue() != root.getTable().getTableInfo().getTableId()) continue;
                        final RecordSet mergedRs = session.merge(rs);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CommandAction cmd = new CommandAction("Record_Set", "AddToNavBox");
                                cmd.setData(mergedRs);
                                CommandDispatcher.dispatch(cmd);
                            }
                        });
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(Uploader.class, ex);
                        session.rollback();
                    }
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(Uploader.class, ex);
                throw new RuntimeException(ex);
            }
        }
        finally {
            session.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.logDebug("keyPressed");
        int key = e.getKeyCode();
        if (key == 10 || key == 9 || key == 40 || key == 38 || key == 9 && e.isShiftDown() || key == 36 || key == 35) {
            this.editInvalidCell(e);
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.logDebug("keyReleased");
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.logDebug("KeyTyped");
    }

    protected void editInvalidCell(KeyEvent e) {
        this.logDebug("editing invalid cell");
        int key = e.getKeyCode();
        if (key == 10 || key == 9 || key == 40) {
            this.goToNextInvalidCell();
        } else if (key == 38 || key == 9 && e.isShiftDown()) {
            this.goToPrevInvalidCell();
        } else if (key == 36) {
            this.goToFirstInvalidCell();
        } else if (key == 35) {
            this.goToLastInvalidCell();
        }
    }

    protected static boolean canOverrideLock() {
        return SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager);
    }

    protected static boolean canRemoveLock() {
        return Uploader.canOverrideLock();
    }

    public static int checkUploadLock(Taskable caller) {
        if (isLockIgnored) {
            return 0;
        }
        if (!TaskSemaphoreMgr.isLocked(Uploader.getLockTitle(), "WORKBENCHUPLOAD", TaskSemaphoreMgr.SCOPE.Discipline)) {
            return 0;
        }
        int result = Uploader.lockUpload(caller, false);
        isLockIgnored = result == 2;
        return result;
    }

    public static String getLockTitle() {
        return UIRegistry.getResourceString("Uploader.UploaderTask");
    }

    public static int lockUpload(Taskable caller, boolean doLock) {
        boolean override = false;
        boolean unlocked = false;
        boolean isLocked = TaskSemaphoreMgr.isLocked(Uploader.getLockTitle(), "WORKBENCHUPLOAD", TaskSemaphoreMgr.SCOPE.Discipline);
        TaskSemaphoreMgr.USER_ACTION result = TaskSemaphoreMgr.lock(Uploader.getLockTitle(), "WORKBENCHUPLOAD", null, TaskSemaphoreMgr.SCOPE.Discipline, false, new UploadLocker(Uploader.canOverrideLock(), Uploader.canRemoveLock(), caller, doLock), false);
        if (result == TaskSemaphoreMgr.USER_ACTION.Override) {
            override = true;
            unlocked = TaskSemaphoreMgr.unlock(Uploader.getLockTitle(), "WORKBENCHUPLOAD", TaskSemaphoreMgr.SCOPE.Discipline);
            if (unlocked && doLock) {
                result = TaskSemaphoreMgr.lock(Uploader.getLockTitle(), "WORKBENCHUPLOAD", null, TaskSemaphoreMgr.SCOPE.Discipline, false);
            }
        }
        if (doLock) {
            if (result == TaskSemaphoreMgr.USER_ACTION.OK) {
                return 3;
            }
            return 4;
        }
        if (!doLock) {
            if (isLocked) {
                if (!override) {
                    if (result == TaskSemaphoreMgr.USER_ACTION.OK) {
                        return 2;
                    }
                    return 3;
                }
                if (unlocked) {
                    return 1;
                }
                return 3;
            }
            return 0;
        }
        return 0;
    }

    public static boolean unlockUpload() {
        return TaskSemaphoreMgr.unlock(Uploader.getLockTitle(), "WORKBENCHUPLOAD", TaskSemaphoreMgr.SCOPE.Discipline);
    }

    protected static void setAppLock(final boolean lock) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenuBar menuBar = (JMenuBar)UIRegistry.get("menubar");
                int m = 0;
                while (m < menuBar.getMenuCount()) {
                    if (Uploader.isSystemMenu(menuBar, m)) {
                        menuBar.getMenu(m).setEnabled(!lock);
                    } else if (Uploader.isTabsMenu(menuBar, m)) {
                        menuBar.getMenu(m).setEnabled(!lock);
                    }
                    ++m;
                }
            }
        });
    }

    public static void lockApp() {
        Uploader.setAppLock(true);
    }

    protected static boolean isSystemMenu(JMenuBar menuBar, int menu) {
        return menu == 3;
    }

    protected static boolean isTabsMenu(JMenuBar menuBar, int menu) {
        return menu == 4;
    }

    public static void unlockApp() {
        Uploader.setAppLock(false);
    }

    public WorkbenchPaneSS getWbSS() {
        return this.wbSS;
    }

    protected List<Pair<UploadTableTree, Boolean>> getTreesToLock(boolean defaultStatus) {
        LinkedList<Pair<UploadTableTree, Boolean>> trees = new LinkedList<Pair<UploadTableTree, Boolean>>();
        for (UploadTable t : this.uploadTables) {
            if (!Treeable.class.isAssignableFrom(t.getTblClass()) || ((UploadTableTree)t).getParent() != null) continue;
            trees.add(new Pair<UploadTableTree, Boolean>((UploadTableTree)t, defaultStatus));
        }
        return trees;
    }

    public boolean setAdditionalLocks() {
        return true;
    }

    protected void unlockTrees(List<Pair<UploadTableTree, Boolean>> trees) {
    }

    public void freeAdditionalLocks() {
        if (this.additionalLocksSet) {
            List<Pair<UploadTableTree, Boolean>> trees = this.getTreesToLock(true);
            this.unlockTrees(trees);
        }
    }

    public void applyMatchSettingsToAllTables(UploadMatchSettingsBasicPanel umsbp) {
        umsbp.applySettingToAll(this.uploadTables);
    }

    public void loadRecordToWb(DataModelObjBase rec, Workbench wb) throws Exception {
        UploadTable t = null;
        for (UploadTable ut : this.uploadTables) {
            if (!ut.getTblClass().equals(rec.getClass())) continue;
            t = ut;
        }
        t.loadRecord(rec, 0);
        WorkbenchRow row = wb.addRow();
        row.setRecordId(rec.getId());
        for (UploadTable ut : this.uploadTables) {
            int seq = 0;
            boolean isOneToMany = ut.getUploadFields().size() > 1 || ut.getTable().getName().equalsIgnoreCase("address");
            for (Vector<UploadField> flds : ut.getUploadFields()) {
                if (ut.getCurrentRecord(seq) != null) {
                    if (isOneToMany) {
                        WorkbenchRowExportedRelationship wber = new WorkbenchRowExportedRelationship();
                        wber.initialize();
                        wber.setWorkbenchRow(row);
                        row.getWorkbenchRowExportedRelationships().add(wber);
                        wber.setTableName(ut.getTblClass().getSimpleName());
                        wber.setSequence(seq);
                        wber.setRecordId(ut.getCurrentRecord(seq).getId());
                    }
                    for (UploadField fld : flds) {
                        Object value;
                        if (fld.getIndex() == -1 || (value = fld.getGetter().invoke((Object)ut.getCurrentRecord(seq), new Object[0])) == null) continue;
                        WorkbenchTemplateMappingItem mi = wb.getMappingFromColumn((short)fld.getIndex());
                        WorkbenchDataItem di = new WorkbenchDataItem();
                        di.initialize();
                        di.setWorkbenchTemplateMappingItem(mi);
                        di.setWorkbenchRow(row);
                        di.setRowNumber(row.getRowNumber());
                        di.setRequired(mi.getIsRequired());
                        di.setCellData(ut.getTextForFieldValue(fld, value, 0));
                        row.getWorkbenchDataItems().add(di);
                    }
                }
                ++seq;
            }
        }
    }

    public String getCurrentOp() {
        return this.currentOp;
    }

    public static void showStructureErrors(Vector<UploadMessage> structureErrors) {
        JPanel pane = new JPanel(new BorderLayout());
        JLabel lbl = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_BAD_STRUCTURE_MSG")) + ":");
        lbl.setBorder(new EmptyBorder(3, 1, 2, 0));
        pane.add((Component)lbl, "North");
        JPanel lstPane = new JPanel(new BorderLayout());
        JList lst = UIHelper.createList(structureErrors);
        lst.setBorder(new SoftBevelBorder(1));
        lstPane.setBorder(new EmptyBorder(1, 1, 10, 1));
        lstPane.add((Component)lst, "Center");
        pane.add((Component)lstPane, "Center");
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WB_UPLOAD_BAD_STRUCTURE_DLG"), true, 5, (Component)pane);
        UIHelper.centerAndShow(dlg);
        dlg.dispose();
    }

    class InvalidValueJRDataSource
    implements JRDataSource {
        protected int rowIndex;
        protected final Vector<UploadTableInvalidValue> rows;

        public InvalidValueJRDataSource(Vector<UploadTableInvalidValue> rows) {
            this.rows = rows;
            this.rowIndex = -1;
        }

        public Object getFieldValue(JRField field) throws JRException {
            if (field.getName().equals("row")) {
                return String.valueOf(this.rows.get(this.rowIndex).getRow());
            }
            if (field.getName().equals("col")) {
                return String.valueOf(this.rows.get(this.rowIndex).getUploadFld().getWbFldName());
            }
            if (field.getName().equals("description")) {
                return this.rows.get(this.rowIndex).getDescription();
            }
            if (field.getName().equals("datasetName")) {
                return Uploader.this.wbSS.getWorkbench().getName();
            }
            if (field.getName().equals("cellData")) {
                return Uploader.this.uploadData.get(this.rows.get(this.rowIndex).getRow(), this.rows.get(this.rowIndex).getUploadFld().getIndex());
            }
            log.error((Object)("Unrecognized field Name: " + field.getName()));
            return null;
        }

        public boolean next() throws JRException {
            if (this.rowIndex >= this.rows.size() - 1) {
                return false;
            }
            ++this.rowIndex;
            return true;
        }
    }

    public class ParentTableEntry {
        protected UploadTable importTable;
        protected Relationship parentRel;
        protected String propertyName;
        protected Method setter;
        protected Method getter;
        protected boolean required = false;

        public ParentTableEntry(UploadTable importTable, Relationship parentRel) {
            this.importTable = importTable;
            this.parentRel = parentRel;
            if (parentRel != null) {
                this.required = parentRel.getRelatedField().isForeignKey() && parentRel.getRelatedField().isRequired();
            }
        }

        public final UploadTable getImportTable() {
            return this.importTable;
        }

        public final Relationship getParentRel() {
            return this.parentRel;
        }

        public final Method getSetter() {
            return this.setter;
        }

        public final void setSetter(Method setter) {
            this.setter = setter;
            this.propertyName = this.setter.getName().startsWith("set") ? UploadTable.deCapitalize(this.setter.getName().substring(3)) : UploadTable.deCapitalize(this.setter.getName());
        }

        public final void setGetter(Method getter) {
            this.getter = getter;
        }

        public final Method getGetter() {
            return this.getter;
        }

        public final String getForeignKey() {
            if (this.parentRel == null) {
                return this.importTable.getTblClass().getSimpleName();
            }
            return this.parentRel.getRelatedField().getName();
        }

        public final String getPropertyName() {
            return this.propertyName;
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    private class SkippedAttachment
    extends BaseUploadMessage {
        protected int row;

        public SkippedAttachment(String msg, int row) {
            super(msg);
            this.row = row;
        }

        @Override
        public int getRow() {
            return this.row;
        }
    }

    private class SkippedRow
    extends BaseUploadMessage {
        protected UploaderException cause;
        protected int row;

        public SkippedRow(UploaderException cause, int row) {
            super(null);
            this.cause = cause;
            this.row = row;
        }

        public UploaderException getCause() {
            return this.cause;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        @Override
        public String getMsg() {
            return String.valueOf(String.format(UIRegistry.getResourceString(Uploader.WB_UPLOAD_ROW_SKIPPED), String.valueOf(this.getRow() + 1))) + ": " + this.cause.getMessage();
        }

        @Override
        public Object getData() {
            return this.cause;
        }
    }

    protected abstract class UploaderTask
    extends SwingWorker<Object, Object> {
        protected final JStatusBar statusBar = UIRegistry.getStatusBar();
        protected boolean cancelled = false;
        protected boolean undo = false;
        protected boolean done = false;
        protected String cancelMsg = null;
        protected boolean cancellable = false;
        protected long startTime;
        protected long endTime;

        public UploaderTask(boolean cancellable, String cancelMsg) {
            this.cancellable = cancellable;
            this.cancelMsg = cancelMsg;
            Uploader.this.currentTask = this;
        }

        public void start() {
            this.startTime = System.nanoTime();
        }

        @Override
        public void done() {
            super.done();
            Uploader.this.currentTask = null;
            this.done = true;
            this.endTime = System.nanoTime();
            Uploader.this.logDebug("UploaderTask time elapsed: " + Long.toString((this.endTime - this.startTime) / 1000000000L));
        }

        public synchronized void cancelTask() {
            this.cancelled = true;
        }

        public synchronized boolean isCancellable() {
            return this.cancellable;
        }

        public synchronized void setCancellable(boolean val) {
            this.cancellable = val;
        }

        public synchronized String getCancelMsg() {
            return this.cancelMsg;
        }

        public synchronized void setCancelMsg(String msg) {
            this.cancelMsg = msg;
        }

        public synchronized boolean isUndo() {
            return this.undo;
        }

        public synchronized void setUndo(boolean undo) {
            this.undo = undo;
        }
    }
}

