/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.tasks.subpane.wb.CellRenderingAttributes;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.BorderUIResource;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class UploadToolPanel
extends JPanel
implements TimingTarget {
    protected boolean animationInProgress = false;
    protected boolean shrinking = false;
    protected boolean expanding = false;
    protected int mode;
    protected Dimension prefSize;
    protected Dimension contractedSize;
    public static final int EXPANDED = 1;
    public static final int CONTRACTED = -1;
    protected JCheckBox autoValidateChk = null;
    protected JButton prevInvalidCellBtn = null;
    protected JButton nextInvalidCellBtn = null;
    protected JLabel invalidCellCountLbl = null;
    protected JCheckBox autoMatchChk = null;
    protected JButton prevUnmatchedCellBtn = null;
    protected JButton nextUnmatchedCellBtn = null;
    protected JLabel unmatchedCellCountLbl = null;
    protected JButton helpBtn = null;
    protected final WorkbenchPaneSS wbSS;

    public UploadToolPanel(final WorkbenchPaneSS wbSS, int startingMode) {
        this.wbSS = wbSS;
        this.autoValidateChk = UIHelper.createI18NCheckBox(null);
        this.autoValidateChk.setSelected(wbSS.isDoIncrementalValidation());
        this.autoValidateChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UploadToolPanel.this.autoValidateChk.isSelected()) {
                    wbSS.turnOnIncrementalValidation();
                    UploadToolPanel.this.prevInvalidCellBtn.setVisible(true);
                    UploadToolPanel.this.nextInvalidCellBtn.setVisible(true);
                    UploadToolPanel.this.invalidCellCountLbl.setVisible(true);
                } else {
                    wbSS.turnOffIncrementalValidation();
                    UploadToolPanel.this.prevInvalidCellBtn.setVisible(false);
                    UploadToolPanel.this.nextInvalidCellBtn.setVisible(false);
                    UploadToolPanel.this.invalidCellCountLbl.setVisible(false);
                }
            }
        });
        JPanel autoValidatePanel = new JPanel(new BorderLayout());
        autoValidatePanel.add((Component)this.autoValidateChk, "West");
        JLabel autoValidateLbl = UIHelper.createLabel(UIRegistry.getResourceString("WorkbenchPaneSS.AutoValidateChk"));
        autoValidateLbl.setBorder(new BorderUIResource.LineBorderUIResource(CellRenderingAttributes.errorBorder));
        autoValidateLbl.setBackground(CellRenderingAttributes.errorBackground);
        autoValidateLbl.setOpaque(true);
        autoValidatePanel.add((Component)autoValidateLbl, "Center");
        Action prevErrAction = wbSS.addRecordKeyMappings((JComponent)((Object)wbSS.getSpreadSheet()), 116, "PrevErr", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                wbSS.goToInvalidCell(false);
            }
        }, 0);
        this.prevInvalidCellBtn = UIHelper.createIconBtn("WBValidatorUp", IconManager.IconSize.Std24, "WB_PREV_ERROR", false, prevErrAction);
        Action nextErrAction = wbSS.addRecordKeyMappings((JComponent)((Object)wbSS.getSpreadSheet()), 117, "NextErr", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                wbSS.goToInvalidCell(true);
            }
        }, 0);
        this.nextInvalidCellBtn = UIHelper.createIconBtn("WBValidatorDown", IconManager.IconSize.Std24, "WB_NEXT_ERROR", false, nextErrAction);
        this.invalidCellCountLbl = UIHelper.createLabel(String.format(UIRegistry.getResourceString("WB_INVALID_CELL_COUNT"), 0));
        this.prevInvalidCellBtn.setVisible(wbSS.isDoIncrementalValidation());
        this.nextInvalidCellBtn.setVisible(wbSS.isDoIncrementalValidation());
        this.invalidCellCountLbl.setVisible(wbSS.isDoIncrementalValidation());
        this.autoMatchChk = UIHelper.createI18NCheckBox(null);
        this.autoMatchChk.setSelected(wbSS.isDoIncrementalMatching());
        this.autoMatchChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UploadToolPanel.this.autoMatchChk.isSelected()) {
                    wbSS.turnOnIncrementalMatching();
                    UploadToolPanel.this.prevUnmatchedCellBtn.setVisible(true);
                    UploadToolPanel.this.nextUnmatchedCellBtn.setVisible(true);
                    UploadToolPanel.this.unmatchedCellCountLbl.setVisible(true);
                } else {
                    wbSS.turnOffIncrementalMatching();
                    UploadToolPanel.this.prevUnmatchedCellBtn.setVisible(false);
                    UploadToolPanel.this.nextUnmatchedCellBtn.setVisible(false);
                    UploadToolPanel.this.unmatchedCellCountLbl.setVisible(false);
                }
            }
        });
        JPanel autoMatchPanel = new JPanel(new BorderLayout());
        autoMatchPanel.add((Component)this.autoMatchChk, "West");
        JLabel autoMatchLbl = UIHelper.createLabel(UIRegistry.getResourceString("WorkbenchPaneSS.AutoMatchChk"));
        autoMatchLbl.setBorder(new BorderUIResource.LineBorderUIResource(CellRenderingAttributes.newDataBorder));
        autoMatchLbl.setBackground(CellRenderingAttributes.newDataBackground);
        autoMatchLbl.setOpaque(true);
        autoMatchPanel.add((Component)autoMatchLbl, "Center");
        Action prevUnmatchedAction = wbSS.addRecordKeyMappings((JComponent)((Object)wbSS.getSpreadSheet()), 118, "PrevUnMatched", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                wbSS.goToUnmatchedCell(false);
            }
        }, 0);
        this.prevUnmatchedCellBtn = UIHelper.createIconBtn("WBValidatorUp", IconManager.IconSize.Std24, "WB_PREV_UNMATCHED", false, prevUnmatchedAction);
        Action nextUnMatchedAction = wbSS.addRecordKeyMappings((JComponent)((Object)wbSS.getSpreadSheet()), 119, "NextUnMatched", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                wbSS.goToUnmatchedCell(true);
            }
        }, 0);
        this.nextUnmatchedCellBtn = UIHelper.createIconBtn("WBValidatorDown", IconManager.IconSize.Std24, "WB_NEXT_UNMATCHED", false, nextUnMatchedAction);
        this.unmatchedCellCountLbl = UIHelper.createLabel(String.format(UIRegistry.getResourceString("WB_UNMATCHED_CELL_COUNT"), 0));
        this.prevUnmatchedCellBtn.setVisible(wbSS.isDoIncrementalMatching());
        this.nextUnmatchedCellBtn.setVisible(wbSS.isDoIncrementalMatching());
        this.unmatchedCellCountLbl.setVisible(wbSS.isDoIncrementalMatching());
        this.helpBtn = UIHelper.createHelpIconButton("uploading");
        CellConstraints cc = new CellConstraints();
        JLabel sep1 = new JLabel(IconManager.getIcon("Separator"));
        JComponent[] compsArray = new JComponent[]{autoValidatePanel, this.invalidCellCountLbl, this.prevInvalidCellBtn, this.nextInvalidCellBtn, sep1, autoMatchPanel, this.unmatchedCellCountLbl, this.prevUnmatchedCellBtn, this.nextUnmatchedCellBtn, this.helpBtn};
        Vector<JComponent> availableComps = new Vector<JComponent>(compsArray.length);
        JComponent[] jComponentArray = compsArray;
        int n = compsArray.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent c = jComponentArray[n2];
            if (c != null) {
                availableComps.add(c);
            }
            ++n2;
        }
        this.setLayout((LayoutManager)new FormLayout(String.valueOf(UIHelper.createDuplicateJGoodiesDef("p", "4px", availableComps.size())) + ",4px,", "2dlu,c:p:g,2dlu"));
        int x = 1;
        for (JComponent c : availableComps) {
            this.add((Component)c, cc.xy(x, 2));
            x += 2;
            c.setFont(c.getFont().deriveFont((float)c.getFont().getSize() + 2.0f));
            Component[] componentArray = c.getComponents();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Component sc = componentArray[n4];
                sc.setFont(sc.getFont().deriveFont((float)sc.getFont().getSize() + 2.0f));
                ++n4;
            }
        }
        this.mode = startingMode;
        this.prefSize = super.getPreferredSize();
        this.contractedSize = new Dimension(this.prefSize.width, 0);
    }

    public void begin() {
        this.animationInProgress = true;
    }

    public void end() {
        this.animationInProgress = false;
        if (this.expanding) {
            this.mode = 1;
            this.expanding = false;
        }
        if (this.shrinking) {
            this.mode = -1;
            this.shrinking = false;
        }
        Container c = this.getParent();
        ((Component)c).invalidate();
        ((Component)c).doLayout();
        ((Component)c).validate();
        c.repaint();
    }

    public void repeat() {
    }

    public void timingEvent(float fraction) {
        float sizeFrac = fraction;
        if (this.shrinking) {
            sizeFrac = 1.0f - fraction;
        }
        this.prefSize.height = (int)((float)super.getPreferredSize().height * sizeFrac);
        Container c = this.getParent().getParent();
        ((Component)c).invalidate();
        ((Component)c).doLayout();
        ((Component)c).validate();
        c.repaint();
        this.invalidate();
        this.repaint();
        this.validate();
    }

    public void expand() {
        if (this.mode == 1 || this.expanding || this.shrinking) {
            return;
        }
        this.expanding = true;
        Animator expander = new Animator(450, (TimingTarget)this);
        expander.start();
    }

    public void contract() {
        if (this.mode == -1 || this.shrinking || this.expanding) {
            return;
        }
        this.shrinking = true;
        Animator expander = new Animator(300, (TimingTarget)this);
        expander.start();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.shrinking || this.expanding) {
            return this.prefSize;
        }
        if (this.mode == -1) {
            return this.contractedSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void updateBtnUI() {
        this.prevInvalidCellBtn.setEnabled(this.wbSS.getInvalidCellCount() > 0);
        this.nextInvalidCellBtn.setEnabled(this.wbSS.getInvalidCellCount() > 0);
        this.invalidCellCountLbl.setText(String.format(UIRegistry.getResourceString("WB_INVALID_CELL_COUNT"), this.wbSS.getInvalidCellCount()));
        this.prevUnmatchedCellBtn.setEnabled(this.wbSS.getUnmatchedCellCount() > 0);
        this.nextUnmatchedCellBtn.setEnabled(this.wbSS.getUnmatchedCellCount() > 0);
        this.unmatchedCellCountLbl.setText(String.format(UIRegistry.getResourceString("WB_UNMATCHED_CELL_COUNT"), this.wbSS.getUnmatchedCellCount()));
    }

    public void uncheckAutoValidation() {
        this.autoValidateChk.setSelected(false);
        this.prevInvalidCellBtn.setVisible(false);
        this.nextInvalidCellBtn.setVisible(false);
        this.invalidCellCountLbl.setVisible(false);
    }

    public void uncheckAutoMatching() {
        this.autoMatchChk.setSelected(false);
        this.prevUnmatchedCellBtn.setVisible(false);
        this.nextUnmatchedCellBtn.setVisible(false);
        this.unmatchedCellCountLbl.setVisible(false);
    }

    public boolean isExpanded() {
        return this.mode == 1;
    }

    public void turnOffSelections() {
        this.autoValidateChk.setSelected(false);
        this.autoMatchChk.setSelected(false);
    }
}

