/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.BaseUploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.InvalidStructure;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.RelatedClassSetter;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadField;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableInvalidValue;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecordInfo;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.ui.UIRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.hibernate.NonUniqueResultException;

public class UploadTableTree
extends UploadTable {
    protected final Table baseTable;
    protected final UploadTableTree parent;
    protected UploadTableTree child;
    protected final Integer rank;
    protected final String wbLevelName;
    protected Treeable treeRoot;
    protected SortedSet<Treeable> defaultParents;
    protected TreeDefIface<?, ?, ?> treeDef;
    protected boolean incrementalNodeNumberUpdates = false;
    protected boolean allowUnacceptedMatches = true;

    public UploadTableTree(Uploader uploader, Table table, Table baseTable, UploadTableTree parent, boolean required, Integer rank, String wbLevelName) {
        super(uploader, table, null);
        this.baseTable = baseTable;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.child = this;
        }
        this.required = required;
        this.rank = rank;
        this.wbLevelName = wbLevelName;
        this.defaultParents = new TreeSet<Treeable>(new RankComparator());
    }

    @Override
    public void determineTblClass() throws UploaderException {
        try {
            this.tblClass = Class.forName("edu.ku.brc.specify.datamodel." + this.baseTable.getName());
        }
        catch (ClassNotFoundException cnfEx) {
            throw new UploaderException(cnfEx, 20);
        }
    }

    public Table getBaseTable() {
        return this.baseTable;
    }

    @Override
    public Table getWriteTable() {
        return this.getBaseTable();
    }

    protected TreeDefIface getTreeDef() throws UploaderException {
        if (this.treeDef == null) {
            this.treeDef = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getTreeDefForClass(this.tblClass);
        }
        if (this.treeDef != null) {
            return this.treeDef;
        }
        throw new UploaderException(String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MISSING_TREE_DEF")) + " (" + this.tblClass.getSimpleName() + ")", 20);
    }

    protected TreeDefItemIface getTreeDefItem() throws UploaderException {
        return this.getTreeDef().getDefItemByRank(this.rank);
    }

    protected DataModelObjBase getAcceptedParent(DataModelObjBase parent, Treeable currentRec, int recNum, boolean notify) {
        if (parent == null || ((Treeable)((Object)parent)).getIsAccepted().booleanValue()) {
            return parent;
        }
        DataModelObjBase newResult = (DataModelObjBase)((Treeable)((Object)parent)).getAcceptedParent();
        if (notify) {
            String name;
            String string = name = currentRec == null ? null : currentRec.getName();
            if (name == null) {
                Treeable tRec = (Treeable)((Object)this.getCurrentRecord(recNum));
                name = tRec == null ? UIRegistry.getResourceString("UploadTableTree.CurrentNode") : tRec.getName();
            }
            String parentName = ((Treeable)((Object)parent)).getName();
            String newParentName = ((Treeable)((Object)newResult)).getName();
            String msg = String.format(UIRegistry.getResourceString("UploadTableTree.UnacceptedParentSwitch"), this.wbCurrentRow, name, parentName, newParentName);
            this.uploader.addMsg(new AcceptedParentSwitchMessage(msg, this.wbCurrentRow));
        }
        return (DataModelObjBase)((Treeable)((Object)parent)).getAcceptedParent();
    }

    protected DataModelObjBase getParentRec(Treeable currentRec, int recNum) {
        if (this.parent == null) {
            return null;
        }
        DataModelObjBase result = this.parent.getCurrentRecord(recNum);
        UploadTableTree grandParent = this.parent.parent;
        while (result == null && grandParent != null) {
            result = grandParent.getCurrentRecord(recNum);
            grandParent = grandParent.parent;
        }
        return this.getAcceptedParent(result, currentRec, recNum, true);
    }

    @Override
    protected void finalizeWrite(DataModelObjBase rec, int recNum) throws UploaderException {
        super.finalizeWrite(rec, recNum);
        Treeable tRec = (Treeable)((Object)rec);
        DataModelObjBase parentRec = this.getParentRec(tRec, recNum);
        tRec.setDefinition(this.getTreeDef());
        tRec.setDefinitionItem(this.getTreeDefItem());
        if (parentRec == null) {
            tRec.setParent(this.getDefaultParent2(this.getTreeDefItem()));
        } else {
            tRec.setParent((Treeable)((Object)parentRec));
        }
    }

    @Override
    protected DataModelObjBase getParentRecord(int recNum, UploadTable forChild) throws UploaderException {
        DataModelObjBase result = super.getParentRecord(recNum, forChild);
        if (result != null) {
            return result;
        }
        result = this.getParentRec(null, recNum);
        if (result == null && forChild instanceof UploadTableTree) {
            return (DataModelObjBase)((Object)this.getDefaultParent2(this.getTreeDefItem()));
        }
        return result;
    }

    protected Treeable getTreeRoot() throws UploaderException {
        if (this.treeRoot == null) {
            this.loadTreeRoot();
        }
        return this.treeRoot;
    }

    protected Treeable getDefaultParent2(TreeDefItemIface defItem) throws UploaderException {
        Object parentDefItem = defItem.getParent();
        while (parentDefItem != null && parentDefItem.getRankId() > 0) {
            if (parentDefItem.getIsEnforced() != null && parentDefItem.getIsEnforced().booleanValue()) break;
            parentDefItem = parentDefItem.getParent();
        }
        if (parentDefItem == null) {
            throw new UploaderException("unable to find default parent for " + defItem.getName(), 10);
        }
        if (parentDefItem.getRankId() == 0) {
            return this.getTreeRoot();
        }
        return this.getDefaultParent((TreeDefItemIface)parentDefItem);
    }

    protected Treeable getDefaultParent(TreeDefItemIface parentDefItem) throws UploaderException {
        for (Treeable p : this.defaultParents) {
            if (!p.getDefinitionItem().getTreeDefItemId().equals(parentDefItem.getTreeDefItemId())) continue;
            return p;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        DataProviderSessionIFace.QueryIFace q = session.createQuery("from " + this.tblClass.getName() + " where rankId=" + parentDefItem.getRankId().toString() + " and name='" + this.getDefaultParentName().replace("'", "''") + "'", false);
        try {
            Treeable result = (Treeable)q.uniqueResult();
            if (result != null) {
                Treeable treeable = result;
                return treeable;
            }
        }
        catch (NonUniqueResultException hex) {
            throw new RuntimeException(hex);
        }
        finally {
            session.close();
        }
        return this.createDefaultParent(parentDefItem);
    }

    protected Treeable createDefaultParent(TreeDefItemIface defItem) throws UploaderException {
        try {
            Constructor constructor = this.tblClass.getDeclaredConstructor(new Class[0]);
            Treeable result = (Treeable)constructor.newInstance(null);
            result.initialize();
            result.setRankId(defItem.getRankId());
            result.setParent(this.getDefaultParent2(defItem));
            result.setName(this.getDefaultParentName());
            result.setDefinition(this.getTreeDef());
            result.setDefinitionItem(defItem);
            this.doWrite((DataModelObjBase)((Object)result));
            this.defaultParents.add(result);
            return result;
        }
        catch (NoSuchMethodException ex) {
            throw new UploaderException(ex, 20);
        }
        catch (InvocationTargetException ex) {
            throw new UploaderException(ex, 20);
        }
        catch (InstantiationException ex) {
            throw new UploaderException(ex, 20);
        }
        catch (IllegalAccessException ex) {
            throw new UploaderException(ex, 20);
        }
    }

    protected void loadTreeRoot() throws UploaderException {
        String hql = "from " + this.tblClass.getName() + " where " + this.getTreeDefFld() + "=" + this.getTreeDef().getTreeDefId() + " and " + this.getTreeDefItemFld() + "=" + this.getTreeDef().getDefItemByRank(0).getTreeDefItemId();
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            DataProviderSessionIFace.QueryIFace q = session.createQuery(hql, false);
            this.treeRoot = (Treeable)q.list().get(0);
        }
        finally {
            session.close();
        }
    }

    protected String getTreeDefFld() {
        return String.valueOf(this.tblClass.getSimpleName()) + "TreeDefId";
    }

    protected String getTreeDefItemFld() {
        return String.valueOf(this.tblClass.getSimpleName()) + "TreeDefItemId";
    }

    protected String getDefaultParentName() {
        return this.uploader.getIdentifier();
    }

    @Override
    public void undoUpload(boolean showProgress) throws UploaderException {
        super.undoUpload(showProgress);
        LinkedList<UploadedRecordInfo> keys = new LinkedList<UploadedRecordInfo>();
        for (Treeable defParent : this.defaultParents) {
            keys.add(new UploadedRecordInfo(((DataModelObjBase)((Object)defParent)).getId(), -1, 0, null));
        }
        this.deleteObjects(keys.iterator(), showProgress);
    }

    @Override
    public void prepareToUpload() throws UploaderException {
        super.prepareToUpload();
        this.defaultParents.clear();
        if (this.parent == null && !this.incrementalNodeNumberUpdates) {
            this.getTreeDef().setDoNodeNumberUpdates(false);
            this.getTreeDef().setUploadInProgress(true);
        }
    }

    @Override
    protected String getFullRecordSetName(boolean showRecordSetInUI) {
        if (showRecordSetInUI) {
            return super.getFullRecordSetName(showRecordSetInUI);
        }
        try {
            return String.valueOf(this.getTreeDefItem().getName()) + "_" + this.uploader.getIdentifier();
        }
        catch (UploaderException ux) {
            return String.valueOf(this.tblClass.getSimpleName()) + "_" + this.uploader.getIdentifier();
        }
    }

    @Override
    protected String getShortRecordSetName() {
        try {
            return this.getTreeDefItem().getName();
        }
        catch (UploaderException ux) {
            return this.tblClass.getSimpleName();
        }
    }

    @Override
    public String toString() {
        try {
            TreeDefItemIface td = this.getTreeDefItem();
            if (td != null) {
                return td.getDisplayText();
            }
            return this.tblClass.getSimpleName();
        }
        catch (UploaderException ux) {
            return this.tblClass.getSimpleName();
        }
    }

    @Override
    public String getTblTitle() {
        return this.toString();
    }

    @Override
    public Vector<InvalidStructure> verifyUploadability() throws UploaderException, ClassNotFoundException {
        Vector<InvalidStructure> result = super.verifyUploadability();
        if (this.getTreeDefItem() == null) {
            String msg = String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_NO_DEFITEM")) + " (" + this.wbLevelName + ")";
            result.add(new InvalidStructure(msg, this));
        }
        if (this.getTreeDefItem() != null) {
            for (Vector flds : this.uploadFields) {
                Vector<Field> fields = new Vector<Field>();
                Vector<UploadField> uploadFields = new Vector<UploadField>();
                for (UploadField fld : flds) {
                    if (fld.getIndex() == -1) continue;
                    int idx = fields.indexOf(fld.getField());
                    if (idx != -1) {
                        String msg = String.format(UIRegistry.getResourceString("WB_UPLOAD_EQUIV_RANKS"), fld.getWbFldName(), ((UploadField)uploadFields.get(idx)).getWbFldName(), this.getTreeDefItem().getName());
                        result.add(new InvalidStructure(msg, this));
                        continue;
                    }
                    fields.add(fld.getField());
                    uploadFields.add(fld);
                }
            }
        }
        if (this.parent == null) {
            Vector<TreeDefItemIface<?, ?, ?>> missingDefs = this.getMissingRequiredDefs();
            for (TreeDefItemIface<?, ?, ?> defItem : missingDefs) {
                String msg = String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MISSING_TREE_LEVEL")) + " (" + defItem.getName() + ")";
                result.add(new InvalidStructure(msg, this));
            }
        }
        return result;
    }

    protected Vector<TreeDefItemIface<?, ?, ?>> getMissingRequiredDefs() throws UploaderException {
        Vector result = new Vector();
        if (this.child != null) {
            for (Object obj : this.getTreeDef().getTreeDefItems()) {
                TreeDefItemIface defItem = (TreeDefItemIface)obj;
                if (defItem.getRankId() <= this.rank || defItem.getIsEnforced() == null || !defItem.getIsEnforced().booleanValue()) continue;
                UploadTableTree currLevel = this;
                while (currLevel != null) {
                    if (defItem.getRankId().equals(currLevel.rank)) break;
                    currLevel = currLevel.child;
                }
                if (currLevel != null) continue;
                result.add(defItem);
            }
        }
        return result;
    }

    @Override
    protected boolean fldInDataset(String fldName) {
        return super.fldInDataset(fldName) || fldName.equalsIgnoreCase("fullname");
    }

    @Override
    protected boolean invalidNull(UploadField fld, UploadData uploadData, int row, int seq) throws UploaderException {
        if (fld.isRequired() && this.getTreeDefItem().getIsEnforced() != null && this.getTreeDefItem().getIsEnforced().booleanValue() && (fld.getValue() == null || fld.getValue().trim().equals(""))) {
            UploadTableTree currentChild = this.child;
            while (currentChild != null) {
                String val;
                UploadField uf = currentChild.findUploadField(fld.getField().getName(), seq);
                if (uf != null && (val = uploadData.get(row, uf.getIndex())) != null && !val.trim().equals("")) {
                    return true;
                }
                currentChild = currentChild.child;
            }
        }
        return false;
    }

    @Override
    protected boolean needToWrite(int recNum) {
        return this.dataToWrite(recNum);
    }

    protected boolean needToUpdateTree() {
        if (this.uploadedRecs.size() > 0) {
            return true;
        }
        if (this.child != null) {
            return this.child.needToUpdateTree();
        }
        return false;
    }

    @Override
    public void finishUpload(boolean cancelled) throws UploaderException {
        super.finishUpload(cancelled);
        if (this.parent == null && !this.incrementalNodeNumberUpdates && !cancelled && this.needToUpdateTree()) {
            try {
                this.getTreeDef().updateAllNodes((DataModelObjBase)((Object)this.getTreeRoot()), true, false);
            }
            catch (Exception ex) {
                if (ex instanceof UploaderException) {
                    throw (UploaderException)ex;
                }
                throw new UploaderException(ex);
            }
        }
    }

    @Override
    public void finishUndoUpload() throws UploaderException {
        super.finishUndoUpload();
        this.finishUpload(false);
    }

    @Override
    public void shutdown() throws UploaderException {
        super.shutdown();
        if (this.parent == null && !this.incrementalNodeNumberUpdates) {
            this.getTreeDef().setDoNodeNumberUpdates(true);
            this.getTreeDef().setUploadInProgress(false);
        }
    }

    @Override
    public boolean needToRefreshAfterWrite() {
        return this.incrementalNodeNumberUpdates;
    }

    @Override
    protected boolean findValueForReqRelClass(RelatedClassSetter rce) throws ClassNotFoundException, UploaderException {
        if (rce.setter.getName().equals("setDefinition")) {
            rce.setDefaultId(this.getTreeDef().getTreeDefId());
            return false;
        }
        if (rce.setter.getName().equals("setDefinitionItem")) {
            return true;
        }
        return super.findValueForReqRelClass(rce);
    }

    public Integer getRank() {
        return this.rank;
    }

    @Override
    protected boolean setParents(DataModelObjBase rec, int recNum, boolean isForWrite) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, UploaderException {
        boolean result = super.setParents(rec, recNum, isForWrite);
        return result;
    }

    @Override
    protected void addDomainCriteria(DataProviderSessionIFace.CriteriaIFace criteria) throws UploaderException {
    }

    @Override
    protected boolean shouldLoadParent(Uploader.ParentTableEntry pte) {
        return super.shouldLoadParent(pte) && pte.getImportTable() != this.parent;
    }

    @Override
    protected void loadMyRecord(DataModelObjBase rec, int seq) {
        DataModelObjBase parentRec = rec;
        if (rec != null && ((Treeable)((Object)rec)).getRankId().equals(this.getRank())) {
            super.loadMyRecord(rec, seq);
            parentRec = (DataModelObjBase)((Treeable)((Object)rec)).getParent();
        } else {
            super.loadMyRecord(null, seq);
        }
        if (this.parent != null) {
            this.parent.loadMyRecord(parentRec, seq);
        }
    }

    @Override
    protected boolean isBlankVal(UploadField fld, int seq, int row, UploadData uploadData) {
        boolean result = super.isBlankVal(fld, seq, row, uploadData);
        if (!result || this.uploadFields.size() == 1 || this.parent != null && this.parent.uploadFields.size() > 1) {
            return false;
        }
        UploadTableTree kid = this.child;
        while (kid != null) {
            UploadField kidField = null;
            for (UploadField field : (Vector)kid.uploadFields.get(seq)) {
                if (!field.getField().getName().equals(fld.getField().getName())) continue;
                kidField = field;
                break;
            }
            if (kidField != null) {
                kidField.setValue(uploadData.get(row, kidField.getIndex()));
                if (!super.isBlankVal(kidField, seq, row, uploadData)) {
                    return false;
                }
            } else {
                log.error((Object)("Possibly invalid tree structure for " + this.tblClass.getSimpleName() + " (" + fld + ")"));
            }
            kid = kid.child;
        }
        return true;
    }

    @Override
    protected void addInvalidValueMsgForOneToManySkip(Vector<UploadTableInvalidValue> msgs, UploadField fld, String name, int row, int seq) {
        super.addInvalidValueMsgForOneToManySkip(msgs, fld, name, row, seq);
        UploadTableTree kid = this.child;
        while (kid != null) {
            UploadField kidField = null;
            for (UploadField field : (Vector)kid.uploadFields.get(seq)) {
                if (!field.getField().getName().equals(fld.getField().getName())) continue;
                kidField = field;
                break;
            }
            if (kidField != null) {
                super.addInvalidValueMsgForOneToManySkip(msgs, kidField, kid.toString(), row, seq);
            } else {
                log.error((Object)("Possibly invalid tree structure for " + this.tblClass.getSimpleName() + " (" + fld + ")"));
            }
            kid = kid.child;
        }
    }

    @Override
    public void validateRowValues(int row, UploadData uploadData, Vector<UploadTableInvalidValue> invalidValues) {
        super.validateRowValues(row, uploadData, invalidValues);
        for (Vector flds : this.uploadFields) {
            boolean nameBlank = true;
            boolean allBlank = true;
            UploadField mainFld = null;
            for (UploadField fld : flds) {
                if (fld.getField().getName().equalsIgnoreCase("name")) {
                    mainFld = fld;
                }
                if (fld.getIndex() == -1 || StringUtils.isEmpty((String)uploadData.get(row, fld.getIndex()))) continue;
                allBlank = false;
                if (fld != mainFld) continue;
                nameBlank = false;
            }
            if (!nameBlank || allBlank) continue;
            invalidValues.add(new UploadTableInvalidValue(null, (UploadTable)this, mainFld, row, new Exception(UIRegistry.getResourceString("WB_UPLOAD_INVALID_EMPTY_CELL"))));
        }
    }

    @Override
    protected boolean requiredLocalFldsArePresent() {
        if (!super.requiredLocalFldsArePresent()) {
            return false;
        }
        for (Vector flds : this.uploadFields) {
            boolean gotName = false;
            for (UploadField fld : flds) {
                if (!fld.getField().getName().equalsIgnoreCase("name")) continue;
                gotName = true;
                break;
            }
            if (gotName) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Vector<Field> getMissingReqLocalFlds() {
        Vector<Field> result = super.getMissingReqLocalFlds();
        result.add(this.table.getField("name"));
        return result;
    }

    @Override
    protected boolean getMatchCriteria(DataProviderSessionIFace.CriteriaIFace critter, int recNum, Vector<UploadTable.MatchRestriction> restrictedVals, HashMap<UploadTable, DataModelObjBase> overrideParentParams) throws UploaderException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        boolean result = super.getMatchCriteria(critter, recNum, restrictedVals, overrideParentParams);
        if (!this.allowUnacceptedMatches) {
            restrictedVals.add(new UploadTable.MatchRestriction("isAccepted", this.addRestriction(critter, "isAccepted", new Boolean(true), false), -1));
        }
        return result;
    }

    @Override
    protected boolean isMatchable(Set<Integer> unmatchableCols, int seq) {
        boolean result;
        boolean bl = result = this.parent != null ? this.parent.isMatchable(unmatchableCols, seq) : true;
        if (result) {
            result = super.isMatchable(unmatchableCols, seq);
        }
        return result;
    }

    public UploadTableTree getParent() {
        return this.parent;
    }

    public UploadTableTree getChild() {
        return this.child;
    }

    @Override
    protected boolean shouldClearParent(Uploader.ParentTableEntry pte) {
        return true;
    }

    @Override
    protected int getAdjustedSeqForBlankRowCheck(int seq) {
        if (this.uploadFields.size() == 1 && seq > 0) {
            return 0;
        }
        return seq;
    }

    public class AcceptedParentSwitchMessage
    extends BaseUploadMessage {
        protected final int row;

        public AcceptedParentSwitchMessage(String msg, int row) {
            super(msg);
            this.row = row;
        }

        @Override
        public int getRow() {
            return this.row;
        }
    }

    protected class RankComparator
    implements Comparator<Treeable> {
        protected RankComparator() {
        }

        @Override
        public int compare(Treeable t1, Treeable t2) {
            if (t1.getRankId() < t2.getRankId()) {
                return 1;
            }
            if (t1.getRankId() == t2.getRankId()) {
                return 0;
            }
            return -1;
        }
    }
}

