/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.BaseUploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadField;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.ui.UIRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;

public class UploadTableInvalidValue
extends BaseUploadMessage
implements Comparable<UploadTableInvalidValue> {
    protected final UploadTable uploadTbl;
    protected final List<UploadField> uploadFlds = new Vector<UploadField>();
    protected final Integer rowNum;
    protected final Exception cause;
    protected final boolean warn;

    public UploadTableInvalidValue(String baseMsg, UploadTable uploadTbl, UploadField uploadFld, int rowNum, Exception cause) {
        this(baseMsg, uploadTbl, uploadFld, null, rowNum, cause, false);
    }

    public UploadTableInvalidValue(String baseMsg, UploadTable uploadTbl, List<UploadField> uploadFlds, int rowNum, Exception cause) {
        this(baseMsg, uploadTbl, null, uploadFlds, rowNum, cause, false);
    }

    public UploadTableInvalidValue(String baseMsg, UploadTable uploadTbl, int rowNum, Exception cause) {
        this(baseMsg, uploadTbl, null, null, rowNum, cause, false);
    }

    protected UploadTableInvalidValue(String baseMsg, UploadTable uploadTbl, UploadField uploadFld, List<UploadField> uploadFlds, int rowNum, Exception cause, boolean warn) {
        super(baseMsg);
        this.uploadTbl = uploadTbl;
        if (uploadFld != null) {
            this.uploadFlds.add(uploadFld);
        }
        if (uploadFlds != null) {
            this.uploadFlds.addAll(uploadFlds);
        }
        this.rowNum = new Integer(rowNum);
        this.cause = cause;
        this.warn = warn;
    }

    public String getDescription() {
        InvocationTargetException theCause;
        if (this.cause == null) {
            return this.msg;
        }
        if (this.cause instanceof UploaderException && this.cause.getCause() != null && this.cause.getCause().getMessage() != null) {
            return this.cause.getCause().getMessage();
        }
        if (this.cause instanceof InvocationTargetException && (theCause = (InvocationTargetException)this.cause).getTargetException() != null && theCause.getTargetException() instanceof NumberFormatException) {
            return UIRegistry.getResourceString("WB_UPLOAD_INVALID_NUMBER");
        }
        if (this.cause.getMessage() != null) {
            return this.cause.getMessage();
        }
        return null;
    }

    public String getIssueName() {
        if (this.cause != null) {
            return this.cause.getClass().getSimpleName();
        }
        return null;
    }

    @Override
    public int getRow() {
        return this.rowNum;
    }

    public UploadField getUploadFld() {
        if (this.uploadFlds.size() > 0) {
            return this.uploadFlds.get(0);
        }
        return null;
    }

    public UploadTable getUploadTbl() {
        return this.uploadTbl;
    }

    @Override
    public String getMsg() {
        if (this.getUploadFld() != null) {
            return String.valueOf(this.getUploadFld().getWbFldName()) + " (row " + Integer.toString(this.rowNum + 1) + "): " + this.getDescription();
        }
        if (this.cause != null) {
            return "(row " + Integer.toString(this.rowNum + 1) + "): " + this.getDescription();
        }
        return super.getMsg();
    }

    @Override
    public int getCol() {
        if (this.getUploadFld() != null) {
            return this.getUploadFld().getIndex();
        }
        return -1;
    }

    public List<Integer> getCols() {
        if (this.uploadFlds.size() == 0) {
            return null;
        }
        Vector<Integer> result = new Vector<Integer>(this.uploadFlds.size());
        int f = 0;
        while (f < this.uploadFlds.size()) {
            result.add(this.uploadFlds.get(f).getIndex());
            ++f;
        }
        return result;
    }

    @Override
    public Object getData() {
        return this.cause;
    }

    @Override
    public int compareTo(UploadTableInvalidValue o) {
        int result;
        if (this.rowNum != null && (result = this.rowNum.compareTo(o.rowNum)) != 0) {
            return result;
        }
        if (this.getUploadFld() != null && o.getUploadFld() != null) {
            if (this.getUploadFld().getIndex() < o.getUploadFld().getIndex()) {
                return -1;
            }
            if (this.getUploadFld().getIndex() > o.getUploadFld().getIndex()) {
                return 1;
            }
        }
        return 0;
    }

    public boolean isInvalidNull() {
        return this.cause != null && this.cause.getMessage().equals(UIRegistry.getResourceString("WB_UPLOAD_FIELD_MUST_CONTAIN_DATA"));
    }

    public boolean isWarn() {
        return this.warn;
    }
}

