/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.AccessionAuthorization;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.Author;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttribute;
import edu.ku.brc.specify.datamodel.CollectionObjectCitation;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.ConservDescription;
import edu.ku.brc.specify.datamodel.ConservEvent;
import edu.ku.brc.specify.datamodel.DNASequence;
import edu.ku.brc.specify.datamodel.DNASequencingRun;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.FieldNotebook;
import edu.ku.brc.specify.datamodel.FieldNotebookPage;
import edu.ku.brc.specify.datamodel.GeoCoordDetail;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.LocalityDetail;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationAttribute;
import edu.ku.brc.specify.datamodel.RecordSet;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.busrules.AttachmentOwnerBaseBusRules;
import edu.ku.brc.specify.dbsupport.RecordTypeCodeBuilder;
import edu.ku.brc.specify.dbsupport.SpecifyDeleteHelper;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.BaseUploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DefaultFieldEntry;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DefaultIsPrimaryEntry;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.InvalidStructure;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.MatchHandler;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.RecordComparator;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.RelatedClassSetter;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadField;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMatchSetting;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableInvalidValue;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableMatchInfo;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableTree;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecFinalizerIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecordInfo;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.DateConverter;
import edu.ku.brc.util.GeoRefConverter;
import edu.ku.brc.util.LatLonConverter;
import edu.ku.brc.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.ObjectDeletedException;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;

public class UploadTable
implements Comparable<UploadTable> {
    protected static boolean debugging = false;
    private static boolean doRawDeletes = true;
    protected final Uploader uploader;
    protected final Table table;
    protected Vector<Vector<UploadField>> uploadFields;
    protected final Relationship relationship;
    protected boolean required = false;
    protected Vector<Vector<Uploader.ParentTableEntry>> parentTables;
    protected SortedSet<UploadedRecordInfo> uploadedRecs;
    protected int wbCurrentRow;
    protected static final Logger log = Logger.getLogger(UploadTable.class);
    protected Vector<DataModelObjBase> currentRecords;
    protected Class<?> tblClass;
    protected Vector<RelatedClassSetter> requiredRelClasses;
    protected Vector<RelatedClassSetter> relatedClassDefaults;
    protected DataProviderSessionIFace tblSession;
    protected DateConverter dateConverter;
    protected char decSep = new DecimalFormatSymbols().getDecimalSeparator();
    protected boolean hasChildren;
    protected Vector<UploadTable> specialChildren;
    protected AtomicBoolean skipChildrenMatching = new AtomicBoolean(false);
    protected boolean skipMatching = false;
    protected boolean skipRow = false;
    protected Vector<DefaultFieldEntry> missingRequiredFlds;
    protected UploadMatchSetting matchSetting;
    protected boolean matchRecordId = false;
    protected Integer exportedRecordId = null;
    protected boolean reusingExportedRec = false;
    protected Integer exportedOneToManyId = null;
    protected boolean exportedOneToManyDelete = false;
    protected boolean isSequenced = false;
    protected boolean updateMatches = false;
    protected boolean checkMatchInfo = false;
    protected Vector<MatchRestriction> restrictedValsForAddNewMatch = null;
    protected boolean validatingValues = false;
    protected Object autoAssignedVal = null;
    protected Object prevAutoAssignedVal = null;
    protected UploadField autoAssignedField = null;
    protected Collection collection = null;
    protected Discipline discipline = null;
    protected Division division = null;
    UploadedRecFinalizerIFace finalizer = null;
    List<Pair<UploadField, Method>> precisionDateFields = new LinkedList<Pair<UploadField, Method>>();
    protected boolean isSecurityOn;
    protected GeoRefConverter geoRefConverter = new GeoRefConverter();
    protected boolean isUploadRoot = false;
    protected boolean plugHoles = true;
    protected boolean deleteUnusedRecs = true;
    protected Set<Pair<Integer, String>> disUsedRecs = new TreeSet<Pair<Integer, String>>(new Comparator<Pair<Integer, String>>(){

        @Override
        public int compare(Pair<Integer, String> arg0, Pair<Integer, String> arg1) {
            return arg0.getFirst().compareTo(arg1.getFirst());
        }
    });
    protected List<Pair<Integer, String>> deletedRecs = new Vector<Pair<Integer, String>>();

    public UploadTable(Uploader uploader, Table table, Relationship relationship) {
        this.uploader = uploader;
        this.table = table;
        this.relationship = relationship;
        this.uploadFields = new Vector();
        this.uploadedRecs = new TreeSet<UploadedRecordInfo>();
        this.currentRecords = new Vector();
        this.specialChildren = new Vector();
        this.relatedClassDefaults = null;
        this.dateConverter = new DateConverter();
        this.matchSetting = new UploadMatchSetting();
        this.plugHoles = AppPreferences.getLocalPrefs().getBoolean("WB_UnPlugManyHoles", false) == false;
    }

    public boolean isMatchChild() {
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (pte.getImportTable().specialChildren == null || !pte.getImportTable().specialChildren.contains(this) || !pte.getImportTable().needToMatchChild(this.tblClass)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean shouldSkipMatching() {
        return this.isOneToOneChild() || this.tblClass.equals(CollectingEvent.class) && AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent() != false;
    }

    public boolean isOneToOneChild() {
        return this.tblClass.equals(CollectionObjectAttribute.class) || this.tblClass.equals(PreparationAttribute.class) || this.tblClass.equals(CollectingEventAttribute.class) || this.tblClass.equals(GeoCoordDetail.class) || this.tblClass.equals(LocalityDetail.class);
    }

    public boolean isZeroToOneMany() {
        return this.tblClass.equals(GeoCoordDetail.class) || this.tblClass.equals(LocalityDetail.class);
    }

    public void init() throws UploaderException {
        this.determineTblClass();
        this.initReqRelClasses();
        this.skipMatching = this.shouldSkipMatching();
        this.finalizer = this.findFinalizer();
    }

    public void findPrecisionDateFields() {
        for (UploadField fld : this.uploadFields.get(0)) {
            DBFieldInfo precFld;
            if (fld.getField() == null || fld.getField().getFieldInfo() == null || (precFld = this.getDatePrecisionFld(fld.getField().getFieldInfo())) == null) continue;
            this.precisionDateFields.add(new Pair<UploadField, Method>(fld, this.getFldSetter(precFld)));
        }
    }

    protected UploadedRecFinalizerIFace findFinalizer() throws UploaderException {
        String className = String.valueOf(this.getClass().getPackage().getName()) + "." + this.tblClass.getSimpleName() + "RecFinalizer";
        try {
            Class<?> cls = Class.forName(className);
            return (UploadedRecFinalizerIFace)cls.newInstance();
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new UploaderException(ex, 20);
        }
    }

    protected void determineTblClass() throws UploaderException {
        try {
            this.tblClass = Class.forName("edu.ku.brc.specify.datamodel." + this.table.getName());
        }
        catch (ClassNotFoundException cnfEx) {
            throw new UploaderException(cnfEx, 20);
        }
    }

    protected void initReqRelClasses() throws UploaderException {
        try {
            this.requiredRelClasses = this.buildReqRelClasses();
        }
        catch (NoSuchMethodException nsmEx) {
            throw new UploaderException(nsmEx, 20);
        }
    }

    protected Method getSetterForGetter(Method getter) throws NoSuchMethodException {
        Class[] params = new Class[]{getter.getReturnType()};
        String setterName = "set" + getter.getName().substring(3);
        return this.tblClass.getMethod(setterName, params);
    }

    public void prepareToUpload() throws UploaderException {
        this.isUploadRoot = this.uploader.getRootTable() == this;
        this.uploadedRecs.clear();
        this.matchSetting.clear();
        this.deletedRecs.clear();
        this.disUsedRecs.clear();
        this.isSecurityOn = AppContextMgr.isSecurityOn();
        if (this.matchRecordId) {
            for (UploadTable ut : this.specialChildren) {
                ut.setSkipMatching(false);
                ut.setMatchRecordId(true);
            }
        }
    }

    protected boolean fldInDataset(String fldName) {
        if (this.uploadFields != null && this.uploadFields.size() > 0) {
            for (UploadField fld : this.uploadFields.get(0)) {
                if (!fld.getField().getName().equalsIgnoreCase(fldName)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean colIsNullable(Column col) {
        if (!(this.tblClass.equals(Locality.class) && (col.name().equalsIgnoreCase("LatLongType") || col.name().equalsIgnoreCase("Latitude1") || col.name().equalsIgnoreCase("Longitude1") || col.name().equalsIgnoreCase("Latitude2") || col.name().equalsIgnoreCase("Longitude2")))) {
            return col.nullable();
        }
        for (Vector<UploadField> flds : this.uploadFields) {
            for (UploadField fld : flds) {
                String fldName = fld.getField().getName();
                if (!(col.name().equalsIgnoreCase("LatLongType") ? fldName.equalsIgnoreCase("Latitude2") || fldName.equalsIgnoreCase("Longitude2") : (col.name().equalsIgnoreCase("Latitude1") ? fldName.equalsIgnoreCase("LatLongType") || fldName.equalsIgnoreCase("Longitude1") || fldName.equalsIgnoreCase("Latitude2") || fldName.equalsIgnoreCase("Longitude2") : (col.name().equalsIgnoreCase("Latitude2") ? fldName.equalsIgnoreCase("Longitude2") : (col.name().equalsIgnoreCase("Longitude1") ? fldName.equalsIgnoreCase("LatLongType") || fldName.equalsIgnoreCase("Latitude1") || fldName.equalsIgnoreCase("Latitude2") || fldName.equalsIgnoreCase("Longitude2") : col.name().equalsIgnoreCase("Longitude2") && fldName.equalsIgnoreCase("Latitude2")))))) continue;
                return false;
            }
        }
        return true;
    }

    protected void buildMissingRequiredFlds() throws NoSuchMethodException {
        this.missingRequiredFlds = new Vector();
        Method[] methodArray = this.tblClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column col;
            Method m = methodArray[n2];
            Column a = m.getAnnotation(Column.class);
            GeneratedValue b = m.getAnnotation(GeneratedValue.class);
            if (!(a == null || b != null || this.colIsNullable(col = a) || col.name().startsWith("Timestamp") || col.name().equalsIgnoreCase("srcLatLongUnit"))) {
                if (!this.fldInDataset(col.name())) {
                    this.logDebug("adding required field: " + this.tblClass.getName() + " - " + m.getName());
                    Method setter = this.getSetterForGetter(m);
                    String fldName = col.name();
                    if (fldName.equalsIgnoreCase("CollectionMemberID")) {
                        fldName = "collectionMemberId";
                    }
                    DefaultFieldEntry dfe = this.table.getName().equalsIgnoreCase("collector") && fldName.equalsIgnoreCase("isprimary") ? new DefaultIsPrimaryEntry(this, m.getReturnType(), setter, fldName, null) : new DefaultFieldEntry(this, m.getReturnType(), setter, fldName, null);
                    this.missingRequiredFlds.add(dfe);
                } else if (col.name().equalsIgnoreCase("LatLongType")) {
                    for (Vector<UploadField> ufs : this.uploadFields) {
                        for (UploadField uf : ufs) {
                            if (uf.getField().isRequired() || !uf.getField().getName().equalsIgnoreCase(col.name())) continue;
                            uf.setRequired(true);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public Iterator<DefaultFieldEntry> getMissingRequiredFlds() throws NoSuchMethodException {
        if (this.missingRequiredFlds == null) {
            this.buildMissingRequiredFlds();
        }
        return this.missingRequiredFlds.iterator();
    }

    public Vector<String> getWbFldNames() {
        Vector<String> result = new Vector<String>();
        for (Vector<UploadField> ufs : this.uploadFields) {
            for (UploadField uf : ufs) {
                if (uf.getWbFldName() == null) continue;
                result.add(uf.getWbFldName());
            }
        }
        return result;
    }

    protected Vector<RelatedClassSetter> buildReqRelClasses() throws NoSuchMethodException {
        Vector<RelatedClassSetter> result = new Vector<RelatedClassSetter>();
        Method[] methodArray = this.tblClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            JoinColumn a = m.getAnnotation(JoinColumn.class);
            if (a != null) {
                JoinColumn jc = a;
                this.logDebug(jc.columnDefinition());
                if (!jc.nullable() || m.getName().equals("getDivision")) {
                    this.logDebug("adding required class: " + this.tblClass.getName() + " - " + m.getName());
                    ManyToOne mto = m.getAnnotation(ManyToOne.class);
                    if (mto != null) {
                        CascadeType[] ct = mto.cascade();
                        int c = 0;
                        while (c < ct.length) {
                            this.logDebug(ct[c]);
                            ++c;
                        }
                    }
                    Method setter = this.getSetterForGetter(m);
                    String fldName = jc.referencedColumnName();
                    if (fldName == null || fldName.equals("")) {
                        fldName = jc.name();
                    }
                    if (this.addToReqRelClasses(m.getReturnType())) {
                        result.add(RelatedClassSetter.createRelatedClassSetter(this, m.getReturnType(), fldName, null, null, setter, this.uploadFields.size()));
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    protected boolean addToReqRelClasses(Class<?> relatedClass) {
        return true;
    }

    protected boolean findValueForReqRelClass(RelatedClassSetter rce) throws ClassNotFoundException, UploaderException {
        for (Vector<Uploader.ParentTableEntry> its : this.parentTables) {
            for (Uploader.ParentTableEntry pt : its) {
                String parentName = UploadTable.capitalize(pt.getImportTable().getWriteTable().getName());
                Class<?> parentTblClass = Class.forName("edu.ku.brc.specify.datamodel." + parentName);
                if (rce.getRelatedClass() != parentTblClass || !pt.getParentRel().getRelatedField().getName().equalsIgnoreCase(rce.getFieldName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void bldMissingReqRelClasses() throws ClassNotFoundException, UploaderException {
        this.relatedClassDefaults = new Vector();
        for (RelatedClassSetter rce : this.requiredRelClasses) {
            rce.refresh(this.uploadFields.size());
            if (this.findValueForReqRelClass(rce)) continue;
            this.relatedClassDefaults.add(rce);
        }
    }

    public Iterator<RelatedClassSetter> getRelatedClassDefaults() throws ClassNotFoundException, UploaderException {
        if (this.relatedClassDefaults == null) {
            this.bldMissingReqRelClasses();
        }
        return this.relatedClassDefaults.iterator();
    }

    protected boolean requiredLocalFldsArePresent() {
        return true;
    }

    protected Vector<Field> getMissingReqLocalFlds() {
        return new Vector<Field>();
    }

    public Vector<InvalidStructure> verifyUploadability() throws UploaderException, ClassNotFoundException {
        Vector<InvalidStructure> result = new Vector<InvalidStructure>();
        String tblTitle = this.getTable().getTableInfo().getTitle();
        if (this.uploadFields.size() > 1) {
            Integer fldCount = null;
            int seq = 1;
            for (Vector<UploadField> ups : this.uploadFields) {
                if (fldCount == null) {
                    fldCount = ups.size();
                } else if (fldCount.intValue() != ups.size()) {
                    String msg = String.valueOf(String.format(UIRegistry.getResourceString("WB_UPLOAD_INVALID_MANY_MAPPING"), seq)) + ": " + tblTitle;
                    result.add(new InvalidStructure(msg, this));
                }
                ++seq;
            }
        }
        if (!this.requiredLocalFldsArePresent()) {
            for (Field fld : this.getMissingReqLocalFlds()) {
                String fldTitle = fld.getFieldInfo().getTitle();
                String msg = String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MISSING_FLD")) + ": " + tblTitle + "." + fldTitle;
                result.add(new InvalidStructure(msg, this));
            }
        }
        return result;
    }

    public void addField(UploadField field) {
        this.isSequenced = field.getSequence() != null;
        int idx = field.getSequence() == null ? 0 : field.getSequence();
        while (this.uploadFields.size() < idx + 1) {
            this.uploadFields.add(new Vector());
        }
        this.uploadFields.get(idx).add(field);
    }

    public Table getTable() {
        return this.table;
    }

    public Vector<Vector<UploadField>> getUploadFields() {
        return this.uploadFields;
    }

    public UploadField getField(String name, Integer sequence) {
        int index;
        int n = index = sequence == null ? 0 : sequence;
        if (index < this.uploadFields.size()) {
            for (UploadField imp : this.uploadFields.get(index)) {
                if (!imp.getField().getName().equals(name)) continue;
                return imp;
            }
        }
        return null;
    }

    public Table getWriteTable() {
        return this.getTable();
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    protected boolean requiredDataPresent(int recNum) {
        int index = this.uploadFields.size() > 1 ? recNum : 0;
        for (UploadField f : this.uploadFields.get(index)) {
            if (f.getField().isForeignKey() || !StringUtils.isEmpty((String)f.getValue()) || !f.isRequired() || f == this.autoAssignedField) continue;
            return false;
        }
        return true;
    }

    protected boolean ignoreFieldData(UploadField f) {
        return f.getField().getName().equalsIgnoreCase("ordernumber");
    }

    protected boolean dataToWrite(int recNum) {
        int index = this.uploadFields.size() > 1 ? recNum : 0;
        boolean result = false;
        for (UploadField f : this.uploadFields.get(index)) {
            if (this.ignoreFieldData(f) || !StringUtils.isNotEmpty((String)f.getValue()) && f != this.autoAssignedField) continue;
            result = true;
            break;
        }
        return result && this.requiredDataPresent(recNum);
    }

    protected boolean isValid(int recNum) {
        return this.requiredDataPresent(recNum);
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public int compareTo(UploadTable impT) {
        if (impT == null) {
            return -1;
        }
        int result = this.toString().compareTo(impT.toString());
        if (result != 0) {
            return result;
        }
        if (this.relationship != null) {
            return this.relationship.compareTo(impT.relationship);
        }
        if (impT.relationship != null) {
            return 1;
        }
        return 0;
    }

    public final Vector<Vector<Uploader.ParentTableEntry>> getParentTables() {
        return this.parentTables;
    }

    public Uploader.ParentTableEntry getParentTableEntry(UploadTable parent) {
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (pte.getImportTable() != parent) continue;
                return pte;
            }
        }
        return null;
    }

    public final void setParentTables(Vector<Vector<Uploader.ParentTableEntry>> parentTables) throws NoSuchMethodException, ClassNotFoundException {
        this.parentTables = parentTables;
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (pte.getImportTable().needToMatchChild(this.tblClass)) {
                    pte.getImportTable().addChild(this);
                    continue;
                }
                if (!this.needToMatchChildren() || !pte.getImportTable().isOneToOneChild()) continue;
                this.addChild(pte.getImportTable());
            }
        }
        this.assignParentSetters();
    }

    protected void addChild(UploadTable child) {
        this.specialChildren.add(child);
    }

    public SortedSet<UploadedRecordInfo> getUploadedRecs() {
        return this.uploadedRecs;
    }

    public DataModelObjBase getCurrentRecord(int index) {
        if (this.currentRecords.size() == 0) {
            return null;
        }
        if (index < this.uploadFields.size() && index > this.currentRecords.size() - 1) {
            return null;
        }
        if (index > this.currentRecords.size() - 1) {
            return this.currentRecords.get(0);
        }
        return this.currentRecords.get(index);
    }

    protected DataModelObjBase getCurrentRecordForSave(int index) throws IllegalAccessException, InstantiationException {
        if (index > this.currentRecords.size() - 1 || this.currentRecords.get(index) == null) {
            return this.createRecord();
        }
        return this.currentRecords.get(index);
    }

    protected void setCurrentRecord(DataModelObjBase rec, int index) {
        while (this.currentRecords.size() < index + 1) {
            this.currentRecords.add(null);
        }
        this.currentRecords.set(index, rec);
    }

    protected void loadMyRecord(DataModelObjBase rec, int seq) {
        this.setCurrentRecord(rec, seq);
    }

    protected boolean shouldLoadParent(Uploader.ParentTableEntry pte) {
        return !pte.getImportTable().specialChildren.contains(this) || !pte.getImportTable().needToMatchChild(this.tblClass);
    }

    protected boolean shouldClearParent(Uploader.ParentTableEntry pte) {
        return this.shouldLoadParent(pte);
    }

    protected void clearCurrentRecords() {
        int r = 0;
        while (r < this.uploadFields.size()) {
            this.setCurrentRecord(null, r);
            ++r;
        }
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (!this.shouldClearParent(pte)) continue;
                pte.getImportTable().clearCurrentRecords();
            }
        }
    }

    protected DataModelObjBase getExportedRecord() {
        if (this.exportedRecordId != null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                DataModelObjBase obj = (DataModelObjBase)session.get(this.tblClass, this.exportedRecordId);
                if (obj != null) {
                    obj.forceLoad();
                    DataModelObjBase dataModelObjBase = obj;
                    return dataModelObjBase;
                }
            }
            finally {
                session.close();
            }
        }
        return null;
    }

    public void loadExportedRecord(Integer id) throws Exception {
        this.exportedRecordId = id;
        DataModelObjBase rec = this.getExportedRecord();
        if (rec != null) {
            this.loadRecord(rec, 0);
        }
    }

    public void loadRecord(DataModelObjBase rec, int seq) throws Exception {
        this.loadMyRecord(rec, seq);
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (!this.shouldLoadParent(pte)) continue;
                if (rec != null) {
                    pte.getImportTable().loadRecord((DataModelObjBase)pte.getGetter().invoke((Object)rec, null), seq);
                    continue;
                }
                pte.getImportTable().loadRecord(null, seq);
            }
        }
        for (UploadTable c : this.specialChildren) {
            c.clearCurrentRecords();
        }
        if (rec != null) {
            for (UploadTable c : this.specialChildren) {
                int cSeq = 0;
                List<DataModelObjBase> childRecs = this.getChildRecords(c, rec);
                for (DataModelObjBase childRec : childRecs) {
                    if (cSeq < c.uploadFields.size()) {
                        c.loadRecord(childRec, cSeq++);
                        continue;
                    }
                    log.warn((Object)("Not loading " + c.getTblTitle() + " child " + cSeq + 1 + " into dataset because only " + c.uploadFields.size() + " children are mapped."));
                }
            }
        }
    }

    protected Method getOneToManyChildGetter(UploadTable child) {
        int tries = 0;
        while (tries < 2) {
            String name = "get" + child.getTblClass().getSimpleName() + (tries == 0 ? "s" : "es");
            try {
                return this.getTblClass().getMethod(name, null);
            }
            catch (NoSuchMethodException ex) {
                if (tries > 0) {
                    return null;
                }
                ++tries;
            }
        }
        return null;
    }

    protected List<DataModelObjBase> getChildRecords(UploadTable child, DataModelObjBase parentRec) throws Exception {
        Vector<DataModelObjBase> result = new Vector<DataModelObjBase>();
        Method getter = this.getOneToManyChildGetter(child);
        if (getter != null) {
            Set set = (Set)getter.invoke((Object)parentRec, null);
            for (DataModelObjBase element : set) {
                result.add(element);
            }
            this.orderChildRecordsForLoad(child, result);
        }
        return result;
    }

    protected void orderChildRecordsForLoad(UploadTable child, List<DataModelObjBase> childRecords) throws Exception {
        RecordComparator rc;
        if (childRecords != null && childRecords.size() > 0 && (rc = RecordComparator.createRecordComparator(child.getTblClass())) != null) {
            Collections.sort(childRecords, rc);
        }
    }

    public void setExportedRecordId(DataModelObjBase rec) throws Exception {
        this.exportedRecordId = rec == null ? null : rec.getId();
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (rec == null) {
                    pte.getImportTable().setExportedRecordId(null);
                    continue;
                }
                pte.getImportTable().setExportedRecordId((DataModelObjBase)pte.getGetter().invoke((Object)rec, null));
            }
        }
        if (this.matchRecordId) {
            for (UploadTable sut : this.specialChildren) {
                if (!sut.matchRecordId) continue;
                sut.exportedRecordId = rec.getId();
            }
        }
    }

    protected DataModelObjBase createRecord() throws InstantiationException, IllegalAccessException {
        return (DataModelObjBase)this.tblClass.newInstance();
    }

    protected void assignParentSetters() throws ClassNotFoundException, NoSuchMethodException {
        for (Vector<Uploader.ParentTableEntry> pts : this.parentTables) {
            for (Uploader.ParentTableEntry pt : pts) {
                String parentName = UploadTable.capitalize(pt.getImportTable().getWriteTable().getName());
                Class<?> parentTblClass = Class.forName("edu.ku.brc.specify.datamodel." + parentName);
                Class[] parType = new Class[]{parentTblClass};
                String keyName = pt.getForeignKey();
                String setterName = UploadTable.capitalize(keyName.substring(0, keyName.length() - 2));
                if (this.tblClass.equals(Preparation.class) && setterName.equals("PreparedBy")) {
                    setterName = "PreparedByAgent";
                } else if (this.tblClass.equals(Determination.class) && setterName.equals("DeterminationStatus")) {
                    setterName = "Status";
                } else if (this.tblClass.equals(GeoCoordDetail.class) && setterName.equals("Agent")) {
                    setterName = "GeoRefDetBy";
                } else if (this.tblClass.equals(FieldNotebook.class) && setterName.equals("Agent")) {
                    setterName = "OwnerAgent";
                } else if (this.tblClass.equals(FieldNotebookPage.class) && setterName.equals("FieldNotebookPageSet")) {
                    setterName = "PageSet";
                } else if (this.tblClass.equals(DNASequencingRun.class) && setterName.startsWith("DNA")) {
                    setterName = setterName.replace("DNA", "Dna");
                } else if (this.tblClass.equals(ConservEvent.class)) {
                    System.out.println(setterName);
                }
                pt.setSetter(this.tblClass.getMethod("set" + setterName, parType));
                pt.setGetter(this.tblClass.getMethod("get" + setterName, null));
            }
        }
    }

    protected boolean setParents(DataModelObjBase rec, int recNum, boolean isForWrite) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, UploaderException {
        boolean requirementsMet = true;
        boolean result = false;
        boolean isNewRecord = rec.getId() == null;
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pt : ptes) {
                DataModelObjBase parentRec = pt.getImportTable().getParentRecord(recNum, this);
                Object[] arg = new Object[]{parentRec == null || parentRec.getId() == null ? null : parentRec};
                if (!isNewRecord && !result) {
                    result = this.valueChange(rec, pt.getGetter(), arg);
                    if (isForWrite && result && !pt.getImportTable().matchRecordId && pt.getImportTable().deleteUnusedRecs) {
                        this.addDisusedRec(rec, pt);
                    }
                }
                pt.getSetter().invoke((Object)rec, arg);
                boolean bl = requirementsMet = requirementsMet && (arg[0] != null || !pt.isRequired());
            }
        }
        if (!requirementsMet) {
            throw new UploaderException("MissingRequiredParent", 10);
        }
        return result;
    }

    protected boolean isLatLongFld(UploadField ufld) {
        String name = ufld.getField().getName();
        return (name = name.substring(0, name.length() - 1)).equalsIgnoreCase("latitude") || name.equalsIgnoreCase("longitude");
    }

    protected boolean isLatFld(UploadField ufld) {
        String name = ufld.getField().getName();
        name = name.substring(0, name.length() - 1);
        return name.equalsIgnoreCase("latitude");
    }

    protected boolean isDateWithPrecision(DBFieldInfo fld) {
        return this.getDatePrecisionFld(fld) != null;
    }

    protected DBFieldInfo getDatePrecisionFld(DBFieldInfo fld) {
        String precFldName = String.valueOf(fld.getName()) + "Precision";
        for (DBFieldInfo otherFld : fld.getTableInfo().getFields()) {
            if (!otherFld.getName().equalsIgnoreCase(precFldName)) continue;
            return otherFld;
        }
        return null;
    }

    protected DateConverter.DateFormats getDateConverterForWbExport() {
        return DateConverter.DateFormats.LYEAR_MON_DAY;
    }

    protected String getDateSeparatorForWbExport() {
        return "/";
    }

    public String getTextForFieldValue(UploadField ufld, Object value, int seq) throws Exception {
        if (value == null) {
            return null;
        }
        Class<?> fldClass = ufld.getSetter().getParameterTypes()[0];
        String result = null;
        if (fldClass == Calendar.class || fldClass == Date.class) {
            DateConverter.DateFormats df = this.getDateConverterForWbExport();
            SimpleDateFormat sdf = new SimpleDateFormat(df.getFormatString(this.getDateSeparatorForWbExport()));
            result = sdf.format(((Calendar)value).getTime());
            if (this.isDateWithPrecision(ufld.getField().getFieldInfo())) {
                Integer precision = (Integer)BasicSQLUtils.querySingleObj("select " + this.getDatePrecisionFld(ufld.getField().getFieldInfo()).getColumn() + " from " + this.getTable().getTableInfo().getName() + " where " + this.getTable().getTableInfo().getIdColumnName() + " = " + this.getCurrentRecord(seq).getId());
                UIFieldFormatterIFace.PartialDateEnum prec = UIFieldFormatterIFace.PartialDateEnum.None;
                if (precision != null) {
                    UIFieldFormatterIFace.PartialDateEnum[] partialDateEnumArray = UIFieldFormatterIFace.PartialDateEnum.values();
                    int n = partialDateEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UIFieldFormatterIFace.PartialDateEnum pde = partialDateEnumArray[n2];
                        if (pde.ordinal() == precision.intValue()) {
                            prec = pde;
                            break;
                        }
                        ++n2;
                    }
                }
                result = df.adjustForPrecisionOut(result, prec);
            }
        } else {
            UIFieldFormatterIFace formatter = ufld.getField().getFieldInfo().getFormatter();
            result = formatter != null ? formatter.formatToUI(value).toString() : value.toString();
        }
        return result;
    }

    protected Object[] getArgForSetter(UploadField ufld) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, UploaderException {
        try {
            String fldStr;
            Object[] arg = new Object[1];
            Class<?> fldClass = ufld.getSetter().getParameterTypes()[0];
            if (ufld.getValueObject() == null) {
                fldStr = null;
            } else {
                String string = fldStr = fldClass.equals(String.class) ? ufld.getValueObject() : ufld.getValueObject().trim();
            }
            if (fldClass == Calendar.class || fldClass == Date.class) {
                if (fldStr == null || fldStr.equals("")) {
                    arg[0] = null;
                } else {
                    if (this.isDateWithPrecision(ufld.getField().getFieldInfo())) {
                        fldStr = this.dateConverter.adjustForPrecision(fldStr);
                    } else {
                        try {
                            UIFieldFormatterIFace.PartialDateEnum prec = this.dateConverter.getDatePrecision(fldStr);
                            if (prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Month) || prec.equals((Object)UIFieldFormatterIFace.PartialDateEnum.Year)) {
                                ParseException pex = new ParseException(UIRegistry.getResourceString("WB_UPLOAD_INVALID_FORMAT"), 0);
                                throw new UploaderException(pex, 30);
                            }
                        }
                        catch (ParseException prec) {
                            // empty catch block
                        }
                    }
                    arg[0] = this.dateConverter.convert(fldStr);
                }
            } else if (fldClass == BigDecimal.class) {
                if (fldStr == null || fldStr.equals("")) {
                    arg[0] = null;
                } else {
                    if (this.isLatLongFld(ufld)) {
                        boolean gotANumber;
                        boolean bl = gotANumber = UIHelper.parseDoubleToBigDecimal(fldStr) != null;
                        if (!gotANumber) {
                            try {
                                fldStr = this.geoRefConverter.convert(StringUtils.stripToNull((String)fldStr), GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
                            }
                            catch (Exception ex) {
                                throw new UploaderException(ex, 30);
                            }
                        }
                    }
                    BigDecimal val = UIHelper.parseDoubleToBigDecimal(fldStr);
                    if (this.isLatLongFld(ufld)) {
                        Double maxVal;
                        Double d = maxVal = this.isLatFld(ufld) ? new Double("90") : new Double("180");
                        if (Math.abs(val.doubleValue()) > maxVal) {
                            throw new UploaderException(UIRegistry.getResourceString("WB_UPLOAD_INVALID_GEOREF_VALUE"), 30);
                        }
                    }
                    arg[0] = val;
                }
            } else if (fldClass == Boolean.class) {
                if (fldStr == null || fldStr.equals("")) {
                    arg[0] = null;
                } else {
                    int i = 0;
                    while (i < WorkbenchTask.boolStrings.length) {
                        if (fldStr.equalsIgnoreCase(WorkbenchTask.boolStrings[i])) break;
                        ++i;
                    }
                    if (i == WorkbenchTask.boolStrings.length) {
                        throw new UploaderException(UIRegistry.getResourceString("WB_INVALID_BOOL_CELL_VALUE"), 30);
                    }
                    arg[0] = i % 2 == 0;
                }
            } else if (fldClass != String.class) {
                Class[] stringArg = new Class[]{String.class};
                Method converter = fldClass.getMethod("valueOf", stringArg);
                Object[] converterArg = new Object[]{fldStr};
                arg[0] = converterArg[0] != null ? converter.invoke(fldClass, converterArg) : null;
            } else {
                UIFieldFormatterIFace formatter = ufld.getField().getFieldInfo().getFormatter();
                if (StringUtils.isBlank((String)fldStr) && (formatter == null || !formatter.isIncrementer())) {
                    arg[0] = null;
                } else {
                    Object val = fldStr;
                    if (ufld.getField().getFieldInfo() != null && formatter != null) {
                        if (this.isUploadRoot && StringUtils.isBlank((String)fldStr) && formatter.isIncrementer()) {
                            if (!this.validatingValues || this.autoAssignedVal == null) {
                                if (this.autoAssignedVal == null) {
                                    val = this.prevAutoAssignedVal != null ? formatter.getNextNumber(formatter.formatFromUI(this.prevAutoAssignedVal.toString()).toString(), true) : formatter.getNextNumber(formatter.formatToUI("").toString());
                                    this.prevAutoAssignedVal = this.autoAssignedVal = formatter.formatToUI(val);
                                } else if (!this.validatingValues) {
                                    val = formatter.formatFromUI(this.autoAssignedVal);
                                }
                            }
                            if (this.autoAssignedField == null) {
                                this.autoAssignedField = ufld;
                            }
                        } else if (StringUtils.isBlank((String)fldStr)) {
                            val = fldStr;
                        } else {
                            val = formatter.formatFromUI(fldStr);
                            if (!formatter.isValid((String)val)) {
                                throw new UploaderException(UIRegistry.getResourceString("WB_UPLOAD_INVALID_FORMAT"), 30);
                            }
                        }
                    }
                    arg[0] = val;
                }
            }
            return arg;
        }
        catch (IllegalArgumentException ex) {
            throw new UploaderException(ex, 30);
        }
        catch (ParseException ex) {
            throw new UploaderException(ex, 30);
        }
    }

    protected Method getFldSetter(DBFieldInfo fld) {
        Class<?> fldClass = this.getFieldClass(fld);
        Class[] parTypes = new Class[]{fldClass};
        String methName = "set" + UploadTable.capitalize(fld.getName());
        try {
            return this.tblClass.getMethod(methName, parTypes);
        }
        catch (NoSuchMethodException nsmEx) {
            return null;
        }
    }

    public void assignFldSetters() {
        for (Vector<UploadField> flds : this.uploadFields) {
            for (UploadField fld : flds) {
                if (fld.getField() == null || fld.getField().getFieldInfo() == null) continue;
                fld.setSetter(this.getFldSetter(fld.getField().getFieldInfo()));
            }
        }
    }

    protected boolean valueChange(DataModelObjBase rec, Method getter, Object[] newVal) throws InvocationTargetException, IllegalAccessException {
        boolean result = false;
        if (getter != null && rec != null) {
            Object newValObj;
            Object currentVal = getter.invoke((Object)rec, new Object[0]);
            if (currentVal == null ^ (newValObj = newVal[0]) == null) {
                result = true;
            } else if (currentVal != null && newValObj != null) {
                Integer newValObjId;
                Integer currentValId;
                result = currentVal instanceof DataModelObjBase ? ((currentValId = ((DataModelObjBase)currentVal).getId()) == null ^ (newValObjId = ((DataModelObjBase)newValObj).getId()) == null ? true : currentValId.longValue() != newValObjId.longValue()) : (currentVal instanceof Comparable ? ((Comparable)currentVal).compareTo((Comparable)newValObj) != 0 : !currentVal.equals(newValObj));
            }
        }
        return result;
    }

    protected boolean setFields(DataModelObjBase rec, Vector<UploadField> flds) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, UploaderException {
        boolean result = false;
        boolean isNewRecord = rec.getId() == null;
        for (UploadField fld : flds) {
            Method setter = fld.getSetter();
            if (setter == null) continue;
            Object[] arg = this.getArgForSetter(fld);
            if (!isNewRecord && !result) {
                result = this.valueChange(rec, fld.getGetter(), arg);
            }
            setter.invoke((Object)rec, arg);
        }
        return result;
    }

    protected void setRequiredFldDefaults(DataModelObjBase rec, int recNum) throws InvocationTargetException, IllegalAccessException {
        for (DefaultFieldEntry dfe : this.missingRequiredFlds) {
            Object[] arg = new Object[]{dfe.getDefaultValue(recNum)};
            dfe.getSetter().invoke((Object)rec, arg);
        }
    }

    protected void setRelatedDefaults(DataModelObjBase rec, int recNum) throws UploaderException, InvocationTargetException, IllegalAccessException {
        for (RelatedClassSetter rce : this.relatedClassDefaults) {
            Object[] args = new Object[]{rce.getDefaultObj(recNum)};
            rce.getSetter().invoke((Object)rec, args);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkChildrenMatch(int recNum) throws UploaderException {
        block137: {
            block142: {
                block141: {
                    block140: {
                        block139: {
                            block138: {
                                result = true;
                                match = this.getCurrentRecord(recNum);
                                deletes = new Vector<UploadTable>();
                                this.logDebug("Checking to see if children match:" + this.tblClass.toString() + "=" + match.getId());
                                if (!this.tblClass.equals(CollectingEvent.class)) break block138;
                                var6_5 = this.specialChildren.iterator();
                                if (true) ** GOTO lbl103
                            }
                            if (!this.tblClass.equals(Accession.class)) break block139;
                            var6_5 = this.specialChildren.iterator();
                            if (true) ** GOTO lbl175
                        }
                        if (!this.tblClass.equals(Agent.class)) break block140;
                        var6_5 = this.specialChildren.iterator();
                        if (true) ** GOTO lbl212
                    }
                    if (!this.tblClass.equals(CollectionObject.class)) break block141;
                    result = true;
                    break block137;
                }
                if (!this.tblClass.equals(Locality.class)) break block142;
                var6_5 = this.specialChildren.iterator();
                if (true) ** GOTO lbl263
            }
            if (!this.tblClass.equals(ReferenceWork.class)) {
                UploadTable.log.error((Object)("Unable to check matching children for " + this.tblClass.getName()));
                throw new UploaderException("Unable to check matching children for " + this.tblClass.getName(), 20);
            }
            var6_5 = this.specialChildren.iterator();
            if (true) ** GOTO lbl309
            do {
                block136: {
                    child = var6_5.next();
                    this.logDebug(child.getTable().getName());
                    if (child.getTblClass().equals(Collector.class)) {
                        matchSession = DataProviderFactory.getInstance().createSession();
                        try {
                            matchesQ = matchSession.createQuery("from Collector where collectingeventid = " + match.getId() + " order by orderNumber", false);
                            matches = matchesQ.list();
                            try {
                                child.loadFromDataSet(this.wbCurrentRow);
                                childCount = 0;
                                c = 0;
                                while (true) {
                                    if (c >= child.getUploadFields().size()) {
                                        if (matches.size() == childCount) break;
                                        result = false;
                                        break block136;
                                    }
                                    if (child.getCurrentRecord(c) != null) {
                                        ++childCount;
                                    }
                                    ++c;
                                }
                                rec = 0;
                                while (rec < matches.size()) {
                                    coll1 = (Collector)matches.get(rec);
                                    coll2 = (Collector)child.getCurrentRecord(rec);
                                    if (!coll1.getOrderNumber().equals(coll2.getOrderNumber())) {
                                        return false;
                                    }
                                    if (coll2.getAgent() == null) return false;
                                    if (!coll1.getAgent().getId().equals(coll2.getAgent().getId())) {
                                        return false;
                                    }
                                    if (coll2.getRemarks() == null ^ coll1.getRemarks() == null) {
                                        return false;
                                    }
                                    if (coll2.getRemarks() != null && !coll2.getRemarks().equals(coll1.getRemarks())) {
                                        return false;
                                    }
                                    ++rec;
                                }
                                break block136;
                            }
                            finally {
                                child.loadFromDataSet(child.wbCurrentRow);
                            }
                        }
                        finally {
                            matchSession.close();
                        }
                    }
                    if (child.getTblClass().equals(CollectingEventAttribute.class)) {
                        matchSession = DataProviderFactory.getInstance().createSession();
                        try {
                            hql = "from CollectingEventAttribute where collectingEventAttributeId ";
                            ceMatch = (CollectingEvent)match;
                            hql = ceMatch.getCollectingEventAttribute() == null ? String.valueOf(hql) + "is null" : String.valueOf(hql) + "= " + ((CollectingEvent)match).getCollectingEventAttribute().getId();
                            matchesQ = matchSession.createQuery(hql, false);
                            matches = matchesQ.list();
                            try {
                                child.loadFromDataSet(this.wbCurrentRow);
                                cea2 = (CollectingEventAttribute)child.getCurrentRecord(0);
                                if (cea2 == null && matches.size() == 0) continue;
                                if (cea2 == null && matches.size() != 0) {
                                    return false;
                                }
                                if (cea2 != null && matches.size() == 0) {
                                    return false;
                                }
                                cea1 = (CollectingEventAttribute)matches.get(0);
                                result = cea1.matches(cea2);
                                if (result) {
                                    deletes.add(child);
                                }
                            }
                            finally {
                                child.loadFromDataSet(child.wbCurrentRow);
                            }
                        }
                        finally {
                            matchSession.close();
                        }
                    }
                }
                if (!result) break block137;
lbl103:
                // 3 sources

            } while (var6_5.hasNext());
            break block137;
            do {
                child = var6_5.next();
                this.logDebug(child.getTable().getName());
                if (child.getTblClass().equals(AccessionAgent.class)) {
                    matchSession = DataProviderFactory.getInstance().createSession();
                    try {
                        matchesQ = matchSession.createQuery("from AccessionAgent where accessionid = " + match.getId(), false);
                        matches = matchesQ.list();
                        try {
                            child.loadFromDataSet(this.wbCurrentRow);
                            childCount = 0;
                            c = 0;
                            while (true) {
                                if (c >= child.getUploadFields().size()) {
                                    if (matches.size() == childCount) break;
                                    return false;
                                }
                                if (child.getCurrentRecord(c) != null) {
                                    ++childCount;
                                }
                                ++c;
                            }
                            rec = 0;
                            while (rec < matches.size()) {
                                ag1 = (AccessionAgent)matches.get(rec);
                                ag2 = (AccessionAgent)child.getCurrentRecord(rec);
                                if (ag1.getAgent() != null || ag2.getAgent() != null) {
                                    if ((ag1.getAgent() == null ^ ag2.getAgent() == null) != false) return false;
                                    if (!ag1.getAgent().getId().equals(ag2.getAgent().getId())) {
                                        return false;
                                    }
                                }
                                ++rec;
                            }
                            continue;
                        }
                        finally {
                            child.loadFromDataSet(child.wbCurrentRow);
                        }
                    }
                    finally {
                        matchSession.close();
                    }
                }
                if (child.getTblClass().equals(AccessionAuthorization.class)) {
                    matchSession = DataProviderFactory.getInstance().createSession();
                    try {
                        matchesQ = matchSession.createQuery("from AccessionAuthorization where accessionid = " + match.getId(), false);
                        matches = matchesQ.list();
                        try {
                            child.loadFromDataSet(this.wbCurrentRow);
                            childCount = 0;
                            c = 0;
                            while (true) {
                                if (c >= child.getUploadFields().size()) {
                                    if (matches.size() == childCount) break;
                                    return false;
                                }
                                if (child.getCurrentRecord(c) != null) {
                                    ++childCount;
                                }
                                ++c;
                            }
                            rec = 0;
                            while (rec < matches.size()) {
                                au1 = (AccessionAuthorization)matches.get(rec);
                                au2 = (AccessionAuthorization)child.getCurrentRecord(rec);
                                if (!au1.getPermit().getId().equals(au2.getPermit().getId())) {
                                    return false;
                                }
                                ++rec;
                            }
                            continue;
                        }
                        finally {
                            child.loadFromDataSet(child.wbCurrentRow);
                        }
                    }
                    finally {
                        matchSession.close();
                    }
                }
                if (!result) break block137;
lbl175:
                // 4 sources

            } while (var6_5.hasNext());
            break block137;
            do {
                child = var6_5.next();
                this.logDebug(child.getTable().getName());
                if (child.getTblClass().equals(Address.class)) {
                    matchSession = DataProviderFactory.getInstance().createSession();
                    try {
                        matchesQ = matchSession.createQuery("from Address where agentId = " + match.getId(), false);
                        matches = matchesQ.list();
                        try {
                            child.loadFromDataSet(this.wbCurrentRow);
                            childCount = 0;
                            c = 0;
                            while (true) {
                                if (c >= child.getUploadFields().size()) {
                                    if (matches.size() == childCount) break;
                                    return false;
                                }
                                if (child.getCurrentRecord(c) != null) {
                                    ++childCount;
                                }
                                ++c;
                            }
                            rec = 0;
                            while (rec < matches.size()) {
                                ad1 = (Address)matches.get(rec);
                                if (!ad1.matches(ad2 = (Address)child.getCurrentRecord(rec))) {
                                    return false;
                                }
                                ++rec;
                            }
                            continue;
                        }
                        finally {
                            child.loadFromDataSet(child.wbCurrentRow);
                        }
                    }
                    finally {
                        matchSession.close();
                    }
                }
                if (!result) break block137;
lbl212:
                // 3 sources

            } while (var6_5.hasNext());
            break block137;
            do {
                if ((child = var6_5.next()).getTblClass().equals(LocalityDetail.class)) {
                    matchSession = DataProviderFactory.getInstance().createSession();
                    try {
                        matchesQ = matchSession.createQuery("from LocalityDetail where localityId = " + match.getId(), false);
                        matches = matchesQ.list();
                        try {
                            child.loadFromDataSet(this.wbCurrentRow);
                            ld2 /* !! */  = (LocalityDetail)child.getCurrentRecord(0);
                            if (ld2 /* !! */  == null && matches.size() == 0) continue;
                            if (ld2 /* !! */  == null && matches.size() != 0) {
                                return false;
                            }
                            if (ld2 /* !! */  != null && matches.size() == 0) {
                                return false;
                            }
                            ld1 = (LocalityDetail)matches.get(0);
                            result = ld1.matches(ld2 /* !! */ );
                            if (!result) {
                                return false;
                            }
                        }
                        finally {
                            child.loadFromDataSet(child.wbCurrentRow);
                        }
                    }
                    finally {
                        matchSession.close();
                    }
                }
                if (!child.getTblClass().equals(GeoCoordDetail.class)) continue;
                matchSession = DataProviderFactory.getInstance().createSession();
                try {
                    matchesQ = matchSession.createQuery("from GeoCoordDetail where localityId = " + match.getId(), false);
                    matches = matchesQ.list();
                    try {
                        child.loadFromDataSet(this.wbCurrentRow);
                        ld2 /* !! */  = (GeoCoordDetail)child.getCurrentRecord(0);
                        if (ld2 /* !! */  == null && matches.size() == 0) continue;
                        if (ld2 /* !! */  == null && matches.size() != 0) {
                            return false;
                        }
                        if (ld2 /* !! */  != null && matches.size() == 0) {
                            return false;
                        }
                        ld1 = (GeoCoordDetail)matches.get(0);
                        result = ld1.matches((GeoCoordDetail)ld2 /* !! */ );
                        if (!result) {
                            return false;
                        }
                    }
                    finally {
                        child.loadFromDataSet(child.wbCurrentRow);
                    }
                }
                finally {
                    matchSession.close();
                }
lbl263:
                // 4 sources

            } while (var6_5.hasNext());
            break block137;
            block90: do {
                child = var6_5.next();
                this.logDebug(child.getTable().getName());
                if (child.getTblClass().equals(Author.class)) {
                    matchSession = DataProviderFactory.getInstance().createSession();
                    try {
                        matchesQ = matchSession.createQuery("from Author where referenceworkid = " + match.getId() + " order by orderNumber", false);
                        matches = matchesQ.list();
                        try {
                            child.loadFromDataSet(this.wbCurrentRow);
                            childCount = 0;
                            c = 0;
                            while (true) {
                                if (c >= child.getUploadFields().size()) {
                                    if (matches.size() == childCount) break;
                                    result = false;
                                    continue block90;
                                }
                                if (child.getCurrentRecord(c) != null) {
                                    ++childCount;
                                }
                                ++c;
                            }
                            rec = 0;
                            while (rec < matches.size()) {
                                auth1 = (Author)matches.get(rec);
                                auth2 = (Author)child.getCurrentRecord(rec);
                                if (!auth1.getOrderNumber().equals(auth2.getOrderNumber())) {
                                    return false;
                                }
                                if (auth2.getAgent() == null) return false;
                                if (!auth1.getAgent().getId().equals(auth2.getAgent().getId())) {
                                    return false;
                                }
                                if (auth2.getRemarks() == null ^ auth1.getRemarks() == null) {
                                    return false;
                                }
                                if (auth2.getRemarks() != null && !auth2.getRemarks().equals(auth1.getRemarks())) {
                                    return false;
                                }
                                ++rec;
                            }
                            continue;
                        }
                        finally {
                            child.loadFromDataSet(child.wbCurrentRow);
                        }
                    }
                    finally {
                        matchSession.close();
                    }
                }
                if (!result) break;
lbl309:
                // 4 sources

            } while (var6_5.hasNext());
        }
        if (result == false) return result;
        for (UploadTable ut : deletes) {
            ut.abortRow(ut.wbCurrentRow);
        }
        return result;
    }

    protected boolean needToMatchChildren() {
        return !this.skipChildrenMatching.get() && (this.tblClass.equals(CollectingEvent.class) || this.tblClass.equals(Accession.class) || this.tblClass.equals(Agent.class) || this.tblClass.equals(CollectionObject.class) || this.tblClass.equals(Locality.class) || this.tblClass.equals(ReferenceWork.class));
    }

    protected boolean needToMatchChild(Class<?> childClass) {
        this.logDebug("need to add more child classes");
        if (this.tblClass.equals(Agent.class)) {
            return childClass.equals(Address.class);
        }
        if (this.tblClass.equals(Accession.class)) {
            return childClass.equals(AccessionAgent.class) || childClass.equals(AccessionAuthorization.class);
        }
        if (this.tblClass.equals(CollectingEvent.class)) {
            return childClass.equals(Collector.class) || childClass.equals(CollectingEventAttribute.class);
        }
        if (this.tblClass.equals(CollectionObject.class)) {
            return childClass.equals(Determination.class) || childClass.equals(Preparation.class) || childClass.equals(CollectionObjectAttribute.class) || childClass.equals(CollectionObjectCitation.class) || childClass.equals(DNASequence.class) || childClass.equals(ConservDescription.class);
        }
        if (this.tblClass.equals(Locality.class)) {
            return childClass.equals(GeoCoordDetail.class) || childClass.equals(LocalityDetail.class);
        }
        if (this.tblClass.equals(ReferenceWork.class)) {
            return childClass.equals(Author.class);
        }
        return false;
    }

    protected String addRestriction(DataProviderSessionIFace.CriteriaIFace critter, String propName, Object arg, boolean ignoreNulls) {
        if (arg != null && (!(arg instanceof String) || StringUtils.isNotBlank((String)((String)arg)))) {
            critter.add(Restrictions.eq((String)propName, (Object)arg));
            if (arg instanceof DataModelObjBase) {
                String value = DataObjFieldFormatMgr.getInstance().format(arg, arg.getClass());
                if (StringUtils.isNotBlank((String)value)) {
                    return value;
                }
                return ((DataModelObjBase)arg).getId().toString();
            }
            return arg.toString();
        }
        if (!ignoreNulls || this.matchSetting.isMatchEmptyValues()) {
            critter.add(Restrictions.isNull((String)propName));
            return this.getNullRestrictionText();
        }
        return "";
    }

    public String getNullRestrictionText() {
        return "#null#";
    }

    protected List<DataModelObjBase> matchChildren(List<DataModelObjBase> matches, int recNum) throws UploaderException {
        ArrayList<DataModelObjBase> result = new ArrayList<DataModelObjBase>();
        for (DataModelObjBase currMatch : matches) {
            DataModelObjBase saveRec = this.getCurrentRecord(recNum);
            try {
                this.setCurrentRecord(currMatch, recNum);
                if (!this.checkChildrenMatch(recNum)) continue;
                result.add(currMatch);
            }
            finally {
                this.setCurrentRecord(saveRec, recNum);
            }
        }
        return result;
    }

    protected DataModelObjBase getParentRecord(int recNum, UploadTable forChild) throws UploaderException {
        return this.getCurrentRecord(recNum);
    }

    protected Discipline getDiscipline() throws UploaderException {
        if (this.discipline == null) {
            this.discipline = (Discipline)this.getClassObject(Discipline.class);
        }
        return this.discipline;
    }

    protected Division getDivision() throws UploaderException {
        if (this.division == null) {
            this.division = (Division)this.getClassObject(Division.class);
        }
        return this.division;
    }

    protected DataModelObjBase getClassObject(Class<?> toGet) throws UploaderException {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            DataModelObjBase temp = (DataModelObjBase)AppContextMgr.getInstance().getClassObject(toGet);
            DataModelObjBase dataModelObjBase = temp = (DataModelObjBase)session.get(temp.getDataClass(), temp.getId());
            return dataModelObjBase;
        }
        catch (Exception ex) {
            throw new UploaderException(ex, 20);
        }
        finally {
            session.close();
        }
    }

    protected void addDomainCriteria(DataProviderSessionIFace.CriteriaIFace criteria) throws UploaderException {
    }

    protected boolean isMatchable(Set<Integer> unmatchableCols, int seq) {
        for (UploadField fld : this.uploadFields.get(seq)) {
            if (!unmatchableCols.contains(new Integer(fld.getIndex()))) continue;
            return false;
        }
        return true;
    }

    protected Uploader.ParentTableEntry getControllingIDMatchingParent() {
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (!pte.getImportTable().specialChildren.contains(this) || !pte.getImportTable().isMatchRecordId() && !pte.getImportTable().reusingExportedRec) continue;
                return pte;
            }
        }
        return null;
    }

    protected Uploader.ParentTableEntry getControllingParent() {
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (pte.getImportTable().getSpecialChildren().indexOf(this) == -1) continue;
                return pte;
            }
        }
        return null;
    }

    protected boolean checkParentsForMatchCriteria(Vector<Vector<Uploader.ParentTableEntry>> parents, DataProviderSessionIFace.CriteriaIFace critter, int recNum, UploadTable child) {
        boolean gotIt = false;
        for (Vector<Uploader.ParentTableEntry> ptes : parents) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (pte.getImportTable() != this && (child != null || !pte.getImportTable().isMatchRecordId())) continue;
                if (child == null) {
                    this.addRestriction(critter, pte.getPropertyName(), pte.getImportTable().getCurrentRecord(recNum), true);
                } else {
                    this.addRestriction(critter, pte.getPropertyName(), this.getCurrentRecord(recNum), true);
                }
                gotIt = true;
                break;
            }
            if (gotIt) break;
        }
        return gotIt;
    }

    protected boolean getUpdateMatchCriteria(DataProviderSessionIFace.CriteriaIFace critter, int recNum, Vector<MatchRestriction> restrictedVals, HashMap<UploadTable, DataModelObjBase> overrideParentParams) throws UploaderException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        boolean reUsingParent;
        Uploader.ParentTableEntry lordAndMaster = this.getControllingIDMatchingParent();
        boolean bl = reUsingParent = lordAndMaster != null && lordAndMaster.getImportTable().reusingExportedRec;
        if (this.matchRecordId || reUsingParent) {
            if (this.exportedRecordId != null || reUsingParent) {
                if (this.getTable().getTableInfo().getTableId() == this.uploader.getUpdateTableId().intValue()) {
                    this.addRestriction(critter, "id", this.exportedRecordId, true);
                } else if (this.uploader.getUpdateTableId() == CollectionObject.getClassTableId() && this.getTable().getTableInfo().getTableId() == CollectingEvent.getClassTableId()) {
                    this.addRestriction(critter, "id", this.exportedRecordId, true);
                } else if (lordAndMaster != null) {
                    if (this.exportedOneToManyId != null) {
                        this.addRestriction(critter, "id", this.exportedOneToManyId, true);
                    } else {
                        this.getInsertMatchCriteria(critter, recNum, restrictedVals, overrideParentParams);
                    }
                }
            }
            return false;
        }
        return this.getInsertMatchCriteria(critter, recNum, restrictedVals, overrideParentParams);
    }

    protected void updateExportedRecInfo(int recNum) {
        Pair<Integer, Boolean> info;
        this.exportedOneToManyId = null;
        this.exportedOneToManyDelete = false;
        Uploader.ParentTableEntry controllingParent = this.getControllingIDMatchingParent();
        if (controllingParent == null) {
            return;
        }
        if ((this.matchRecordId && this.exportedRecordId != null || controllingParent.getImportTable().reusingExportedRec) && (info = this.getExportedRecInfo(recNum)) != null) {
            this.exportedOneToManyId = info.getFirst();
            this.exportedOneToManyDelete = info.getSecond();
        }
    }

    protected Pair<Integer, Boolean> getExportedRecInfo(int recNum) {
        String sql = "select wber.RecordID  from workbenchrow wbr inner join workbenchrowexportedrelationship wber on wber.workbenchrowid = wbr.workbenchrowID  where wber.Sequence = " + recNum + " and " + "wber.TableName = '" + this.tblClass.getSimpleName().toLowerCase() + "' and " + "wbr.RowNumber = " + this.wbCurrentRow + " and " + "wbr.WorkbenchID = " + this.uploader.getWbSS().getWorkbench().getId();
        Vector<Object[]> recInfo = BasicSQLUtils.query(sql);
        if (recInfo == null || recInfo.size() == 0) {
            return null;
        }
        if (recInfo.size() > 1) {
            log.warn((Object)("Multiple exported rec info records found. Table=" + this.tblClass.getSimpleName().toLowerCase() + " row=" + this.wbCurrentRow + " seq=" + recNum));
        }
        return new Pair<Integer, Boolean>((Integer)recInfo.get(0)[0], false);
    }

    protected boolean getMatchCriteria(DataProviderSessionIFace.CriteriaIFace critter, int recNum, Vector<MatchRestriction> restrictedVals, HashMap<UploadTable, DataModelObjBase> overrideParentParams) throws UploaderException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (this.updateMatches) {
            return this.getUpdateMatchCriteria(critter, recNum, restrictedVals, overrideParentParams);
        }
        return this.getInsertMatchCriteria(critter, recNum, restrictedVals, overrideParentParams);
    }

    protected boolean isFieldToMatchOn(UploadField uf) {
        if (this.tblClass.equals(Collector.class) && uf.getField().getFieldInfo() != null && uf.getField().getFieldInfo().getColumn().equalsIgnoreCase("isprimary")) {
            return false;
        }
        return uf.getSetter() != null;
    }

    protected boolean getInsertMatchCriteria(DataProviderSessionIFace.CriteriaIFace critter, int recNum, Vector<MatchRestriction> restrictedVals, HashMap<UploadTable, DataModelObjBase> overrideParentParams) throws UploaderException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        boolean ignoringBlankCell = false;
        for (UploadField uploadField : this.uploadFields.get(recNum)) {
            if (!this.isFieldToMatchOn(uploadField)) continue;
            String restriction = this.addRestriction(critter, UploadTable.deCapitalize(uploadField.getField().getName()), this.getArgForSetter(uploadField)[0], true);
            ignoringBlankCell = ignoringBlankCell || restriction.equals("") && !this.matchSetting.isMatchEmptyValues();
            String fldName = uploadField.getWbFldName();
            if (StringUtils.isBlank((String)fldName)) {
                if (uploadField.getField() != null && uploadField.getField().getFieldInfo() != null) {
                    fldName = uploadField.getField().getFieldInfo().getTitle();
                } else if (uploadField.getField() != null) {
                    fldName = uploadField.getField().getName();
                } else {
                    fldName = "?";
                    log.error((Object)("unable to find field title or name for " + uploadField));
                }
            }
            restrictedVals.add(new MatchRestriction(fldName, restriction, uploadField.getIndex()));
        }
        for (Vector vector : this.parentTables) {
            for (Uploader.ParentTableEntry pte : vector) {
                if (this.needToMatchChildren() && pte.getImportTable().isOneToOneChild()) continue;
                DataModelObjBase parentParam = overrideParentParams != null ? overrideParentParams.get(pte.getImportTable()) : pte.getImportTable().getParentRecord(recNum, this);
                restrictedVals.add(new MatchRestriction(pte.getPropertyName(), this.addRestriction(critter, pte.getPropertyName(), parentParam, false), -1));
            }
        }
        for (RelatedClassSetter relatedClassSetter : this.relatedClassDefaults) {
            critter.add(Restrictions.eq((String)relatedClassSetter.getPropertyName(), (Object)relatedClassSetter.getDefaultObj(recNum)));
        }
        if (!this.tblClass.equals(ReferenceWork.class)) {
            for (DefaultFieldEntry defaultFieldEntry : this.missingRequiredFlds) {
                if (defaultFieldEntry.isMultiValued()) {
                    critter.add(Restrictions.in((String)UploadTable.deCapitalize(defaultFieldEntry.getFldName()), defaultFieldEntry.getDefaultValues(recNum)));
                    continue;
                }
                critter.add(Restrictions.eq((String)UploadTable.deCapitalize(defaultFieldEntry.getFldName()), (Object)defaultFieldEntry.getDefaultValue(recNum)));
            }
        }
        this.addDomainCriteria(critter);
        Collections.sort(restrictedVals);
        return ignoringBlankCell;
    }

    protected boolean containsInvalidCol(int recNum, Set<Integer> invalidColNums) {
        int adjustedRecNum = this.uploadFields.size() == 1 ? 0 : recNum;
        for (UploadField fld : this.uploadFields.get(adjustedRecNum)) {
            if (!invalidColNums.contains(fld.getIndex())) continue;
            return true;
        }
        return false;
    }

    protected List<ParentMatchInfo> getMatchInfoInternal(int row, int recNum, Set<Integer> invalidColNums, HashMap<UploadTable, DataModelObjBase> matchChildrenParents) throws UploaderException, InvocationTargetException, IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, SQLException {
        int adjustedRecNum = this.uploadFields.size() == 1 ? 0 : recNum;
        this.wbCurrentRow = row;
        Vector<ParentMatchInfo> result = new Vector<ParentMatchInfo>();
        Vector<List<ParentMatchInfo>> parentMatches = new Vector<List<ParentMatchInfo>>();
        Vector<List<ParentMatchInfo>> childMatches = new Vector<List<ParentMatchInfo>>();
        Vector<UploadTable> childTables = new Vector<UploadTable>(this.specialChildren);
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                if (pte.getImportTable().specialChildren.contains(this) && pte.getImportTable().needToMatchChild(this.tblClass)) continue;
                if (pte.getImportTable().isOneToOneChild()) {
                    childTables.add(pte.getImportTable());
                    continue;
                }
                parentMatches.add(pte.getImportTable().getMatchInfoInternal(row, adjustedRecNum, invalidColNums, matchChildrenParents));
            }
        }
        HashMap<UploadTable, DataModelObjBase> parentParams = new HashMap<UploadTable, DataModelObjBase>();
        boolean doMatch = true;
        boolean matched = false;
        boolean blankParentage = true;
        boolean blank = this.isBlankRow(row, this.uploader.getUploadData(), adjustedRecNum);
        Vector<DataModelObjBase> matches = new Vector<DataModelObjBase>();
        for (List list : parentMatches) {
            if (doMatch && list.size() > 0) {
                ParentMatchInfo nearest = (ParentMatchInfo)list.get(list.size() - 1);
                blankParentage &= nearest.isBlank();
                if (nearest.getMatches().size() == 1 || nearest.getMatches().size() == 0 && nearest.isBlank()) {
                    Iterator<UploadField> match = nearest.getMatches().size() == 1 ? nearest.getMatches().get(0) : null;
                    parentParams.put(nearest.getTable(), (DataModelObjBase)((Object)match));
                } else {
                    doMatch = false;
                }
            }
            result.addAll(list);
        }
        if (doMatch && !blank) {
            for (Vector<UploadField> vector : this.uploadFields) {
                for (UploadField uf : vector) {
                    if (uf.getIndex() == -1) continue;
                    uf.setValue(this.uploader.getUploadData().get(row, uf.getIndex()));
                }
            }
            this.skipChildrenMatching.set(true);
            try {
                this.findMatch(adjustedRecNum, false, matches, parentParams);
                matched = true;
            }
            finally {
                this.skipChildrenMatching.set(false);
            }
        }
        for (UploadTable uploadTable : childTables) {
            int rc = 0;
            while (rc < uploadTable.getUploadFields().size()) {
                childMatches.add(uploadTable.getMatchInfoInternal(row, rc, invalidColNums, matchChildrenParents));
                ++rc;
            }
        }
        boolean bl = this.containsInvalidCol(adjustedRecNum, invalidColNums);
        for (List list : childMatches) {
            if (!bl && matched) {
                result.addAll(list);
                continue;
            }
            int i = list.size() - 1;
            while (i > -1) {
                ParentMatchInfo mi = (ParentMatchInfo)list.get(i);
                if (mi.getTable().isOneToOneChild()) {
                    if (bl) {
                        list.remove(i);
                    } else if (!matched) {
                        mi.setIsSkipped(true);
                    }
                }
                --i;
            }
            result.addAll(list);
        }
        if (!this.containsInvalidCol(adjustedRecNum, invalidColNums)) {
            result.add(new ParentMatchInfo(matches, this, blank && blankParentage, !matched, recNum));
        }
        return result;
    }

    public List<UploadTableMatchInfo> getMatchInfo(int row, int recNum, Set<Integer> invalidColNums) throws UploaderException, InvocationTargetException, IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, SQLException {
        this.wbCurrentRow = row;
        List<ParentMatchInfo> internalResult = this.getMatchInfoInternal(row, recNum, invalidColNums, null);
        Vector<UploadTableMatchInfo> result = new Vector<UploadTableMatchInfo>();
        for (ParentMatchInfo pmi : internalResult) {
            if (!pmi.getTable().checkMatchInfo) continue;
            Vector<Integer> colIdxs = new Vector<Integer>();
            int adjustedRecNum = pmi.getTable().getUploadFields().size() == 1 ? 0 : (pmi.getRecNum() == -1 ? 0 : pmi.getRecNum());
            for (UploadField uf : pmi.getTable().getUploadFields().get(adjustedRecNum)) {
                if (uf.getIndex() == -1) continue;
                colIdxs.add(uf.getIndex());
            }
            result.add(new UploadTableMatchInfo(pmi.getTable().getTblTitle(), pmi.matches.size(), colIdxs, pmi.isBlank(), pmi.isSkipped()));
        }
        return result;
    }

    protected boolean findMatch(int recNum, boolean forceMatch, List<DataModelObjBase> returnMatches, HashMap<UploadTable, DataModelObjBase> overrideParentParams) throws UploaderException, InvocationTargetException, IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, SQLException {
        if (this.skipMatching && !this.matchRecordId) {
            return false;
        }
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        DataModelObjBase match = null;
        Vector<MatchRestriction> restrictedVals = new Vector<MatchRestriction>();
        boolean ignoringBlankCell = false;
        try {
            List<DataModelObjBase> matches;
            DataProviderSessionIFace.CriteriaIFace critter = session.createCriteria(this.tblClass);
            ignoringBlankCell = this.getMatchCriteria(critter, recNum, restrictedVals, overrideParentParams);
            List<DataModelObjBase> matchList = critter.list();
            if (matchList.size() > 1) {
                TreeSet<DataModelObjBase> matchSet = new TreeSet<DataModelObjBase>(new Comparator<DataModelObjBase>(){

                    @Override
                    public int compare(DataModelObjBase arg0, DataModelObjBase arg1) {
                        return arg0.getId().compareTo(arg1.getId());
                    }
                });
                matchSet.addAll(matchList);
                matches = new ArrayList<DataModelObjBase>(matchSet);
            } else {
                matches = matchList;
            }
            if (!this.matchRecordId && this.needToMatchChildren()) {
                matches = this.matchChildren(matches, recNum);
            }
            if (returnMatches != null) {
                returnMatches.addAll(matches);
                return true;
            }
            if (matches.size() == 1) {
                match = matches.get(0);
                if (ignoringBlankCell) {
                    this.uploader.addMsg(new PartialMatchMsg(restrictedVals, match.toString(), this.uploader.getRow() + 1, this));
                }
            } else if (matches.size() > 1 && (match = this.dealWithMultipleMatches(matches, restrictedVals, recNum)) != null) {
                UploadMatchSetting uploadMatchSetting = this.matchSetting;
                uploadMatchSetting.getClass();
                this.matchSetting.addSelection(uploadMatchSetting.new UploadMatchSetting.MatchSelection(restrictedVals, this.uploader.getRow(), match.getId(), this.matchSetting.getMode()));
            }
            this.setCurrentRecordFromMatch(match, recNum);
            if (match != null) {
                if (this.updateMatches && this.matchRecordId) {
                    match.forceLoad();
                }
                if (!this.updateMatches) {
                    for (UploadTable child : this.specialChildren) {
                        if (!this.needToMatchChild(child.tblClass) || child.isOneToOneChild() && !child.isZeroToOneMany()) continue;
                        child.skipRow = true;
                    }
                }
                return true;
            }
            return false;
        }
        finally {
            session.close();
        }
    }

    protected void setCurrentRecordFromMatch(DataModelObjBase match, int recNum) throws IllegalAccessException, InstantiationException, SQLException {
        if (this.updateMatches && !this.matchRecordId) {
            DataModelObjBase expRec = this.getExportedRecord();
            if (expRec == null && match == null) {
                this.setCurrentRecord(null, recNum);
                return;
            }
            if (expRec != null && match != null && expRec.getId().equals(match.getId())) {
                this.setCurrentRecord(match, recNum);
                return;
            }
            boolean recIsShared = false;
            if (this.tblClass.equals(Agent.class) || Treeable.class.isAssignableFrom(this.tblClass)) {
                System.out.println("Assuming shared for class: " + this.tblClass);
                recIsShared = true;
            }
            SpecifyDeleteHelper delhel = new SpecifyDeleteHelper();
            recIsShared = expRec == null ? false : delhel.isRecordShared(this.tblClass, expRec.getId());
            delhel.done(true);
            if (!recIsShared) {
                if (match == null) {
                    this.setCurrentRecord(expRec, recNum);
                    this.reusingExportedRec = true;
                } else {
                    this.setCurrentRecord(match, recNum);
                }
            } else if (match == null) {
                DataModelObjBase newRec = this.createRecord();
                if (expRec != null) {
                    System.out.println("!!!!setCurrentRecordFromMatch NOT copying old rec to new rec!!!");
                }
                this.setCurrentRecord(newRec, recNum);
            } else {
                this.setCurrentRecord(match, recNum);
            }
        } else {
            this.setCurrentRecord(match, recNum);
        }
    }

    public void onAddNewMatch(Vector<MatchRestriction> restrictedVals) {
        this.restrictedValsForAddNewMatch = restrictedVals;
    }

    protected DataModelObjBase dealWithMultipleMatches(List<DataModelObjBase> matches, Vector<MatchRestriction> restrictedVals, int recNum) throws UploaderException {
        return new MatchHandler(this).dealWithMultipleMatches(matches, restrictedVals, recNum);
    }

    protected void finalizeWrite(DataModelObjBase rec, int recNum) throws UploaderException {
        this.finalizeDatePrecisionFields(rec);
        if (this.finalizer != null) {
            this.finalizer.finalizeForWrite(rec, recNum, this.uploader);
        }
    }

    protected void finalizeDatePrecisionFields(DataModelObjBase rec) throws UploaderException {
        for (Pair<UploadField, Method> fld : this.precisionDateFields) {
            if (fld.getSecond() == null) continue;
            try {
                fld.getSecond().invoke((Object)rec, (byte)this.getDatePrecision(fld.getFirst()).ordinal());
            }
            catch (InvocationTargetException ex) {
                throw new UploaderException(ex, 10);
            }
            catch (IllegalAccessException ex) {
                throw new UploaderException(ex, 10);
            }
            catch (ParseException ex) {
                throw new UploaderException(ex, 10);
            }
        }
    }

    protected UIFieldFormatterIFace.PartialDateEnum getDatePrecision(UploadField fld) throws ParseException {
        return this.dateConverter.getDatePrecision(fld.getValue());
    }

    protected UploadField findUploadField(String name, int seq) {
        if (seq >= this.uploadFields.size()) {
            log.error((Object)"seq out of range.");
            return null;
        }
        for (UploadField uf : this.uploadFields.get(seq)) {
            if (!uf.getField().getName().equalsIgnoreCase(name)) continue;
            return uf;
        }
        return null;
    }

    protected boolean invalidNull(UploadField fld, UploadData uploadData, int row, int seq) throws UploaderException {
        boolean isAutoAssignable;
        boolean blankButRequired;
        if ("latlongtype".equalsIgnoreCase(fld.getField().getName())) {
            return false;
        }
        boolean bl = blankButRequired = fld.isRequired() && (fld.getValue() == null || fld.getValue().trim().equals(""));
        if (blankButRequired && this.tblClass.equals(Locality.class) && fld.getField().getName().equalsIgnoreCase("LatLongType")) {
            boolean geoDataPresent = false;
            for (UploadField f : this.getLatLongFlds()) {
                if (!StringUtils.isNotBlank((String)f.getValue())) continue;
                geoDataPresent = true;
                break;
            }
            blankButRequired = geoDataPresent;
        }
        boolean bl2 = isAutoAssignable = fld.getField().getFieldInfo() != null && fld.getField().getFieldInfo().getFormatter() != null && fld.getField().getFieldInfo().getFormatter().isIncrementer();
        return blankButRequired && !isAutoAssignable;
    }

    protected String getPickListName(UploadField fld) {
        if (fld.getIndex() != -1 && fld.getField().getFieldInfo() != null) {
            String pickListName = fld.getField().getFieldInfo().getPickListName();
            if (StringUtils.isEmpty((String)pickListName) && RecordTypeCodeBuilder.isTypeCodeField(fld.getField().getFieldInfo())) {
                pickListName = String.valueOf(fld.getField().getFieldInfo().getColumn()) + "PREDEFSYS";
            }
            return pickListName;
        }
        return null;
    }

    protected boolean pickListCheck(UploadField fld) {
        if (fld.getValue() == null || fld.getValue().trim().equals("")) {
            return true;
        }
        Map<String, PickListItemIFace> validValues = fld.getValidValues();
        if (validValues == null) {
            return true;
        }
        if (!fld.isPicklistWarn() && !fld.isReadOnlyValidValues()) {
            return true;
        }
        return validValues.containsKey(fld.getValue());
    }

    protected String getInvalidPicklistValErrMsg(UploadField fld) {
        return this.getInvalidPicklistValErrMsg(fld, fld.getValidValues().keySet());
    }

    protected String getInvalidPicklistValErrMsg(UploadField fld, Set<String> vals) {
        String valList = "";
        if (vals != null) {
            int valCount = 0;
            for (String val : vals) {
                if (!StringUtils.isEmpty((String)valList)) {
                    valList = String.valueOf(valList) + ", ";
                }
                valList = String.valueOf(valList) + "'" + val + "'";
                if (++valCount != 13) continue;
                valList = String.valueOf(valList) + " ...";
                break;
            }
            if (fld.isReadOnlyValidValues()) {
                return String.format(UIRegistry.getResourceString("WB_UPLOAD_VALID_VALS"), valList);
            }
            return String.format(UIRegistry.getResourceString("WB_UPLOAD_VALID_VALS_WARN"), valList);
        }
        log.error((Object)("Could not find picklist values for " + (fld.getField().getFieldInfo() == null ? fld.getField().getName() : fld.getField().getFieldInfo().getColumn())));
        return UIRegistry.getResourceString("WB_UPLOAD_UNABLE_TO_FIND_VALID_VALS");
    }

    protected boolean isBlankVal(UploadField fld, int seq, int row, UploadData uploadData) {
        return StringUtils.isEmpty((String)fld.getValue());
    }

    protected void addInvalidValueMsgForOneToManySkip(Vector<UploadTableInvalidValue> msgs, UploadField fld, String name, int row, int seq) {
        msgs.add(new UploadTableInvalidValue(null, this, fld, row, new Exception(String.format(UIRegistry.getResourceString("WB_UPLOAD_ONE_TO_MANY_SKIP"), name, seq + 1))));
    }

    protected int getAdjustedSeqForBlankRowCheck(int seq) {
        return seq;
    }

    protected boolean isBlankRow(int row, UploadData uploadData, int seq) {
        for (UploadField fld : this.uploadFields.get(this.getAdjustedSeqForBlankRowCheck(seq))) {
            if (fld.getIndex() == -1 && !fld.getField().isForeignKey()) continue;
            int idx = fld.getIndex();
            if (idx == -1) {
                idx = uploadData.indexOfWbFldName(fld.getWbFldName());
            }
            if (StringUtils.isEmpty((String)uploadData.get(row, idx))) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldEnforceNonNullConstraint(int row, UploadData uploadData, int seq) {
        if (this.tblClass.equals(PrepType.class)) {
            return !this.uploader.getUploadTableByName("Preparation").isBlankRow(row, uploadData, seq);
        }
        if (!this.isBlankRow(row, uploadData, seq)) {
            return true;
        }
        if (this.parentTableIsNonBlank(row, uploadData, true)) {
            return true;
        }
        if (this.iAmRequiredByARelationship()) {
            return true;
        }
        List<UploadTable> chillun = this.uploader.getChildren(this);
        for (UploadTable chile : chillun) {
            if (!this.iControlTheChild(chile) || chile.isBlankRow(row, uploadData, seq)) continue;
            return true;
        }
        return false;
    }

    protected boolean iControlTheChild(UploadTable child) {
        if (this.specialChildren.contains(child)) {
            return true;
        }
        DBTableInfo tblInfo = child.getTable().getTableInfo();
        if (tblInfo != null) {
            for (DBRelationshipInfo relInfo : tblInfo.getRelationships()) {
                if (!relInfo.getDataClass().equals(this.tblClass) || !relInfo.isRequired()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean iAmRequiredByARelationship() {
        for (Vector<Uploader.ParentTableEntry> parents : this.parentTables) {
            for (Uploader.ParentTableEntry pte : parents) {
                DBTableInfo tblInfo = pte.getImportTable().getTable().getTableInfo();
                if (tblInfo == null) continue;
                for (DBRelationshipInfo relInfo : tblInfo.getRelationships()) {
                    if (!relInfo.getDataClass().equals(this.tblClass) || !relInfo.isRequired()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean parentTableIsNonBlank(int row, UploadData uploadData) {
        return this.parentTableIsNonBlank(row, uploadData, false);
    }

    protected boolean parentTableIsNonBlank(int row, UploadData uploadData, Boolean ignoreControllingParents) {
        block0: for (Vector<Uploader.ParentTableEntry> parents : this.parentTables) {
            for (Uploader.ParentTableEntry pte : parents) {
                UploadTable ut = pte.getImportTable();
                if (ignoreControllingParents.booleanValue() && ut.specialChildren != null && ut.specialChildren.contains(this)) continue block0;
                int seq = 0;
                while (seq < ut.getUploadFields().size()) {
                    if (!ut.isBlankRow(row, uploadData, seq)) {
                        return true;
                    }
                    ++seq;
                }
                if (!ut.parentTableIsNonBlank(row, uploadData)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<UploadField> getLatLongFlds() {
        Vector<UploadField> result = new Vector<UploadField>();
        for (Vector<UploadField> flds : this.uploadFields) {
            for (UploadField fld : flds) {
                String fldName = fld.getField().getName();
                if (!fldName.equalsIgnoreCase("latitude1") && !fldName.equalsIgnoreCase("latitude2") && !fldName.equalsIgnoreCase("longitude1") && !fldName.equalsIgnoreCase("longitude2")) continue;
                result.add(fld);
            }
        }
        return result;
    }

    protected List<UploadField> getChangedFields(int row) throws UploaderException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Vector<UploadField> result = new Vector<UploadField>();
        if (this.uploadFields.size() <= 1) {
            result.addAll(this.getChangedFields(row, 0));
        }
        return result;
    }

    protected List<UploadField> getChangedFields(int row, int seq) throws UploaderException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        DataModelObjBase rec = this.getCurrentRecord(seq);
        Vector<UploadField> result = new Vector<UploadField>();
        for (UploadField fld : this.uploadFields.get(seq)) {
            if (fld.getIndex() == -1 || !this.valueChange(rec, fld.getGetter(), this.getArgForSetter(fld))) continue;
            result.add(fld);
        }
        return result;
    }

    public void validateRowValues(int row, UploadData uploadData, Vector<UploadTableInvalidValue> invalidValues) {
        if (uploadData.isEmptyRow(row)) {
            return;
        }
        try {
            boolean isBlank;
            this.validatingValues = true;
            int seq = 0;
            boolean gotABlank = false;
            LatLonConverter.FORMAT llFmt1 = null;
            LatLonConverter.FORMAT llFmt2 = null;
            UploadField llFld = null;
            Vector<UploadTableInvalidValue> invalidNulls = new Vector<UploadTableInvalidValue>();
            Vector<Integer> blankSeqs = new Vector<Integer>();
            for (Vector<UploadField> flds : this.uploadFields) {
                isBlank = true;
                UploadField currFirstFld = null;
                for (UploadField uploadField : flds) {
                    boolean hasCoord2;
                    if (uploadField.getIndex() != -1) {
                        if (currFirstFld == null) {
                            currFirstFld = uploadField;
                        }
                        uploadField.setValue(uploadData.get(row, uploadField.getIndex()));
                        isBlank &= this.isBlankVal(uploadField, seq, row, uploadData);
                        try {
                            if (this.invalidNull(uploadField, uploadData, row, seq) && this.shouldEnforceNonNullConstraint(row, uploadData, seq)) {
                                invalidNulls.add(new UploadTableInvalidValue(UIRegistry.getResourceString("WB_UPLOAD_FIELD_MUST_CONTAIN_DATA"), this, uploadField, row, null));
                                continue;
                            }
                            if (!this.pickListCheck(uploadField)) {
                                if (!uploadField.isReadOnlyValidValues()) {
                                    if (this.uploader != Uploader.currentUpload) {
                                        invalidValues.add(new UploadTableInvalidValue(null, this, uploadField, null, row, new Exception(this.getInvalidPicklistValErrMsg(uploadField)), true));
                                        continue;
                                    }
                                } else {
                                    throw new Exception(this.getInvalidPicklistValErrMsg(uploadField));
                                }
                            }
                            Object[] finalVal = this.getArgForSetter(uploadField);
                            if (!this.updateMatches) {
                                this.checkUniqueness(finalVal, uploadField);
                            }
                        }
                        catch (Exception e) {
                            invalidValues.add(new UploadTableInvalidValue(null, this, uploadField, row, e));
                        }
                    }
                    if (!this.tblClass.equals(Locality.class)) continue;
                    String fldName = uploadField.getField().getName();
                    if (fldName.equalsIgnoreCase("latitude1") || fldName.equalsIgnoreCase("latitude2") || fldName.equalsIgnoreCase("longitude1") || fldName.equalsIgnoreCase("longitude2")) {
                        int c;
                        llFld = uploadField;
                        LatLonConverter.FORMAT fmt = this.geoRefConverter.getLatLonFormat(StringUtils.stripToNull((String)uploadField.getValue()));
                        LatLonConverter.FORMAT llFmt = fldName.endsWith("1") ? llFmt1 : llFmt2;
                        boolean checkDecimalPlaces = true;
                        if (llFmt == null) {
                            llFmt = fmt;
                            if (fldName.endsWith("1")) {
                                llFmt1 = fmt;
                            } else {
                                llFmt2 = fmt;
                            }
                        } else if (!llFmt.equals((Object)fmt)) {
                            checkDecimalPlaces = false;
                            invalidValues.add(new UploadTableInvalidValue(null, this, this.getLatLongFlds(), row, new Exception(UIRegistry.getResourceString("WB_UPLOADER_INVALID_LATLONG"))));
                        }
                        if (checkDecimalPlaces && fmt != null && fmt != LatLonConverter.FORMAT.None && (c = uploadField.getValue().indexOf(this.decSep)) > -1) {
                            String points = uploadField.getValue().substring(c + 1);
                            int d = 0;
                            while (d < points.length()) {
                                System.out.println(points.substring(d, d + 1));
                                if (!"0123456789".contains(points.substring(d, d + 1))) break;
                                ++d;
                            }
                            if (d > LatLonConverter.DECIMAL_SIZES[fmt.ordinal()]) {
                                invalidValues.add(new UploadTableInvalidValue(null, this, uploadField, row, new Exception(String.format(UIRegistry.getResourceString("WB_UPLOADER_TOO_MANY_FRACTION_DIGITS"), LatLonConverter.DECIMAL_SIZES[fmt.ordinal()]))));
                            }
                        }
                    }
                    if (!fldName.equalsIgnoreCase("LatLongType")) continue;
                    boolean hasLat1 = false;
                    boolean hasLong1 = false;
                    boolean hasLat2 = false;
                    boolean hasLong2 = false;
                    for (UploadField f : this.getLatLongFlds()) {
                        f.setValue(uploadData.get(row, f.getIndex()));
                        String coordName = f.getField().getName();
                        if (coordName.equalsIgnoreCase("latitude1") && StringUtils.isNotBlank((String)f.getValue())) {
                            hasLat1 = true;
                            continue;
                        }
                        if (coordName.equalsIgnoreCase("longitude1") && StringUtils.isNotBlank((String)f.getValue())) {
                            hasLong1 = true;
                            continue;
                        }
                        if (coordName.equalsIgnoreCase("latitude2") && StringUtils.isNotBlank((String)f.getValue())) {
                            hasLat2 = true;
                            continue;
                        }
                        if (!coordName.equalsIgnoreCase("longitude2") || !StringUtils.isNotBlank((String)f.getValue())) continue;
                        hasLong2 = true;
                    }
                    boolean hasCoord1 = hasLat1 && hasLong1;
                    boolean bl = hasCoord2 = hasLat2 && hasLong2;
                    if ((hasCoord1 || hasCoord2) && StringUtils.isBlank((String)uploadField.getValue())) {
                        invalidNulls.add(new UploadTableInvalidValue(UIRegistry.getResourceString("WB_UPLOAD_FIELD_MUST_CONTAIN_DATA"), this, uploadField, row, null));
                        continue;
                    }
                    if (!hasCoord1 && !hasCoord2 && StringUtils.isBlank((String)uploadField.getValue())) continue;
                    String pntStr = UIRegistry.getResourceString("Locality.LL_TYPE_POINT");
                    String lineStr = UIRegistry.getResourceString("Locality.LL_TYPE_LINE");
                    String rectStr = UIRegistry.getResourceString("Locality.LL_TYPE_RECTANGLE");
                    TreeSet<String> validValues = new TreeSet<String>();
                    for (String item : uploadField.getValidValues().keySet()) {
                        if (item.equals(pntStr) && hasCoord1 && !hasCoord2) {
                            validValues.add(item);
                            continue;
                        }
                        if (!item.equals(lineStr) && !item.equals(rectStr) || !hasCoord1 || !hasCoord2) continue;
                        validValues.add(item);
                    }
                    if (validValues.contains(uploadField.getValue()) || this.uploader == Uploader.currentUpload) continue;
                    invalidValues.add(new UploadTableInvalidValue(null, this, uploadField, null, row, new Exception(this.getInvalidPicklistValErrMsg(uploadField, validValues)), false));
                }
                if (this.tblClass.equals(Locality.class) && llFmt1 != llFmt2 && llFmt2 != null && llFmt2 != LatLonConverter.FORMAT.None) {
                    invalidValues.add(new UploadTableInvalidValue(null, this, llFld, row, new Exception(UIRegistry.getResourceString("WB_UPLOADER_INVALID_LATLONG"))));
                }
                if (isBlank = this.isBlankSequence(isBlank, uploadData, row, seq)) {
                    gotABlank = true;
                    blankSeqs.add(seq);
                } else if (!isBlank && gotABlank && this.plugHoles) {
                    for (Integer n : blankSeqs) {
                        for (UploadField blankSeqFld : this.getBlankFields(n, row, uploadData)) {
                            this.addInvalidValueMsgForOneToManySkip(invalidValues, blankSeqFld, this.toString(), row, n);
                        }
                    }
                    blankSeqs.clear();
                }
                invalidValues.addAll(invalidNulls);
                invalidNulls.clear();
                ++seq;
            }
            if (this.tblClass.equals(Determination.class)) {
                boolean isCurrentPresent = false;
                UploadField anIsCurrentFld = null;
                isBlank = true;
                int trueCount = 0;
                for (Vector vector : this.uploadFields) {
                    for (UploadField fld : vector) {
                        if (isBlank && StringUtils.isNotBlank((String)uploadData.get(row, fld.getIndex()))) {
                            isBlank = false;
                        }
                        if (!fld.getField().getName().equalsIgnoreCase("iscurrent")) continue;
                        isCurrentPresent = true;
                        if (anIsCurrentFld == null) {
                            anIsCurrentFld = fld;
                        }
                        fld.setValue(uploadData.get(row, fld.getIndex()));
                        try {
                            Object[] boolVal = this.getArgForSetter(fld);
                            if (boolVal[0] == null || !((Boolean)boolVal[0]).booleanValue()) continue;
                            ++trueCount;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (isCurrentPresent && !isBlank && trueCount != 1) {
                    invalidValues.add(new UploadTableInvalidValue(null, this, anIsCurrentFld, row, new Exception(UIRegistry.getResourceString("WB_UPLOAD_ONE_CURRENT_DETERMINATION"))));
                }
            }
            if (this.tblClass.equals(Agent.class)) {
                boolean nonPersonNonEmpty = false;
                boolean isNonPerson = false;
                Vector<UploadField> personOnlyFlds = new Vector<UploadField>();
                for (Vector<UploadField> flds : this.uploadFields) {
                    for (UploadField fld : flds) {
                        try {
                            Object[] val;
                            if (fld.getField().getName().equalsIgnoreCase("firstName") || fld.getField().getName().equalsIgnoreCase("middleInitial") || fld.getField().getName().equalsIgnoreCase("title")) {
                                val = this.getArgForSetter(fld);
                                nonPersonNonEmpty = StringUtils.isNotEmpty((String)((String)val[0]));
                                personOnlyFlds.add(fld);
                            }
                            if (!fld.getField().getName().equalsIgnoreCase("agenttype")) continue;
                            val = this.getArgForSetter(fld);
                            boolean bl = isNonPerson = val[0] != null && !((Byte)val[0]).equals((byte)1);
                            if (isNonPerson) continue;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!isNonPerson || !nonPersonNonEmpty) continue;
                    for (UploadField poFld : personOnlyFlds) {
                        invalidValues.add(new UploadTableInvalidValue(null, this, poFld, row, new Exception(UIRegistry.getResourceString("UploadTable.FieldNotApplicableForAgentType"))));
                    }
                }
            }
        }
        finally {
            this.validatingValues = false;
        }
    }

    protected void checkUniqueness(Object[] val, UploadField fld) throws Exception {
        if (val != null && val[0] != null && fld.getIndex() != -1 && fld.getField() != null && fld.getField().getFieldInfo() != null) {
            DBFieldInfo fldInfo = fld.getField().getFieldInfo();
            DBTableInfo tblInfo = fldInfo.getTableInfo();
            if (fldInfo.getName().equalsIgnoreCase("catalognumber") && tblInfo.getName().equals("collectionobject") && BasicSQLUtils.getCount("select count(*) from collectionobject where CollectionMemberID = " + AppContextMgr.getInstance().getClassObject(Collection.class).getId() + " and CatalogNumber = '" + val[0] + "'") != 0) {
                throw new Exception(UIRegistry.getResourceString("UploadTable.UniquenessViolation"));
            }
        }
    }

    protected void addDisusedRec(DataModelObjBase rec, Uploader.ParentTableEntry pt) throws InvocationTargetException, IllegalAccessException {
        UploadTable parentTbl = pt.getImportTable();
        Set<Pair<Integer, String>> parentDisUsed = pt.getImportTable().disUsedRecs;
        DataModelObjBase parentRec = (DataModelObjBase)pt.getGetter().invoke((Object)rec, new Object[0]);
        if (!parentDisUsed.contains(parentRec.getId())) {
            String text = DataObjFieldFormatMgr.getInstance().format((Object)parentRec, parentTbl.getTable().getTableInfo().getDataObjFormatter());
            parentDisUsed.add(new Pair<Integer, String>(parentRec.getId(), text));
        }
    }

    protected void disUseRecs(Set<Pair<Integer, String>> theDisUsed) {
        if (this.tblClass.equals(Agent.class) || Treeable.class.isAssignableFrom(this.tblClass)) {
            System.out.println("Not attempting to remove disused recs for class: " + this.tblClass);
            return;
        }
        SpecifyDeleteHelper delhel = new SpecifyDeleteHelper();
        for (Pair<Integer, String> disUsedOne : theDisUsed) {
            this.disUseRec(disUsedOne, delhel);
        }
        delhel.done(true);
        for (Pair<Integer, String> deletedRec : this.deletedRecs) {
            System.out.println("Deleted " + this.tblClass.getSimpleName() + "[" + deletedRec.getFirst() + "]: " + deletedRec.getSecond());
        }
    }

    protected void disUseRec(Pair<Integer, String> disUsedRec, SpecifyDeleteHelper delhel) {
        System.out.println("deleting " + disUsedRec);
        try {
            delhel.delRecordFromTable(this.tblClass, disUsedRec.getFirst(), true);
            this.deletedRecs.add(disUsedRec);
        }
        catch (SQLException sqex) {
            delhel.rollback();
            System.out.println("unable to delete " + this.tblClass.getSimpleName() + ":" + disUsedRec);
        }
    }

    protected List<UploadField> getBlankFields(int blankSeq, int row, UploadData uploadData) {
        LinkedList<UploadField> result = new LinkedList<UploadField>();
        for (UploadField uploadField : this.uploadFields.get(blankSeq)) {
            if (uploadField.getIndex() == -1) continue;
            result.add(uploadField);
        }
        for (Vector vector : this.parentTables) {
            for (Uploader.ParentTableEntry pte : vector) {
                if (!pte.getImportTable().isSequenced) continue;
                result.addAll(pte.getImportTable().getBlankFields(blankSeq, row, uploadData));
            }
        }
        return result;
    }

    protected boolean isBlankSequence(boolean blank, UploadData uploadData, int row, int seq) {
        if (!blank) {
            return false;
        }
        if (this.parentTables.size() > 0) {
            for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
                for (Uploader.ParentTableEntry pte : ptes) {
                    if (!pte.getImportTable().isSequenced || pte.getImportTable().isBlankRow(row, uploadData, seq)) continue;
                    return false;
                }
            }
            return true;
        }
        return !this.hasChildren;
    }

    public Vector<UploadTableInvalidValue> validateValues(UploadData uploadData) {
        Vector<UploadTableInvalidValue> result = new Vector<UploadTableInvalidValue>();
        int row = 0;
        while (row < uploadData.getRows()) {
            this.validateRowValues(row, uploadData, result);
            ++row;
        }
        return result;
    }

    protected void loadFromDataSet(int wbRow) throws UploaderException {
        if (wbRow == 0 || wbRow != this.wbCurrentRow) {
            this.readFromDataSet(wbRow, false);
            this.writeRowOrNot(wbRow == 0 || this.wbCurrentRow < wbRow, wbRow == 0 || this.wbCurrentRow < wbRow);
            this.readFromDataSet(this.wbCurrentRow, true);
        }
    }

    protected void readFromDataSet(int wbRow, boolean restore) {
        this.uploader.loadRow(this, wbRow);
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pt : ptes) {
                if (pt.getImportTable() == null) continue;
                pt.getImportTable().readFromDataSet(restore ? pt.getImportTable().wbCurrentRow : wbRow, restore);
            }
        }
    }

    protected void writeRow(int row) throws UploaderException {
        this.wbCurrentRow = row;
        if (!this.skipRow) {
            this.writeRowOrNot(false, false);
        } else {
            this.skipRow = false;
        }
    }

    protected void writeRowOrNot(boolean doNotWrite, boolean skipMatch) throws UploaderException {
        this.logDebug("writeRowOrNot: " + this.table.getName());
        System.out.println("writeRowOrNot: " + this.table.getName() + " (" + this.wbCurrentRow + ")");
        this.autoAssignedVal = null;
        this.reusingExportedRec = false;
        int recNum = this.uploadFields.size() - 1;
        while (recNum >= 0) {
            block23: {
                Vector<UploadField> seq = this.uploadFields.get(recNum);
                try {
                    if (this.updateMatches) {
                        this.updateExportedRecInfo(recNum);
                    }
                    if (this.needToWrite(recNum)) {
                        boolean isNewRecord;
                        if (!skipMatch && this.findMatch(recNum, false, null, null) && !this.updateMatches) break block23;
                        if (this.isSecurityOn && !this.getWriteTable().getTableInfo().getPermissions().canAdd()) {
                            throw new UploaderException(String.format(UIRegistry.getResourceString("WB_UPLOAD_NO_ADD_PERMISSION"), this.getWriteTable().getTableInfo().getTitle()), 10);
                        }
                        DataModelObjBase rec = this.getCurrentRecordForSave(recNum);
                        boolean bl = isNewRecord = rec.getId() == null;
                        if (isNewRecord || !this.updateMatches) {
                            rec.initialize();
                        }
                        boolean valuesChanged = this.setFields(rec, seq);
                        boolean isUpdate = this.updateMatches && !isNewRecord && valuesChanged;
                        boolean gotRequiredParents = true;
                        try {
                            isUpdate |= (valuesChanged |= this.setParents(rec, recNum, !doNotWrite));
                        }
                        catch (UploaderException ex) {
                            if ("MissingRequiredParent".equals(ex.getMessage())) {
                                gotRequiredParents = false;
                            }
                            throw ex;
                        }
                        if (!this.updateMatches || isNewRecord) {
                            this.setRequiredFldDefaults(rec, recNum);
                            this.setRelatedDefaults(rec, recNum);
                        }
                        if (!doNotWrite && (!this.updateMatches || isUpdate || isNewRecord)) {
                            this.finalizeWrite(rec, recNum);
                            if (!gotRequiredParents && this.hasChildren) {
                                throw new UploaderException(UIRegistry.getResourceString("UPLOADER_MISSING_REQUIRED_DATA"), 10);
                            }
                            this.doWrite(rec);
                            if (!this.updateMatches || isNewRecord) {
                                this.uploadedRecs.add(new UploadedRecordInfo(rec.getId(), this.wbCurrentRow, recNum, this.autoAssignedVal));
                            } else if (isUpdate && this.updateMatches) {
                                this.uploadedRecs.add(new UploadedRecordInfo(rec.getId(), this.wbCurrentRow, recNum, this.autoAssignedVal, true, null, null));
                            }
                        }
                        this.setCurrentRecord(rec, recNum);
                        this.finishMatching(rec);
                        break block23;
                    }
                    if (this.exportedOneToManyId != null) {
                        this.banishChild();
                    }
                    this.setCurrentRecord(null, recNum);
                }
                catch (InstantiationException ieEx) {
                    throw new UploaderException(ieEx, 20);
                }
                catch (IllegalAccessException iaEx) {
                    throw new UploaderException(iaEx, 20);
                }
                catch (NoSuchMethodException ssmEx) {
                    throw new UploaderException(ssmEx, 20);
                }
                catch (InvocationTargetException itEx) {
                    throw new UploaderException(itEx, 20);
                }
                catch (IllegalArgumentException iaA) {
                    throw new UploaderException(iaA, 20);
                }
                catch (ParseException peEx) {
                    throw new UploaderException(peEx, 20);
                }
                catch (SQLException sqEx) {
                    throw new UploaderException(sqEx, 20);
                }
            }
            --recNum;
        }
    }

    protected void banishChild() {
        String sql = "delete from " + this.tblClass.getSimpleName().toLowerCase() + " where " + this.getTable().getTableInfo().getPrimaryKeyName() + " = " + this.exportedOneToManyId;
        int r = BasicSQLUtils.update(sql);
        System.out.println(String.valueOf(r) + " deleted (" + sql + ")");
    }

    protected void finishMatching(DataModelObjBase rec) {
        if (this.restrictedValsForAddNewMatch != null) {
            UploadMatchSetting uploadMatchSetting = this.matchSetting;
            uploadMatchSetting.getClass();
            this.matchSetting.addSelection(uploadMatchSetting.new UploadMatchSetting.MatchSelection(this.restrictedValsForAddNewMatch, this.uploader.getRow(), rec.getId(), this.matchSetting.getMode()));
            this.restrictedValsForAddNewMatch = null;
        }
    }

    public Vector<Uploader.ParentTableEntry> getAncestors() {
        Vector<Uploader.ParentTableEntry> result = new Vector<Uploader.ParentTableEntry>();
        for (Vector<Uploader.ParentTableEntry> ptes : this.parentTables) {
            for (Uploader.ParentTableEntry pte : ptes) {
                result.add(pte);
                result.addAll(pte.getImportTable().getAncestors());
            }
        }
        return result;
    }

    protected boolean needToWrite(int recNum) throws UploaderException {
        if (this.dataToWrite(recNum)) {
            return true;
        }
        if (this.tblClass.equals(CollectingEvent.class) && AppContextMgr.getInstance().getClassObject(Collection.class).getIsEmbeddedCollectingEvent().booleanValue()) {
            return true;
        }
        for (UploadTable uploadTable : this.specialChildren) {
            if (!this.needToMatchChild(uploadTable.tblClass)) continue;
            uploadTable.loadFromDataSet(this.wbCurrentRow);
            int c = 0;
            while (c < uploadTable.getUploadFields().size()) {
                if (uploadTable.getCurrentRecord(c) != null) {
                    return true;
                }
                ++c;
            }
        }
        if (this.parentTables.size() == 0) {
            return false;
        }
        for (Vector vector : this.parentTables) {
            for (Uploader.ParentTableEntry pt : vector) {
                boolean checkParent;
                UploadTable parentTbl = pt.getImportTable();
                boolean bl = checkParent = parentTbl instanceof UploadTableTree || parentTbl.isOneToOneChild();
                if (!checkParent && pt.getParentRel() != null) {
                    checkParent = pt.getParentRel().getRelType().startsWith("OneTo") ? !parentTbl.specialChildren.contains(this) : true;
                }
                if (!checkParent) continue;
                try {
                    if (pt.getImportTable().getParentRecord(recNum, this) == null) continue;
                    return true;
                }
                catch (Exception ex) {
                    throw new UploaderException(ex, 20);
                }
            }
        }
        return false;
    }

    protected void doWrite(DataModelObjBase rec) throws UploaderException {
        this.tblSession = DataProviderFactory.getInstance().createSession();
        boolean tblTransactionOpen = false;
        try {
            try {
                DataModelObjBase mergedRec = rec;
                BusinessRulesIFace busRule = DBTableIdMgr.getInstance().getBusinessRule(this.tblClass);
                if (busRule instanceof AttachmentOwnerBaseBusRules) {
                    ((AttachmentOwnerBaseBusRules)busRule).setProcessOwnersAndRefs(true);
                }
                if (busRule != null) {
                    busRule.beforeSave(mergedRec, this.tblSession);
                }
                this.tblSession.beginTransaction();
                tblTransactionOpen = true;
                this.tblSession.saveOrUpdate(mergedRec);
                if (busRule != null && !busRule.beforeSaveCommit(mergedRec, this.tblSession)) {
                    this.tblSession.rollback();
                    tblTransactionOpen = false;
                    throw new Exception("Business rules processing failed");
                }
                this.tblSession.commit();
                tblTransactionOpen = false;
                if (busRule != null) {
                    busRule.afterSaveCommit(mergedRec, this.tblSession);
                }
                if (this.needToRefreshAfterWrite() || this.updateMatches) {
                    this.tblSession.refresh(rec);
                }
            }
            catch (Exception ex) {
                if (tblTransactionOpen) {
                    this.tblSession.rollback();
                }
                if (ex instanceof ConstraintViolationException) {
                    throw new UploaderException(ex, 10);
                }
                throw new UploaderException(ex, 20);
            }
        }
        finally {
            this.tblSession.close();
        }
    }

    public boolean needToRefreshAfterWrite() {
        return false;
    }

    public static String capitalize(String toCap) {
        return toCap.substring(0, 1).toUpperCase().concat(toCap.substring(1));
    }

    public static String deCapitalize(String toDecap) {
        return toDecap.substring(0, 1).toLowerCase().concat(toDecap.substring(1));
    }

    private Class<?> getFieldClass(DBFieldInfo fi) {
        if (fi == null) {
            return Integer.class;
        }
        String type = fi.getType();
        if (StringUtils.isNotEmpty((String)type)) {
            if (type.equals("calendar_date")) {
                return Calendar.class;
            }
            if (type.equals("text")) {
                return String.class;
            }
            if (type.equals("boolean")) {
                return Boolean.class;
            }
            if (type.equals("short")) {
                return Short.class;
            }
            if (type.equals("byte")) {
                return Byte.class;
            }
            try {
                return Class.forName(type);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UploadTable.class, e);
                log.error((Object)e);
            }
        }
        throw new RuntimeException("Could not find [" + fi.getName() + "]");
    }

    public void undoUpload(boolean showProgress) throws UploaderException {
        this.deleteObjects(this.uploadedRecs.iterator(), showProgress);
    }

    public void abortRow(int row) throws UploaderException {
        UploadedRecordInfo arg2;
        UploadedRecordInfo arg1 = new UploadedRecordInfo(null, row, 0, null);
        SortedSet<UploadedRecordInfo> recsForRow = this.uploadedRecs.subSet(arg1, arg2 = new UploadedRecordInfo(null, row + 1, 0, null));
        if (recsForRow.size() > 0) {
            this.deleteObjects(recsForRow.iterator(), false);
            this.uploadedRecs.removeAll(recsForRow);
        }
    }

    protected Vector<DeleteQuery> getQueriesForRawDeletes(DataProviderSessionIFace session) {
        Vector<DeleteQuery> result = new Vector<DeleteQuery>();
        AttachmentOwnerIFace.class.isAssignableFrom(this.getTblClass());
        result.add(new DeleteQuery(session.createQuery("delete from " + this.getWriteTable().getName().toLowerCase() + " where " + this.getWriteTable().getTableInfo().getIdColumnName() + "=:theKey", true), true, -1));
        return result;
    }

    protected void deleteObjects(Iterator<UploadedRecordInfo> objs, boolean showProgress) throws UploaderException {
        Vector<DeleteQuery> q;
        log.debug((Object)("deleting from " + this.getWriteTable().getName()));
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        if (doRawDeletes) {
            q = this.getQueriesForRawDeletes(session);
        } else {
            q = new Vector(1);
            String hql = "from " + this.getWriteTable().getName() + " where id =:theKey";
            q.add(new DeleteQuery(session.createQuery(hql, false), true, -1));
        }
        Runnable progShower = null;
        if (showProgress) {
            progShower = new Runnable(){

                @Override
                public void run() {
                    UploadTable.this.uploader.undoStep();
                }
            };
        }
        try {
            while (objs.hasNext()) {
                Integer key = objs.next().getKey();
                if (key != null) {
                    boolean committed = false;
                    boolean opened = false;
                    try {
                        for (DeleteQuery qFace : q) {
                            if (qFace.getKeyGeneratorIdx() != -1) continue;
                            qFace.getQuery().setParameter("theKey", key);
                        }
                        if (doRawDeletes) {
                            HashMap subKeysMap = new HashMap();
                            int qIdx = 0;
                            for (DeleteQuery qFace : q) {
                                session.beginTransaction();
                                opened = true;
                                if (qFace.isDeletes()) {
                                    if (qFace.getKeyGeneratorIdx() == -1) {
                                        qFace.getQuery().executeUpdate();
                                    } else {
                                        List subKeys = (List)subKeysMap.get(qFace.getKeyGeneratorIdx());
                                        for (Object subKeyObj : subKeys) {
                                            qFace.getQuery().setParameter("theKey", subKeyObj);
                                            qFace.getQuery().executeUpdate();
                                        }
                                    }
                                } else {
                                    subKeysMap.put(qIdx, qFace.getQuery().list());
                                }
                                session.commit();
                                committed = true;
                                ++qIdx;
                            }
                        } else {
                            DataModelObjBase obj = (DataModelObjBase)q.get(0).getQuery().uniqueResult();
                            if (obj != null) {
                                session.beginTransaction();
                                BusinessRulesIFace busRule = DBTableIdMgr.getInstance().getBusinessRule(this.tblClass);
                                opened = true;
                                if (busRule != null) {
                                    obj = (DataModelObjBase)busRule.beforeDelete(obj, session);
                                }
                                session.delete(obj);
                                if (busRule != null) {
                                    busRule.beforeDeleteCommit(obj, session);
                                }
                                session.commit();
                                committed = true;
                            } else if (!this.isOneToOneChild()) {
                                log.error((Object)(String.valueOf(this.tblClass.getSimpleName()) + ": record with key " + key + " does not exist."));
                            }
                        }
                    }
                    catch (ConstraintViolationException ex) {
                        log.info((Object)(String.valueOf(this.table.getName()) + ":" + (Object)((Object)ex)));
                        if (opened && !committed) {
                            session.rollback();
                        }
                    }
                    catch (ObjectDeletedException ex) {
                        log.info((Object)(String.valueOf(this.table.getName()) + "." + key + ":" + (Object)((Object)ex)));
                        if (opened && !committed) {
                            session.rollback();
                        }
                    }
                    catch (Exception ex) {
                        log.info((Object)(String.valueOf(this.table.getName()) + ":" + ex));
                        if (opened && !committed) {
                            session.rollback();
                        }
                        throw new UploaderException(ex);
                    }
                }
                if (!showProgress) continue;
                SwingUtilities.invokeLater(progShower);
            }
        }
        finally {
            session.close();
        }
    }

    private Vector<Method> getGetters() {
        Method[] methods = this.tblClass.getMethods();
        Vector<Method> result = new Vector<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("get") && m.getParameterTypes().length == 0 && m.getReturnType() != Void.TYPE && Modifier.isPublic(m.getModifiers()) && !Modifier.isTransient(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers())) {
                Column jc = m.getAnnotation(Column.class);
                JoinColumn c = m.getAnnotation(JoinColumn.class);
                OneToMany otm = m.getAnnotation(OneToMany.class);
                if (otm == null && (jc != null || c != null || m.getName().equalsIgnoreCase("getId"))) {
                    result.add(m);
                }
            }
            ++n2;
        }
        return result;
    }

    public Vector<Vector<String>> printUpload() throws InvocationTargetException, IllegalAccessException {
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        Vector<Method> getters = this.getGetters();
        Object[] args = new Object[]{};
        Vector<Vector<String>> result = new Vector<Vector<String>>();
        try {
            String hql = "from " + this.tblClass.getSimpleName() + " obj where id=:theKey";
            DataProviderSessionIFace.QueryIFace qif = session.createQuery(hql, false);
            boolean wroteHeaders = false;
            for (Object e : this.uploadedRecs) {
                if (e == null) {
                    log.error((Object)"null key");
                    continue;
                }
                qif.setParameter("theKey", e);
                Object rec = qif.uniqueResult();
                if (rec == null) {
                    log.error((Object)("null object for key: " + e.toString()));
                    continue;
                }
                if (!wroteHeaders) {
                    Vector<String> heads = new Vector<String>();
                    heads.add("Id");
                    for (Method getter : getters) {
                        if (getter.getName().equalsIgnoreCase("getId") || getter.getName().equalsIgnoreCase("get" + this.getWriteTable().getName() + "Id")) continue;
                        heads.add(getter.getName().substring(3));
                    }
                    result.add(heads);
                    wroteHeaders = true;
                }
                Vector<String> row = new Vector<String>();
                row.add(e.toString());
                for (Method getter : getters) {
                    if (getter.getName().equalsIgnoreCase("getId") || getter.getName().equalsIgnoreCase("get" + this.getWriteTable().getName() + "Id")) continue;
                    Object obj = getter.invoke(rec, args);
                    if (obj == null) {
                        row.add(null);
                        continue;
                    }
                    if (DataModelObjBase.class.isInstance(obj)) {
                        DataModelObjBase dbobj = (DataModelObjBase)obj;
                        row.add(dbobj.getId() == null ? null : dbobj.getId().toString());
                        continue;
                    }
                    row.add(obj.toString());
                }
                result.add(row);
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    public final void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public final Class<?> getTblClass() {
        return this.tblClass;
    }

    protected String getRecordSetName(boolean showRecordSetInUI) {
        int maxNameLength = DBTableIdMgr.getInstance().getInfoByTableName("recordset").getFieldByColumnName("name").getLength();
        String rsName = this.getFullRecordSetName(showRecordSetInUI);
        if (rsName.length() > maxNameLength) {
            Calendar now = this.uploader.getUploadTime();
            String[] chunks = new String[]{"_" + String.valueOf(now.get(1)), "-" + String.valueOf(now.get(2) + 1), "-" + String.valueOf(now.get(5)), "_" + String.valueOf(now.get(11)), ":" + String.valueOf(now.get(13))};
            rsName = this.getShortRecordSetName();
            int c = 0;
            while (c < chunks.length && (String.valueOf(rsName) + chunks[c]).length() <= maxNameLength) {
                rsName = String.valueOf(rsName) + chunks[c++];
            }
        }
        return rsName;
    }

    protected String getFullRecordSetName(boolean showRecordSetInUI) {
        String tblName = showRecordSetInUI ? "" : String.valueOf(DBTableIdMgr.getInstance().getByShortClassName(this.tblClass.getSimpleName()).getTitle()) + "_";
        String uploadName = this.uploader.getIdentifier();
        return String.valueOf(tblName) + uploadName;
    }

    protected String getShortRecordSetName() {
        return DBTableIdMgr.getInstance().getByShortClassName(this.tblClass.getSimpleName()).getTitle();
    }

    public RecordSet getRecordSet(boolean showRecordSetInUI) {
        RecordSet result = new RecordSet();
        result.initialize();
        result.set(this.getRecordSetName(showRecordSetInUI), DBTableIdMgr.getInstance().getByShortClassName(this.tblClass.getSimpleName()).getTableId(), showRecordSetInUI ? RecordSet.GLOBAL : RecordSet.WB_UPLOAD);
        result.setSpecifyUser(AppContextMgr.getInstance().getClassObject(SpecifyUser.class));
        for (UploadedRecordInfo rec : this.uploadedRecs) {
            result.addItem((int)rec.getKey());
        }
        return result;
    }

    public Vector<UploadTable> getSpecialChildren() {
        return this.specialChildren;
    }

    public String toString() {
        String result = this.getTblTitle();
        if (this.tblClass.equals(Agent.class) && this.relationship != null) {
            result = String.valueOf(result) + " (" + this.relationship.getRelatedField().getTable().getTableInfo().getTitle() + ")";
        }
        return result;
    }

    public String getTblTitle() {
        return DBTableIdMgr.getInstance().getByShortClassName(this.tblClass.getSimpleName()).getTitle();
    }

    public UploadMatchSetting getMatchSetting() {
        return this.matchSetting;
    }

    public void finishUpload(boolean cancelled) throws UploaderException {
        if (this.updateMatches) {
            this.disUseRecs(this.disUsedRecs);
        }
    }

    public void finishUndoUpload() throws UploaderException {
    }

    public void shutdown() throws UploaderException {
    }

    public boolean isSkipMatching() {
        return this.skipMatching;
    }

    public void setSkipMatching(boolean skipMatching) {
        this.skipMatching = skipMatching;
    }

    private void logDebug(Object toLog) {
        if (debugging) {
            log.debug(toLog);
        }
    }

    public boolean getHasChildren() {
        return this.hasChildren;
    }

    public UploadField getAutoAssignedField() {
        return this.autoAssignedField;
    }

    public boolean isCheckMatchInfo() {
        return this.checkMatchInfo;
    }

    public void setCheckMatchInfo(boolean checkMatchInfo) {
        this.checkMatchInfo = checkMatchInfo;
    }

    public void setMatchRecordId(boolean matchRecordId) {
        this.matchRecordId = matchRecordId;
    }

    public boolean isUpdateMatches() {
        return this.updateMatches;
    }

    public void setUpdateMatches(boolean updateMatches) {
        this.updateMatches = updateMatches;
    }

    public boolean isMatchRecordId() {
        return this.matchRecordId;
    }

    protected class DeleteQuery {
        protected final DataProviderSessionIFace.QueryIFace query;
        protected final boolean deletes;
        protected final int keyGeneratorIdx;

        public DeleteQuery(DataProviderSessionIFace.QueryIFace query, boolean deletes, int keyGeneratorIdx) {
            this.query = query;
            this.deletes = deletes;
            this.keyGeneratorIdx = keyGeneratorIdx;
        }

        public DataProviderSessionIFace.QueryIFace getQuery() {
            return this.query;
        }

        public boolean isDeletes() {
            return this.deletes;
        }

        public int getKeyGeneratorIdx() {
            return this.keyGeneratorIdx;
        }
    }

    public class MatchRestriction
    implements Comparable<MatchRestriction> {
        protected final String fieldName;
        protected final String restriction;
        protected final int col;

        public MatchRestriction(String fieldName, String restriction, int col) {
            this.fieldName = fieldName;
            this.restriction = restriction;
            this.col = col;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getRestriction() {
            return this.restriction;
        }

        public int getCol() {
            return this.col;
        }

        @Override
        public int compareTo(MatchRestriction o) {
            if (this.col == -1) {
                return 1;
            }
            if (o.col == -1) {
                return -1;
            }
            return this.col < o.col ? -1 : (this.col == o.col ? 0 : 1);
        }
    }

    private class ParentMatchInfo {
        protected final List<DataModelObjBase> matches;
        protected final UploadTable table;
        protected final boolean isBlank;
        protected boolean isSkipped;
        protected final int recNum;

        public ParentMatchInfo(List<DataModelObjBase> matches, UploadTable table, boolean isBlank, boolean isSkipped, int recNum) {
            this.matches = matches;
            this.table = table;
            this.isBlank = isBlank;
            this.isSkipped = isSkipped;
            this.recNum = recNum;
        }

        public List<DataModelObjBase> getMatches() {
            return this.matches;
        }

        public UploadTable getTable() {
            return this.table;
        }

        public boolean isBlank() {
            return this.isBlank;
        }

        public boolean isSkipped() {
            return this.isSkipped;
        }

        public void setIsSkipped(boolean isSkipped) {
            this.isSkipped = isSkipped;
        }

        public int getRecNum() {
            return this.recNum;
        }
    }

    public class PartialMatchMsg
    extends BaseUploadMessage {
        protected String matchVals;
        protected String matchedText;
        protected int row;
        protected UploadTable uploadTable;

        public PartialMatchMsg(Vector<MatchRestriction> cellVals, String matchedText, int row, UploadTable uploadTable2) {
            super(null);
            StringBuilder sb = new StringBuilder();
            for (MatchRestriction p : cellVals) {
                if (!sb.toString().equals("")) {
                    sb.append(", ");
                }
                sb.append(p.getFieldName());
                sb.append("=");
                sb.append("\"" + p.getRestriction() + "\"");
            }
            this.matchVals = sb.toString();
            this.matchedText = matchedText;
            this.row = row;
            this.uploadTable = uploadTable2;
        }

        @Override
        public Object getData() {
            return this.uploadTable;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        @Override
        public String getMsg() {
            StringBuilder result = new StringBuilder(UIRegistry.getResourceString("WB_UPLOAD_ROW"));
            result.append(" ");
            result.append(String.valueOf(this.row));
            result.append(": ");
            result.append(UIRegistry.getResourceString("WB_UPLOAD_PARTIAL_MATCH"));
            result.append(" (");
            result.append(this.matchVals);
            result.append(" ");
            result.append(UIRegistry.getResourceString("WB_UPLOAD_MATCHED"));
            result.append(" ");
            result.append("\"" + this.matchedText + "\")");
            return result.toString();
        }
    }
}

