/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadField;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadRetriever;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecordInfo;
import edu.ku.brc.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class UploadResultsQuery
implements CustomQueryIFace {
    protected final CustomQueryListener customQueryListener;
    protected final UploadTable uploadTable;
    protected final UploadData uploadData;
    protected final List<Object[]> dataObjects;
    protected int maxFldIdx;
    protected static final int MAX_DISPLAYED_ROWS = 2000;

    protected Integer getTblCol(Pair<Integer, Integer> fldDef) {
        return fldDef.getFirst();
    }

    protected Integer getWbCol(Pair<Integer, Integer> fldDef) {
        return fldDef.getSecond();
    }

    public UploadResultsQuery(CustomQueryListener cql, UploadTable uploadTable, UploadData uploadData) {
        this.customQueryListener = cql;
        this.uploadTable = uploadTable;
        this.uploadData = uploadData;
        this.dataObjects = new ArrayList<Object[]>(uploadTable.getUploadedRecs().size());
    }

    protected void fillRows() {
        Vector<Vector<Pair<Integer, Integer>>> indexes = this.setupFldIdxInfo(this.uploadTable);
        if (indexes != null) {
            int row = 0;
            for (UploadedRecordInfo rec : this.uploadTable.getUploadedRecs()) {
                Object[] rowData = new Object[this.maxFldIdx + 2];
                rowData[0] = rec.getKey();
                Vector<Pair<Integer, Integer>> index = indexes.get(rec.getSeq());
                int i = 0;
                while (i < index.size()) {
                    int wbCol = this.getWbCol(index.get(i));
                    Object val = rec.getAutoAssignedVal() != null && this.uploadTable.getAutoAssignedField() != null && wbCol == this.uploadTable.getAutoAssignedField().getIndex() ? rec.getAutoAssignedVal() : this.uploadData.getWbRow(rec.getWbRow()).getData(wbCol);
                    rowData[this.getTblCol(index.get((int)i)).intValue() + 1] = val;
                    ++i;
                }
                this.dataObjects.add(rowData);
                if (++row == 2000) break;
            }
        }
    }

    protected Vector<Vector<Pair<Integer, Integer>>> setupFldIdxInfo(UploadTable uploadTable) {
        LinkedList<UploadField> sortedFlds = new LinkedList<UploadField>();
        for (Vector<UploadField> flds : uploadTable.getUploadFields()) {
            for (UploadField fld : flds) {
                if (fld.getIndex() == -1) continue;
                sortedFlds.add(fld);
            }
        }
        if (sortedFlds.size() == 0) {
            return null;
        }
        UploadRetriever.columnOrder(sortedFlds);
        int maxSequence = ((UploadField)sortedFlds.get(sortedFlds.size() - 1)).getSequenceInt() + 1;
        Vector<Vector<Pair<Integer, Integer>>> result = new Vector<Vector<Pair<Integer, Integer>>>(maxSequence);
        int s = 0;
        while (s < maxSequence) {
            result.add(new Vector());
            ++s;
        }
        int tblCol = -1;
        int seq = -1;
        for (UploadField fld : sortedFlds) {
            if (fld.getSequenceInt() != seq) {
                seq = fld.getSequenceInt();
                tblCol = 0;
            }
            result.get(fld.getSequenceInt()).add(new Pair<Integer, Integer>(tblCol, fld.getIndex()));
            if (tblCol > this.maxFldIdx) {
                this.maxFldIdx = tblCol;
            }
            ++tblCol;
        }
        return result;
    }

    @Override
    public boolean execute() {
        this.execute(this.customQueryListener);
        return true;
    }

    @Override
    public void execute(CustomQueryListener cql) {
        this.fillRows();
        if (this.dataObjects.size() > 0) {
            cql.exectionDone(this);
        }
    }

    @Override
    public List<?> getDataObjects() {
        return this.dataObjects;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public List<QueryResultsContainerIFace> getQueryDefinition() {
        return null;
    }

    @Override
    public List<QueryResultsDataObj> getResults() {
        return null;
    }

    @Override
    public boolean isInError() {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void cancel() {
    }

    @Override
    public List<Integer> getTableIds() {
        return null;
    }

    @Override
    public int getMaxResults() {
        return 0;
    }

    @Override
    public void setMaxResults(int maxResults) {
    }
}

