/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadField;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadRetriever;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecordInfo;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;

public class UploadResults
implements QueryForIdResultsIFace {
    protected final UploadTable uploadTable;
    protected final UploadData uploadData;
    protected Vector<Integer> recIds = null;
    protected final List<ERTICaptionInfo> captions;
    protected final Color bannerColor = new Color(144, 30, 255);

    public UploadResults(UploadTable uploadTable, UploadData uploadData) {
        this.uploadTable = uploadTable;
        this.uploadData = uploadData;
        this.captions = this.buildCaptions();
    }

    protected List<ERTICaptionInfo> buildCaptions() {
        ArrayList<ERTICaptionInfo> result = new ArrayList<ERTICaptionInfo>();
        for (Vector<UploadField> flds : this.uploadTable.getUploadFields()) {
            ArrayList<UploadField> orderedFields = new ArrayList<UploadField>();
            for (UploadField fld : flds) {
                if (fld.getIndex() == -1 || fld.getSequenceInt() > 0) continue;
                orderedFields.add(fld);
            }
            UploadRetriever.columnOrder(orderedFields);
            for (UploadField fld : orderedFields) {
                String title = fld.getField().getFieldInfo().getTitle();
                String fldName = String.valueOf(this.uploadTable.getTable().getTableInfo().getName()) + "." + fld.getField().getFieldInfo().getName();
                result.add(new ERTICaptionInfo(fldName, title, true, null, 0));
            }
        }
        return result;
    }

    public int getUploadedRecCount() {
        return this.uploadTable.getUploadedRecs().size();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void complete() {
    }

    @Override
    public boolean isEditingEnabled() {
        return false;
    }

    @Override
    public Color getBannerColor() {
        return this.bannerColor;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Integer getDisplayOrder() {
        return 0;
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public List<Pair<String, Object>> getParams() {
        return null;
    }

    @Override
    public Future<?> getQueryTask() {
        return null;
    }

    @Override
    public Vector<Integer> getRecIds() {
        if (this.recIds == null) {
            this.buildRecIds();
        }
        return this.recIds;
    }

    protected void buildRecIds() {
        this.recIds = new Vector(this.uploadTable.getUploadedRecs().size());
        for (UploadedRecordInfo rec : this.uploadTable.getUploadedRecs()) {
            this.recIds.add(rec.getKey());
        }
    }

    @Override
    public String getSQL(String searchTerm, Vector<Integer> ids) {
        return null;
    }

    @Override
    public String getSearchTerm() {
        return null;
    }

    @Override
    public int getTableId() {
        return this.uploadTable.getTable().getTableInfo().getTableId();
    }

    @Override
    public String getTitle() {
        return this.uploadTable.toString();
    }

    @Override
    public List<ERTICaptionInfo> getVisibleCaptionInfo() {
        return this.captions;
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    @Override
    public boolean isHQL() {
        return false;
    }

    @Override
    public boolean isMultipleSelection() {
        return false;
    }

    @Override
    public void queryTaskDone(Object results) {
    }

    @Override
    public void removeIds(List<Integer> ids) {
    }

    @Override
    public void setMultipleSelection(boolean isMultiple) {
    }

    @Override
    public void setQueryTask(Future<?> queryTask) {
    }

    @Override
    public void setSQL(String sql) {
    }

    @Override
    public boolean shouldInstallServices() {
        return true;
    }

    public UploadTable getUploadTable() {
        return this.uploadTable;
    }

    public UploadData getUploadData() {
        return this.uploadData;
    }

    @Override
    public int size() {
        return this.getRecIds().size();
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public int getMaxTableRows() {
        return -1;
    }

    @Override
    public void cacheFilled(Vector<Vector<Object>> cache) {
    }
}

