/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMatchSetting;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class UploadMatchSettingsPanel
extends JPanel
implements ActionListener {
    protected static final Logger log = Logger.getLogger(UploadMatchSettingsPanel.class);
    protected DefaultComboBoxModel modeTexts;
    protected DefaultComboBoxModel boolTexts;
    protected JLabel tblLbl;
    protected TableModel tblModel;
    protected JTable tblTbl;
    protected JButton applyBtn;
    protected JLabel caption;
    protected final Vector<UploadTable> tables;

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().getClass().equals(JComboBox.class)) {
            if (this.tblTbl.getEditingRow() != -1 && this.tblTbl.getEditingColumn() != -1) {
                JComboBox jbox = (JComboBox)action.getSource();
                this.tblTbl.getModel().setValueAt(jbox.getSelectedItem(), this.tblTbl.getEditingRow(), this.tblTbl.getEditingColumn());
            }
        } else if (action.getActionCommand().equals("APPLY")) {
            this.apply();
        }
    }

    public void refresh() {
        int row = 0;
        while (row < this.tables.size()) {
            UploadMatchSetting matchSet = this.tables.get(row).getMatchSetting();
            this.tblTbl.getModel().setValueAt(this.modeTexts.getElementAt(matchSet.getMode()).toString(), row, 1);
            this.tblTbl.getModel().setValueAt(Boolean.toString(matchSet.isRemember()), row, 2);
            ++row;
        }
    }

    public void apply() {
        int row = 0;
        while (row < this.tables.size()) {
            UploadMatchSetting matchSet = this.tables.get(row).getMatchSetting();
            matchSet.setMode(UploadMatchSetting.getMode(this.tblTbl.getModel().getValueAt(row, 1).toString()));
            matchSet.setRemember(Boolean.valueOf(this.tblTbl.getModel().getValueAt(row, 2).toString()));
            matchSet.setMatchEmptyValues(Boolean.valueOf(this.tblTbl.getModel().getValueAt(row, 3).toString()));
            log.debug((Object)"NOT setting fields to match!");
            ++row;
        }
    }

    public UploadMatchSettingsPanel(Vector<UploadTable> tables, boolean readOnly, boolean showApplyBtn) {
        this.setLayout(new BorderLayout());
        this.tables = new Vector<UploadTable>(new TreeSet<UploadTable>(tables));
        this.modeTexts = new DefaultComboBoxModel<String>(UploadMatchSetting.getModeTexts());
        this.boolTexts = new DefaultComboBoxModel();
        this.boolTexts.addElement(Boolean.toString(Boolean.TRUE));
        this.boolTexts.addElement(Boolean.toString(Boolean.FALSE));
        Vector<String> headers = new Vector<String>();
        headers.add(UIRegistry.getResourceString("SL_TABLES"));
        headers.add(UIRegistry.getResourceString("WB_MATCH_MODE_CAPTION"));
        headers.add(UIRegistry.getResourceString("WB_UPLOAD_MATCH_REMEMBER_CAPTION"));
        headers.add(UIRegistry.getResourceString("WB_UPLOAD_MATCH_BLANKS_CAPTION"));
        Vector rows = new Vector();
        for (UploadTable tbl : this.tables) {
            Vector<String> row = new Vector<String>();
            row.add(tbl.toString());
            row.add(this.modeTexts.getElementAt(tbl.getMatchSetting().getMode()).toString());
            row.add(Boolean.toString(tbl.getMatchSetting().isRemember()));
            row.add(Boolean.toString(tbl.getMatchSetting().isMatchEmptyValues()));
            rows.add(row);
        }
        if (readOnly) {
            this.tblModel = new DefaultTableModel(rows, headers){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
        } else {
            final UploadMatchSettingsPanel myself = this;
            this.tblModel = new DefaultTableModel(rows, headers){

                @Override
                public boolean isCellEditable(int row, int col) {
                    if (col >= 1 && col <= 3) {
                        JComboBox jBox = col == 1 ? UIHelper.createComboBox(UploadMatchSettingsPanel.this.modeTexts) : UIHelper.createComboBox(UploadMatchSettingsPanel.this.boolTexts);
                        jBox.addActionListener(myself);
                        UploadMatchSettingsPanel.this.tblTbl.setDefaultEditor(UploadMatchSettingsPanel.this.tblTbl.getColumnClass(col), new DefaultCellEditor(jBox));
                        return true;
                    }
                    return false;
                }
            };
        }
        this.tblTbl = new JTable(this.tblModel);
        Enumeration<TableColumn> cols = this.tblTbl.getColumnModel().getColumns();
        while (cols.hasMoreElements()) {
            TableColumn col = cols.nextElement();
            col.setPreferredWidth(new JLabel((String)((String)col.getHeaderValue())).getPreferredSize().width);
        }
        PanelBuilder pb = showApplyBtn ? new PanelBuilder(new FormLayout("2dlu, f:p:g, 2dlu", "2dlu, c:p, 2dlu, f:p:g, p, 2dlu")) : new PanelBuilder(new FormLayout("2dlu, f:p:g, 2dlu", "2dlu, c:p, 2dlu, f:p:g, 2dlu"));
        CellConstraints cc = new CellConstraints();
        this.caption = UIHelper.createLabel(String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SETTINGS")) + ":");
        this.caption.setFont(this.caption.getFont().deriveFont(1));
        pb.add((Component)this.caption, cc.xy(2, 2));
        JScrollPane sp = new JScrollPane(this.tblTbl, 20, 30);
        pb.add((Component)sp, cc.xy(2, 4));
        if (showApplyBtn) {
            this.applyBtn = UIHelper.createButton(UIRegistry.getResourceString("APPLY"));
            this.applyBtn.setActionCommand("APPLY");
            this.applyBtn.addActionListener(this);
            pb.add((Component)this.applyBtn, cc.xy(2, 6));
        } else {
            this.applyBtn = null;
        }
        this.add((Component)pb.getPanel(), "Center");
    }
}

