/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMatchSetting;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class UploadMatchSettingsBasicPanel
extends JPanel
implements ActionListener {
    protected static final Logger log = Logger.getLogger(UploadMatchSettingsBasicPanel.class);
    ToggleButtonChooserPanel<String> modePanel;
    JCheckBox rememberCheck;
    JCheckBox matchBlanksCheck;
    JButton advancedBtn;

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource() == this.advancedBtn) {
            log.debug((Object)"advanced");
        }
    }

    public UploadMatchSettingsBasicPanel() {
        PanelBuilder pb = new PanelBuilder(new FormLayout("2dlu, f:p:g, 5dlu", "2dlu, f:p:g, 8dlu, c:p, 2dlu, c:p, 3dlu"));
        CellConstraints cc = new CellConstraints();
        this.modePanel = new ToggleButtonChooserPanel<String>(UploadMatchSetting.getModeTexts(), UIRegistry.getResourceString("WB_MATCH_MODE_CAPTION"), ToggleButtonChooserPanel.Type.RadioButton);
        this.modePanel.createUI();
        this.modePanel.setOkBtn(UIHelper.createButton(""));
        pb.add(this.modePanel, cc.xy(2, 2));
        this.rememberCheck = UIHelper.createCheckBox(UIRegistry.getResourceString("WB_UPLOAD_MATCH_REMEMBER_CAPTION"));
        pb.add((Component)this.rememberCheck, cc.xy(2, 4));
        this.matchBlanksCheck = UIHelper.createCheckBox(UIRegistry.getResourceString("WB_UPLOAD_MATCH_BLANKS_CAPTION"));
        pb.add((Component)this.matchBlanksCheck, cc.xy(2, 6));
        this.add(pb.getPanel());
    }

    public void showSetting(UploadTable uploadTable) {
        this.modePanel.setSelectedObj(UploadMatchSetting.getModeText(uploadTable.getMatchSetting().getMode()));
        this.rememberCheck.setSelected(uploadTable.getMatchSetting().isRemember());
        this.matchBlanksCheck.setSelected(uploadTable.getMatchSetting().isMatchEmptyValues());
    }

    public void applySetting(UploadTable uploadTable) {
        uploadTable.getMatchSetting().setMode(UploadMatchSetting.getMode(this.modePanel.getSelectedObject()));
        uploadTable.getMatchSetting().setRemember(this.rememberCheck.isSelected());
        uploadTable.getMatchSetting().setMatchEmptyValues(this.matchBlanksCheck.isSelected());
    }

    public void applySettingToAll(List<UploadTable> uploadTables) {
        for (UploadTable ut : uploadTables) {
            this.applySetting(ut);
        }
    }
}

