/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.ui.UIRegistry;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UploadMatchSetting {
    protected static final Logger log = Logger.getLogger(UploadMatchSetting.class);
    public static final int ASK_MODE = 0;
    public static final int ADD_NEW_MODE = 1;
    public static final int PICK_FIRST_MODE = 2;
    public static final int SKIP_ROW_MODE = 3;
    protected int mode = 0;
    protected Vector<Integer> colsToMatch = new Vector();
    protected Vector<MatchSelection> selections = new Vector();
    protected TreeMap<String, MatchSelection> lookups = new TreeMap();
    protected boolean remember = true;
    protected boolean matchEmptyValues = true;

    public static Vector<String> getModeTexts() {
        Vector<String> result = new Vector<String>();
        result.addElement(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_ASK"));
        result.addElement(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_ADD"));
        result.addElement(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_FIRST"));
        result.addElement(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_SKIP_ROW"));
        return result;
    }

    public static String getModeText(int mode) {
        if (mode == 0) {
            return UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_ASK");
        }
        if (mode == 1) {
            return UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_ADD");
        }
        if (mode == 2) {
            return UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_FIRST");
        }
        if (mode == 3) {
            return UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_SKIP_ROW");
        }
        throw new RuntimeException("Unknown match mode.");
    }

    public static int getMode(String modeName) {
        if (modeName.equals(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_ASK"))) {
            return 0;
        }
        if (modeName.equals(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_ADD"))) {
            return 1;
        }
        if (modeName.equals(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_FIRST"))) {
            return 2;
        }
        if (modeName.equals(UIRegistry.getResourceString("WB_UPLOAD_MATCH_MODE_SKIP_ROW"))) {
            return 3;
        }
        return -1;
    }

    public void addSelection(MatchSelection selection) {
        this.selections.add(selection);
        if (this.remember || this.mode == 1) {
            this.lookups.put(selection.getRowValues(), selection);
        }
    }

    public String buildRowValues(Vector<UploadTable.MatchRestriction> rowVals) {
        StringBuilder result = new StringBuilder();
        for (UploadTable.MatchRestriction val : rowVals) {
            result.append(val.getFieldName());
            result.append("\t");
            result.append(val.getRestriction());
        }
        return result.toString();
    }

    public Object doLookup(Vector<UploadTable.MatchRestriction> values) {
        MatchSelection match = this.lookups.get(this.buildRowValues(values));
        if (match != null) {
            return match.getSelectionKeyId();
        }
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isRemember() {
        return this.remember;
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    public boolean isMatchEmptyValues() {
        return this.matchEmptyValues;
    }

    public void setMatchEmptyValues(boolean matchEmptyValues) {
        this.matchEmptyValues = matchEmptyValues;
    }

    public void clear() {
        this.lookups.clear();
        this.selections.clear();
    }

    public class MatchSelection {
        protected String rowValues;
        protected int rowNumber;
        protected Object selectionKeyId;
        protected int modeOfSelection;

        public MatchSelection(Vector<UploadTable.MatchRestriction> rowValues, int rowNumber, Object selectionKeyId, int mode) {
            this.rowValues = UploadMatchSetting.this.buildRowValues(rowValues);
            this.rowNumber = rowNumber;
            this.selectionKeyId = selectionKeyId;
            this.modeOfSelection = mode;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public String getRowValues() {
            return this.rowValues;
        }

        public Object getSelectionKeyId() {
            return this.selectionKeyId;
        }

        public int getModeOfSelection() {
            return this.modeOfSelection;
        }
    }
}

