/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.expresssearch.TableNameRenderer;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadInfoRenderable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableInvalidValue;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class UploadMainPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(UploadMainPanel.class);
    public static final String VALIDATE_CONTENT = "VALIDATE_CONTENT";
    public static final String DO_UPLOAD = "DO_UPLOAD";
    public static final String VIEW_UPLOAD = "VIEW_UPLOAD";
    public static final String VIEW_SETTINGS = "VIEW_SETTINGS";
    public static final String CLOSE_UI = "CLOSE_UI";
    public static final String CANCEL_OPERATION = "CANCEL_OPERATION";
    public static final String TBL_CLICK = "TBL_CLICK";
    public static final String TBL_DBL_CLICK = "TBL_DBL_CLICK";
    public static final String MSG_CLICK = "MSG_CLICK";
    public static final String UNDO_UPLOAD = "UNDO_UPLOAD";
    public static final String PRINT_INVALID = "PRINT_INVALID";
    protected JLabel uploadTblLbl;
    protected JList uploadTbls;
    protected JTable uploadTblTbl;
    protected JPanel uploadTblPanel;
    protected JLabel currOpLbl;
    protected JProgressBar currOpProgress;
    protected JButton validateContentBtn;
    protected JButton doUploadBtn;
    protected JButton viewSettingsBtn;
    protected JButton viewUploadBtn;
    protected JButton closeBtn;
    protected JButton cancelBtn;
    protected JButton undoBtn;
    protected JButton printBtn;
    protected JPanel msgPane;
    protected JLabel msgLbl;
    protected JList msgList;
    protected JList validationErrorList;
    protected JPanel validationErrorPanel;
    protected JScrollPane msgListSB;
    protected boolean isUpdateUpload;
    protected ActionListener listener = null;

    public UploadMainPanel(boolean isUpdateUpload) {
        this.isUpdateUpload = isUpdateUpload;
        this.buildUI();
    }

    protected void showValidationErrors() {
        CellConstraints cc = new CellConstraints();
        this.msgPane.remove(this.msgListSB);
        this.msgPane.add((Component)this.validationErrorPanel, cc.xy(1, 1));
        this.msgPane.add((Component)this.msgListSB, cc.xy(1, 2));
        this.msgPane.validate();
    }

    protected void hideValidationErrors() {
        CellConstraints cc = new CellConstraints();
        this.msgPane.remove(this.validationErrorPanel);
        this.msgPane.remove(this.msgListSB);
        this.msgPane.add((Component)this.msgListSB, cc.xywh(1, 1, 1, 2));
        this.msgPane.validate();
    }

    protected boolean isValidationErrorsVisible() {
        return this.validationErrorPanel.getParent() == this.msgPane;
    }

    public void showUploadTblList() {
        ((CardLayout)this.uploadTblPanel.getLayout()).first(this.uploadTblPanel);
    }

    public void showUploadTblTbl() {
        ((CardLayout)this.uploadTblPanel.getLayout()).last(this.uploadTblPanel);
    }

    public void addAffectedTables(Iterator<UploadInfoRenderable> uts) {
        DefaultListModel<UploadInfoRenderable> tbls = new DefaultListModel<UploadInfoRenderable>();
        Vector cells = new Vector();
        JList tableList = this.getUploadTbls();
        TableNameRenderer nameRender = new TableNameRenderer(IconManager.IconSize.Std24);
        nameRender.setUseIcon("PlaceHolder");
        tableList.setCellRenderer(nameRender);
        while (uts.hasNext()) {
            UploadInfoRenderable ut = uts.next();
            tbls.addElement(ut);
            Vector<UploadInfoRenderable> row = new Vector<UploadInfoRenderable>(2);
            row.add(ut);
            row.add(ut);
            if (this.isUpdateUpload) {
                row.add(ut);
            }
            cells.add(row);
        }
        tableList.setModel(tbls);
        Vector<String> heads = new Vector<String>(3);
        heads.add(UIRegistry.getResourceString("ERD_TABLE"));
        heads.add(UIRegistry.getResourceString("WB_UPLOAD_RECORDS_ADDED"));
        if (this.isUpdateUpload) {
            heads.add(UIRegistry.getResourceString("WB_UPLOAD_RECORDS_UPDATED"));
        }
        this.getUploadTblTbl().setModel(new DefaultTableModel(cells, heads));
        this.getUploadTblTbl().getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                UploadInfoRenderable ti = (UploadInfoRenderable)value;
                if (column == 0) {
                    ImageIcon icon = IconManager.getIcon(ti.getIconName(), IconManager.STD_ICON_SIZE);
                    this.setIcon(icon != null ? icon : IconManager.getIcon("Blank", IconManager.STD_ICON_SIZE));
                } else {
                    this.setIcon(null);
                }
                if (isSelected) {
                    this.setOpaque(true);
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
                this.setText(ti.getTitle());
                return this;
            }
        });
        DefaultTableCellRenderer colRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                UploadInfoRenderable ti = (UploadInfoRenderable)value;
                this.setIcon(null);
                if (isSelected) {
                    this.setOpaque(true);
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
                if (column == 1) {
                    if (ti.getCreatedCnt() != null) {
                        if (this.getHorizontalAlignment() != 0) {
                            this.setHorizontalAlignment(0);
                        }
                        this.setText(ti.getCreatedCnt().toString());
                    }
                } else if (column == 2) {
                    if (ti == null) {
                        return this;
                    }
                    if (ti.getUpdatedCnt() != null) {
                        if (this.getHorizontalAlignment() != 0) {
                            this.setHorizontalAlignment(0);
                        }
                        this.setText(ti.getUpdatedCnt().toString());
                    }
                }
                return this;
            }
        };
        this.getUploadTblTbl().getColumnModel().getColumn(1).setCellRenderer(colRenderer);
        if (this.isUpdateUpload) {
            this.getUploadTblTbl().getColumnModel().getColumn(2).setCellRenderer(colRenderer);
        }
    }

    public void buildUI() {
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("3dlu:none, fill:50dlu:grow(0.30), 20dlu:none, fill:50dlu:grow(0.70), 5dlu:none, r:max(50dlu;pref), 3dlu:none", "2dlu:none, fill:m:none, 4dlu:none, t:m:none, 2dlu:none, fill:75dlu:grow, 5dlu:none"));
        JLabel title = UIHelper.createLabel(UIRegistry.getResourceString("WB_UPLOAD_FORM_TITLE"));
        title.setFont(title.getFont().deriveFont(1));
        title.setHorizontalAlignment(2);
        this.add((Component)title, cc.xywh(2, 2, 5, 1));
        JPanel pPane = new JPanel((LayoutManager)new FormLayout("fill:pref:grow, fill:pref:none", "center:m:grow"));
        this.currOpProgress = UIHelper.createProgressBar();
        pPane.add((Component)this.currOpProgress, cc.xy(1, 1));
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_CANCEL"));
        this.cancelBtn.setActionCommand(CANCEL_OPERATION);
        pPane.add((Component)this.cancelBtn, cc.xy(2, 1));
        this.add((Component)pPane, cc.xywh(4, 2, 3, 1));
        this.add((Component)new JSeparator(0), cc.xywh(2, 3, 5, 1));
        this.uploadTblLbl = UIHelper.createLabel(UIRegistry.getResourceString("WB_UPLOAD_AFFECTED_TBLS_LIST"));
        this.add((Component)this.uploadTblLbl, cc.xy(2, 4));
        this.uploadTblPanel = new JPanel(new CardLayout());
        this.uploadTbls = new JList();
        JScrollPane sp = new JScrollPane(this.uploadTbls, 20, 31);
        this.uploadTblPanel.add((Component)sp, "list");
        this.uploadTblTbl = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.uploadTblTbl.setCellSelectionEnabled(false);
        sp = new JScrollPane(this.uploadTblTbl, 20, 30);
        this.uploadTblPanel.add((Component)sp, "table");
        this.add((Component)this.uploadTblPanel, cc.xy(2, 6));
        this.msgPane = new JPanel((LayoutManager)new FormLayout("fill:m:grow", "fill:pref:grow, fill:m:grow"));
        this.msgLbl = UIHelper.createLabel(UIRegistry.getResourceString("WB_UPLOAD_MSG_LIST"));
        this.add((Component)this.msgLbl, cc.xy(4, 4));
        this.msgList = new JList(new DefaultListModel()){

            @Override
            public String getToolTipText(MouseEvent event) {
                Point point = event.getPoint();
                int index = this.locationToIndex(point);
                return this.getModel().getElementAt(index).toString();
            }
        };
        this.msgListSB = new JScrollPane(this.msgList, 20, 31);
        this.msgPane.add((Component)this.msgListSB, cc.xywh(1, 1, 1, 2));
        this.validationErrorPanel = new JPanel(new BorderLayout());
        this.validationErrorList = new JList(new DefaultListModel()){

            @Override
            public String getToolTipText(MouseEvent event) {
                Point point = event.getPoint();
                int index = this.locationToIndex(point);
                return this.getModel().getElementAt(index).toString();
            }
        };
        this.validationErrorPanel.add((Component)new JScrollPane(this.validationErrorList, 20, 31), "Center");
        this.printBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_PRINT_MESSAGES_BTN"));
        this.printBtn.setActionCommand(PRINT_INVALID);
        JPanel pbtnPane = new JPanel((LayoutManager)new FormLayout("fill:m:grow, right:max(50dlu;pref)", "c:m"));
        pbtnPane.add((Component)this.printBtn, cc.xy(2, 1));
        this.validationErrorPanel.add((Component)pbtnPane, "South");
        this.add((Component)this.msgPane, cc.xy(4, 6));
        JPanel btnPane = new JPanel((LayoutManager)new FormLayout("f:max(50dlu;pref)", "c:m, c:m, c:m, c:m, c:m, c:m"));
        this.validateContentBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_VALIDATE_CONTENT_BTN"));
        this.validateContentBtn.setActionCommand(VALIDATE_CONTENT);
        this.viewSettingsBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_SETTINGS_BTN"));
        this.viewSettingsBtn.setActionCommand(VIEW_SETTINGS);
        this.doUploadBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_BTN"));
        this.doUploadBtn.setActionCommand(DO_UPLOAD);
        this.viewUploadBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_VIEW_BTN"));
        this.viewUploadBtn.setActionCommand(VIEW_UPLOAD);
        this.closeBtn = UIHelper.createButton(UIRegistry.getResourceString("CLOSE"));
        this.closeBtn.setActionCommand(CLOSE_UI);
        this.undoBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_UNDO_BTN"));
        this.undoBtn.setActionCommand(UNDO_UPLOAD);
        this.undoBtn.setVisible(!this.isUpdateUpload);
        btnPane.add((Component)this.validateContentBtn, cc.xy(1, 1));
        btnPane.add((Component)this.doUploadBtn, cc.xy(1, 2));
        btnPane.add((Component)this.viewUploadBtn, cc.xy(1, 3));
        btnPane.add((Component)this.viewSettingsBtn, cc.xy(1, 4));
        btnPane.add((Component)this.undoBtn, cc.xy(1, 5));
        btnPane.add((Component)this.closeBtn, cc.xy(1, 6));
        this.add((Component)btnPane, cc.xy(6, 6));
        this.uploadTbls.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    UploadMainPanel.this.uploadTblDblClick();
                }
                UploadMainPanel.this.uploadTblClick();
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }
        });
        this.msgList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                UploadMainPanel.this.msgClick(false);
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }
        });
        this.validationErrorList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                UploadMainPanel.this.msgClick(true);
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }
        });
    }

    protected void uploadTblDblClick() {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this.uploadTbls, 0, TBL_DBL_CLICK));
        }
    }

    protected void uploadTblClick() {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this.uploadTbls, 0, TBL_CLICK));
        }
    }

    protected void msgClick(boolean isValidationErrorMsg) {
        if (this.listener != null) {
            if (isValidationErrorMsg) {
                this.listener.actionPerformed(new ActionEvent(this.validationErrorList, 0, MSG_CLICK));
            } else {
                this.listener.actionPerformed(new ActionEvent(this.msgList, 0, MSG_CLICK));
            }
        }
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public JLabel getCurrOpLbl() {
        return this.currOpLbl;
    }

    public JProgressBar getCurrOpProgress() {
        return this.currOpProgress;
    }

    public JButton getDoUploadBtn() {
        return this.doUploadBtn;
    }

    public JList getMsgList() {
        return this.msgList;
    }

    public JLabel getUploadTblLbl() {
        return this.uploadTblLbl;
    }

    public JList getUploadTbls() {
        return this.uploadTbls;
    }

    public JButton getViewSettingsBtn() {
        return this.viewSettingsBtn;
    }

    public JButton getViewUploadBtn() {
        return this.viewUploadBtn;
    }

    public JButton getValidateContentBtn() {
        return this.validateContentBtn;
    }

    public JLabel getMsgLbl() {
        return this.msgLbl;
    }

    public JPanel getMsgPane() {
        return this.msgPane;
    }

    protected void setBtnListener(JButton btn, ActionListener listener) {
        if (btn != null) {
            btn.addActionListener(listener);
        } else {
            log.error((Object)"button object is null.");
        }
    }

    public void setActionListener(ActionListener listener) {
        this.listener = listener;
        this.setBtnListener(this.validateContentBtn, listener);
        this.setBtnListener(this.doUploadBtn, listener);
        this.setBtnListener(this.viewSettingsBtn, listener);
        this.setBtnListener(this.viewUploadBtn, listener);
        this.setBtnListener(this.closeBtn, listener);
        this.setBtnListener(this.cancelBtn, listener);
        this.setBtnListener(this.undoBtn, listener);
        this.setBtnListener(this.printBtn, listener);
    }

    public void addMsg(UploadMessage msg) {
        JList list;
        boolean isValErrMsg = false;
        if (msg instanceof UploadTableInvalidValue) {
            list = this.validationErrorList;
            isValErrMsg = true;
        } else {
            list = this.msgList;
        }
        ((DefaultListModel)list.getModel()).addElement(msg);
        if (isValErrMsg && !this.isValidationErrorsVisible()) {
            this.showValidationErrors();
        }
        list.ensureIndexIsVisible(list.getModel().getSize() - 1);
    }

    public void clearMsgs(Class<?>[] toClear) {
        DefaultListModel model1 = (DefaultListModel)this.msgList.getModel();
        DefaultListModel model2 = (DefaultListModel)this.validationErrorList.getModel();
        int c = 0;
        while (c < toClear.length) {
            int i = model1.getSize() - 1;
            while (i >= 0) {
                if (model1.getElementAt(i).getClass().equals(toClear[c])) {
                    model1.remove(i);
                }
                --i;
            }
            i = model2.getSize() - 1;
            while (i >= 0) {
                if (model2.getElementAt(i).getClass().equals(toClear[c])) {
                    model2.remove(i);
                }
                --i;
            }
            ++c;
        }
        if (model2.getSize() == 0) {
            this.hideValidationErrors();
        }
    }

    public void updateObjectsCreated() {
        this.showObjectsCreated(false);
    }

    public void clearObjectsCreated() {
        this.showObjectsCreated(true);
    }

    protected void showObjectsCreated(boolean clear) {
        DefaultListModel model = (DefaultListModel)this.uploadTbls.getModel();
        int i = model.getSize() - 1;
        while (i >= 0) {
            if (clear) {
                ((UploadInfoRenderable)model.getElementAt(i)).reset();
            }
            ((UploadInfoRenderable)model.getElementAt(i)).refresh();
            --i;
        }
        this.uploadTbls.repaint();
        this.uploadTblTbl.repaint();
    }

    public static void main(String[] args) {
        UploadMainPanel tf = new UploadMainPanel(false);
        tf.buildUI();
        DefaultListModel<String> tbls = new DefaultListModel<String>();
        tbls.addElement("CollectingEvent");
        tbls.addElement("Collection Object");
        tbls.addElement("Taxon");
        tf.getUploadTbls().setModel(tbls);
        DefaultListModel<String> invalids = new DefaultListModel<String>();
        invalids.addElement("good");
        invalids.addElement("dog");
        DefaultListModel<String> msgs = new DefaultListModel<String>();
        msgs.addElement("happy");
        msgs.addElement("man");
        tf.getMsgList().setModel(msgs);
        tf.getValidationErrorList().setModel(invalids);
        tf.getMsgPane().setVisible(invalids.size() > 0);
        tf.setActionListener(tf.new TesterThingy());
        tf.setVisible(true);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("A Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("flipper", 70);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UploadMainPanel.this.isValidationErrorsVisible()) {
                    UploadMainPanel.this.hideValidationErrors();
                } else {
                    UploadMainPanel.this.showValidationErrors();
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("list");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadMainPanel.this.showUploadTblList();
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("table");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadMainPanel.this.showUploadTblTbl();
            }
        });
        menu.add(menuItem);
        JFrame frm = new JFrame();
        frm.setPreferredSize(new Dimension(600, 400));
        frm.setContentPane(tf);
        frm.setJMenuBar(menuBar);
        frm.pack();
        frm.setVisible(true);
    }

    public ActionListener getListener() {
        return this.listener;
    }

    public void setListener(ActionListener listener) {
        this.listener = listener;
    }

    public JButton getUndoBtn() {
        return this.undoBtn;
    }

    public JButton getPrintBtn() {
        return this.printBtn;
    }

    public JList getValidationErrorList() {
        return this.validationErrorList;
    }

    public JPanel getValidationErrorPanel() {
        return this.validationErrorPanel;
    }

    public JTable getUploadTblTbl() {
        return this.uploadTblTbl;
    }

    public class TesterThingy
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(UploadMainPanel.DO_UPLOAD)) {
                System.out.println(UploadMainPanel.DO_UPLOAD);
            } else if (e.getActionCommand().equals(UploadMainPanel.VIEW_UPLOAD)) {
                System.out.println(UploadMainPanel.VIEW_UPLOAD);
            } else if (e.getActionCommand().equals(UploadMainPanel.VIEW_SETTINGS)) {
                System.out.println(UploadMainPanel.VIEW_SETTINGS);
            } else if (e.getActionCommand().equals(UploadMainPanel.CLOSE_UI)) {
                System.out.println(UploadMainPanel.CLOSE_UI);
            } else if (e.getActionCommand().equals(UploadMainPanel.CANCEL_OPERATION)) {
                System.out.println(UploadMainPanel.CANCEL_OPERATION);
            } else if (e.getActionCommand().equals(UploadMainPanel.TBL_DBL_CLICK)) {
                System.out.println(UploadMainPanel.TBL_DBL_CLICK);
            } else if (e.getActionCommand().equals(UploadMainPanel.MSG_CLICK)) {
                System.out.println(UploadMainPanel.MSG_CLICK);
            }
        }
    }
}

