/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgrCallerIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.ui.UIRegistry;
import java.net.InetAddress;
import javax.swing.JOptionPane;

public class UploadLocker
implements TaskSemaphoreMgrCallerIFace {
    protected final boolean canIgnore;
    protected final boolean canOverride;
    protected final boolean doLock;
    protected final Taskable task;

    public UploadLocker() {
        this.canIgnore = false;
        this.canOverride = false;
        this.doLock = false;
        this.task = null;
    }

    public UploadLocker(boolean canOverride, boolean canUnlock, Taskable task, boolean doLock) {
        this.canIgnore = canOverride;
        this.canOverride = canUnlock;
        this.doLock = doLock;
        this.task = task;
    }

    @Override
    public TaskSemaphoreMgr.USER_ACTION resolveConflict(SpTaskSemaphore semaphore, boolean previouslyLocked, String prevLockBy) {
        try {
            String msg;
            SpecifyUser currentUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
            SpecifyUser lockUser = semaphore.getOwner();
            boolean sameUser = currentUser.getId().equals(lockUser != null ? lockUser.getId() : null);
            String currMachineName = InetAddress.getLocalHost().toString();
            String lockMachineName = semaphore.getMachineName();
            boolean sameMachine = currMachineName.equals(lockMachineName);
            int defBtn = 0;
            int msgType = 1;
            int options = 0;
            Object[] optionLabels = new String[]{UIRegistry.getResourceString("OK")};
            Collection currCollection = AppContextMgr.getInstance().getClassObject(Collection.class);
            if (sameUser && sameMachine) {
                msg = this.task == null ? String.format(UIRegistry.getResourceString("UploadLocker.LockedByYou"), currCollection.getCollectionName()) : String.format(UIRegistry.getResourceString("UploadLocker.TaskUnavailable"), this.task.getTitle());
            } else {
                msg = String.format(UIRegistry.getResourceString("UploadLocker.LockedByUserMachine"), currCollection.getCollectionName(), lockUser.getIdentityTitle(), lockMachineName);
                if (this.task != null) {
                    msg = String.valueOf(msg) + String.format(UIRegistry.getResourceString("UploadLocker.TaskUnavailable"), this.task.getTitle(), Uploader.getLockTitle());
                }
            }
            msgType = 3;
            if (!this.doLock) {
                if (this.canIgnore && this.canOverride) {
                    options = 0;
                    optionLabels = new String[]{UIRegistry.getResourceString("UploadLocker.Exit"), UIRegistry.getResourceString("UploadLocker.Remove")};
                } else if (this.canIgnore) {
                    options = 0;
                    optionLabels = new String[]{UIRegistry.getResourceString("UploadLocker.Exit")};
                }
            } else if (this.doLock && this.canOverride) {
                options = 0;
                optionLabels = new String[]{UIRegistry.getResourceString("UploadLocker.Exit"), UIRegistry.getResourceString("UploadLocker.Override")};
            }
            int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), msg, UIRegistry.getResourceString("SpTaskSemaphore.IN_USE_TITLE"), options, msgType, null, optionLabels, defBtn);
            if (userChoice == 0) {
                return TaskSemaphoreMgr.USER_ACTION.Cancel;
            }
            if (userChoice == 1) {
                return TaskSemaphoreMgr.USER_ACTION.Override;
            }
            if (userChoice == 2) {
                return TaskSemaphoreMgr.USER_ACTION.Override;
            }
            return TaskSemaphoreMgr.USER_ACTION.Error;
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(UploadLocker.class, e);
            e.printStackTrace();
            return TaskSemaphoreMgr.USER_ACTION.Error;
        }
    }
}

