/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.expresssearch.TableNameRendererIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadedRecordInfo;
import edu.ku.brc.ui.UIRegistry;
import java.util.SortedSet;
import java.util.Vector;

public class UploadInfoRenderable
implements TableNameRendererIFace,
Comparable<UploadInfoRenderable> {
    protected Class<?> tblClass;
    protected String title;
    protected Integer createdCnt;
    protected Integer updatedCnt;
    protected boolean showCnt = false;
    protected boolean includeCreatedCntinTitle = false;
    UploadedRecordInfo dummy = new UploadedRecordInfo(null, null, -1, null, true, null, null);
    protected Vector<UploadTable> myTables;

    protected void refresh() {
        this.updatedCnt = 0;
        this.createdCnt = 0;
        for (UploadTable ut : this.myTables) {
            SortedSet<UploadedRecordInfo> ups = ut.getUploadedRecs();
            int updates = ups.headSet(this.dummy).size();
            this.createdCnt = this.createdCnt + updates;
            this.updatedCnt = this.updatedCnt + (ups.size() - updates);
        }
    }

    public UploadInfoRenderable(UploadTable ut) {
        this.tblClass = ut.getTblClass();
        this.title = ut.getTable().getTableInfo().getTitle();
        this.createdCnt = 0;
        this.updatedCnt = 0;
        this.myTables = new Vector();
        this.myTables.add(ut);
    }

    public void addTable(UploadTable ut) {
        this.myTables.add(ut);
    }

    @Override
    public String getIconName() {
        return this.tblClass.getSimpleName().toLowerCase();
    }

    @Override
    public String getTitle() {
        if (!this.showCnt || this.includeCreatedCntinTitle) {
            return this.title;
        }
        StringBuilder count = new StringBuilder(" (");
        count.append(this.createdCnt);
        count.append(" ");
        if (this.createdCnt == 1) {
            count.append(UIRegistry.getResourceString("WB_OBJECT_CREATED"));
        } else {
            count.append(UIRegistry.getResourceString("WB_OBJECTS_CREATED"));
        }
        count.append(")");
        return String.valueOf(this.title) + count.toString();
    }

    @Override
    public int compareTo(UploadInfoRenderable obj) {
        return this.title.compareTo(obj.getTitle());
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(UploadInfoRenderable.class)) {
            return false;
        }
        return this.compareTo((UploadInfoRenderable)obj) == 0;
    }

    public void setShowCnt(boolean showCnt) {
        this.showCnt = showCnt;
    }

    public String getTableName() {
        return this.tblClass.getSimpleName();
    }

    public Integer getCreatedCnt() {
        return this.createdCnt;
    }

    public Integer getUpdatedCnt() {
        return this.updatedCnt;
    }

    public void reset() {
        this.createdCnt = 0;
        this.updatedCnt = 0;
        this.setShowCnt(false);
    }
}

