/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.dbsupport.RecordTypeCodeBuilder;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import edu.ku.brc.specify.ui.db.PickListDBAdapterFactory;
import edu.ku.brc.specify.ui.db.PickListTableAdapter;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UploadField {
    protected static final Logger log = Logger.getLogger(UploadField.class);
    protected Field field;
    protected String value;
    protected Relationship relationship;
    protected int index;
    protected String wbFldName;
    protected Integer sequence = null;
    protected Boolean required = null;
    protected Method setter;
    protected Method getter = null;
    protected Map<String, PickListItemIFace> validValues = null;
    protected boolean readOnlyValidValues = false;
    protected boolean picklistWarn = false;
    protected boolean validValuesChecked = false;

    public final Method getSetter() {
        return this.setter;
    }

    public final void setSetter(Method setter) {
        this.setter = setter;
    }

    public final Method getGetter() {
        if (this.getter != null) {
            return this.getter;
        }
        if (this.setter == null) {
            return null;
        }
        Class<?> cls = this.setter.getDeclaringClass();
        try {
            String name = "get" + this.setter.getName().substring(3);
            this.getter = cls.getMethod(name, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return this.getter;
    }

    public UploadField(Field field, int index, String wbFldName, Relationship relationship) {
        this.field = field;
        this.index = index;
        this.wbFldName = wbFldName;
        this.relationship = relationship;
    }

    public String toString() {
        return String.valueOf(this.wbFldName) + ", " + String.valueOf(this.index) + ", " + this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean validate(String val) {
        return true;
    }

    public String getValueObject() {
        if (this.getValidValues() == null) {
            return this.getValue();
        }
        PickListItemIFace item = this.validValues.get(this.value);
        if (item != null) {
            Object valObj = item.getValueObject();
            if (valObj instanceof DataModelObjBase) {
                return this.value;
            }
            return valObj.toString();
        }
        if (!StringUtils.isBlank((String)this.value)) {
            if (this.readOnlyValidValues) {
                log.error((Object)("Invalid value '" + this.value + "' for field '" + this.wbFldName + "'"));
                return null;
            }
            return this.value;
        }
        return null;
    }

    public String getValue() {
        if (StringUtils.isEmpty((String)this.value)) {
            return null;
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public int getSequenceInt() {
        if (this.sequence == null) {
            return 0;
        }
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isRequired() {
        if (this.required != null) {
            return this.required;
        }
        if (this.field != null && this.field.getFieldInfo() != null) {
            return this.field.getFieldInfo().isRequired() || this.field.getFieldInfo().getTableInfo().getTableId() == 1 && this.field.getFieldInfo().getName().equalsIgnoreCase("catalogNumber") || this.field.getFieldInfo().getTableInfo().getTableId() == Locality.getClassTableId() && this.field.getFieldInfo().getName().equalsIgnoreCase("localityname");
        }
        return false;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public final String getWbFldName() {
        return this.wbFldName;
    }

    public Map<String, PickListItemIFace> getValidValues() {
        if (!this.validValuesChecked) {
            this.validValuesChecked = true;
            this.validValues = this.buildValidValues();
        }
        return this.validValues;
    }

    protected Map<String, PickListItemIFace> buildValidValues() {
        if (this.getIndex() != -1 && this.getField().getFieldInfo() != null) {
            PickListDBAdapterIFace pickList = null;
            pickList = !StringUtils.isEmpty((String)this.getField().getFieldInfo().getPickListName()) ? PickListDBAdapterFactory.getInstance().create(this.getField().getFieldInfo().getPickListName(), false) : (RecordTypeCodeBuilder.isTypeCodeField(this.getField().getFieldInfo()) ? RecordTypeCodeBuilder.getTypeCode(this.getField().getFieldInfo()) : this.checkForSpecialCasePicklist());
            if (pickList != null) {
                this.readOnlyValidValues = pickList.isReadOnly() && !(pickList instanceof PickListTableAdapter);
                this.picklistWarn = !this.readOnlyValidValues && pickList instanceof PickListTableAdapter;
                TreeMap<String, PickListItemIFace> pickListItems = new TreeMap<String, PickListItemIFace>(new Comparator<String>(){

                    @Override
                    public int compare(String arg0, String arg1) {
                        if (arg0 == null && arg1 == null) {
                            return 0;
                        }
                        if (arg0 == null) {
                            return 1;
                        }
                        if (arg1 == null) {
                            return -1;
                        }
                        return arg0.compareToIgnoreCase(arg1);
                    }
                });
                for (PickListItemIFace item : pickList.getList()) {
                    pickListItems.put(item.getTitle(), item);
                }
                return pickListItems;
            }
        }
        return null;
    }

    protected PickListDBAdapterIFace checkForSpecialCasePicklist() {
        PickListDBAdapterIFace pl;
        PickListDBAdapterIFace result = null;
        DBFieldInfo fldInfo = this.getField().getFieldInfo();
        if (fldInfo != null && fldInfo.getName().equals("name") && fldInfo.getTableInfo().getClassObj().equals(PrepType.class) && (pl = PickListDBAdapterFactory.getInstance().create(fldInfo.getTableInfo().getName(), false)) instanceof PickListTableAdapter) {
            result = pl;
        }
        return result;
    }

    public boolean isReadOnlyValidValues() {
        return this.readOnlyValidValues;
    }

    public boolean isPicklistWarn() {
        return this.picklistWarn;
    }
}

