/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDef;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class UploadData {
    Vector<UploadMappingDef> mappings;
    Vector<WorkbenchRow> wbRows;

    public UploadMappingDef getMapping(int m) {
        return this.mappings.get(m);
    }

    public WorkbenchRow getWbRow(int r) {
        return this.wbRows.get(r);
    }

    public String get(int row, int col) {
        return this.wbRows.get(row).getData(col);
    }

    public boolean isEmptyRow(int row) {
        if (row < 0 || row >= this.getRows()) {
            return true;
        }
        WorkbenchRow wbrow = this.getWbRow(row);
        int c = 0;
        while (c < this.getCols()) {
            if (!StringUtils.isBlank((String)wbrow.getData(c))) {
                return false;
            }
            ++c;
        }
        return true;
    }

    public int getRows() {
        return this.wbRows.size();
    }

    public int getCols() {
        return this.mappings.size();
    }

    public UploadData(Vector<UploadMappingDef> mappings, Vector<WorkbenchRow> wbRows) {
        this.mappings = mappings;
        this.wbRows = wbRows != null ? wbRows : new Vector();
    }

    public void refresh(Vector<WorkbenchRow> freshRows) {
        this.wbRows = freshRows;
    }

    public int indexOfWbFldName(String wbFldName) {
        if (this.wbRows.size() > 0) {
            for (WorkbenchDataItem wbdi : this.wbRows.get(0).getWorkbenchDataItems()) {
                if (!wbdi.getWorkbenchTemplateMappingItem().getCaption().equals(wbFldName)) continue;
                return wbdi.getColumnNumber().shortValue();
            }
        }
        return -1;
    }
}

