/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import java.util.Vector;

public class UniquenessChecker {
    protected TreeMap<Integer, String> map = new TreeMap();

    public void clear() {
        this.map.clear();
    }

    public Vector<Integer> setValue(int row, String value, boolean check) {
        this.map.put(row, value);
        if (check) {
            return this.checkValues(row, row);
        }
        return null;
    }

    public boolean checkValue(int row, Vector<String> sortedValues) {
        int idx;
        String value = this.map.get(row);
        int currIdx = idx = Collections.binarySearch(sortedValues, value);
        if (--currIdx >= 0 && sortedValues.get(currIdx).equals(value)) {
            return true;
        }
        currIdx = idx + 1;
        return currIdx < sortedValues.size() && sortedValues.get(currIdx++).equals(value);
    }

    public Vector<Integer> checkValues(int[] rows) {
        return this.checkValues(-1, -1, rows);
    }

    public Vector<Integer> checkValues(int startRow, int endRow) {
        return this.checkValues(startRow, endRow, null);
    }

    public Vector<Integer> checkValues(int startRow, int endRow, int[] rows) {
        Vector<Integer> result = new Vector<Integer>();
        Collection<String> valuesColl = this.map.values();
        Vector<String> values = new Vector<String>(valuesColl);
        Collections.sort(values);
        if (rows == null) {
            int row = startRow;
            while (row <= endRow) {
                if (this.checkValue(row, values)) {
                    result.add(row);
                }
                ++row;
            }
        } else {
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                Integer row = nArray[n2];
                if (this.checkValue(row, values)) {
                    result.add(row);
                }
                ++n2;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        UniquenessChecker uc = new UniquenessChecker();
        int i = 0;
        while (i < 2000000) {
            uc.setValue(i, String.valueOf(i), false);
            ++i;
        }
        System.out.println(uc.setValue(50, "4", true));
        System.out.println(uc.setValue(500, "4", true));
        System.out.println(uc.setValue(5000, "4", true));
        System.out.println(uc.setValue(50000, "4", true));
        System.out.println(uc.setValue(500000, "4", true));
        System.out.println(uc.setValue(123, "bash", true));
        Vector<Integer> duped = uc.checkValues(0, 1999999);
        for (Integer dupe : duped) {
            System.out.println(dupe);
        }
        int[] checkees = new int[]{4, 50, 500, 5000, 50000, 500000, 666, 52, 37, 99};
        duped = uc.checkValues(checkees);
        System.out.println();
        for (Integer dupe : duped) {
            System.out.println(dupe);
        }
    }
}

