/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.TreeMapElement;
import java.util.Vector;

public class TreeMapElements {
    final Vector<TreeMapElement> elements;

    protected boolean validateRank() {
        if (this.size() > 0) {
            int rank = this.elements.get(0).getRank();
            for (TreeMapElement tme : this.elements) {
                if (tme.getRank() == rank) continue;
                return false;
            }
        }
        return true;
    }

    public TreeMapElements(Vector<TreeMapElement> elements) throws Exception {
        this.elements = elements;
        if (!this.validateRank()) {
            throw new Exception("TreeMapElements: inconsistent ranks");
        }
    }

    public TreeMapElement getElement(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements != null ? this.elements.size() : 0;
    }

    public int getMaxSeq() {
        if (this.size() == 0) {
            return -1;
        }
        int result = -1;
        for (TreeMapElement tme : this.elements) {
            if (tme.getSequence() <= result) continue;
            result = tme.getSequence();
        }
        return result;
    }

    public int getRank() {
        if (this.size() == 0) {
            return -1;
        }
        return this.elements.get(0).getRank();
    }

    public String getWbFldName() {
        if (this.size() == 0) {
            return null;
        }
        return this.elements.get(0).getWbFldName();
    }

    public boolean[] getSeqs() {
        if (this.size() == 0) {
            return null;
        }
        boolean[] result = new boolean[this.getMaxSeq() + 1];
        int i = 0;
        while (i <= this.getMaxSeq()) {
            result[i] = false;
            ++i;
        }
        for (TreeMapElement tme : this.elements) {
            result[tme.getSequence().intValue()] = true;
        }
        return result;
    }

    public boolean isRequired() {
        if (this.size() == 0) {
            return false;
        }
        return this.elements.get(0).isRequired();
    }
}

