/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RelatedClassSetter {
    protected static final Logger log = Logger.getLogger(RelatedClassSetter.class);
    protected final UploadTable uploadTbl;
    protected Class<?> relatedClass;
    protected String fieldName;
    protected Vector<Object> defaultIds = new Vector();
    protected Vector<Object> defaultObjs = new Vector();
    protected Method setter;
    protected String propertyName;

    protected RelatedClassSetter(UploadTable uploadTbl, Class<?> relatedClass, String fieldName, Object defaultId, Object defaultObj, Method setter) {
        this.uploadTbl = uploadTbl;
        this.relatedClass = relatedClass;
        this.fieldName = fieldName;
        this.defaultIds.add(defaultId);
        this.defaultObjs.add(defaultObj);
        this.setter = setter;
        this.propertyName = this.setter.getName().startsWith("set") ? UploadTable.deCapitalize(this.setter.getName().substring(3)) : UploadTable.deCapitalize(this.setter.getName());
    }

    public Object getDefaultId(int idx) {
        return this.defaultIds.get(this.adjustIdx(idx));
    }

    public Object getDefaultId() {
        return this.getDefaultId(0);
    }

    public void setDefaultId(Object defaultId, int idx) {
        while (this.defaultIds.size() <= idx) {
            this.defaultIds.add(null);
            this.defaultObjs.add(null);
        }
        this.defaultIds.set(idx, defaultId);
        this.defaultObjs.set(idx, null);
    }

    public void setDefaultId(Object defaultId) {
        this.setDefaultId(defaultId, 0);
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public final Class<?> getRelatedClass() {
        return this.relatedClass;
    }

    public final Method getSetter() {
        return this.setter;
    }

    private Method getSessionGetMethod() {
        Method[] meths;
        Method[] methodArray = meths = DataProviderSessionIFace.class.getMethods();
        int n = meths.length;
        int n2 = 0;
        while (n2 < n) {
            Method result = methodArray[n2];
            if (result.getName().equals("get") && result.getParameterTypes().length == 2) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    protected int getSettings() {
        return this.defaultIds.size();
    }

    protected Object getSetDefault(int idx) {
        return this.defaultObjs.get(this.adjustIdx(idx));
    }

    protected int adjustIdx(int idx) {
        int index = idx;
        if (index >= this.getSettings()) {
            index = 0;
            if (this.getSettings() > 1) {
                log.error((Object)"invalid idx for defaultObj");
            }
        }
        return index;
    }

    public Object getDefaultObj(int idx) throws UploaderException {
        block9: {
            if (this.getDefaultId(idx) != null && this.getSetDefault(idx) == null) {
                DataProviderSessionIFace objSession = DataProviderFactory.getInstance().createSession();
                Method getMethod = this.getSessionGetMethod();
                if (getMethod != null) {
                    Class<?> keyClass = getMethod.getParameterTypes()[1];
                    try {
                        try {
                            Object[] args = new Object[]{this.relatedClass, keyClass.cast(this.getDefaultId(idx))};
                            this.defaultObjs.set(this.adjustIdx(idx), getMethod.invoke((Object)objSession, args));
                            if (this.getDefaultObj(idx) == null) {
                                throw new UploaderException("Object with id " + this.getDefaultId(idx).toString() + " does not exist.", 20);
                            }
                            break block9;
                        }
                        catch (IllegalAccessException iaEx) {
                            throw new UploaderException(iaEx, 20);
                        }
                        catch (InvocationTargetException itEx) {
                            throw new UploaderException(itEx, 20);
                        }
                    }
                    finally {
                        objSession.close();
                    }
                }
                throw new UploaderException("Could not find DataProviderSessionIFace.get method.", 20);
            }
        }
        return this.getSetDefault(idx);
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final UploadTable getUploadTbl() {
        return this.uploadTbl;
    }

    protected Discipline getDiscipline() throws UploaderException {
        Discipline discipline;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                DataModelObjBase temp = AppContextMgr.getInstance().getClassObject(Discipline.class);
                discipline = (Discipline)session.get(temp.getDataClass(), temp.getId());
            }
            catch (Exception ex) {
                throw new UploaderException(ex, 20);
            }
        }
        finally {
            session.close();
        }
        return discipline;
    }

    protected Collection getCollection() throws UploaderException {
        Collection collection;
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            try {
                DataModelObjBase temp = AppContextMgr.getInstance().getClassObject(Collection.class);
                collection = (Collection)session.get(temp.getDataClass(), temp.getId());
            }
            catch (Exception ex) {
                throw new UploaderException(ex, 20);
            }
        }
        finally {
            session.close();
        }
        return collection;
    }

    public boolean defaultSetting() throws UploaderException {
        if (this.relatedClass.equals(Discipline.class)) {
            this.setDefaultId(this.getDiscipline().getDisciplineId());
            return true;
        }
        if (this.relatedClass.equals(Collection.class)) {
            this.setDefaultId(this.getCollection().getCollectionId());
            return true;
        }
        if (this.relatedClass.equals(Division.class)) {
            this.setDefaultId(this.getDiscipline().getDivision().getId());
            return true;
        }
        log.debug((Object)("unable to meet requirement: " + this.getUploadTbl().getTblClass().getSimpleName() + "<->" + this.getRelatedClass().getSimpleName()));
        return false;
    }

    public boolean isDefined() {
        return this.defaultObjs.size() > 0 && this.defaultObjs.get(0) != null || this.getDefaultId(0) != null;
    }

    public void refresh(Object data) {
    }

    public static RelatedClassSetter createRelatedClassSetter(UploadTable uploadTbl, Class<?> relatedClass, String fieldName, Object defaultId, Object defaultObj, Method setter, int count) {
        return new RelatedClassSetter(uploadTbl, relatedClass, fieldName, defaultObj, defaultId, setter);
    }
}

