/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DefaultFieldEntry;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.RelatedClassSetter;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class MissingDataResolver
implements ActionListener {
    protected static final Logger log = Logger.getLogger(MissingDataResolver.class);
    protected Vector<RelatedClassSetter> missingClasses;
    protected Vector<DefaultFieldEntry> missingFlds;
    protected Vector<ComboBoxModel> lists;
    protected ActionListener myself;
    protected Vector<Object> tblObjects;
    protected JTable uiTbl;

    @Override
    public void actionPerformed(ActionEvent a) {
        if (a.getActionCommand().equals("DEFAULTS")) {
            try {
                this.setDefaults();
            }
            catch (UploaderException ex) {
                UIRegistry.showError(ex.getLocalizedMessage());
            }
            this.uiTbl.setModel(this.bldModel(false));
        } else if (a.getSource().getClass().equals(JComboBox.class)) {
            JComboBox jbox = (JComboBox)a.getSource();
            this.setFldOrClass(jbox.getSelectedItem());
        }
    }

    protected void setFldOrClass(Object lblObj) {
        Object obj = this.tblObjects.get(this.uiTbl.getSelectedRow());
        LabelledObject valToSet = (LabelledObject)lblObj;
        if (obj.getClass().equals(DefaultFieldEntry.class)) {
            ((DefaultFieldEntry)obj).setDefaultValue(valToSet.getSecond());
        } else if (obj.getClass().equals(RelatedClassSetter.class)) {
            ((RelatedClassSetter)obj).setDefaultId(valToSet.getSecond());
        }
    }

    protected void setDefaults() throws UploaderException {
        this.setDefaultFlds();
        this.setDefaultClasses();
    }

    protected void setDefaultFlds() {
        for (DefaultFieldEntry dfe : this.missingFlds) {
            this.meetFldRequirement(dfe);
        }
    }

    protected void setDefaultClasses() throws UploaderException {
        for (RelatedClassSetter rce : this.missingClasses) {
            if (rce.isDefined()) continue;
            rce.defaultSetting();
        }
    }

    public MissingDataResolver(Vector<RelatedClassSetter> missingClasses, Vector<DefaultFieldEntry> missingFlds) throws UploaderException {
        this.missingClasses = missingClasses;
        this.missingFlds = missingFlds;
        this.tblObjects = new Vector(this.missingClasses.size() + this.missingFlds.size());
        this.setDefaults();
    }

    public boolean resolve(boolean readOnly) {
        this.showUI(readOnly);
        return this.isResolved();
    }

    public boolean isResolved() {
        return this.missingClassesResolved() && this.missingFldsResolved();
    }

    protected Vector<Pair<String, Object>> getReqClassChcs(RelatedClassSetter rce) {
        Vector<Pair<String, Object>> result = new Vector<Pair<String, Object>>();
        StringBuilder hql = new StringBuilder("from ");
        hql.append(rce.getRelatedClass().getSimpleName());
        DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
        try {
            for (DataModelObjBase nextObj : session.createQuery(hql.toString(), false).list()) {
                result.add(new LabelledObject<String, Integer>(nextObj.toString(), nextObj.getId()));
            }
        }
        finally {
            session.close();
        }
        return result;
    }

    protected String getTextForTypeCode(String fldName, Byte code) {
        if (fldName.equalsIgnoreCase("agenttype")) {
            switch (code) {
                case 3: {
                    return "Group";
                }
                case 0: {
                    return "Organization";
                }
                case 2: {
                    return "Other";
                }
                case 1: {
                    return "Person";
                }
            }
        } else if (fldName.equalsIgnoreCase("referenceworktype")) {
            switch (code) {
                case 0: {
                    return "Book";
                }
                case 1: {
                    return "Electronic Media";
                }
                case 2: {
                    return "Paper";
                }
                case 3: {
                    return "Technical Report";
                }
                case 4: {
                    return "Thesis";
                }
                case 5: {
                    return "Section in Book";
                }
            }
        }
        return code.toString();
    }

    protected Vector<Byte> getValsForTypeFld(String fldName) {
        Vector<Byte> result = new Vector<Byte>();
        if (fldName.equalsIgnoreCase("agenttype")) {
            result.add(new Byte(3));
            result.add(new Byte(0));
            result.add(new Byte(2));
            result.add(new Byte(1));
        } else if (fldName.equalsIgnoreCase("referenceworktype")) {
            result.add(Byte.valueOf("0"));
            result.add(Byte.valueOf("1"));
            result.add(Byte.valueOf("2"));
            result.add(Byte.valueOf("3"));
            result.add(Byte.valueOf("4"));
            result.add(Byte.valueOf("5"));
        }
        return result;
    }

    protected boolean isTypeFld(String fldName) {
        return fldName.equalsIgnoreCase("ReferenceWorkType") || fldName.equalsIgnoreCase("AgentType");
    }

    protected Vector<LabelledObject<String, Object>> getTypeFldChcs(String fldName) {
        Vector<LabelledObject<String, Object>> result = new Vector<LabelledObject<String, Object>>();
        for (Byte val : this.getValsForTypeFld(fldName)) {
            result.add(new LabelledObject<String, Byte>(this.getTextForTypeCode(fldName, val), val));
        }
        return result;
    }

    protected Vector<LabelledObject<String, Object>> getReqFldChcs(DefaultFieldEntry dfe) {
        if (this.isTypeFld(dfe.getFldName())) {
            return this.getTypeFldChcs(dfe.getFldName());
        }
        Vector<LabelledObject<String, Object>> result = new Vector<LabelledObject<String, Object>>();
        if (dfe.getUploadTbl().getTblClass() == PrepType.class) {
            if (dfe.getFldName().equalsIgnoreCase("IsLoanable")) {
                result.add(new LabelledObject<String, Boolean>(String.valueOf(Boolean.FALSE), new Boolean(false)));
                result.add(new LabelledObject<String, Boolean>(String.valueOf(Boolean.TRUE), new Boolean(true)));
            }
        } else if (dfe.getUploadTbl().getTblClass() == AccessionAgent.class) {
            if (dfe.getFldName().equalsIgnoreCase("Role")) {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    for (Object nextOne : session.createQuery("from picklistitem where picklistid = 15", false).list()) {
                        result.add(new LabelledObject<String, String>(nextOne.toString(), nextOne.toString()));
                    }
                }
                finally {
                    session.close();
                }
            }
        } else {
            log.error((Object)("unable to find default valid values for " + dfe.getUploadTbl().getTblClass().getSimpleName() + "." + dfe.getFldName()));
        }
        return result;
    }

    protected boolean meetFldRequirement(DefaultFieldEntry dfe) {
        if (dfe.getUploadTbl().getTblClass() == Agent.class && dfe.getFldName().equalsIgnoreCase("agenttype")) {
            log.debug((Object)"setting Agent.AgentType to 1");
            Object[] options = new Object[]{new Byte(1), new Byte(0), new Byte(3), new Byte(2)};
            dfe.setValues(options);
            return true;
        }
        if (dfe.getUploadTbl().getTblClass() == PrepType.class && dfe.getFldName().equalsIgnoreCase("IsLoanable")) {
            log.debug((Object)"setting PrepType.IsLoanable to true");
            dfe.setDefaultValue(true);
            return true;
        }
        if (dfe.getUploadTbl().getTblClass() == AccessionAgent.class && dfe.getFldName().equalsIgnoreCase("Role")) {
            log.debug((Object)"setting AccessionAgent.Role to \"Receiver\"");
            dfe.setDefaultValue("Receiver");
            return true;
        }
        if (dfe.getUploadTbl().getTblClass() == ReferenceWork.class && dfe.getFldName().equalsIgnoreCase("ReferenceWorkType")) {
            log.debug((Object)"setting ReferenceWork.ReferenceWorkType to 1");
            dfe.setDefaultValue(new Byte("1"));
            return true;
        }
        if (dfe.getUploadTbl().getTblClass() == Determination.class && dfe.getFldName().equalsIgnoreCase("IsCurrent")) {
            log.debug((Object)"setting IsCurrent to true");
            dfe.setDefaultValue(true);
            return true;
        }
        if (dfe.getUploadTbl().getTblClass() == Locality.class && dfe.getFldName().equalsIgnoreCase("SrcLatLongUnit")) {
            log.debug((Object)"setting SrcLatLongUnit to 0");
            dfe.setDefaultValue(new Byte("0"));
            return true;
        }
        if (CollectionMember.class.isAssignableFrom(dfe.getUploadTbl().getTblClass())) {
            if (AppContextMgr.getInstance().getClassObject(Collection.class) != null) {
                dfe.setDefaultValue(AppContextMgr.getInstance().getClassObject(Collection.class).getCollectionId());
                return true;
            }
            log.error((Object)"No default Collection has been set!");
        }
        log.error((Object)("unable to meet requirement: " + dfe.getUploadTbl().getTblClass().getSimpleName() + "." + dfe.getFldName()));
        return false;
    }

    protected String commaList(Vector<String> items) {
        StringBuilder result = new StringBuilder();
        for (String item : items) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(item);
        }
        return result.toString();
    }

    protected TableModel bldModel(boolean readOnly) {
        LabelledObject currChc;
        Vector<Pair<String, Object>> chcs;
        DefaultComboBoxModel<LabelledObject> list;
        Vector<String> row;
        Vector<String> headers = new Vector<String>();
        headers.add("Columns");
        headers.add("Data Type");
        headers.add("Data");
        headers.add("Value");
        this.lists = new Vector();
        Vector rows = new Vector();
        for (RelatedClassSetter rce : this.missingClasses) {
            row = new Vector<String>(4);
            row.add(this.commaList(rce.getUploadTbl().getWbFldNames()));
            row.add(rce.getUploadTbl().getTable().getName());
            row.add(rce.getFieldName());
            if (rce.getDefaultId() == null) {
                row.add("<undefined>");
            } else {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                DataModelObjBase rec = (DataModelObjBase)session.get(rce.getRelatedClass(), (Integer)rce.getDefaultId());
                if (rec != null) {
                    row.add(rec.toString());
                } else {
                    row.add(rce.getDefaultId().toString());
                }
            }
            rows.add(row);
            this.tblObjects.add(rce);
            list = new DefaultComboBoxModel<LabelledObject>();
            chcs = this.getReqClassChcs(rce);
            currChc = null;
            for (LabelledObject labelledObject : chcs) {
                list.addElement(labelledObject);
                if (rce.getDefaultId() == null || !rce.getDefaultId().equals(labelledObject.getSecond())) continue;
                currChc = labelledObject;
            }
            if (currChc != null) {
                list.setSelectedItem(currChc);
            }
            this.lists.add(list);
        }
        for (DefaultFieldEntry dfe : this.missingFlds) {
            row = new Vector(4);
            row.add(this.commaList(dfe.getUploadTbl().getWbFldNames()));
            row.add(dfe.getUploadTbl().getTable().getName());
            row.add(dfe.getFldName());
            if (dfe.getDefaultValue(new Object[0]) == null || dfe.getDefaultValue(new Object[0]) == null) {
                row.add("<undefined>");
            } else if (this.isTypeFld(dfe.getFldName())) {
                row.add(this.getTextForTypeCode(dfe.getFldName(), (Byte)dfe.getDefaultValue(new Object[0])));
            } else {
                row.add(dfe.getDefaultValue(new Object[0]).toString());
            }
            rows.add(row);
            this.tblObjects.add(dfe);
            list = new DefaultComboBoxModel();
            chcs = this.getReqFldChcs(dfe);
            currChc = null;
            for (LabelledObject labelledObject : chcs) {
                list.addElement(labelledObject);
                if (dfe.getDefaultValue(new Object[0]) == null || !dfe.getDefaultValue(new Object[0]).equals(labelledObject.getSecond())) continue;
                currChc = labelledObject;
            }
            if (currChc != null) {
                list.setSelectedItem(currChc);
            }
            this.lists.add(list);
        }
        this.myself = this;
        if (readOnly) {
            return new DefaultTableModel(rows, headers){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            };
        }
        return new DefaultTableModel(rows, headers){

            @Override
            public boolean isCellEditable(int row, int col) {
                JComboBox jBox = UIHelper.createComboBox(MissingDataResolver.this.lists.get(row));
                jBox.addActionListener(MissingDataResolver.this.myself);
                MissingDataResolver.this.uiTbl.setDefaultEditor(MissingDataResolver.this.uiTbl.getColumnClass(col), new DefaultCellEditor(jBox));
                return col == 3;
            }
        };
    }

    public JPanel getUI(boolean readOnly) {
        JPanel mainPane = new JPanel(new BorderLayout());
        if (!readOnly) {
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p", "p"));
            JButton defBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_DEFAULTS_BTN"));
            defBtn.setActionCommand("DEFAULTS");
            defBtn.addActionListener(this);
            pb.add((Component)defBtn, cc.xy(2, 1));
            mainPane.add((Component)pb.getPanel(), "South");
        }
        this.uiTbl = new JTable(this.bldModel(readOnly));
        this.uiTbl.getSelectionModel().setSelectionMode(0);
        this.uiTbl.setDefaultEditor(this.uiTbl.getColumnClass(3), new DefaultCellEditor(UIHelper.createComboBox()));
        this.uiTbl.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    JTable tbl = (JTable)me.getSource();
                    int rowNum = tbl.getSelectedRow();
                    log.debug((Object)(tbl.getModel().getValueAt(rowNum, 0) + "." + tbl.getModel().getValueAt(rowNum, 1)));
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent me) {
            }
        });
        mainPane.add((Component)new JScrollPane(this.uiTbl), "Center");
        return mainPane;
    }

    protected boolean showUI(boolean readOnly) {
        if (this.missingClasses.size() == 0 && this.missingFlds.size() == 0) {
            return true;
        }
        JPanel mainPane = this.getUI(readOnly);
        CustomDialog cwin = !readOnly ? new CustomDialog(null, "Missing Data", true, mainPane) : new CustomDialog(null, "Missing Data", true, 1, mainPane, 1);
        cwin.setModal(true);
        UIHelper.centerAndShow(cwin);
        boolean result = !cwin.isCancelled();
        cwin.dispose();
        return result;
    }

    protected boolean missingClassesResolved() {
        for (RelatedClassSetter rce : this.missingClasses) {
            if (rce.isDefined()) continue;
            return false;
        }
        return true;
    }

    protected boolean missingFldsResolved() {
        for (DefaultFieldEntry dfe : this.missingFlds) {
            if (dfe.isDefined()) continue;
            return false;
        }
        return true;
    }

    private class LabelledObject<F, S>
    extends Pair<F, S> {
        @Override
        public String toString() {
            return this.first.toString();
        }

        public LabelledObject(F first, S second) {
            super(first, second);
        }
    }
}

