/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.ViewBasedDisplayDialog;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMatchSettingsBasicPanel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderMatchSkipException;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class MatchHandler {
    protected static final Logger log = Logger.getLogger(MatchHandler.class);
    protected final UploadTable uploadTable;
    protected CustomDialog matchDlg;
    protected CustomDialog settingDlg;
    protected JList matchesList;
    protected JButton viewBtn;

    public MatchHandler(UploadTable uploadTable) {
        this.uploadTable = uploadTable;
    }

    public DataModelObjBase dealWithMultipleMatches(List<DataModelObjBase> matches, Vector<UploadTable.MatchRestriction> restrictedVals, int recNum) throws UploaderException {
        if (this.uploadTable.getMatchSetting().getMode() == 2) {
            return matches.get(0);
        }
        if (this.uploadTable.getMatchSetting().getMode() == 3) {
            throw new UploaderMatchSkipException(UploaderMatchSkipException.makeMsg(restrictedVals, this.uploadTable.getUploadFields().get(recNum).size(), Uploader.getCurrentUpload().getRow()), matches, Uploader.getCurrentUpload().getRow(), this.uploadTable);
        }
        if (this.uploadTable.getMatchSetting().isRemember() || this.uploadTable.getMatchSetting().getMode() == 1) {
            Object key = this.uploadTable.getMatchSetting().doLookup(restrictedVals);
            if (this.uploadTable.getMatchSetting().getMode() == 1 && key == null) {
                this.uploadTable.onAddNewMatch(restrictedVals);
                return null;
            }
            if (key != null) {
                for (DataModelObjBase match : matches) {
                    if (!key.equals(match.getId())) continue;
                    return match;
                }
                log.error((Object)"WB values matched previous selection, but no matching database object was found.");
            }
        }
        JPanel pane = new JPanel(new BorderLayout());
        JPanel matchedPane = new JPanel(new BorderLayout());
        JLabel matchedLbl = UIHelper.createLabel(UIRegistry.getResourceString("WB_UPLOAD_MATCHED_CELLS"));
        matchedLbl.setFont(matchedLbl.getFont().deriveFont(1));
        matchedLbl.setBorder(new EmptyBorder(3, 1, 3, 0));
        matchedPane.add((Component)matchedLbl, "North");
        Vector<String> headers = new Vector<String>(restrictedVals.size());
        for (UploadTable.MatchRestriction val : restrictedVals) {
            headers.add(val.getFieldName());
        }
        Vector matchedVec = new Vector(1);
        Vector<String> row = new Vector<String>(restrictedVals.size());
        int v = 0;
        while (v < restrictedVals.size()) {
            String val = restrictedVals.get(v).getRestriction();
            if (val.equals(this.uploadTable.getNullRestrictionText())) {
                val = "";
            }
            row.add(val);
            ++v;
        }
        matchedVec.add(row);
        JTable matchedTbl = new JTable(matchedVec, headers);
        JScrollPane scrollPane = new JScrollPane(matchedTbl);
        JPanel corner = new JPanel();
        scrollPane.setCorner("UPPER_LEFT_CORNER", corner);
        TableColumn column = matchedTbl.getColumnModel().getColumn(0);
        TableCellRenderer renderer = matchedTbl.getTableHeader().getDefaultRenderer();
        if (renderer == null) {
            column = matchedTbl.getColumnModel().getColumn(0);
            renderer = column.getHeaderRenderer();
        }
        Component cellRenderComp = renderer.getTableCellRendererComponent(matchedTbl, column.getHeaderValue(), false, false, -1, 0);
        Font cellFont = cellRenderComp.getFont();
        Border cellBorder = (Border)UIManager.getDefaults().get("TableHeader.cellBorder");
        Insets insets = cellBorder.getBorderInsets(matchedTbl.getTableHeader());
        FontMetrics metrics = matchedTbl.getFontMetrics(cellFont);
        int rowHeight = insets.bottom + metrics.getHeight() + insets.top;
        int rowLabelWidth = metrics.stringWidth("9999") + insets.right + insets.left;
        Dimension dim = new Dimension(rowLabelWidth, rowHeight);
        JLabel lbl = UIHelper.createLabel(Integer.toString(Uploader.getCurrentUpload().rowUploading + 1));
        lbl.setHorizontalAlignment(0);
        lbl.setPreferredSize(dim);
        lbl.setBorder(cellBorder);
        lbl.setSize(dim);
        JViewport viewPort = new JViewport();
        dim.height = rowHeight;
        viewPort.setViewSize(dim);
        viewPort.setView(lbl);
        scrollPane.setRowHeader(viewPort);
        matchedTbl.setPreferredScrollableViewportSize(new Dimension(matchedTbl.getWidth(), matchedTbl.getRowCount() * matchedTbl.getRowHeight()));
        matchedPane.add((Component)scrollPane, "Center");
        pane.add((Component)matchedPane, "North");
        JPanel matchesPane = new JPanel(new BorderLayout());
        JLabel matchesLbl = UIHelper.createLabel(UIRegistry.getResourceString("WB_UPLOAD_DB_MATCHES"));
        matchesLbl.setFont(matchedLbl.getFont().deriveFont(1));
        matchesLbl.setBorder(new EmptyBorder(8, 1, 3, 0));
        matchesPane.add((Component)matchesLbl, "North");
        Vector<MatchedRecord> matchVec = new Vector<MatchedRecord>();
        for (DataModelObjBase match : matches) {
            matchVec.add(new MatchedRecord(match));
        }
        this.matchesList = new JList(matchVec);
        this.matchesList.setBorder(new SoftBevelBorder(1));
        this.matchesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MatchHandler.this.updateMatchUIState();
                }
            }
        });
        matchesPane.add((Component)new JScrollPane(this.matchesList), "Center");
        pane.add((Component)matchesPane, "Center");
        JButton settingsBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SETTINGS_BTN"));
        settingsBtn.setToolTipText(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SETTINGS_BTN_HINT"));
        settingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MatchHandler.this.showSettings();
            }
        });
        JPanel btnPane = new JPanel(new BorderLayout());
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p, 1dlu, f:min", "f:p"));
        this.viewBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_UPLOAD_VIEW_MATCH_BTN"));
        this.viewBtn.setToolTipText(UIRegistry.getResourceString("WB_UPLOAD_VIEW_MATCH_BTN_HINT"));
        this.viewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MatchHandler.this.viewSelectedMatch();
            }
        });
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.viewBtn, cc.xy(1, 1));
        pb.add((Component)settingsBtn, cc.xy(3, 1));
        btnPane.add((Component)pb.getPanel(), "East");
        pane.add((Component)btnPane, "South");
        String tblTitle = DBTableIdMgr.getInstance().getByShortClassName(this.uploadTable.getTblClass().getSimpleName()).getTitle();
        this.matchDlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), String.valueOf(UIRegistry.getResourceString("WB_UPLOAD_CHOOSE_MATCH")) + " - " + tblTitle, true, 15, pane, 1);
        this.matchDlg.setOkLabel(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SELECT_BTN"));
        this.matchDlg.setCancelLabel(UIRegistry.getResourceString("WB_UPLOAD_MATCH_ADD_BTN"));
        this.matchDlg.setApplyLabel(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SKIPROW_BTN"));
        this.matchDlg.createUI();
        this.matchDlg.getOkBtn().setToolTipText(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SELECT_BTN_HINT"));
        this.matchDlg.getCancelBtn().setToolTipText(UIRegistry.getResourceString("WB_UPLOAD_MATCH_ADD_BTN_HINT"));
        this.matchDlg.getApplyBtn().setToolTipText(UIRegistry.getResourceString("WB_UPLOAD_MATCH_SKIPROW_BTN_HINT"));
        this.matchDlg.getApplyBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MatchHandler.this.matchDlg.setVisible(false);
            }
        });
        this.updateMatchUIState();
        try {
            do {
                UIHelper.centerAndShow(this.matchDlg);
                if (!this.matchDlg.isCancelled() || this.matchDlg.getBtnPressed() != 2) continue;
                return null;
            } while (this.matchDlg.isCancelled());
            if (this.matchDlg.getBtnPressed() == 8) {
                throw new UploaderMatchSkipException(UploaderMatchSkipException.makeMsg(restrictedVals, this.uploadTable.getUploadFields().get(recNum).size(), Uploader.getCurrentUpload().getRow()), matches, Uploader.getCurrentUpload().getRow(), this.uploadTable);
            }
            DataModelObjBase dataModelObjBase = ((MatchedRecord)this.matchesList.getSelectedValue()).getDataObj();
            return dataModelObjBase;
        }
        finally {
            this.matchDlg.dispose();
            this.matchDlg = null;
        }
    }

    protected void updateMatchUIState() {
        this.matchDlg.getOkBtn().setEnabled(this.matchesList.getSelectedValue() != null);
        this.viewBtn.setEnabled(this.matchesList.getSelectedValue() != null);
    }

    protected void showSettings() {
        final UploadMatchSettingsBasicPanel umsbp = new UploadMatchSettingsBasicPanel();
        umsbp.showSetting(this.uploadTable);
        try {
            this.settingDlg = new CustomDialog(null, UIRegistry.getResourceString("WB_UPLOAD_SETTINGS"), true, 15, umsbp, 1);
            this.settingDlg.setApplyLabel(UIRegistry.getResourceString("WB_UPLOAD_APPLY_TO_ALL"));
            this.settingDlg.createUI();
            this.settingDlg.getApplyBtn().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Uploader.currentUpload.applyMatchSettingsToAllTables(umsbp);
                }
            });
            UIHelper.centerAndShow(this.settingDlg);
            if (!this.settingDlg.isCancelled()) {
                if (this.settingDlg.getBtnPressed() == 1) {
                    umsbp.applySetting(this.uploadTable);
                }
                if (this.settingDlg.getBtnPressed() == 8) {
                    System.out.println("applyToAll??");
                }
            }
        }
        finally {
            this.settingDlg.dispose();
            this.settingDlg = null;
        }
    }

    protected boolean viewSelectedMatch() {
        MatchedRecord selection = (MatchedRecord)this.matchesList.getSelectedValue();
        System.out.println("Viewing " + this.matchesList.getSelectedValue());
        String viewName = selection.getDataObj().getClass().getSimpleName();
        Frame parentFrame = (Frame)UIRegistry.get("frame");
        String displayName = selection.getTblInfo().getTitle();
        String closeBtnText = UIRegistry.getResourceString("CLOSE");
        String className = selection.getDataObj().getClass().getName();
        String idFieldName = selection.getTblInfo().getIdFieldName();
        int options = 8;
        ViewBasedDisplayDialog dialog = new ViewBasedDisplayDialog(parentFrame, null, viewName, displayName, displayName, closeBtnText, className, idFieldName, false, options);
        dialog.setModal(true);
        dialog.setData(selection.getDataObj());
        dialog.pack();
        dialog.setVisible(true);
        return false;
    }

    private class MatchedRecord {
        protected final DataModelObjBase dataObj;
        protected final DBTableInfo tblInfo;

        public MatchedRecord(DataModelObjBase matchedObj) {
            this.dataObj = matchedObj;
            int tblId = DBTableIdMgr.getInstance().getIdByClassName(this.dataObj.getClass().getName());
            this.tblInfo = DBTableIdMgr.getInstance().getInfoById(tblId);
        }

        public DataModelObjBase getDataObj() {
            return this.dataObj;
        }

        public DBTableInfo getTblInfo() {
            return this.tblInfo;
        }

        public String toString() {
            String value = DataObjFieldFormatMgr.getInstance().format((Object)this.dataObj, this.dataObj.getClass());
            if (value != null) {
                return value;
            }
            log.error((Object)("no formatter found for " + this.dataObj.getClass().toString()));
            return this.dataObj.toString();
        }
    }
}

