/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraph;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraphException;
import edu.ku.brc.specify.tasks.subpane.wb.graph.Vertex;
import edu.ku.brc.specify.tasks.subpane.wb.schema.DBSchema;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class GraphBuilder {
    private DBTableIdMgr schema;
    private DBSchema scheme;
    private DirectedGraph<Table, Relationship> g;
    private SortedSet<String> excludeTbls;
    private static final Logger log = Logger.getLogger(GraphBuilder.class);

    public GraphBuilder(DBTableIdMgr schema, DBSchema scheme, String[] excludeTbls) {
        this.schema = schema;
        this.scheme = scheme;
        this.buildExcludeTables(excludeTbls);
    }

    public DirectedGraph<Table, Relationship> buildGraph() throws DirectedGraphException {
        this.g = new DirectedGraph();
        for (DBTableInfo dBTableInfo : this.schema.getTables()) {
            if (!this.includeTable(dBTableInfo)) continue;
            this.g.addVertex(this.buildTableVertex(dBTableInfo));
        }
        for (Vertex vertex : this.g.getVertices()) {
            DBTableInfo tbl = ((Table)vertex.getData()).getTableInfo();
            for (DBRelationshipInfo rel : tbl.getRelationships()) {
                Relationship relationship;
                String relTblName = this.getRelShortName(rel);
                if (relTblName == null || this.g.getVertexByLabel(relTblName) == null || !this.includeEdge(tbl.getShortClassName().toLowerCase(), relTblName, rel) || (relationship = this.getOneToManyRelationship(tbl, rel)) == null || this.isSystemRelationship(relationship)) continue;
                this.g.addEdge(relTblName, tbl.getShortClassName().toLowerCase(), relationship);
            }
        }
        return this.g;
    }

    private boolean includeEdge(String tblName, String relTblName, DBRelationshipInfo rel) {
        if (rel.getType() != DBRelationshipInfo.RelationshipType.ManyToOne) {
            return false;
        }
        return !tblName.equals(relTblName);
    }

    private boolean includeTable(DBTableInfo tbl) {
        return !this.excludeTbls.contains(tbl.getShortClassName().toLowerCase());
    }

    protected boolean isSystemRelationship(Relationship r) {
        return r.getField().getName().equalsIgnoreCase("ModifiedByAgentID") || r.getField().getName().equalsIgnoreCase("CreatedByAgentID") || r.getRelatedField().getName().equalsIgnoreCase("ModifiedByAgentID") || r.getRelatedField().getName().equalsIgnoreCase("CreatedByAgentID");
    }

    private Relationship getOneToManyRelationship(DBTableInfo tbl, DBRelationshipInfo rel) {
        try {
            DBTableInfo oneSideTblInfo = this.schema.getByClassName(rel.getClassName());
            Table oneSideTbl = this.scheme.getTable(oneSideTblInfo.getShortClassName());
            Field oneSideFld = oneSideTbl.getField(oneSideTblInfo.getIdColumnName());
            Table manySideTbl = this.scheme.getTable(tbl.getShortClassName());
            String manySideFldName = rel.getColName() == null ? oneSideFld.getName() : rel.getColName();
            Field manySideFld = manySideTbl.getField(manySideFldName);
            if (oneSideFld == null || manySideFld == null) {
                log.debug((Object)(String.valueOf(rel.getName()) + ": one of the fields is null."));
            }
            return new Relationship(oneSideFld, manySideFld, "OneToMany");
        }
        catch (RuntimeException ex) {
            log.debug((Object)("relationship " + rel.getName() + "could not be added to database graph."));
            return null;
        }
    }

    private String getRelShortName(DBRelationshipInfo rel) {
        try {
            return this.schema.getByClassName(rel.getClassName()).getShortClassName().toLowerCase();
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private Vertex<Table> buildTableVertex(DBTableInfo tbl) {
        Table table = this.scheme.getTable(tbl.getShortClassName());
        if (table == null) {
            log.debug((Object)("unable to find " + tbl.getShortClassName() + " in DBSchema."));
            return null;
        }
        return new Vertex<Table>(tbl.getShortClassName().toLowerCase(), table);
    }

    private void buildExcludeTables(String[] badTbls) {
        this.excludeTbls = new TreeSet<String>();
        String[] stringArray = badTbls;
        int n = badTbls.length;
        int n2 = 0;
        while (n2 < n) {
            String tbl = stringArray[n2];
            this.excludeTbls.add(tbl);
            ++n2;
        }
    }
}

