/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.wbuploader;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraph;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraphException;
import edu.ku.brc.specify.tasks.subpane.wb.schema.DBSchema;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class DB {
    protected DBSchema schema = new DBSchema(DBTableIdMgr.getInstance(), this);
    protected DirectedGraph<Table, Relationship> dbGraph = this.schema.getGraph();
    protected boolean useBogusStorage = false;
    protected Map<String, Vector<Vector<String>>> bogusStorages;

    public DBSchema getSchema() {
        return this.schema;
    }

    public DB() throws DirectedGraphException {
        if (!this.useBogusStorage) {
            this.bogusStorages = null;
        } else {
            this.bogusStorages = new HashMap<String, Vector<Vector<String>>>();
            for (Table t : this.schema.getTables()) {
                this.bogusStorages.put(t.getName(), new Vector());
            }
        }
    }

    public DirectedGraph<Table, Relationship> getGraph() {
        return this.dbGraph;
    }

    protected Vector<Vector<String>> getBogusStorage(Table t) {
        return this.bogusStorages.get(t.getName());
    }

    public BogusRecord getBogusRecord(Table t) {
        return new BogusRecord(t, this.getBogusStorage(t));
    }

    public void dumpBogus() {
        for (Table t : this.schema.getTables()) {
            if (this.getBogusStorage(t).size() <= 0) continue;
            System.out.println();
            System.out.println(t.getName());
            TreeMap<Integer, String> header = new TreeMap<Integer, String>();
            for (Field f : t.getFields()) {
                header.put(f.getColumnIndex(), f.getName());
            }
            for (String h : header.values()) {
                System.out.print(String.valueOf(h) + ", ");
            }
            System.out.println();
            Vector<Vector<String>> bogus = this.getBogusStorage(t);
            for (Vector<String> row : bogus) {
                for (String val : row) {
                    System.out.print(String.valueOf(val) + ", ");
                }
                System.out.println();
            }
        }
    }

    public void viewBogusData() {
        new BogusViewer().viewBogus();
    }

    public class BogusRecord {
        protected Table table;
        protected Vector<String> values;
        protected Vector<Vector<String>> bogusStorage;
        protected Set<Integer> assignedFldIdxs;

        public BogusRecord(Table table) {
            this.table = table;
            this.values = new Vector(this.table.getFields().size());
            int v = 0;
            while (v < this.table.getFields().size()) {
                this.values.add(null);
                ++v;
            }
            this.bogusStorage = new Vector();
            this.assignedFldIdxs = new HashSet<Integer>();
        }

        public BogusRecord(Table table, Vector<Vector<String>> bogus) {
            this.table = table;
            this.values = new Vector(this.table.getFields().size());
            int v = 0;
            while (v < this.table.getFields().size()) {
                this.values.add(null);
                ++v;
            }
            this.bogusStorage = bogus;
            this.assignedFldIdxs = new HashSet<Integer>();
        }

        protected int getColIdx(String fldName) {
            Field fld = this.table.getField(fldName);
            if (fld != null) {
                return fld.getColumnIndex();
            }
            return -1;
        }

        public void setField(String fldName, String value) {
            int idx = this.getColIdx(fldName);
            this.values.set(idx, value);
            this.assignedFldIdxs.add(idx);
        }

        public String getField(String fldName) {
            return this.values.get(this.getColIdx(fldName));
        }

        protected int getKeyIdx() {
            if (this.table.getKey() != null) {
                return this.table.getKey().getColumnIndex();
            }
            return 0;
        }

        public Integer writeValues() throws DuplicateMatchException {
            Vector<Integer> matches = this.findMatches(this.values, true);
            if (matches.size() == 0) {
                this.bogusStorage.add(this.values);
                this.values.set(this.getKeyIdx(), String.valueOf(this.bogusStorage.size() - 1));
                Integer result = new Integer(this.values.get(this.getKeyIdx()));
                this.values = new Vector(this.table.getFields().size());
                int v = 0;
                while (v < this.table.getFields().size()) {
                    this.values.add(null);
                    ++v;
                }
                return result;
            }
            if (matches.size() == 1) {
                return matches.get(0);
            }
            throw new DuplicateMatchException(matches);
        }

        public Vector<Integer> findMatches(Vector<String> recVals, boolean compareAssignedFldsOnly) {
            Vector<Integer> result = new Vector<Integer>();
            for (Vector<String> rec : this.bogusStorage) {
                if (!this.recsEqual(recVals, rec, compareAssignedFldsOnly)) continue;
                result.add(new Integer(rec.get(this.getKeyIdx())));
            }
            return result;
        }

        protected boolean recValsEqual(String v1, String v2) {
            if (v1 != null || v2 != null) {
                if (v1 == null ^ v2 == null) {
                    return false;
                }
                if (!v1.equals(v2)) {
                    return false;
                }
            }
            return true;
        }

        protected boolean recsEqual(Vector<String> rec1, Vector<String> rec2, boolean compareAssignedFldsOnly) {
            if (compareAssignedFldsOnly) {
                for (Integer f : this.assignedFldIdxs) {
                    if (this.recValsEqual(rec1.get(f), rec2.get(f))) continue;
                    return false;
                }
                return true;
            }
            int f = 0;
            while (f < rec1.size()) {
                if (f != this.getKeyIdx() && !this.recValsEqual(rec1.get(f), rec2.get(f))) {
                    return false;
                }
                ++f;
            }
            return true;
        }

        public class DuplicateMatchException
        extends Exception {
            protected Vector<Integer> matchIds;

            DuplicateMatchException(Vector<Integer> matchIds) {
                this.matchIds = matchIds;
            }

            public final Vector<Integer> getMatchIds() {
                return this.matchIds;
            }
        }
    }

    public class BogusViewer
    implements ActionListener {
        protected boolean showAllFields = false;
        protected Map<String, Vector<Vector<String>>> myStorages;
        protected Vector<CustomFrame> tblForms;

        public BogusViewer(Map<String, Vector<Vector<String>>> myStorages) {
            this.myStorages = myStorages;
            this.tblForms = new Vector();
        }

        public BogusViewer() {
            this.myStorages = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showAllFields = !this.showAllFields;
        }

        public void viewBogus() {
            JPanel mainPane = new JPanel(new BorderLayout());
            JLabel msg = UIHelper.createLabel("Tables containing imported data");
            msg.setFont(msg.getFont().deriveFont(1));
            mainPane.add((Component)msg, "North");
            JCheckBox cb = UIHelper.createCheckBox("show all fields");
            cb.addActionListener(this);
            mainPane.add((Component)cb, "South");
            Vector<String> tblNames = new Vector<String>();
            if (this.myStorages == null) {
                for (Table t : DB.this.schema.getTables()) {
                    if (DB.this.getBogusStorage(t).size() <= 0) continue;
                    tblNames.add(t.getName());
                }
            } else {
                tblNames.addAll(this.myStorages.keySet());
            }
            JList mods = new JList(tblNames);
            mods.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        BogusViewer.this.viewBogusTbl(((JList)me.getSource()).getSelectedValue().toString(), !BogusViewer.this.showAllFields);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseReleased(MouseEvent me) {
                }
            });
            mainPane.add((Component)new JScrollPane(mods), "Center");
            CustomFrame cwin = new CustomFrame("Imported Data", 1, mainPane);
            cwin.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    System.out.println("closed");
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    System.out.println("closing");
                }
            });
            UIHelper.centerAndShow(cwin);
        }

        protected boolean fldHasData(String tblName, Integer fldIdx) {
            for (Vector<String> row : DB.this.getBogusStorage(DB.this.schema.getTable(tblName))) {
                if (row.get(fldIdx) == null) continue;
                return true;
            }
            return false;
        }

        protected CustomFrame findTblForm(String tblName) {
            for (CustomFrame result : this.tblForms) {
                if (!result.getTitle().equals(tblName)) continue;
                return result;
            }
            return null;
        }

        public void viewBogusTbl(String tblName, boolean hideEmptyFields) {
            Vector<Object> vals;
            CustomFrame cwin = this.findTblForm(tblName);
            if (cwin != null) {
                if (!cwin.isVisible()) {
                    cwin.setVisible(true);
                }
                if (cwin.getExtendedState() == 1) {
                    cwin.setExtendedState(0);
                }
                cwin.toFront();
                return;
            }
            JPanel mainPane = new JPanel(new BorderLayout());
            Vector<String> fldNames = new Vector<String>();
            if (this.myStorages == null) {
                TreeMap<Integer, String> header = new TreeMap<Integer, String>();
                for (Field fld : DB.this.schema.getTable(tblName).getFields()) {
                    header.put(fld.getColumnIndex(), fld.getName());
                }
                for (String fldName : header.values()) {
                    fldNames.add(fldName);
                }
            } else if (this.myStorages.containsKey(tblName)) {
                fldNames.addAll((Collection)this.myStorages.get(tblName).get(0));
            } else {
                return;
            }
            if (this.myStorages == null) {
                vals = DB.this.getBogusStorage(DB.this.schema.getTable(tblName));
            } else {
                vals = new Vector();
                vals.addAll((Collection)this.myStorages.get(tblName));
                vals.remove(0);
            }
            JTable table = new JTable(vals, fldNames);
            table.setAutoResizeMode(0);
            int col = 0;
            while (col < table.getColumnModel().getColumnCount()) {
                table.getColumnModel().getColumn(col).sizeWidthToFit();
                ++col;
            }
            if (hideEmptyFields) {
                col = table.getModel().getColumnCount() - 1;
                while (col >= 0) {
                    boolean hasData = false;
                    int row = 0;
                    while (row < table.getModel().getRowCount()) {
                        String val;
                        Object valObj = table.getModel().getValueAt(row, col);
                        String string = val = valObj == null ? null : valObj.toString();
                        if (val != null && !val.equals("")) {
                            hasData = true;
                            break;
                        }
                        ++row;
                    }
                    if (!hasData) {
                        table.removeColumn(table.getColumnModel().getColumn(col));
                    }
                    --col;
                }
            }
            mainPane.add((Component)new JScrollPane(table), "Center");
            cwin = new CustomFrame(tblName, 1, mainPane);
            this.tblForms.add(cwin);
            UIHelper.centerAndShow(cwin);
        }

        public void closeViewers() {
            for (CustomFrame frm : this.tblForms) {
                if (frm.isVisible()) {
                    frm.setVisible(false);
                }
                frm.dispose();
            }
        }
    }
}

