/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.schema;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.tasks.subpane.wb.schema.DBSchema;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;

public class Table
implements Comparable<Table> {
    protected String name;
    protected TreeMap<String, Field> fields;
    protected Vector<Relationship> relationships;
    protected DBTableInfo tableInfo;
    protected Field keyFld = null;
    protected DBSchema schema;

    public boolean equals(Object tableObj) {
        if (tableObj == null) {
            return false;
        }
        if (this.getClass() != tableObj.getClass()) {
            return false;
        }
        Table table = (Table)tableObj;
        return this.getName().equalsIgnoreCase(table.getName());
    }

    @Override
    public int compareTo(Table tbl) {
        return this.name.compareToIgnoreCase(tbl.name);
    }

    public final Collection<Field> getFields() {
        return this.fields.values();
    }

    public final String getName() {
        return this.name;
    }

    public final Vector<Relationship> getRelationships() {
        return this.relationships;
    }

    public Table(DBSchema schema, String name) {
        this.schema = schema;
        this.name = name;
        this.fields = new TreeMap();
        this.relationships = new Vector();
        this.tableInfo = null;
    }

    public Table(DBSchema schema, DBTableInfo tableInfo) {
        this.schema = schema;
        this.tableInfo = tableInfo;
        this.name = this.tableInfo.getShortClassName();
        this.fields = new TreeMap();
        for (DBFieldInfo fld : this.tableInfo.getFields()) {
            this.addField(new Field(fld));
        }
        if (this.tableInfo.getIdFieldName() != null) {
            this.keyFld = new Field(this.tableInfo.getIdFieldName(), this.tableInfo.getIdType());
            this.addField(this.keyFld);
        } else {
            this.keyFld = null;
        }
        this.relationships = new Vector();
    }

    public Table(String name, Table toCopy) {
        this.tableInfo = toCopy.tableInfo;
        this.name = name;
        this.schema = toCopy.schema;
        this.fields = new TreeMap();
        for (Field copyFld : toCopy.getFields()) {
            this.addField(new Field(copyFld));
        }
        if (toCopy.getKey() != null) {
            this.keyFld = this.getField(toCopy.getKey().getName());
        }
        this.relationships = new Vector();
    }

    public void addField(Field field) {
        this.fields.put(field.getName().toLowerCase(), field);
        if (field.columnIndex == -1) {
            field.setColumnIndex(this.fields.size() - 1);
        }
        field.setTable(this);
    }

    public Field getField(String fldName) {
        return this.fields.get(fldName.toLowerCase());
    }

    public Field getKey() {
        return this.keyFld;
    }

    public final DBTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public final DBSchema getSchema() {
        return this.schema;
    }
}

