/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.schema;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;

public class Field
implements Comparable<Field> {
    protected String name;
    protected String type;
    protected Table table;
    protected DBFieldInfo fieldInfo;
    protected int columnIndex = -1;
    protected boolean required = false;
    protected boolean foreignKey = false;

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    public final void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Field fld) {
        int tc = this.table.compareTo(fld.table);
        if (tc != 0) {
            return tc;
        }
        return this.name.compareToIgnoreCase(fld.name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Field)) {
            return false;
        }
        return this.compareTo((Field)obj) == 0;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public Field(String name, String type, boolean required, boolean foreignKey) {
        this.name = name;
        this.type = type;
        this.required = required;
        this.foreignKey = foreignKey;
        this.fieldInfo = null;
    }

    public Field(String name, String type) {
        this.name = name;
        this.type = type;
        this.fieldInfo = null;
    }

    public Field(String name, String type, boolean foreignKey) {
        this.name = name;
        this.type = type;
        this.foreignKey = foreignKey;
        this.fieldInfo = null;
    }

    public Field(DBFieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.name = fieldInfo.getName();
        this.type = fieldInfo.getType();
    }

    public Field(Field field) {
        this.fieldInfo = field.fieldInfo;
        this.name = field.getName();
        this.type = field.getType();
    }

    public final Table getTable() {
        return this.table;
    }

    public final void setTable(Table table) {
        this.table = table;
    }

    public final DBFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }
}

