/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.schema;

import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraph;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraphException;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Field;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Relationship;
import edu.ku.brc.specify.tasks.subpane.wb.schema.Table;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DB;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.GraphBuilder;
import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;

public class DBSchema {
    protected TreeMap<String, Table> tables;
    protected Vector<Relationship> relationships;
    protected final DBTableIdMgr scheme;
    protected DB db;

    public DBSchema(DBTableIdMgr scheme, DB db) {
        this.scheme = scheme;
        this.db = db;
        this.buildSchema();
    }

    protected void buildSchema() {
        this.tables = new TreeMap();
        for (DBTableInfo dBTableInfo : this.scheme.getTables()) {
            Table newTbl = new Table(this, dBTableInfo);
            this.tables.put(newTbl.getName().toLowerCase(), newTbl);
        }
        for (Table table : this.getTables()) {
            Class<?> tblClass = table.getTableInfo().getClassObj();
            if (Treeable.class.isAssignableFrom(tblClass)) {
                table.addField(new Field("parentid", table.getTableInfo().getIdType(), true));
            }
            for (DBRelationshipInfo rel : table.getTableInfo().getRelationships()) {
                Field fld2;
                String fld2Name = rel.getColName();
                if (fld2Name == null) {
                    fld2Name = table.getTableInfo().getIdFieldName();
                }
                if ((fld2 = table.getField(fld2Name)) != null) continue;
                table.addField(new Field(fld2Name, table.getTableInfo().getIdType(), rel.isRequired(), true));
            }
        }
        this.relationships = new Vector();
    }

    public Field getField(String tblName, String fldName) {
        Table t = this.getTable(tblName);
        if (t == null) {
            return null;
        }
        return t.getField(fldName);
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Table getTable(String tblName) {
        return this.tables.get(tblName.toLowerCase());
    }

    public DirectedGraph<Table, Relationship> getGraph() throws DirectedGraphException {
        String[] badTbls = new String[]{"appresource", "appresourcedata", "appresourcedefault", "datatype", "picklist", "specifyuser", "spprincipal", "viewsetobj", "workbench", "workbenchdataitem", "workbenchrow", "workbenchrowimage", "workbenchtemplate", "workbenchtemplatemappingitem"};
        GraphBuilder gb = new GraphBuilder(this.scheme, this, badTbls);
        return gb.buildGraph();
    }
}

