/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.graph;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraph;
import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraphException;
import edu.ku.brc.specify.tasks.subpane.wb.graph.Vertex;
import java.util.Set;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DirectedGraphTest {
    protected static DirectedGraph<String, String> disConnect;
    protected static DirectedGraph<String, String> connect;
    protected static Vertex<String> a;
    protected static Vertex<String> b;
    protected static Vertex<String> c;
    protected static Vertex<String> d;
    protected static Vertex<String> e;
    protected static Vertex<String> f;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        a = new Vertex<String>("a", "a");
        b = new Vertex<String>("b", "b");
        c = new Vertex<String>("c", "c");
        d = new Vertex<String>("d", "d");
        e = new Vertex<String>("e", "e");
        f = new Vertex<String>("f", "f");
        disConnect = new DirectedGraph();
        disConnect.addVertex(a);
        disConnect.addVertex(b);
        disConnect.addVertex(c);
        disConnect.addVertex(d);
        disConnect.addVertex(e);
        disConnect.addVertex(f);
        disConnect.addEdge(a.getLabel(), c.getLabel());
        disConnect.addEdge(d.getLabel(), e.getLabel());
        disConnect.addEdge(e.getLabel(), f.getLabel());
        connect = new DirectedGraph();
        connect.addVertex(a);
        connect.addVertex(b);
        connect.addVertex(c);
        connect.addVertex(d);
        connect.addVertex(e);
        connect.addVertex(f);
        connect.addEdge("a", "c");
        connect.addEdge("c", "b");
        connect.addEdge("a", "d");
        connect.addEdge("b", "d");
        connect.addEdge("d", "e");
        connect.addEdge("a", "f");
        connect.addEdge("e", "f");
    }

    @Test
    public void testIsConnected() throws DirectedGraphException {
        Assert.assertTrue((!disConnect.isStronglyConnected() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)connect.isStronglyConnected());
    }

    @Test
    public void testGetAdjacentVertices() {
        Assert.assertTrue((boolean)disConnect.getAdjacentVertices(a).contains(c));
        Assert.assertTrue((boolean)connect.getAdjacentVertices(a).contains(c));
        Assert.assertTrue((boolean)connect.getAdjacentVertices(a).contains(d));
        Assert.assertTrue((boolean)connect.getAdjacentVertices(a).contains(f));
    }

    @Test
    public void testTopoSortVertexOfEVectorOfVertex() {
        Vector result = new Vector();
        connect.topoSort(a, result);
        Assert.assertTrue((result.get(0) == a ? 1 : 0) != 0);
        Assert.assertTrue((result.get(1) == c ? 1 : 0) != 0);
        Assert.assertTrue((result.get(2) == b ? 1 : 0) != 0);
    }

    @Test
    public void testTopoSortVertexOfE() {
        Vector<Vertex<String>> result = connect.topoSort(a);
        Assert.assertTrue((result.get(0) == a ? 1 : 0) != 0);
        Assert.assertTrue((result.get(1) == c ? 1 : 0) != 0);
        Assert.assertTrue((result.get(2) == b ? 1 : 0) != 0);
        Assert.assertTrue((result.get(3) == d ? 1 : 0) != 0);
        Assert.assertTrue((result.get(result.size() - 1) == f ? 1 : 0) != 0);
    }

    @Test
    public void testSources() {
        Set<Vertex<String>> result = connect.sources();
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        for (Vertex<String> v : result) {
            Assert.assertTrue((v == a ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFrom() {
        try {
            Set<Vertex<Vertex<String>>> froms = connect.from((String)((Object)a));
            Assert.assertTrue((boolean)froms.contains(c));
            Assert.assertTrue((boolean)froms.contains(b));
            froms = disConnect.from((String)((Object)a));
            Assert.assertTrue((!froms.contains(b) ? 1 : 0) != 0);
            froms = connect.from((String)((Object)b));
            Assert.assertTrue((boolean)froms.contains(d));
        }
        catch (DirectedGraphException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DirectedGraphTest.class, ex);
        }
    }

    @Test
    public void testTo() {
        try {
            Set<Vertex<Vertex<String>>> t = connect.to((String)((Object)b));
            Assert.assertTrue((boolean)t.contains(a));
            Assert.assertTrue((boolean)t.contains(c));
            t = disConnect.to((String)((Object)b));
            Assert.assertTrue((t.size() == 0 ? 1 : 0) != 0);
        }
        catch (DirectedGraphException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DirectedGraphTest.class, ex);
        }
    }
}

