/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb.graph;

import edu.ku.brc.specify.tasks.subpane.wb.graph.DirectedGraphException;
import edu.ku.brc.specify.tasks.subpane.wb.graph.Edge;
import edu.ku.brc.specify.tasks.subpane.wb.graph.Vertex;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DirectedGraph<E, F> {
    protected Set<Vertex<E>> vertices = new HashSet<Vertex<E>>();
    protected Set<Edge<E, F>> edges = new HashSet<Edge<E, F>>();
    private static final Logger log = Logger.getLogger(DirectedGraph.class);

    protected DirectedGraph<E, F> makeUndirectedCopy() throws DirectedGraphException {
        DirectedGraph<E, F> result = new DirectedGraph<E, F>();
        for (Vertex<E> vertex : this.vertices) {
            result.addVertex(new Vertex<E>(vertex.getLabel(), vertex.getData()));
        }
        for (Edge edge : this.edges) {
            result.addEdge(edge.getPointA().getLabel(), edge.getPointB().getLabel());
            result.addEdge(edge.getPointB().getLabel(), edge.getPointA().getLabel());
        }
        return result;
    }

    public Vector<String> listEdges() {
        TreeSet<String> lines = new TreeSet<String>();
        for (Edge<E, F> e : this.edges) {
            lines.add(String.valueOf(e.getPointA().getLabel()) + " --> " + e.getPointB().getLabel());
        }
        return new Vector<String>(lines);
    }

    public void addVertex(Vertex<E> v) throws DirectedGraphException {
        if (this.getVertexByLabel(v.getLabel()) != null) {
            throw new DirectedGraphException("vertex is already in graph");
        }
        this.vertices.add(v);
    }

    public void addEdge(Vertex<E> a, Vertex<E> b) throws DirectedGraphException {
        this.addEdge(a, b, null);
    }

    public void addEdge(Vertex<E> a, Vertex<E> b, F data) throws DirectedGraphException {
        this.addVertex(a);
        this.addVertex(b);
        this.edges.add(new Edge<E, F>(a, b, data));
    }

    public void addEdge(String aLabel, String bLabel) throws DirectedGraphException {
        this.addEdge(aLabel, bLabel, null);
    }

    public void addEdge(String aLabel, String bLabel, F data) throws DirectedGraphException {
        Vertex<E> v1 = this.getVertexByLabel(aLabel);
        Vertex<E> v2 = this.getVertexByLabel(bLabel);
        if (v1 == null || v2 == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        this.edges.add(new Edge<E, F>(v1, v2, data));
    }

    private Edge<E, F> getEdge(Vertex<E> v1, Vertex<E> v2) {
        for (Edge<E, F> e : this.edges) {
            if (!e.getPointA().equals(v1) || !e.getPointB().equals(v2)) continue;
            return e;
        }
        return null;
    }

    private Vector<Edge<E, F>> getEdges(Vertex<E> v1, Vertex<E> v2) {
        Vector<Edge<Edge<E, F>, F>> result = new Vector<Edge<Edge<E, F>, F>>();
        for (Edge<E, F> e : this.edges) {
            if (!e.getPointA().equals(v1) || !e.getPointB().equals(v2)) continue;
            result.add(e);
        }
        return result;
    }

    public F getEdgeData(Vertex<E> v1, Vertex<E> v2) {
        Edge<E, F> e = this.getEdge(v1, v2);
        if (e != null) {
            return e.getData();
        }
        return null;
    }

    public Vector<F> getAllEdgeData(Vertex<E> v1, Vertex<E> v2) {
        Vector<Edge<E, F>> es = this.getEdges(v1, v2);
        Vector<F> result = new Vector<F>();
        for (Edge<E, F> e : es) {
            result.add(e.getData());
        }
        return result;
    }

    public F getEdgeData(E vData1, E vData2) throws DirectedGraphException {
        Vertex<E> v1 = this.getVertexByData(vData1);
        Vertex<E> v2 = this.getVertexByData(vData2);
        if (v1 == null || v2 == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        return this.getEdgeData((E)v1, (E)v2);
    }

    public Vector<F> getAllEdgeData(E vData1, E vData2) throws DirectedGraphException {
        Vertex<E> v1 = this.getVertexByData(vData1);
        Vertex<E> v2 = this.getVertexByData(vData2);
        if (v1 == null || v2 == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        return this.getAllEdgeData((E)v1, (E)v2);
    }

    public boolean isStronglyConnected() throws DirectedGraphException {
        for (Vertex<E> v : this.vertices) {
            Set<Vertex<Vertex<Vertex<E>>>> g = this.from((E)v);
            g.addAll(this.to((E)v));
            g.add(v);
            if (g.equals(this.vertices)) continue;
            return false;
        }
        return true;
    }

    public boolean isConnected() throws DirectedGraphException {
        DirectedGraph<E, F> undirected = this.makeUndirectedCopy();
        if (undirected == null) {
            return false;
        }
        return undirected.isStronglyConnected();
    }

    public Vector<Vertex<E>> getAdjacentVertices(Vertex<E> v) {
        Vector<Vertex<Vertex<E>>> result = new Vector<Vertex<Vertex<E>>>();
        for (Edge<E, F> e : this.edges) {
            if (!e.getPointA().equals(v)) continue;
            result.add(e.getPointB());
        }
        return result;
    }

    public void removeVertex(Vertex<E> v) {
        LinkedList<Edge<E, F>> toRemove = new LinkedList<Edge<E, F>>();
        for (Edge<E, F> e : this.edges) {
            if (!e.getPointA().equals(v) && !e.getPointB().equals(v)) continue;
            toRemove.add(e);
        }
        for (Edge<E, F> e : toRemove) {
            this.edges.remove(e);
        }
        this.vertices.remove(v);
    }

    protected void topoSort(Vertex<E> v, Vector<Vertex<E>> visited) {
        for (Vertex<E> a : this.getAdjacentVertices(v)) {
            if (visited.contains(a)) continue;
            this.topoSort(a, visited);
        }
        visited.insertElementAt(v, 0);
    }

    public Vector<Vertex<E>> topoSort(Vertex<E> v) {
        Vector<Vertex<E>> result = new Vector<Vertex<E>>();
        this.topoSort(v, result);
        return result;
    }

    public Vector<Vertex<E>> topoSort(String vLabel) throws DirectedGraphException {
        Vertex<E> v = this.getVertexByLabel(vLabel);
        if (v == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        return this.topoSort(v);
    }

    public Vertex<E> getVertexByLabel(String vLabel) {
        for (Vertex<E> v : this.vertices) {
            if (!v.getLabel().equalsIgnoreCase(vLabel)) continue;
            return v;
        }
        return null;
    }

    public Vertex<E> getVertexByData(E vData) {
        for (Vertex<E> v : this.vertices) {
            if (v.getData() != vData) continue;
            return v;
        }
        return null;
    }

    public Set<Vertex<E>> sources() {
        HashSet<Vertex<E>> notSources = new HashSet<Vertex<E>>();
        for (Vertex<E> v : this.vertices) {
            notSources.addAll(this.getAdjacentVertices(v));
        }
        HashSet<Vertex<Vertex<E>>> result = new HashSet<Vertex<Vertex<E>>>();
        for (Vertex<E> v : this.vertices) {
            if (notSources.contains(v)) continue;
            result.add(v);
        }
        return result;
    }

    protected Vertex<E> findVertexInGraph(Vertex<E> vertex) {
        for (Vertex<E> v : this.vertices) {
            if (!v.equals(vertex)) continue;
            return v;
        }
        return null;
    }

    public Set<Vertex<E>> from(Vertex<E> v) throws DirectedGraphException {
        HashSet<Vertex<E>> result = new HashSet<Vertex<E>>();
        this.from2(v, result);
        return result;
    }

    protected Set<Vertex<E>> from2(Vertex<E> v, Set<Vertex<E>> result) throws DirectedGraphException {
        if (this.findVertexInGraph(v) == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        for (Vertex<E> a : this.getAdjacentVertices(v)) {
            if (result.contains(a)) continue;
            result.add(a);
            result.addAll(this.from2(a, result));
        }
        return result;
    }

    public Set<Vertex<E>> from(E vData) throws DirectedGraphException {
        Vertex<E> v = this.getVertexByData(vData);
        if (v == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        return this.from((E)v);
    }

    public Set<Vertex<E>> to(Vertex<E> v) throws DirectedGraphException {
        if (this.findVertexInGraph(v) == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        HashSet<Vertex<Vertex<E>>> result = new HashSet<Vertex<Vertex<E>>>();
        for (Vertex<E> u : this.vertices) {
            if (u.equals(v) || !this.from((E)u).contains(v)) continue;
            result.add(u);
        }
        return result;
    }

    public Set<Vertex<E>> to(E vData) throws DirectedGraphException {
        Vertex<E> v = this.getVertexByData(vData);
        if (v == null) {
            throw new DirectedGraphException("vertex does not exist in graph");
        }
        return this.to((E)v);
    }

    public Set<Vertex<E>> into(Vertex<E> v) {
        HashSet<Vertex<Vertex<E>>> result = new HashSet<Vertex<Vertex<E>>>();
        for (Edge<E, F> e : this.edges) {
            if (!e.getPointB().equals(v)) continue;
            result.add(e.getPointA());
        }
        return result;
    }

    public Set<Vertex<E>> into(E vData) {
        return this.into((E)this.getVertexByData(vData));
    }

    public Vector<Vertex<E>> getTopoSort() throws DirectedGraphException {
        Vector<Vector<Vertex<E>>> sorts = new Vector<Vector<Vertex<E>>>();
        for (Vertex<E> v : this.sources()) {
            log.debug((Object)("topoSorting: " + v.getLabel()));
            sorts.add(this.topoSort(v));
        }
        Vector<Vertex<Vertex>> result = new Vector<Vertex<Vertex>>();
        for (Vertex v : (Vector)sorts.get(0)) {
            result.add(v);
        }
        int s = 1;
        while (s < sorts.size()) {
            this.mergeSort((Vector)sorts.get(s), result);
            ++s;
        }
        return result;
    }

    protected void mergeSort(Vector<Vertex<E>> merger, Vector<Vertex<E>> mergee) throws DirectedGraphException {
        int startPnt = mergee.size() - 1;
        int t = merger.size() - 1;
        while (t >= 0) {
            if (!mergee.contains(merger.get(t))) {
                int mergeAt = 0;
                int m = startPnt;
                while (m >= 0) {
                    if (this.from((E)merger.get(t)).contains(mergee.get(m))) {
                        mergeAt = m;
                    }
                    --m;
                }
                mergee.insertElementAt(merger.get(t), mergeAt);
                startPnt = mergeAt;
            }
            --t;
        }
    }

    public final Set<Vertex<E>> getVertices() {
        return this.vertices;
    }

    public final Set<Edge<E, F>> getEdges() {
        return this.edges;
    }
}

