/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImport;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportIFace;
import edu.ku.brc.ui.DateWrapper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.LatLonConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XLSImport
extends DataImport
implements DataImportIFace {
    private static final Logger log = Logger.getLogger(XLSImport.class);
    private Vector<Integer> cardImageCols = new Vector();
    private int geoCol = -1;
    protected ConfigureExternalDataIFace config;

    private void getSystemCols(HSSFRow headerRow) {
        int c = headerRow.getFirstCellNum();
        while (c <= headerRow.getLastCellNum()) {
            HSSFCell cell = headerRow.getCell(c);
            int nulls = 0;
            if (cell != null) {
                String header = cell.getRichStringCellValue().getString();
                if (header != null) {
                    if (header.equals(IMAGE_PATH_HEADING)) {
                        this.cardImageCols.add(c - nulls);
                    }
                    if (header.equals(GEO_DATA_HEADING)) {
                        this.geoCol = c - nulls;
                    }
                }
            } else {
                ++nulls;
            }
            ++c;
        }
    }

    public XLSImport(ConfigureExternalDataIFace config) {
        this.config = config;
    }

    protected boolean isGeoCoordinate(WorkbenchTemplateMappingItem wbtmi) {
        String fld = wbtmi.getFieldName().toLowerCase();
        return fld.equals("latitude1") || fld.equals("latitude2") || fld.equals("longitude1") || fld.equals("longitude2");
    }

    @Override
    public DataImportIFace.Status getData(Workbench workbench) {
        if (this.config.getStatus() == ConfigureExternalDataIFace.Status.Valid) {
            DateWrapper scrDateFormat = AppPrefsCache.getDateWrapper("ui", "formatting", "scrdateformat");
            try {
                FileInputStream input = new FileInputStream(this.config.getFile());
                POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
                HSSFWorkbook workBook = new HSSFWorkbook(fs);
                HSSFSheet sheet = workBook.getSheetAt(0);
                int numRows = 0;
                Set<WorkbenchTemplateMappingItem> wbtmiSet = workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems();
                Vector<WorkbenchTemplateMappingItem> wbtmiList = new Vector<WorkbenchTemplateMappingItem>();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMinimumFractionDigits(0);
                nf.setMaximumFractionDigits(20);
                nf.setGroupingUsed(false);
                NumberFormat nfGeoCoord = NumberFormat.getInstance();
                nfGeoCoord.setMinimumFractionDigits(0);
                nfGeoCoord.setMaximumFractionDigits(LatLonConverter.DECIMAL_SIZES[LatLonConverter.FORMAT.DDDDDD.ordinal()]);
                nfGeoCoord.setGroupingUsed(false);
                char decSep = new DecimalFormatSymbols().getDecimalSeparator();
                wbtmiList.addAll(wbtmiSet);
                Collections.sort(wbtmiList);
                this.truncations.clear();
                Vector<HSSFHyperlink> activeHyperlinks = new Vector<HSSFHyperlink>();
                Iterator rows = sheet.rowIterator();
                while (rows.hasNext()) {
                    HSSFRow row = (HSSFRow)rows.next();
                    if (numRows == 0 && this.config.getFirstRowHasHeaders()) {
                        ++numRows;
                        this.getSystemCols(row);
                        continue;
                    }
                    WorkbenchRow wbRow = workbench.addRow();
                    for (WorkbenchTemplateMappingItem wbtmi : wbtmiList) {
                        HSSFCell cell;
                        int cellNum = wbtmi.getOrigImportColumnIndex().intValue();
                        if (cellNum == -1 && wbtmi.getViewOrder() != null && (cellNum = wbtmi.getViewOrder().intValue()) == -1 || (cell = row.getCell(cellNum)) == null) continue;
                        int type = cell.getCellType();
                        if (type == 2) {
                            type = cell.getCachedFormulaResultType();
                        }
                        String value = "";
                        boolean skip = false;
                        switch (type) {
                            case 0: {
                                int maxlen;
                                int sepInx;
                                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                                    value = scrDateFormat.getSimpleDateFormat().format(cell.getDateCellValue());
                                    break;
                                }
                                Class<?> classObj = WorkbenchTask.getDataType(wbtmi);
                                if (classObj.equals(Integer.class)) {
                                    double numeric = cell.getNumericCellValue();
                                    value = Integer.toString((int)numeric);
                                    break;
                                }
                                if (classObj.equals(Calendar.class) || classObj.equals(Date.class)) {
                                    value = scrDateFormat.getSimpleDateFormat().format(cell.getDateCellValue());
                                    break;
                                }
                                double numeric = cell.getNumericCellValue();
                                value = nf.format(numeric);
                                if (!this.isGeoCoordinate(wbtmi) || (sepInx = value.indexOf(decSep)) <= -1 || value.substring(sepInx).length() <= nfGeoCoord.getMaximumFractionDigits()) break;
                                String value2 = nfGeoCoord.format(numeric);
                                int n = maxlen = wbtmi.getFieldName().startsWith("latitude") ? nfGeoCoord.getMaximumFractionDigits() + 3 : nfGeoCoord.getMaximumFractionDigits() + 4;
                                if (numeric < 0.0) {
                                    ++maxlen;
                                }
                                value = value2;
                                break;
                            }
                            case 1: {
                                HSSFHyperlink hl = this.checkHyperlinks(cell, activeHyperlinks);
                                if (hl == null) {
                                    value = cell.getRichStringCellValue().getString();
                                    break;
                                }
                                value = hl.getLabel();
                                break;
                            }
                            case 3: {
                                value = "";
                                type = 1;
                                break;
                            }
                            case 4: {
                                boolean bool = cell.getBooleanCellValue();
                                value = Boolean.toString(bool);
                                break;
                            }
                            default: {
                                skip = true;
                            }
                        }
                        if (skip || value == null || value.trim().equals("")) continue;
                        wbRow.setData(this.truncateIfNecessary(value, numRows, wbtmi), wbtmi.getViewOrder(), true);
                    }
                    this.addImageInfo(row, wbRow);
                    this.addGeoInfo(row, wbRow);
                    ++numRows;
                }
                if (activeHyperlinks.size() > 0) {
                    log.warn((Object)"Hyperlinks vector not empty after import. Overlapping hyperlink ranges?");
                }
                this.status = this.truncations.size() == 0 && this.messages.size() == 0 ? DataImportIFace.Status.Valid : DataImportIFace.Status.Modified;
                return this.status;
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(XLSImport.class, ex);
                log.error((Object)ex);
            }
        }
        this.status = DataImportIFace.Status.Error;
        return this.status;
    }

    protected HSSFHyperlink checkHyperlinks(HSSFCell cell, Vector<HSSFHyperlink> activeHyperlinks) {
        if (cell.getHyperlink() != null) {
            HSSFHyperlink l = cell.getHyperlink();
            if (l.getLastRow() > cell.getRowIndex() || l.getLastColumn() > cell.getColumnIndex()) {
                activeHyperlinks.add(l);
            }
            return l;
        }
        for (HSSFHyperlink hl : activeHyperlinks) {
            if (cell.getRowIndex() < hl.getFirstRow() || cell.getRowIndex() > hl.getLastRow() || cell.getColumnIndex() < hl.getFirstColumn() || cell.getColumnIndex() > hl.getLastColumn()) continue;
            if (cell.getRowIndex() == hl.getLastRow()) {
                activeHyperlinks.remove(hl);
            }
            return hl;
        }
        return null;
    }

    private void addImageInfo(HSSFRow row, WorkbenchRow wbRow) {
        for (Integer c : this.cardImageCols) {
            String attachToTblName;
            HSSFCell imgCell = row.getCell(c.intValue());
            if (imgCell == null) continue;
            String[] imageSpec = imgCell.getRichStringCellValue().getString().split("\\t");
            String imagePath = imageSpec[0];
            String string = attachToTblName = imageSpec.length > 1 ? imageSpec[1] : null;
            if (imagePath == null) continue;
            try {
                wbRow.addImage(new File(imagePath), attachToTblName);
            }
            catch (IOException e) {
                wbRow.addImagePath(imagePath, attachToTblName);
                UIRegistry.getStatusBar().setErrorMessage(e.getMessage());
                StringBuilder errMsg = new StringBuilder(UIRegistry.getResourceString("WB_IMG_IMPORT_ERROR"));
                errMsg.append(": ");
                errMsg.append(UIRegistry.getResourceString("WB_ROW"));
                errMsg.append(" ");
                errMsg.append(row.getRowNum());
                errMsg.append(", ");
                errMsg.append(imagePath);
                this.messages.add(errMsg.toString());
            }
        }
    }

    public void addGeoInfo(HSSFRow row, WorkbenchRow wbRow) {
        String geoData;
        HSSFCell c;
        if (this.geoCol != -1 && (c = row.getCell(this.geoCol)) != null && (geoData = c.getRichStringCellValue().getString()) != null) {
            wbRow.setBioGeomancerResults(geoData.length() <= 255 ? geoData : geoData.substring(0, 254));
        }
    }

    @Override
    public void setConfig(ConfigureExternalDataIFace config) {
        this.config = config;
    }

    @Override
    public ConfigureExternalDataIFace getConfig() {
        return this.config;
    }
}

