/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureXLS;
import edu.ku.brc.specify.tasks.subpane.wb.DataExport;
import edu.ku.brc.specify.tasks.subpane.wb.DataImport;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XLSExport
implements DataExport {
    ConfigureXLS config;

    public XLSExport(ConfigureExternalDataIFace config) {
        this.setConfig(config);
    }

    @Override
    public ConfigureExternalDataIFace getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ConfigureExternalDataIFace config) {
        this.config = (ConfigureXLS)config;
    }

    protected void writeHeaders(HSSFSheet workSheet) {
        String[] headers = this.config.getHeaders();
        HSSFRow hssfRow = workSheet.createRow(0);
        int col = 0;
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String head = stringArray[n2];
            hssfRow.createCell(col++).setCellValue(new HSSFRichTextString(head));
            ++n2;
        }
    }

    protected void writeExtraHeaders(HSSFSheet workSheet, Vector<Integer> imgCols, int geoDataCol) {
        HSSFRow hssfRow = workSheet.getRow(0);
        if (geoDataCol != -1) {
            hssfRow.createCell(geoDataCol).setCellValue(new HSSFRichTextString(DataImport.GEO_DATA_HEADING));
        }
        for (Integer c : imgCols) {
            hssfRow.createCell(c.intValue()).setCellValue(new HSSFRichTextString(DataImport.IMAGE_PATH_HEADING));
        }
    }

    protected int[] bldColTypes(WorkbenchTemplate wbt) {
        int[] result = new int[wbt.getWorkbenchTemplateMappingItems().size()];
        for (WorkbenchTemplateMappingItem mapItem : wbt.getWorkbenchTemplateMappingItems()) {
            result[mapItem.getViewOrder().shortValue()] = this.getColType(mapItem);
        }
        return result;
    }

    protected int getColType(WorkbenchTemplateMappingItem mapItem) {
        Class<?> dataType = WorkbenchTask.getDataType(mapItem);
        if (dataType == Long.class || dataType == Float.class || dataType == Byte.class || dataType == Integer.class || dataType == Short.class || dataType == Double.class || dataType == BigDecimal.class) {
            return 0;
        }
        if (dataType == Boolean.class) {
            return 4;
        }
        return 1;
    }

    protected void setCellValue(HSSFCell cell, String value) {
        cell.setCellValue(new HSSFRichTextString(value));
    }

    protected DocumentSummaryInformation writeMappings(WorkbenchTemplate wbt) {
        DocumentSummaryInformation dsi = PropertySetFactory.newDocumentSummaryInformation();
        CustomProperties cps = new CustomProperties();
        for (WorkbenchTemplateMappingItem wbmi : wbt.getWorkbenchTemplateMappingItems()) {
            cps.put(wbmi.getCaption(), String.valueOf(wbmi.getTableName()) + "\t" + wbmi.getFieldName() + "\t" + wbmi.getXCoord() + "\t" + wbmi.getYCoord() + "\t" + wbmi.getCaption() + "\t" + wbmi.getFieldType() + "\t" + wbmi.getMetaData());
        }
        dsi.setCustomProperties(cps);
        return dsi;
    }

    @Override
    public void writeData(List<?> data) throws Exception {
        boolean hasRows;
        boolean hasTemplate;
        HSSFWorkbook workBook = new HSSFWorkbook();
        HSSFSheet workSheet = workBook.createSheet();
        DocumentSummaryInformation mappings = null;
        int rowNum = 0;
        if (this.config.getFirstRowHasHeaders() && !this.config.getAppendData()) {
            this.writeHeaders(workSheet);
            ++rowNum;
            String[] headers = this.config.getHeaders();
            int i = 0;
            while (i < headers.length) {
                workSheet.setColumnWidth(i, StringUtils.isNotEmpty((String)headers[i]) ? 256 * headers[i].length() : 2560);
                ++i;
            }
            WorkbenchTemplate wbTemplate = null;
            wbTemplate = data.get(0) instanceof WorkbenchTemplate ? (WorkbenchTemplate)data.get(0) : ((WorkbenchRow)data.get(0)).getWorkbench().getWorkbenchTemplate();
            mappings = this.writeMappings(wbTemplate);
        }
        boolean bl = (hasTemplate = data.get(0) instanceof WorkbenchTemplate) ? data.size() > 1 : (hasRows = data.size() > 0);
        if (hasRows) {
            WorkbenchRow wbRow = (WorkbenchRow)data.get(hasTemplate ? 1 : 0);
            Workbench workBench = wbRow.getWorkbench();
            WorkbenchTemplate template = workBench.getWorkbenchTemplate();
            int numCols = template.getWorkbenchTemplateMappingItems().size();
            int geoDataCol = -1;
            Vector<Integer> imgCols = new Vector<Integer>();
            int[] disciplinees = this.bldColTypes(template);
            for (Object rowObj : data) {
                HSSFCell cell;
                if (rowObj instanceof WorkbenchTemplate) continue;
                WorkbenchRow row = (WorkbenchRow)rowObj;
                HSSFRow hssfRow = workSheet.createRow(rowNum++);
                boolean rowHasGeoData = false;
                int colNum = 0;
                while (colNum < numCols) {
                    cell = hssfRow.createCell(colNum);
                    cell.setCellType(disciplinees[colNum]);
                    this.setCellValue(cell, row.getData(colNum));
                    ++colNum;
                }
                if (row.getBioGeomancerResults() != null && !row.getBioGeomancerResults().equals("")) {
                    geoDataCol = colNum;
                    rowHasGeoData = true;
                    cell = hssfRow.createCell(colNum++);
                    cell.setCellType(1);
                    this.setCellValue(cell, row.getBioGeomancerResults());
                }
                if (row.getRowImage(0) == null) continue;
                if (!rowHasGeoData) {
                    ++colNum;
                }
                int imgIdx = 0;
                WorkbenchRowImage img = row.getRowImage(imgIdx++);
                while (img != null) {
                    if (imgCols.indexOf(colNum) < 0) {
                        imgCols.add(colNum);
                    }
                    HSSFCell cell2 = hssfRow.createCell(colNum++);
                    cell2.setCellType(1);
                    String cellValue = img.getCardImageFullPath();
                    String attachToTbl = img.getAttachToTableName();
                    if (attachToTbl != null) {
                        cellValue = String.valueOf(cellValue) + "\t" + attachToTbl;
                    }
                    this.setCellValue(cell2, cellValue);
                    img = row.getRowImage(imgIdx++);
                }
            }
            if (imgCols.size() > 0 || geoDataCol != -1) {
                this.writeExtraHeaders(workSheet, imgCols, geoDataCol);
            }
        }
        try {
            File file = new File(this.getConfig().getFileName());
            if (file.canWrite() || !file.exists() && file.createNewFile()) {
                FileOutputStream fos = new FileOutputStream(file);
                workBook.write((OutputStream)fos);
                fos.close();
                if (mappings != null) {
                    FileInputStream is = new FileInputStream(file);
                    POIFSFileSystem poifs = new POIFSFileSystem((InputStream)is);
                    ((InputStream)is).close();
                    mappings.write((DirectoryEntry)poifs.getRoot(), "\u0005DocumentSummaryInformation");
                    fos = new FileOutputStream(file);
                    poifs.writeFilesystem((OutputStream)fos);
                    fos.close();
                }
            } else {
                UIRegistry.displayErrorDlgLocalized("WB_EXPORT_PERM_ERR", new Object[0]);
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(XLSExport.class, e);
            throw e;
        }
    }
}

