/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DB;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDef;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTableInvalidValue;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploaderException;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.WorkbenchUploadMapper;
import java.util.List;
import java.util.Vector;

public class WorkbenchValidator {
    protected final WorkbenchPaneSS wbPane;
    protected final Workbench workbench;
    protected final Uploader uploader;

    public WorkbenchValidator(WorkbenchPaneSS wbPane) throws WorkbenchValidatorException, UploaderException {
        this.wbPane = wbPane;
        this.workbench = wbPane.getWorkbench();
        this.uploader = this.createUploader();
    }

    public WorkbenchValidator(Workbench wb) throws WorkbenchValidatorException, UploaderException {
        this.wbPane = null;
        this.workbench = wb;
        this.uploader = this.createUploader();
    }

    protected Uploader createUploader() throws WorkbenchValidatorException, UploaderException {
        WorkbenchUploadMapper importMapper = new WorkbenchUploadMapper(this.workbench.getWorkbenchTemplate());
        Vector<UploadMappingDef> maps = importMapper.getImporterMapping();
        try {
            DB db = new DB();
            Uploader result = new Uploader(db, new UploadData(maps, this.workbench.getWorkbenchRowsAsList()), this.wbPane, this.workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems(), true);
            Vector<UploadMessage> structureErrors = result.verifyUploadability();
            if (structureErrors.size() > 0) {
                throw new WorkbenchValidatorException(structureErrors);
            }
            return result;
        }
        catch (Exception ex) {
            throw new UploaderException(ex);
        }
    }

    public List<UploadTableInvalidValue> endCellEdit(int row, int col) {
        Vector<UploadTableInvalidValue> issues = this.uploader.validateData(row, col);
        return issues;
    }

    public void startCellEdit(int row, int col) {
    }

    public Uploader getUploader() {
        return this.uploader;
    }

    public class WorkbenchValidatorException
    extends Exception {
        protected final Vector<UploadMessage> structureErrors;

        public WorkbenchValidatorException(Vector<UploadMessage> structureErrors) {
            this.structureErrors = structureErrors;
        }

        public Vector<UploadMessage> getStructureErrors() {
            return this.structureErrors;
        }
    }
}

