/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.GridTableHeader;
import edu.ku.brc.specify.tasks.subpane.wb.GridTableModel;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.TableSearcher;
import edu.ku.brc.ui.TableSearcherCell;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.tmanfe.SearchReplacePanel;
import edu.ku.brc.ui.tmanfe.SpreadSheet;
import edu.ku.brc.ui.tmanfe.SpreadSheetModel;
import edu.ku.brc.util.DateConverter;
import edu.ku.brc.util.GeoRefConverter;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.table.TableColumnExt;

public class WorkbenchSpreadSheet
extends SpreadSheet {
    protected WorkbenchPaneSS workbenchPaneSS;
    protected DateConverter dateConverter = new DateConverter();
    protected GeoRefConverter geoRefConverter = new GeoRefConverter();
    protected Vector<Comparator<String>> comparators;

    public WorkbenchSpreadSheet(SpreadSheetModel model, WorkbenchPaneSS workbenchPaneSS) {
        super(model);
        this.workbenchPaneSS = workbenchPaneSS;
        this.buildComparators();
    }

    public Vector<Comparator<String>> getComparators() {
        return this.comparators;
    }

    @Override
    public void paste() {
        super.paste();
        if (this.pastedRows[0] > -1) {
            int[] rows = new int[this.pastedRows[1] + 1];
            int r = 0;
            while (r < rows.length) {
                rows[r] = this.convertRowIndexToModel(this.pastedRows[0] + r);
                ++r;
            }
            this.workbenchPaneSS.validateRows(rows);
        }
        this.pastedRows[0] = -1;
    }

    @Override
    public void cutOrCopy(boolean isCut) {
        if (!this.canCutOrCopy()) {
            return;
        }
        super.cutOrCopy(isCut);
        if (isCut) {
            int[] selRows = this.getSelectedRows();
            int[] rows = new int[selRows.length];
            int r = 0;
            while (r < rows.length) {
                rows[r] = this.convertRowIndexToModel(selRows[r]);
                ++r;
            }
            this.workbenchPaneSS.validateRows(rows);
        }
    }

    @Override
    protected SearchReplacePanel createSearchReplacePanel() {
        return new SearchReplacePanel(this){
            final Vector<Integer> replacedRows;
            {
                this.replacedRows = new Vector();
            }

            @Override
            protected TableSearcher createTableSearcher() {
                return new TableSearcher(this.table, this){

                    @Override
                    public boolean replace(TableSearcherCell cell, String findValue, String replaceValue, boolean isMtchCaseOn, boolean isSearchSelection) {
                        boolean result = super.replace(cell, findValue, replaceValue, isMtchCaseOn, isSearchSelection);
                        if (result && (this).WorkbenchSpreadSheet.this.workbenchPaneSS.isDoIncremental()) {
                            replacedRows.add(cell.getRow());
                        }
                        return result;
                    }

                    @Override
                    public void replacementCleanup() {
                        if ((this).WorkbenchSpreadSheet.this.workbenchPaneSS.isDoIncremental()) {
                            int[] rows = new int[replacedRows.size()];
                            int r = 0;
                            while (r < rows.length) {
                                rows[r] = WorkbenchSpreadSheet.this.convertRowIndexToModel(replacedRows.get(r));
                                ++r;
                            }
                            (this).WorkbenchSpreadSheet.this.workbenchPaneSS.validateRows(rows);
                        }
                        WorkbenchSpreadSheet.this.model.fireTableDataChanged();
                    }

                    @Override
                    protected void reset() {
                        super.reset();
                        replacedRows.clear();
                    }
                };
            }
        };
    }

    protected void buildComparators() {
        this.comparators = new Vector(this.model.getColumnCount());
        int c = 0;
        while (c < this.model.getColumnCount()) {
            this.comparators.add(this.getComparatorForCol(c));
            ++c;
        }
    }

    protected Comparator<String> getComparatorForCol(int colIdx) {
        DBTableInfo ti;
        DBFieldInfo fi;
        UIFieldFormatterIFace format;
        GridTableHeader mapping = ((GridTableModel)this.model).getColMapping(colIdx);
        Class<?> dataClass = mapping.getDataType();
        if (dataClass.equals(Calendar.class)) {
            return new DateColumnComparator();
        }
        if (dataClass.equals(Boolean.class)) {
            return new BooleanColumnComparator();
        }
        if (this.isGeoRefMapping(mapping)) {
            return new GeoRefColumnComparator();
        }
        if (Number.class.isAssignableFrom(dataClass)) {
            return new NumericColumnComparator();
        }
        if (mapping.getFieldName().equalsIgnoreCase("catalognumber") && mapping.getTableName().equalsIgnoreCase("collectionobject") && (format = (fi = (ti = DBTableIdMgr.getInstance().getInfoById(1)).getFieldByName("catalogNumber")).getFormatter()) != null && format.isNumeric()) {
            return new NumericColumnComparator();
        }
        return null;
    }

    protected boolean isGeoRefMapping(GridTableHeader mapping) {
        return mapping.getFieldName().equalsIgnoreCase("latitude1") || mapping.getFieldName().equalsIgnoreCase("latitude2") || mapping.getFieldName().equalsIgnoreCase("longitude1") || mapping.getFieldName().equalsIgnoreCase("longitude2");
    }

    public void toggleSortOrder(int arg0) {
        TableColumnExt col = this.getColumnExt(arg0);
        Comparator<String> cmp = this.comparators.get(arg0);
        if (col.getComparator() == null && cmp != null) {
            this.getColumnExt(arg0).setComparator(cmp);
        }
        super.toggleSortOrder(arg0);
    }

    @Override
    protected JPopupMenu createMenuForSelection(Point pnt) {
        UIFieldFormatterIFace fldFormatter;
        int[] rows;
        JPopupMenu result = super.createMenuForSelection(pnt);
        final int modelCol = this.convertColumnIndexToModel(this.columnAtPoint(pnt));
        if (this.getSelectedColumnCount() == 1 && this.getModel().getColumnClass(modelCol).equals(String.class) && (rows = this.getSelectedRowModelIndexes()).length > 1 && StringUtils.isNotBlank((String)((String)this.getValueAt(rows[0], modelCol))) && (fldFormatter = this.workbenchPaneSS.getFormatterForCol(modelCol)) != null && fldFormatter.isIncrementer()) {
            int insertPosition = -1;
            int i = 0;
            while (i < result.getComponentCount()) {
                Component c = result.getComponent(i);
                if (c instanceof JMenuItem && ((JMenuItem)c).getText().equals(UIRegistry.getResourceString("SpreadSheet.FillDown"))) {
                    insertPosition = i;
                    break;
                }
                ++i;
            }
            JMenuItem mi = new JMenuItem(UIRegistry.getResourceString("WorkbenchSpreadSheet.FillDownIncrement"));
            if (insertPosition == -1) {
                result.add(mi);
            } else {
                result.insert(mi, insertPosition);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((GridTableModel)WorkbenchSpreadSheet.this.model).fillAndIncrement(modelCol, rows[0], rows, fldFormatter);
                    WorkbenchSpreadSheet.this.popupMenu.setVisible(false);
                }
            });
        }
        return result;
    }

    public class BooleanColumnComparator
    implements Comparator<String> {
        protected Boolean getBool(String fldStr) {
            if (fldStr == null || fldStr.equals("")) {
                return null;
            }
            int i = 0;
            while (i < WorkbenchTask.boolStrings.length) {
                if (fldStr.equalsIgnoreCase(WorkbenchTask.boolStrings[i])) break;
                ++i;
            }
            if (i == WorkbenchTask.boolStrings.length) {
                return null;
            }
            return i % 2 == 0;
        }

        @Override
        public int compare(String arg0, String arg1) {
            Boolean b0 = this.getBool(arg0);
            Boolean b1 = this.getBool(arg1);
            if (b0 == null && b1 == null) {
                return arg0.compareTo(arg1);
            }
            if (b0 == null && b1 != null) {
                return -1;
            }
            if (b0 != null && b1 == null) {
                return 1;
            }
            return b0.compareTo(b1);
        }
    }

    public class DateColumnComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            Calendar cal0 = null;
            Calendar cal1 = null;
            try {
                cal0 = WorkbenchSpreadSheet.this.dateConverter.convert(arg0);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                cal1 = WorkbenchSpreadSheet.this.dateConverter.convert(arg1);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (cal0 == null && cal1 == null) {
                return arg0.compareTo(arg1);
            }
            if (cal0 == null && cal1 != null) {
                return -1;
            }
            if (cal0 != null && cal1 == null) {
                return 1;
            }
            return cal0.compareTo(cal1);
        }
    }

    public class GeoRefColumnComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            String llStr0 = null;
            String llStr1 = null;
            BigDecimal ll0 = null;
            BigDecimal ll1 = null;
            try {
                llStr0 = WorkbenchSpreadSheet.this.geoRefConverter.convert(arg0, GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
                ll0 = UIHelper.parseDoubleToBigDecimal(llStr0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                llStr1 = WorkbenchSpreadSheet.this.geoRefConverter.convert(arg1, GeoRefConverter.GeoRefFormat.D_PLUS_MINUS.name());
                ll1 = UIHelper.parseDoubleToBigDecimal(llStr1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ll0 == null && ll1 == null) {
                return arg0.compareTo(arg1);
            }
            if (ll0 == null && ll1 != null) {
                return -1;
            }
            if (ll0 != null && ll1 == null) {
                return 1;
            }
            return ll0.compareTo(ll1);
        }
    }

    public class NumericColumnComparator
    implements Comparator<String> {
        @Override
        public int compare(String arg0, String arg1) {
            Number n0 = null;
            Number n1 = null;
            NumberFormat nf = NumberFormat.getInstance();
            try {
                n0 = nf.parse(arg0);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                n1 = nf.parse(arg1);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (n0 == null && n1 == null) {
                return arg0.compareTo(arg1);
            }
            if (n0 == null && n1 != null) {
                return -1;
            }
            if (n0 != null && n1 == null) {
                return 1;
            }
            return new Double(n0.doubleValue()).compareTo(n1.doubleValue());
        }
    }
}

