/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class WorkbenchJRDataSource
implements JRDataSource {
    private Hashtable<String, Short> map = new Hashtable();
    private Workbench workbench;
    private int rowIndex = -1;
    private List<WorkbenchRow> workbenchRows;

    public WorkbenchJRDataSource(Workbench workbench, boolean useLongFieldNames) {
        this.workbench = workbench;
        this.workbenchRows = workbench.getWorkbenchRowsAsList();
        this.createMap(useLongFieldNames);
    }

    public WorkbenchJRDataSource(Workbench workbench, List<WorkbenchRow> workbenchRows, boolean useLongFieldNames) {
        this.workbench = workbench;
        this.workbenchRows = workbenchRows;
        Collections.sort(workbenchRows);
        this.createMap(useLongFieldNames);
    }

    protected void createMap(boolean useLongFieldNames) {
        for (WorkbenchTemplateMappingItem wbtmi : this.workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems()) {
            String fldName = wbtmi.getFieldName();
            if (useLongFieldNames) {
                fldName = String.valueOf(wbtmi.getTableName()) + "." + fldName;
            }
            this.map.put(fldName, wbtmi.getViewOrder());
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        WorkbenchRow row = this.workbench.getRow(this.rowIndex);
        Short inx = this.map.get(field.getName());
        return inx == null ? "" : row.getData(inx.shortValue());
    }

    public Object getFieldValue(String field) {
        WorkbenchRow row = this.workbench.getRow(this.rowIndex);
        Short inx = this.map.get(field);
        return inx == null ? "" : row.getData(inx.shortValue());
    }

    public boolean next() throws JRException {
        if (this.rowIndex >= this.workbenchRows.size() - 1) {
            return false;
        }
        ++this.rowIndex;
        return true;
    }
}

