/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.rstools.ExportToFile;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WorkbenchBackupMgr {
    private static final Logger log = Logger.getLogger(WorkbenchPaneSS.class);
    private static int maxBackupCount = 5;
    private static String backupSubDir = "Backups";

    protected static String getPrefix(Workbench workbench) {
        return "WB" + workbench.getId().toString() + "_";
    }

    protected static Vector<File> getExistingBackups(Workbench workbench) {
        File[] backups = UIRegistry.getAppDataSubDir(backupSubDir, true).listFiles();
        Vector<File> result = new Vector<File>(maxBackupCount);
        File[] fileArray = backups;
        int n = backups.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().startsWith(WorkbenchBackupMgr.getPrefix(workbench))) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }

    protected static File getEarliestBackup(Vector<File> backups) {
        Date earliest = null;
        File earliestFile = null;
        for (File f : backups) {
            Date current = new Date(f.lastModified());
            if (earliest != null && !earliest.after(current)) continue;
            earliest = current;
            earliestFile = f;
        }
        return earliestFile;
    }

    protected static void cleanupBackups(Workbench workbench) {
        Vector<File> backups = WorkbenchBackupMgr.getExistingBackups(workbench);
        if (backups.size() > maxBackupCount) {
            File earliest = WorkbenchBackupMgr.getEarliestBackup(backups);
            if (earliest != null) {
                if (!earliest.delete()) {
                    log.error((Object)("Unable to delete backup: " + earliest.getName()));
                }
            } else {
                log.error((Object)"Unable to delete backup");
            }
        }
    }

    protected static String getNameForBackupFileName(Workbench workbench) {
        UIHelper.OSTYPE os = UIHelper.getOSType();
        String invalidChars = os.equals((Object)UIHelper.OSTYPE.Windows) ? "\\/:*?\"<>|" : (os.equals((Object)UIHelper.OSTYPE.MacOSX) ? "/:" : "/");
        char[] chars = workbench.getName().toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (invalidChars.indexOf(chars[i]) >= 0 || chars[i] < ' ' || chars[i] > '~' && chars[i] < '\u00a0') {
                chars[i] = 95;
            }
            ++i;
        }
        return new String(chars);
    }

    protected static String getFileName(Workbench workbench) {
        String result;
        File file;
        int tries = 0;
        do {
            result = String.valueOf(WorkbenchBackupMgr.getPrefix(workbench)) + Math.round(Math.random() * 1000.0) + "_" + WorkbenchBackupMgr.getNameForBackupFileName(workbench) + ".xls";
            file = new File(result);
        } while (tries++ < 100 && file.exists());
        return result;
    }

    public static String backupWorkbench(Object toBackup) {
        String backupName = null;
        try {
            Workbench workbench = null;
            if (toBackup instanceof Workbench) {
                workbench = (Workbench)toBackup;
            } else {
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    workbench = session.get(Workbench.class, (Integer)toBackup);
                    workbench.forceLoad();
                }
                finally {
                    session.close();
                    session = null;
                }
            }
            String fileName = WorkbenchBackupMgr.getFileName(workbench);
            backupName = UIRegistry.getAppDataSubDir(backupSubDir, true) + File.separator + fileName;
            Properties props = new Properties();
            props.setProperty("mimetype", ExportFileConfigurationFactory.XLS_MIME_TYPE);
            props.setProperty("fileName", backupName);
            CommandAction command = new CommandAction("Plugins", "ExportList");
            command.setProperty("tool", ExportToFile.class);
            command.setProperty("statusmsgkey", "WB_BACKUP_TO");
            command.setProperty("statusdonemsgkey", "WB_BACKUP_TO_DONE");
            Vector<WorkbenchRow> rowData = workbench.getWorkbenchRowsAsList();
            Vector<Comparable<WorkbenchTemplate>> exportData = new Vector<Comparable<WorkbenchTemplate>>(rowData.size() + 1);
            exportData.add(workbench.getWorkbenchTemplate());
            exportData.addAll(rowData);
            command.setData(exportData);
            WorkbenchTask.sendExportCommand(props, workbench.getWorkbenchTemplate().getWorkbenchTemplateMappingItems(), command);
            UIRegistry.getStatusBar().setText("");
            WorkbenchBackupMgr.cleanupBackups(workbench);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(WorkbenchBackupMgr.class, ex);
            log.error((Object)ex);
        }
        return backupName;
    }
}

