/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.SchemaI18NService;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.TableFieldPair;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.datamodel.WorkbenchTemplate;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.FieldInfo;
import edu.ku.brc.specify.tasks.subpane.wb.ImportColumnInfo;
import edu.ku.brc.specify.tasks.subpane.wb.ImportDataFileInfo;
import edu.ku.brc.specify.tasks.subpane.wb.TableInfo;
import edu.ku.brc.specify.tasks.subpane.wb.TableInfoListRenderer;
import edu.ku.brc.specify.tasks.subpane.wb.TableListItemIFace;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.DB;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadData;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMappingDef;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadMessage;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.WorkbenchUploadMapper;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DefaultModifiableListModel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class TemplateEditor
extends CustomDialog {
    private static final Logger log = Logger.getLogger(TemplateEditor.class);
    private static int taxId = 4;
    private static int taxOnlyId = 4000;
    protected JButton mapToBtn;
    protected JButton unmapBtn;
    protected JButton upBtn;
    protected JButton downBtn;
    protected JLabel descriptionLbl;
    protected JList mapList;
    protected DefaultModifiableListModel<FieldMappingPanel> mapModel;
    protected JScrollPane mapScrollPane;
    protected JList tableList;
    protected DefaultModifiableListModel<TableInfo> tableModel;
    protected JList fieldList;
    protected DefaultModifiableListModel<FieldInfo> fieldModel;
    protected Vector<WorkbenchTemplateMappingItem> deletedItems = new Vector();
    protected boolean hasChanged = false;
    protected boolean doingFill = false;
    protected Color btnPanelColor;
    protected JPanel btnPanel;
    protected ImportDataFileInfo dataFileInfo = null;
    protected WorkbenchTemplate workbenchTemplate = null;
    protected DBTableIdMgr databaseSchema;
    protected List<TreeDefItemStandardEntry> taxRanks = null;
    protected boolean isMappedToAFile;
    protected boolean isEditMode;
    protected boolean isReadOnly = false;
    protected boolean ignoreMapListUpdate = false;
    protected ImageIcon blankIcon = IconManager.getIcon("BlankIcon", IconManager.STD_ICON_SIZE);
    protected TableInfoListRenderer tableInfoListRenderer;
    protected List<String> tablesWithAttachments = null;
    protected Map<String, UploadInfo> uploadDefs = new HashMap<String, UploadInfo>();

    public TemplateEditor(Frame frame, String title, ImportDataFileInfo dataFileInfo) throws Exception {
        super(frame, title, true, 7, null);
        this.dataFileInfo = dataFileInfo;
        this.isMappedToAFile = dataFileInfo != null;
        this.isEditMode = false;
        this.helpContext = dataFileInfo == null ? "WorkbenchNewMapping" : "WorkbenchEditMapping";
        this.buildUploadDefs();
        this.createUI();
    }

    public TemplateEditor(Frame frame, String title, WorkbenchTemplate wbTemplate) throws Exception {
        super(frame, title, true, 7, null);
        this.workbenchTemplate = wbTemplate;
        this.isMappedToAFile = StringUtils.isNotEmpty((String)wbTemplate.getSrcFilePath());
        this.isEditMode = this.workbenchTemplate != null;
        this.helpContext = "WorkbenchEditMapping";
        this.buildUploadDefs();
        this.createUI();
    }

    @Override
    public void createUI() {
        String fieldsLabel;
        super.createUI();
        this.databaseSchema = WorkbenchTask.getDatabaseSchema();
        int disciplineeId = AppContextMgr.getInstance().getClassObject(Discipline.class).getDisciplineId();
        SchemaI18NService.getInstance().loadWithLocale(SpLocaleContainer.WORKBENCH_SCHEMA, disciplineeId, this.databaseSchema, SchemaI18NService.getCurrentLocale());
        Vector<TableInfo> tableInfoList = new Vector<TableInfo>();
        for (DBTableInfo dBTableInfo : this.databaseSchema.getTables()) {
            if (!StringUtils.isNotEmpty((String)dBTableInfo.toString())) continue;
            TableInfo tableInfo = new TableInfo(dBTableInfo, IconManager.STD_ICON_SIZE);
            tableInfoList.add(tableInfo);
            Vector fldList = new Vector();
            for (DBFieldInfo fi : dBTableInfo.getFields()) {
                String fldTitle = fi.getTitle().replace(" ", "");
                if (fldTitle.equalsIgnoreCase(fi.getName())) {
                    UploadInfo upInfo = this.getUploadInfo(fi);
                    DBFieldInfo mInfo = this.getMappedFieldInfo(fi);
                    if (mInfo != null) {
                        String title = mInfo.getTitle();
                        if (upInfo != null && upInfo.getSequence() != -1) {
                            title = String.valueOf(title) + " " + (upInfo.getSequence() + 1);
                        }
                        fi.setTitle(title);
                    }
                }
                fldList.add(new FieldInfo(dBTableInfo, fi));
            }
            tableInfo.setFieldItems(fldList);
        }
        Collections.sort(tableInfoList);
        this.fieldModel = new DefaultModifiableListModel();
        this.tableModel = new DefaultModifiableListModel();
        for (TableInfo tableInfo : tableInfoList) {
            this.tableModel.add(tableInfo);
            for (FieldInfo fi : tableInfo.getFieldItems()) {
                this.fieldModel.add(fi);
            }
        }
        this.tableList = new JList<TableInfo>(this.tableModel);
        this.tableList.setSelectionMode(0);
        this.tableInfoListRenderer = new TableInfoListRenderer(IconManager.STD_ICON_SIZE);
        this.tableList.setCellRenderer(this.tableInfoListRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.tableList, 20, 31);
        this.tableList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selObj = TemplateEditor.this.tableList.getSelectedValue();
                    if (selObj != null) {
                        TemplateEditor.this.fillFieldList((TableInfo)selObj);
                    }
                    TemplateEditor.this.updateEnabledState();
                }
            }
        });
        this.fieldList = new JList<FieldInfo>(this.fieldModel);
        this.tableInfoListRenderer = new TableInfoListRenderer(IconManager.STD_ICON_SIZE);
        this.fieldList.setCellRenderer(this.tableInfoListRenderer);
        this.fieldList.setSelectionMode(2);
        JScrollPane fieldScrollPane = new JScrollPane(this.fieldList, 20, 31);
        this.fieldList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TemplateEditor.this.updateEnabledState();
                    TemplateEditor.this.updateFieldDescription();
                }
            }
        });
        this.mapModel = new DefaultModifiableListModel();
        this.mapList = new JList<FieldMappingPanel>(this.mapModel);
        this.mapList.setCellRenderer(new MapCellRenderer());
        this.mapList.setSelectionMode(0);
        this.mapScrollPane = new JScrollPane(this.mapList, 20, 31);
        this.mapList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FieldMappingPanel fmp;
                if (!e.getValueIsAdjusting() && (fmp = (FieldMappingPanel)TemplateEditor.this.mapList.getSelectedValue()) != null) {
                    TemplateEditor.this.ignoreMapListUpdate = true;
                    FieldInfo fldInfo = fmp.getFieldInfo();
                    if (fldInfo != null) {
                        int i = 0;
                        while (i < TemplateEditor.this.tableModel.size()) {
                            TableInfo tblInfo = (TableInfo)TemplateEditor.this.tableModel.get(i);
                            if (fldInfo.getTableinfo() == tblInfo.getTableInfo()) {
                                TemplateEditor.this.tableList.setSelectedValue(tblInfo, true);
                                TemplateEditor.this.fillFieldList(tblInfo);
                                TemplateEditor.this.fieldList.setSelectedValue(fldInfo, true);
                                TemplateEditor.this.updateFieldDescription();
                                break;
                            }
                            ++i;
                        }
                    }
                    TemplateEditor.this.ignoreMapListUpdate = false;
                    TemplateEditor.this.updateEnabledState();
                }
            }
        });
        this.upBtn = UIHelper.createIconBtn("ReorderUp", "WB_MOVE_UP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = TemplateEditor.this.mapList.getSelectedIndex();
                FieldMappingPanel fmp = TemplateEditor.this.mapModel.getElementAt(inx);
                TemplateEditor.this.mapModel.remove(fmp);
                TemplateEditor.this.mapModel.insertElementAt((FieldMappingPanel)fmp, inx - 1);
                TemplateEditor.this.mapList.setSelectedIndex(inx - 1);
                TemplateEditor.this.updateEnabledState();
                TemplateEditor.this.setChanged(true);
            }
        });
        this.downBtn = UIHelper.createIconBtn("ReorderDown", "WB_MOVE_DOWN", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = TemplateEditor.this.mapList.getSelectedIndex();
                FieldMappingPanel fmp = TemplateEditor.this.mapModel.getElementAt(inx);
                TemplateEditor.this.mapModel.remove(fmp);
                TemplateEditor.this.mapModel.insertElementAt((FieldMappingPanel)fmp, inx + 1);
                TemplateEditor.this.mapList.setSelectedIndex(inx + 1);
                TemplateEditor.this.updateEnabledState();
                TemplateEditor.this.setChanged(true);
            }
        });
        JButton dumpMappingBtn = UIHelper.createIconBtn("BlankIcon", IconManager.IconSize.Std16, "WB_MAPPING_DUMP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TemplateEditor.this.dumpMapping();
            }
        });
        dumpMappingBtn.setEnabled(true);
        dumpMappingBtn.setFocusable(false);
        dumpMappingBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JButton)e.getSource()).setIcon(IconManager.getIcon("Save", IconManager.IconSize.Std16));
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JButton)e.getSource()).setIcon(IconManager.getIcon("BlankIcon", IconManager.IconSize.Std16));
                super.mouseExited(e);
            }
        });
        this.mapToBtn = UIHelper.createIconBtn("Map", "WB_ADD_MAPPING_ITEM", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TemplateEditor.this.map();
            }
        });
        this.unmapBtn = UIHelper.createIconBtn("Unmap", "WB_REMOVE_MAPPING_ITEM", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TemplateEditor.this.unmap();
            }
        });
        String dataTypeLabel = UIRegistry.getResourceString("WB_DATA_TYPE");
        String mapListLeftLabel = fieldsLabel = UIRegistry.getResourceString("WB_FIELDS");
        String mapListRightLabel = UIRegistry.getResourceString("WB_COLUMNS");
        CellConstraints cc = new CellConstraints();
        JPanel mainLayoutPanel = new JPanel();
        PanelBuilder labelsBldr = new PanelBuilder(new FormLayout("p, f:p:g, p", "p"));
        labelsBldr.add((Component)UIHelper.createLabel(mapListLeftLabel, 2), cc.xy(1, 1));
        labelsBldr.add((Component)UIHelper.createLabel(mapListRightLabel, 4), cc.xy(3, 1));
        PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "p,f:p:g, p, 2px, p, f:p:g"));
        upDownPanel.add((Component)dumpMappingBtn, cc.xy(1, 1));
        upDownPanel.add((Component)this.upBtn, cc.xy(1, 3));
        upDownPanel.add((Component)this.downBtn, cc.xy(1, 5));
        PanelBuilder middlePanel = new PanelBuilder(new FormLayout("c:p:g", "p, 2px, p"));
        middlePanel.add((Component)this.mapToBtn, cc.xy(1, 1));
        middlePanel.add((Component)this.unmapBtn, cc.xy(1, 3));
        this.btnPanel = middlePanel.getPanel();
        this.btnPanel.setOpaque(false);
        PanelBuilder outerMiddlePanel = new PanelBuilder(new FormLayout("c:p:g", "f:p:g, p, f:p:g"));
        outerMiddlePanel.add((Component)this.btnPanel, cc.xy(1, 2));
        outerMiddlePanel.getPanel().setOpaque(false);
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:max(200px;p):g, 5px, max(200px;p), 5px, p:g, 5px, f:max(250px;p):g, 2px, p", "p, 2px, f:max(350px;p):g"), mainLayoutPanel);
        builder.add((Component)UIHelper.createLabel(dataTypeLabel, 0), cc.xy(1, 1));
        builder.add((Component)UIHelper.createLabel(fieldsLabel, 0), cc.xy(3, 1));
        builder.add((Component)labelsBldr.getPanel(), cc.xy(7, 1));
        builder.add((Component)jScrollPane, cc.xy(1, 3));
        builder.add((Component)fieldScrollPane, cc.xy(3, 3));
        builder.add((Component)outerMiddlePanel.getPanel(), cc.xy(5, 3));
        builder.add((Component)this.mapScrollPane, cc.xy(7, 3));
        builder.add((Component)upDownPanel.getPanel(), cc.xy(9, 3));
        mainLayoutPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel megaPanel = new JPanel(new BorderLayout());
        megaPanel.add((Component)mainLayoutPanel, "Center");
        this.descriptionLbl = UIHelper.createLabel("  ", 2);
        megaPanel.add((Component)this.descriptionLbl, "South");
        this.contentPanel = megaPanel;
        Color bgColor = this.btnPanel.getBackground();
        int inc = 16;
        this.btnPanelColor = new Color(Math.min(255, bgColor.getRed() + inc), Math.min(255, bgColor.getGreen() + inc), Math.min(255, bgColor.getBlue() + inc));
        this.btnPanel.setBackground(this.btnPanelColor);
        this.btnPanel.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.okBtn.setEnabled(false);
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
        if (this.dataFileInfo != null) {
            this.autoMapFromDataFile(this.dataFileInfo.getColInfo());
        }
        if (this.workbenchTemplate != null) {
            this.fillFromTemplate();
            this.setChanged(false);
        }
        this.mainPanel.add(this.contentPanel, "Center");
        if (this.dataFileInfo == null) {
            FieldMappingPanel fmp = this.addMappingItem(null, IconManager.getIcon("BlankIcon", IconManager.STD_ICON_SIZE), null);
            fmp.setAdded(true);
            fmp.setNew(true);
        }
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateEditor.this.cancelBtn.requestFocus();
                TemplateEditor.this.fieldModel.clear();
                TemplateEditor.this.fieldList.clearSelection();
                TemplateEditor.this.updateFieldDescription();
                TemplateEditor.this.updateEnabledState();
                if (TemplateEditor.this.mapModel.size() > 1) {
                    TemplateEditor.this.mapList.clearSelection();
                }
            }
        });
    }

    protected void dumpMapping() {
        StringBuilder clipBrdTxt = new StringBuilder();
        StringBuilder sb = new StringBuilder("<html><br><table border=\"1\">");
        sb.append("<tr><td><b>" + UIRegistry.getResourceString("WB_FIELDS") + "</b></td><td><b>" + UIRegistry.getResourceString("WB_COLUMNS") + "</b></td></tr>");
        int i = 0;
        while (i < this.mapModel.size()) {
            FieldMappingPanel fmp = (FieldMappingPanel)this.mapModel.get(i);
            FieldInfo fieldInfo = fmp.getFieldInfo();
            ImportColumnInfo colInfo = fmp.getColInfo();
            if (!fmp.isNew) {
                sb.append("<tr><td>" + fieldInfo.getTableinfo().getTitle() + " - " + fieldInfo.getFieldInfo().getName() + "</td><td>" + colInfo.getColTitle() + "</td></tr>");
                clipBrdTxt.append(String.valueOf(fieldInfo.getTableinfo().getTitle()) + " - " + fieldInfo.getFieldInfo().getName() + " -> " + colInfo.getColTitle() + "\n");
            }
            ++i;
        }
        sb.append("</table><br>The Mappings have been copied to the clipboard for pasting into an email.<br><br></htm>");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)UIHelper.createLabel(sb.toString()), "Center");
        UIHelper.setTextToClipboard(clipBrdTxt.toString());
        CustomDialog dialog = new CustomDialog((JFrame)UIRegistry.getTopWindow(), "Mappings", true, 1, (Component)panel);
        dialog.setVisible(true);
    }

    protected void fillFieldList(TableInfo tableInfo) {
        DefaultListModel model = (DefaultListModel)this.fieldList.getModel();
        model.clear();
        this.fieldList.clearSelection();
        if (tableInfo != null) {
            for (FieldInfo fi : tableInfo.getFieldItems()) {
                model.addElement(fi);
            }
        }
    }

    @Override
    protected void okButtonPressed() {
        this.adjustViewOrder();
        super.okButtonPressed();
    }

    protected void setChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
        this.okBtn.setEnabled(hasChanged);
    }

    protected FieldMappingPanel addMappingItem(ImportColumnInfo colInfo, ImageIcon mappingIcon, WorkbenchTemplateMappingItem wbtmi) {
        FieldMappingPanel fmp = new FieldMappingPanel(colInfo, mappingIcon);
        fmp.setWbtmi(wbtmi);
        this.mapModel.add(fmp);
        this.mapList.setSelectedValue(fmp, true);
        return fmp;
    }

    protected UploadInfo getUploadInfo(DBFieldInfo fInfo) {
        String key = String.valueOf(fInfo.getTableInfo().getName().toLowerCase()) + "." + fInfo.getName().toLowerCase();
        return this.uploadDefs.get(key);
    }

    protected DBFieldInfo getMappedFieldInfo(DBFieldInfo fInfo) {
        UploadInfo upInfo = this.getUploadInfo(fInfo);
        if (upInfo == null) {
            return this.getFieldInfoByTableField(fInfo.getTableInfo().getName(), fInfo.getName());
        }
        return upInfo.getFieldInfo();
    }

    protected DBFieldInfo getMappedFieldInfo(FieldInfo fldItem) {
        DBFieldInfo fInfo = fldItem.getFieldInfo();
        return this.getMappedFieldInfo(fInfo);
    }

    protected void updateFieldDescription() {
        DBFieldInfo mInfo;
        TableListItemIFace fldItem = (TableListItemIFace)this.fieldList.getSelectedValue();
        this.descriptionLbl.setText("   ");
        this.descriptionLbl.setToolTipText(null);
        if (fldItem != null && fldItem instanceof FieldInfo && (mInfo = this.getMappedFieldInfo((FieldInfo)fldItem)) != null && !mInfo.getDescription().equalsIgnoreCase(mInfo.getTitle()) && !mInfo.getDescription().equalsIgnoreCase(mInfo.getName())) {
            String desc = "  " + UIRegistry.getResourceString("TemplateEditor.SpFldDesc") + " " + mInfo.getDescription();
            this.descriptionLbl.setText(desc);
            this.descriptionLbl.setToolTipText(desc);
        }
    }

    protected void buildUploadDefs() throws Exception {
        Element defs = WorkbenchTask.isCustomizedSchema() ? XMLHelper.readFileToDOM4J(new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "specify_workbench_upload_def.xml")) : XMLHelper.readDOMFromConfigDir("specify_workbench_upload_def.xml");
        List flds = defs.selectNodes("field");
        this.uploadDefs.clear();
        for (Object fld : flds) {
            String table = XMLHelper.getAttr((Element)fld, "table", null);
            String actualTable = XMLHelper.getAttr((Element)fld, "actualtable", null);
            if (actualTable == null) {
                actualTable = table;
            }
            String field = XMLHelper.getAttr((Element)fld, "name", null);
            String actualField = XMLHelper.getAttr((Element)fld, "actualname", null);
            String relatedField = XMLHelper.getAttr((Element)fld, "relatedfieldname", null);
            String mappedField = field;
            if (actualField != null) {
                mappedField = actualField;
            }
            if (relatedField != null) {
                mappedField = relatedField;
            }
            int sequence = XMLHelper.getAttr((Element)fld, "onetomanysequence", -1);
            String key = String.valueOf(table.toLowerCase()) + "." + field.toLowerCase();
            DBFieldInfo fInfo = this.getFieldInfoByTableField(actualTable, actualField);
            if (fInfo == null) continue;
            this.uploadDefs.put(key, new UploadInfo(fInfo, sequence));
        }
    }

    protected DBFieldInfo getFieldInfoByTableField(String tbl, String fld) {
        DBTableInfo tInfo = null;
        for (DBTableInfo t : DBTableIdMgr.getInstance().getTables()) {
            if (!t.getName().equalsIgnoreCase(tbl)) continue;
            tInfo = t;
            break;
        }
        if (tInfo != null) {
            for (DBFieldInfo f : tInfo.getFields()) {
                if (!f.getName().equalsIgnoreCase(fld)) continue;
                return f;
            }
        }
        return null;
    }

    protected void updateEnabledState() {
        int mapInx = this.mapList.getSelectedIndex();
        if (mapInx > -1) {
            FieldMappingPanel fmp = this.mapModel.getElementAt(mapInx);
            TableListItemIFace tblItem = (TableListItemIFace)this.tableList.getSelectedValue();
            TableListItemIFace fldItem = (TableListItemIFace)this.fieldList.getSelectedValue();
            if (tblItem != null && fldItem != null) {
                this.mapToBtn.setEnabled(!fldItem.isChecked());
                this.unmapBtn.setEnabled(!fmp.isNew() && fmp.getFieldInfo() != null);
                if (!this.isEditMode) {
                    // empty if block
                }
                this.upBtn.setEnabled(mapInx > 0 && !fmp.isNew());
                this.downBtn.setEnabled(mapInx < this.mapModel.size() - 2 && !fmp.isNew());
            } else {
                this.mapToBtn.setEnabled(false);
            }
        } else {
            this.mapToBtn.setEnabled(false);
            this.unmapBtn.setEnabled(false);
        }
        if (this.okBtn != null && this.hasChanged) {
            boolean isOK = false;
            int i = 0;
            while (i < this.mapModel.size()) {
                FieldMappingPanel fmp = (FieldMappingPanel)this.mapModel.get(i);
                if (fmp.getFieldInfo() != null) {
                    isOK = true;
                    break;
                }
                ++i;
            }
            this.okBtn.setEnabled(isOK);
        }
        this.repaint();
    }

    protected void adjustViewOrder() {
        short inx = 0;
        int i = 0;
        while (i < this.mapModel.size()) {
            FieldMappingPanel fmp = this.mapModel.getElementAt(i);
            if (fmp.getFieldInfo() != null) {
                fmp.setViewOrder(inx);
                inx = (short)(inx + 1);
            }
            ++i;
        }
    }

    protected FieldMappingPanel map() {
        FieldMappingPanel fmp = (FieldMappingPanel)this.mapList.getSelectedValue();
        if (fmp.isNew()) {
            this.mapModel.remove(fmp);
            this.addNewMappingItems();
            FieldMappingPanel newFmp = this.addMappingItem(null, IconManager.getIcon("BlankIcon", IconManager.STD_ICON_SIZE), null);
            newFmp.setAdded(true);
            newFmp.setNew(true);
        } else {
            ImportColumnInfo colInfo = fmp.getColInfo();
            FieldInfo fi = (FieldInfo)this.fieldList.getSelectedValue();
            TableInfo tblInfo = (TableInfo)this.tableList.getSelectedValue();
            String errMsg = this.isMappable(fi, fmp);
            if (errMsg == null) {
                this.map(fmp, colInfo, tblInfo, fi, fmp.getWbtmi());
            } else {
                UIRegistry.displayErrorDlg(errMsg);
            }
        }
        this.updateEnabledState();
        return fmp;
    }

    protected FieldMappingPanel map(FieldMappingPanel fmpArg, ImportColumnInfo colInfo, TableInfo tableInfo, FieldInfo fieldInfo, WorkbenchTemplateMappingItem wbtmi) {
        FieldInfo oldFieldInfo;
        FieldMappingPanel fmp = fmpArg;
        if (fmp == null) {
            fmp = this.addMappingItem(colInfo, null, wbtmi);
        }
        if ((oldFieldInfo = fmp.getFieldInfo()) != null) {
            oldFieldInfo.setInUse(false);
        }
        fieldInfo.setInUse(true);
        fmp.setColInfo(colInfo);
        fmp.setFieldInfo(fieldInfo);
        fmp.setWbtmi(wbtmi);
        if (tableInfo.getIcon() == null) {
            fmp.setIcon(tableInfo.getTableInfo().getIcon(IconManager.STD_ICON_SIZE));
        } else {
            fmp.setIcon(tableInfo.getIcon());
        }
        fmp.getArrowLabel().setVisible(true);
        if (colInfo == null && wbtmi == null) {
            fmp.setColFieldLabel(fieldInfo.getText());
            fmp.getArrowLabel().setIcon(IconManager.getIcon("LinkedRight"));
        } else {
            fmp.getArrowLabel().setIcon(IconManager.getIcon(colInfo != null ? "Linked" : "LinkedRight"));
        }
        this.setChanged(true);
        this.updateEnabledState();
        return fmp;
    }

    protected boolean okToUnmap(FieldMappingPanel fmp) {
        if (!this.isEditMode) {
            return true;
        }
        return this.checkAttachmentsForUnmap(fmp);
    }

    protected boolean checkAttachmentsForUnmap(FieldMappingPanel fmp) {
        if (fmp.getFieldInfo() == null) {
            return true;
        }
        if (this.tablesWithAttachments == null) {
            this.buildTablesWithAttachments();
        }
        if (this.tablesWithAttachments.size() == 0) {
            return true;
        }
        if (!this.isLastMappingToItsTable(fmp)) {
            return true;
        }
        String fmpTblName = this.getAttachToTblName(fmp);
        if (fmpTblName == null) {
            return true;
        }
        for (String attachedToTable : this.tablesWithAttachments) {
            if (!fmpTblName.equalsIgnoreCase(attachedToTable)) continue;
            return this.confirmUnmapAttachToTable(fmp);
        }
        return true;
    }

    protected boolean confirmUnmapAttachToTable(FieldMappingPanel fmp) {
        return UIRegistry.displayConfirmLocalized("TemplateEditor.ConfirmAttachedToUnmapTitle", "TemplateEditor.confireAttachedToUnmap", "OK", "Cancel", 2);
    }

    protected String getAttachToTblName(FieldMappingPanel fmp) {
        if (fmp.getFieldInfo() == null) {
            return null;
        }
        if (!this.isTreeMapping(fmp) || this.getRank(fmp.getFieldInfo()) == -1) {
            return fmp.getFieldInfo().getTableinfo().getName();
        }
        String tblName = fmp.getFieldInfo().getTableinfo().getName();
        return String.valueOf(tblName.equalsIgnoreCase("determination") ? "taxon" : tblName) + this.getRank(fmp.getFieldInfo());
    }

    protected boolean isTreeMapping(FieldMappingPanel fmp) {
        if (fmp.getFieldInfo() == null) {
            return false;
        }
        if (Treeable.class.isAssignableFrom(fmp.getFieldInfo().getTableinfo().getClassObj())) {
            return true;
        }
        if (fmp.getFieldInfo().getTableinfo().getClassObj().equals(Determination.class)) {
            return this.getRank(fmp.getFieldInfo()) != -1;
        }
        return false;
    }

    protected boolean isLastMappingToItsTable(FieldMappingPanel fmp) {
        if (fmp.getFieldInfo() == null) {
            return true;
        }
        int i = 0;
        while (i < this.mapModel.size()) {
            FieldMappingPanel fmp2 = this.mapModel.getElementAt(i);
            if (fmp2.getFieldInfo() != null && fmp2 != fmp && fmp2.getFieldInfo().getTableinfo().getName().equals(fmp.getFieldInfo().getTableinfo().getName())) {
                if (this.isTreeMapping(fmp)) {
                    if (this.getRank(fmp.getFieldInfo()) == this.getRank(fmp2.getFieldInfo())) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void buildTablesWithAttachments() {
        this.tablesWithAttachments = new Vector<String>();
        String sql = "select distinct attachToTableName from workbenchrowimage wri inner join workbenchrow wr on wr.WorkbenchRowID = wri.WorkbenchRowID inner join workbench w on w.WorkbenchID = wr.WorkbenchID where AttachToTableName is not null and WorkbenchTemplateID = " + this.workbenchTemplate.getId();
        Vector<Object> results = BasicSQLUtils.querySingleCol(sql);
        for (Object result : results) {
            this.tablesWithAttachments.add(result.toString());
        }
    }

    protected void unmap() {
        FieldMappingPanel fmp = (FieldMappingPanel)this.mapList.getSelectedValue();
        if (!this.okToUnmap(fmp)) {
            return;
        }
        FieldInfo fieldInfo = fmp.getFieldInfo();
        if (fieldInfo != null) {
            fieldInfo.setChecked(false);
            this.fieldList.repaint();
        }
        if (fmp.isAdded()) {
            this.mapModel.remove(fmp);
        } else {
            fmp.setFieldInfo(null);
            fmp.getArrowLabel().setIcon(null);
            this.mapList.repaint();
        }
        this.setChanged(true);
        this.updateEnabledState();
    }

    protected boolean allFieldsChecked() {
        Object[] objs = this.tableList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                TableListItemIFace item = (TableListItemIFace)obj;
                if (item.isExpandable()) {
                    TableInfo tableInfo = (TableInfo)this.tableList.getSelectedValue();
                    for (FieldInfo fieldInfo : tableInfo.getFieldItems()) {
                        if (fieldInfo.isChecked()) continue;
                        return false;
                    }
                } else if (!item.isChecked()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected boolean taxonOnlyInUse(FieldMappingPanel currentMap) {
        return this.tableInUse(currentMap, 4000);
    }

    protected boolean tableInUse(FieldMappingPanel currentMap, int tableId) {
        int m = 0;
        while (m < this.mapModel.size()) {
            FieldMappingPanel fmp = (FieldMappingPanel)this.mapModel.get(m);
            if (fmp != currentMap && fmp.getFieldInfo() != null && fmp.getFieldInfo().getTableinfo().getTableId() == tableId) {
                return true;
            }
            ++m;
        }
        return false;
    }

    protected boolean onlyTaxonOnlyInUse(FieldMappingPanel currentMap) {
        return this.onlyTableInUse(currentMap, 4000);
    }

    protected boolean onlyTableInUse(FieldMappingPanel currentMap, int tableId) {
        int m = 0;
        while (m < this.mapModel.size()) {
            FieldMappingPanel fmp = (FieldMappingPanel)this.mapModel.get(m);
            if (fmp != currentMap && fmp.getFieldInfo() != null && fmp.getFieldInfo().getTableinfo().getTableId() != tableId) {
                return false;
            }
            ++m;
        }
        return true;
    }

    protected int getLowestMappedTaxonRank(FieldMappingPanel currentMap) {
        int low = -1;
        int m = 0;
        while (m < this.mapModel.size()) {
            int rank;
            FieldMappingPanel fmp = (FieldMappingPanel)this.mapModel.get(m);
            if (fmp != currentMap && fmp.getFieldInfo() != null && fmp.getFieldInfo().getTableinfo().getTableId() == 4 && (rank = this.getRank(fmp.getFieldInfo())) > low) {
                low = rank;
            }
            ++m;
        }
        return low;
    }

    protected int getHighestMappedDetRank(FieldMappingPanel currentMap) {
        int high = 600000;
        int m = 0;
        while (m < this.mapModel.size()) {
            int rank;
            FieldMappingPanel fmp = (FieldMappingPanel)this.mapModel.get(m);
            if (fmp != currentMap && fmp.getFieldInfo() != null && fmp.getFieldInfo().getTableinfo().getClassObj().equals(Determination.class) && (rank = this.getRank(fmp.getFieldInfo())) != -1 && rank < high) {
                high = rank;
            }
            ++m;
        }
        return high;
    }

    protected int getRankForTaxMapping(FieldInfo fi) {
        if (this.taxRanks == null) {
            this.taxRanks = TaxonTreeDef.getStandardLevelsStatic();
        }
        String fldName = fi.getFieldInfo().getName();
        if (fi.getTableinfo().getClassObj().equals(Determination.class)) {
            fldName = fldName.substring(0, fldName.length() - 1);
        }
        for (TreeDefItemStandardEntry rank : this.taxRanks) {
            if (!fldName.equalsIgnoreCase(rank.getName())) continue;
            return rank.getRank();
        }
        return -1;
    }

    protected int getRank(FieldInfo fi) {
        if (fi.getTableinfo().getClassObj().equals(Determination.class) || fi.getTableinfo().getClassObj().equals(Taxon.class)) {
            return this.getRankForTaxMapping(fi);
        }
        return -1;
    }

    protected String isMappable(FieldInfo fi, FieldMappingPanel currentMap) {
        int rank;
        if (this.taxonOnlyInUse(currentMap) && fi.getTableinfo().getTableId() != 4000) {
            return UIRegistry.getResourceString("TemplateEditor.TaxonOnly");
        }
        if (fi.getTableinfo().getClassObj().equals(Determination.class)) {
            int low = this.getLowestMappedTaxonRank(currentMap);
            rank = this.getRank(fi);
            if (rank <= low && rank != -1) {
                return UIRegistry.getResourceString("TemplateEditor.DetRanksLowerThanTaxRanks");
            }
        }
        if (fi.getTableinfo().getClassObj().equals(Taxon.class)) {
            if (fi.getTableinfo().getTableId() == 4) {
                int high = this.getHighestMappedDetRank(currentMap);
                rank = this.getRank(fi);
                if (rank >= high && rank != -1) {
                    return UIRegistry.getResourceString("TemplateEditor.TaxRanksHigherThanDetRanks");
                }
            }
            if (fi.getTableinfo().getTableId() == 4000 && !this.onlyTaxonOnlyInUse(currentMap)) {
                return UIRegistry.getResourceString("TemplateEditor.TaxonOnlyOnly");
            }
        }
        if (this.tableInUse(currentMap, Agent.getClassTableId()) && fi.getTableinfo().getTableId() != Agent.getClassTableId()) {
            return UIRegistry.getResourceString("TemplateEditor.AgentOnly");
        }
        if (fi.getTableinfo().getTableId() == Agent.getClassTableId() && !this.onlyTableInUse(currentMap, Agent.getClassTableId())) {
            return UIRegistry.getResourceString("TemplateEditor.AgentOnlyOnly");
        }
        return null;
    }

    protected void addNewMappingItems() {
        Object[] objs = this.fieldList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            Vector<FieldInfo> toAdd = new Vector<FieldInfo>();
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                TableListItemIFace item = (TableListItemIFace)obj;
                if (!item.isChecked()) {
                    String errMsg = this.isMappable((FieldInfo)item, null);
                    if (errMsg == null) {
                        toAdd.add((FieldInfo)item);
                    } else {
                        UIRegistry.displayErrorDlg(errMsg);
                        toAdd.clear();
                        break;
                    }
                }
                ++n2;
            }
            for (FieldInfo fld : toAdd) {
                FieldMappingPanel fmp = this.addNewMapItem(fld, null);
                fmp.getArrowLabel().setVisible(true);
                fmp.getArrowLabel().setIcon(IconManager.getIcon("LinkedRight"));
            }
        }
    }

    protected FieldMappingPanel addNewMapItem(FieldInfo fieldInfoArg, WorkbenchTemplateMappingItem wbtmi) {
        FieldInfo fieldInfo = fieldInfoArg == null ? (FieldInfo)this.tableList.getSelectedValue() : fieldInfoArg;
        fieldInfo.setChecked(true);
        Class<?> tableClass = this.getTableClass(fieldInfo);
        ImportColumnInfo colInfo = new ImportColumnInfo(-1, ImportColumnInfo.getType(tableClass), fieldInfo.getFieldInfo().getColumn(), fieldInfo.getText(), null, null, null);
        FieldMappingPanel fmp = this.addMappingItem(colInfo, IconManager.getIcon(fieldInfo.getTableinfo().getShortClassName().toLowerCase(), IconManager.STD_ICON_SIZE), wbtmi);
        fmp.setFieldInfo(fieldInfo);
        fmp.setAdded(wbtmi == null);
        this.setChanged(true);
        this.fieldList.repaint();
        this.updateEnabledState();
        return fmp;
    }

    protected Class<?> getTableClass(FieldInfo fieldInfo) {
        Class<String> tableClass = null;
        try {
            Object newDbObj = fieldInfo.getTableinfo().getClassObj().newInstance();
            tableClass = PropertyUtils.getPropertyType(newDbObj, (String)fieldInfo.getFieldInfo().getName());
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TemplateEditor.class, e);
            log.warn((Object)"Exception while looking up field type.  Assuming java.lang.String.", (Throwable)e);
            tableClass = String.class;
        }
        return tableClass;
    }

    protected DBTableInfo getTableInfo(Class<?> classObj) {
        int i = 0;
        while (i < this.tableModel.size()) {
            TableListItemIFace item = this.tableModel.getElementAt(i);
            if (item.isExpandable() && ((TableInfo)item).getTableInfo().getClassObj() == classObj) {
                return ((TableInfo)item).getTableInfo();
            }
            ++i;
        }
        return null;
    }

    protected FieldInfo getFieldInfo(DBTableInfo ti, String fieldName) {
        if (ti != null) {
            String fldFieldName = fieldName.toLowerCase();
            int i = 0;
            while (i < this.tableModel.size()) {
                FieldInfo fi;
                String tblFieldName;
                TableListItemIFace item = this.tableModel.getElementAt(i);
                if (!item.isExpandable() && ((tblFieldName = (fi = (FieldInfo)item).getFieldInfo().getName().toLowerCase()).equals(fldFieldName) || tblFieldName.startsWith(fldFieldName))) {
                    return fi;
                }
                ++i;
            }
        }
        return null;
    }

    protected FieldInfo findFieldInfo(String tbl, String fld) {
        if (tbl == null || fld == null) {
            return null;
        }
        TableInfo tblInfo = null;
        int i = 0;
        while (i < this.tableModel.size()) {
            if (this.tableModel.getElementAt(i).getTableInfo().getShortClassName().equalsIgnoreCase(tbl)) {
                tblInfo = this.tableModel.getElementAt(i);
                break;
            }
            ++i;
        }
        if (tblInfo == null) {
            return null;
        }
        for (FieldInfo fi : tblInfo.getFieldItems()) {
            if (!fi.getFieldInfo().getName().equalsIgnoreCase(fld)) continue;
            return fi;
        }
        return null;
    }

    protected Vector<TableInfo> getTablesForAutoMapping() {
        Vector<TableInfo> result = new Vector<TableInfo>();
        int t = 0;
        while (t < this.tableModel.size()) {
            TableInfo tbl = (TableInfo)this.tableModel.get(t);
            result.add(tbl);
            ++t;
        }
        Collections.sort(result, new Comparator<TableInfo>(){

            @Override
            public int compare(TableInfo arg0, TableInfo arg1) {
                int tid0 = arg0.getTableInfo().getTableId();
                int tid1 = arg1.getTableInfo().getTableId();
                if (tid0 == taxOnlyId) {
                    tid0 = taxId;
                }
                if (tid1 == taxOnlyId) {
                    tid1 = taxId;
                }
                return tid0 < tid1 ? -1 : (tid0 == tid1 ? 0 : 1);
            }
        });
        for (TableInfo tblInfo : result) {
            System.out.println(tblInfo.getTableInfo());
        }
        return result;
    }

    protected FieldInfo autoMapFieldName(String fieldNameArg, List<Pair<String, TableFieldPair>> automappings, Set<FieldInfo> previouslyMapped) {
        String fieldNameLower = fieldNameArg.toLowerCase();
        String fieldNameLowerNoWS = StringUtils.deleteWhitespace((String)fieldNameLower);
        FieldInfo fieldInfo = null;
        if (fieldInfo == null) {
            Vector<TableInfo> tbls = this.getTablesForAutoMapping();
            for (TableInfo tblInfo : tbls) {
                for (FieldInfo fi : tblInfo.getFieldItems()) {
                    DBFieldInfo dbFieldInfo = fi.getFieldInfo();
                    String tblFieldName = dbFieldInfo.getName().toLowerCase();
                    String tblColumnName = dbFieldInfo.getColumn().toLowerCase();
                    if (!tblFieldName.equals(fieldNameLower) && !tblColumnName.equals(fieldNameLower) && !tblColumnName.equals(fieldNameLowerNoWS) && !tblFieldName.equals(fieldNameLowerNoWS) && !tblFieldName.startsWith(fieldNameLower) && !tblColumnName.startsWith(fieldNameLower)) continue;
                    fieldInfo = fi;
                    break;
                }
                if (fieldInfo != null) break;
            }
        }
        for (Pair<String, TableFieldPair> mapping : automappings) {
            if (fieldNameLowerNoWS.matches((String)mapping.first)) {
                TableFieldPair tblFldPair = (TableFieldPair)mapping.second;
                log.debug((Object)("Mapping incoming column name '" + fieldNameArg + "' to " + tblFldPair.getTableinfo().getName() + "." + tblFldPair.getFieldInfo().getName()));
                int i = 0;
                while (i < this.tableModel.size()) {
                    TableInfo tblInfo = this.tableModel.getElementAt(i);
                    for (FieldInfo fi : tblInfo.getFieldItems()) {
                        if (fi.getFieldInfo() != tblFldPair.getFieldInfo()) continue;
                        fieldInfo = fi;
                        break;
                    }
                    if (fieldInfo != null) break;
                    ++i;
                }
            }
            if (fieldInfo != null) break;
        }
        if (fieldInfo != null && previouslyMapped.add(fieldInfo)) {
            return fieldInfo;
        }
        return null;
    }

    protected void autoMapFromDataFile(Vector<ImportColumnInfo> colInfos) {
        Hashtable<TableInfo, Boolean> tablesInUse = new Hashtable<TableInfo, Boolean>();
        String currentLocale = "en";
        Vector<Pair<String, TableFieldPair>> automappings = new Vector<Pair<String, TableFieldPair>>();
        Element mappingsInXml = null;
        try {
            mappingsInXml = XMLHelper.readDOMFromConfigDir("datamodel_automappings.xml");
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TemplateEditor.class, e);
            log.error((Object)"Failed to read/parse automapping config file", (Throwable)e);
            return;
        }
        List mappings = mappingsInXml.selectNodes("//mapping");
        for (Object o : mappings) {
            Element mapping = (Element)o;
            String className = XMLHelper.getValue(mapping, "class");
            String fieldName = XMLHelper.getValue(mapping, "field");
            DBTableInfo table = this.databaseSchema.getByClassName(className);
            DBFieldInfo field = table.getFieldByName(fieldName);
            TableFieldPair tblFldPair = new TableFieldPair(table, field);
            for (Object regO : mapping.selectNodes("regex")) {
                Element regex = (Element)regO;
                String regexStr = regex.getText();
                String locale = XMLHelper.getAttr(regex, "locale", "en");
                if (!locale.equalsIgnoreCase(currentLocale)) continue;
                automappings.add(new Pair<String, TableFieldPair>(regexStr, tblFldPair));
                log.debug((Object)("Registering regex (" + regexStr + ") as match for " + className + "." + fieldName));
            }
        }
        boolean notAllMapped = false;
        HashSet<FieldInfo> mappedFlds = new HashSet<FieldInfo>();
        for (ImportColumnInfo colInfo : colInfos) {
            if (colInfo.getIsSystemCol()) continue;
            FieldInfo fieldInfo = this.findFieldInfo(colInfo.getMapToTbl(), colInfo.getMapToFld());
            if (fieldInfo == null) {
                fieldInfo = this.autoMapFieldName(colInfo.getColTitle(), automappings, mappedFlds);
            }
            if (fieldInfo != null) {
                TableInfo tblInfo = null;
                int i = 0;
                while (i < this.tableModel.size()) {
                    TableListItemIFace item = this.tableModel.getElementAt(i);
                    if (item.isExpandable() && ((TableInfo)item).getTableInfo() == fieldInfo.getTableinfo()) {
                        tblInfo = (TableInfo)item;
                        tablesInUse.put(tblInfo, true);
                        break;
                    }
                    ++i;
                }
                if (tblInfo == null) {
                    throw new RuntimeException("Couldn't find table info for fieldinfo.");
                }
                this.map(null, colInfo, tblInfo, fieldInfo, null);
                continue;
            }
            notAllMapped = true;
            FieldMappingPanel fmp = new FieldMappingPanel(colInfo, this.blankIcon);
            fmp.getArrowLabel().setVisible(false);
            this.mapModel.add(fmp);
        }
        if (!notAllMapped) {
            this.okBtn.setEnabled(false);
        }
        this.adjustMappings();
        this.updateEnabledState();
    }

    protected Set<Integer> getTblsMapped() {
        HashSet<Integer> result = new HashSet<Integer>();
        int m = 0;
        while (m < this.mapModel.getSize()) {
            FieldMappingPanel fmp = this.mapModel.getElementAt(m);
            if (fmp != null && fmp.getFieldInfo() != null) {
                result.add(fmp.getFieldInfo().getTableinfo().getTableId());
            }
            ++m;
        }
        return result;
    }

    protected void adjustMappings() {
        boolean doTaxOnlyRemap = true;
        boolean unMapTaxOnlys = false;
        boolean contaminateAgent = false;
        boolean agentMapped = false;
        boolean nonAgentMapped = false;
        for (Integer tblId : this.getTblsMapped()) {
            if (!(tblId.equals(DBTableIdMgr.getInstance().getByClassName(Taxon.class.getName()).getTableId()) || tblId.equals(DBTableIdMgr.getInstance().getByClassName(Determination.class.getName()).getTableId()) || tblId.equals(4000))) {
                doTaxOnlyRemap = false;
            }
            if (tblId.equals(4000)) {
                unMapTaxOnlys = true;
            }
            if (tblId.equals(Agent.getClassTableId())) {
                agentMapped = true;
                continue;
            }
            nonAgentMapped = true;
        }
        boolean bl = contaminateAgent = agentMapped && nonAgentMapped;
        if (contaminateAgent) {
            int agentFlds = 0;
            Vector<Integer> others = new Vector<Integer>();
            int m = 0;
            while (m < this.mapModel.getSize()) {
                FieldMappingPanel fmp = this.mapModel.getElementAt(m);
                if (fmp.getFieldInfo() != null) {
                    if (fmp.getFieldInfo().getTableinfo().getTableId() == Agent.getClassTableId()) {
                        ++agentFlds;
                    } else {
                        others.add(fmp.getFieldInfo().getTableinfo().getTableId());
                    }
                }
                ++m;
            }
            if (agentFlds < others.size()) {
                this.unmapTable(Agent.getClassTableId());
            } else {
                for (Integer tblId : others) {
                    this.unmapTable(tblId);
                }
            }
        }
        if (doTaxOnlyRemap) {
            log.debug((Object)"remapping for taxon-only import");
            TableInfo taxaOnly = null;
            int i = 0;
            while (i < this.tableModel.size()) {
                TableListItemIFace item = this.tableModel.getElementAt(i);
                if (item.isExpandable() && ((TableInfo)item).getTableInfo().getTableId() == 4000) {
                    taxaOnly = (TableInfo)item;
                    break;
                }
                ++i;
            }
            if (taxaOnly == null) {
                log.warn((Object)"couldn't find taxon-only table in workbench schema");
                return;
            }
            int m = 0;
            while (m < this.mapModel.getSize()) {
                FieldMappingPanel fmp = this.mapModel.getElementAt(m);
                String fldName = fmp.getFieldName();
                if (fldName.endsWith("1") || fldName.endsWith("2")) {
                    fldName = fldName.substring(0, fldName.length() - 1);
                }
                TableFieldPair newInfo = null;
                for (FieldInfo fi : taxaOnly.getFieldItems()) {
                    if (!fi.getFieldInfo().getName().equalsIgnoreCase(fldName)) continue;
                    newInfo = fi;
                    break;
                }
                if (newInfo == null) {
                    log.warn((Object)("Couldn't find Taxon Only field info for " + fldName));
                } else {
                    fmp.getFieldInfo().setInUse(false);
                    newInfo.setInUse(true);
                    fmp.setFieldInfo((FieldInfo)newInfo);
                    fmp.setIcon(DBTableIdMgr.getInstance().getByClassName(Taxon.class.getName()).getIcon(IconManager.STD_ICON_SIZE));
                }
                ++m;
            }
        } else if (unMapTaxOnlys) {
            this.unmapTable(4000);
        }
    }

    protected void unmapTable(int tableId) {
        int m = 0;
        while (m < this.mapModel.getSize()) {
            FieldMappingPanel fmp = this.mapModel.getElementAt(m);
            if (fmp.getFieldInfo() != null && fmp.getFieldInfo().getTableinfo().getTableId() == tableId) {
                log.info((Object)("unmapping " + fmp.getFieldName()));
                fmp.getFieldInfo().setInUse(false);
                fmp.setFieldInfo(null);
                fmp.setIcon(this.blankIcon);
            }
            ++m;
        }
    }

    protected WorkbenchTemplateMappingItem getMappingByDataColIdx(Vector<WorkbenchTemplateMappingItem> items, int dataColIdx) {
        for (WorkbenchTemplateMappingItem item : items) {
            if (item.getOrigImportColumnIndex().intValue() != dataColIdx) continue;
            return item;
        }
        return null;
    }

    protected void fillFromTemplate() {
        this.doingFill = true;
        Hashtable<Integer, Integer> tblIdToListIndex = new Hashtable<Integer, Integer>();
        int i = 0;
        while (i < this.tableModel.size()) {
            TableListItemIFace ti = this.tableModel.getElementAt(i);
            if (ti.isExpandable()) {
                tblIdToListIndex.put(((TableInfo)ti).getTableInfo().getTableId(), i);
            }
            ++i;
        }
        Vector<WorkbenchTemplateMappingItem> items = new Vector<WorkbenchTemplateMappingItem>(this.workbenchTemplate.getWorkbenchTemplateMappingItems());
        Collections.sort(items);
        block1: for (WorkbenchTemplateMappingItem wbtmi : items) {
            int inx = (Integer)tblIdToListIndex.get(wbtmi.getSrcTableId());
            TableInfo ti = this.tableModel.getElementAt(inx);
            for (FieldInfo fi : ti.getFieldItems()) {
                if (!wbtmi.getFieldName().equals(fi.getFieldInfo().getName())) continue;
                this.addNewMapItem(fi, wbtmi);
                continue block1;
            }
        }
        this.doingFill = false;
        this.mapList.getSelectionModel().clearSelection();
        this.tableList.getSelectionModel().clearSelection();
    }

    public Collection<WorkbenchTemplateMappingItem> updateAndGetNewItems() {
        Vector<WorkbenchTemplateMappingItem> newItems = new Vector<WorkbenchTemplateMappingItem>();
        int i = 0;
        while (i < this.mapModel.size()) {
            FieldMappingPanel fmp = this.mapModel.getElementAt(i);
            if (fmp.getFieldInfo() != null) {
                WorkbenchTemplateMappingItem item;
                FieldInfo fieldInfo = fmp.getFieldInfo();
                Integer origColNum = -1;
                if (fmp.getWbtmi() == null) {
                    ImportColumnInfo colInfo = fmp.getColInfo();
                    item = new WorkbenchTemplateMappingItem();
                    item.initialize();
                    String caption = colInfo.getCaption();
                    int maxCapLen = DBTableIdMgr.getInstance().getInfoByTableName("workbenchtemplatemappingitem").getFieldByColumnName("Caption").getLength();
                    int maxImportedColNameLen = DBTableIdMgr.getInstance().getInfoByTableName("workbenchtemplatemappingitem").getFieldByColumnName("ImportedColName").getLength();
                    item.setCaption(caption.length() > maxCapLen ? caption.substring(0, maxCapLen) : caption);
                    item.setImportedColName(caption.length() > maxImportedColNameLen ? caption.substring(0, maxImportedColNameLen) : caption);
                    origColNum = fmp.isAdded() ? -1 : colInfo.getColInx();
                    item.setXCoord(Integer.valueOf(colInfo.getFormXCoord()).shortValue());
                    item.setYCoord(Integer.valueOf(colInfo.getFormYCoord()).shortValue());
                    item.setFieldType(Integer.valueOf(colInfo.getFrmFieldType()).shortValue());
                    item.setMetaData(colInfo.getFrmMetaData());
                    newItems.add(item);
                } else {
                    item = fmp.getWbtmi();
                }
                item.setFieldName(fieldInfo.getFieldInfo().getName());
                item.setSrcTableId(fieldInfo.getTableinfo().getTableId());
                item.setTableName(fieldInfo.getTableinfo().getName());
                short len = (short)fieldInfo.getFieldInfo().getLength();
                item.setDataFieldLength(len == -1 ? (short)15 : (short)len);
                item.setViewOrder(fmp.getViewOrder());
                item.setOrigImportColumnIndex(origColNum.shortValue());
            }
            ++i;
        }
        return newItems;
    }

    protected boolean updateMappingItem(FieldMappingPanel fmp, WorkbenchTemplateMappingItem item) {
        if (fmp.getFieldInfo() == null) {
            return false;
        }
        ImportColumnInfo colInfo = fmp.getColInfo();
        FieldInfo fieldInfo = fmp.getFieldInfo();
        item.setCaption(colInfo.getCaption());
        item.setImportedColName(colInfo.getColName());
        item.setXCoord(Integer.valueOf(colInfo.getFormXCoord()).shortValue());
        item.setYCoord(Integer.valueOf(colInfo.getFormYCoord()).shortValue());
        item.setFieldType(Integer.valueOf(colInfo.getFrmFieldType()).shortValue());
        item.setMetaData(colInfo.getFrmMetaData());
        Integer origColNum = fmp.isAdded() ? -1 : colInfo.getColInx();
        item.setFieldName(fieldInfo.getFieldInfo().getName());
        item.setSrcTableId(fieldInfo.getTableinfo().getTableId());
        item.setTableName(fieldInfo.getTableinfo().getName());
        short len = (short)fieldInfo.getFieldInfo().getLength();
        item.setDataFieldLength(len == -1 ? (short)15 : (short)len);
        item.setViewOrder(fmp.getViewOrder());
        item.setOrigImportColumnIndex(origColNum.shortValue());
        return true;
    }

    protected boolean checkUploadability() {
        Collection<WorkbenchTemplateMappingItem> mappings = this.getCurrentMappings();
        WorkbenchUploadMapper importMapper = new WorkbenchUploadMapper(mappings);
        try {
            DB db = new DB();
            Vector<UploadMappingDef> maps = importMapper.getImporterMapping();
            Uploader result = new Uploader(db, new UploadData(maps, null), null, mappings, true);
            Vector<UploadMessage> structureErrors = result.verifyUploadability();
            return structureErrors.size() <= 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected Collection<WorkbenchTemplateMappingItem> getCurrentMappings() {
        Vector<WorkbenchTemplateMappingItem> result = new Vector<WorkbenchTemplateMappingItem>();
        int i = 0;
        while (i < this.mapModel.size()) {
            WorkbenchTemplateMappingItem item = new WorkbenchTemplateMappingItem();
            item.initialize();
            if (this.updateMappingItem(this.mapModel.getElementAt(i), item)) {
                result.add(item);
            }
            ++i;
        }
        return result;
    }

    public Collection<WorkbenchTemplateMappingItem> getDeletedItems() {
        Vector<WorkbenchTemplateMappingItem> items = new Vector<WorkbenchTemplateMappingItem>();
        int i = 0;
        while (i < this.mapModel.size()) {
            FieldMappingPanel fmp = this.mapModel.getElementAt(i);
            if (fmp.getFieldInfo() == null && fmp.getWbtmi() != null) {
                items.add(fmp.getWbtmi());
            }
            ++i;
        }
        return items;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(final boolean isReadOnly) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateEditor.this.isReadOnly = isReadOnly;
                TemplateEditor.this.mapToBtn.setVisible(!isReadOnly);
                TemplateEditor.this.unmapBtn.setVisible(!isReadOnly);
                TemplateEditor.this.btnPanel.setVisible(!isReadOnly);
                TemplateEditor.this.upBtn.setVisible(!isReadOnly);
                TemplateEditor.this.downBtn.setVisible(!isReadOnly);
                TemplateEditor.this.getOkBtn().setVisible(!isReadOnly);
                TemplateEditor.this.getCancelBtn().setText(TemplateEditor.this.getOkBtn().getText());
            }
        });
    }

    class FieldMappingPanel
    extends JPanel {
        protected String noMappingStr = UIRegistry.getResourceString("WB_NO_MAPPING");
        protected boolean isSelected = false;
        protected Color bgColor = null;
        protected JLabel colFieldLabel;
        protected JLabel schemaLabel;
        protected JLabel iconLabel;
        protected JLabel arrowLabel;
        protected ImageIcon mappingIcon;
        protected Short viewOrder = null;
        protected FieldInfo fieldInfo = null;
        protected ImportColumnInfo colInfo = null;
        protected boolean isAdded = false;
        protected boolean isNew = false;
        protected WorkbenchTemplateMappingItem wbtmi = null;

        public FieldMappingPanel(ImportColumnInfo colInfo, ImageIcon mappingIcon) {
            this.colInfo = colInfo;
            this.setBackground(Color.WHITE);
            PanelBuilder builder = new PanelBuilder(new FormLayout("2px,p,2px,150px, p:g, p, p:g, 150px,2px", "p:g"), (JPanel)this);
            CellConstraints cc = new CellConstraints();
            this.colFieldLabel = UIHelper.createLabel(colInfo != null ? colInfo.getColTitle() : "", 4);
            this.schemaLabel = UIHelper.createLabel(this.noMappingStr, 2);
            this.arrowLabel = new JLabel(IconManager.getIcon("Linked"));
            this.setFocusable(true);
            this.iconLabel = new JLabel(mappingIcon);
            builder.add((Component)this.iconLabel, cc.xy(2, 1));
            this.setIcon(mappingIcon);
            builder.add((Component)this.schemaLabel, cc.xy(4, 1));
            builder.add((Component)this.arrowLabel, cc.xy(6, 1));
            builder.add((Component)this.colFieldLabel, cc.xy(8, 1));
        }

        public void setColInfo(ImportColumnInfo colInfo) {
            this.colInfo = colInfo;
            this.colFieldLabel.setText(colInfo != null ? colInfo.getColTitle() : "");
        }

        public void setColFieldLabel(String text) {
            this.colFieldLabel.setText(text);
        }

        public WorkbenchTemplateMappingItem getWbtmi() {
            return this.wbtmi;
        }

        public JLabel getArrowLabel() {
            return this.arrowLabel;
        }

        public void setWbtmi(WorkbenchTemplateMappingItem wbtmi) {
            if (wbtmi != null && TemplateEditor.this.workbenchTemplate != null) {
                this.colFieldLabel.setText(wbtmi.getCaption());
            }
            this.wbtmi = wbtmi;
        }

        public Short getViewOrder() {
            if (this.wbtmi != null) {
                return this.wbtmi.getViewOrder();
            }
            return this.viewOrder;
        }

        public void setViewOrder(Short viewOrder) {
            if (this.wbtmi != null) {
                this.wbtmi.setViewOrder(viewOrder);
            } else {
                this.viewOrder = viewOrder;
            }
        }

        public void setFieldInfo(FieldInfo fieldInfoArg) {
            this.fieldInfo = fieldInfoArg;
            if (fieldInfoArg == null) {
                this.iconLabel.setIcon(TemplateEditor.this.blankIcon);
            }
            this.schemaLabel.setText(fieldInfoArg != null ? fieldInfoArg.getText() : this.noMappingStr);
            this.schemaLabel.repaint();
        }

        @Override
        public String getToolTipText() {
            if (this.isNew) {
                return UIRegistry.getResourceString("WB_NEW_REC_TT");
            }
            if (this.fieldInfo != null) {
                String name = this.fieldInfo.getFieldInfo().getTableInfo().getTitle();
                StringBuilder sb = new StringBuilder();
                sb.append(name);
                sb.append(" - ");
                sb.append(this.fieldInfo.getTitle());
                return sb.toString();
            }
            return UIRegistry.getResourceString("WB_NO_MAPPING_TT");
        }

        public void setSchemaLabelVisible(boolean isVis) {
            this.schemaLabel.setVisible(isVis);
        }

        public void setSelected(boolean isSelected) {
            if (this.bgColor == null) {
                this.bgColor = this.getBackground();
            }
            this.isSelected = isSelected;
            if (UIHelper.getOSType() == UIHelper.OSTYPE.Windows) {
                this.colFieldLabel.setForeground(isSelected ? Color.WHITE : Color.BLACK);
                this.schemaLabel.setForeground(isSelected ? Color.WHITE : Color.BLACK);
            }
            this.setBackground(isSelected ? TemplateEditor.this.tableList.getSelectionBackground() : this.bgColor);
        }

        public void setIcon(ImageIcon mappingIcon) {
            this.mappingIcon = mappingIcon == null ? TemplateEditor.this.blankIcon : mappingIcon;
            this.iconLabel.setIcon(this.mappingIcon);
        }

        public FieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        public ImportColumnInfo getColInfo() {
            return this.colInfo;
        }

        public String getFieldName() {
            return this.colFieldLabel.getText();
        }

        public boolean isAdded() {
            return this.isAdded;
        }

        public void setAdded(boolean isAdded) {
            this.isAdded = isAdded;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
            if (isNew) {
                this.schemaLabel.setText(UIRegistry.getResourceString("WB_NEW_REC"));
                this.schemaLabel.setToolTipText(UIRegistry.getResourceString("WB_NEW_REC_TT"));
                this.schemaLabel.setVisible(true);
                this.arrowLabel.setVisible(false);
            }
        }
    }

    class MapCellRenderer
    implements ListCellRenderer {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        MapCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FieldMappingPanel panel = (FieldMappingPanel)value;
            panel.setSelected(isSelected);
            panel.setToolTipText(panel.getToolTipText());
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.getNoFocusBorder();
            }
            panel.setBorder(border);
            return (Component)value;
        }

        private Border getNoFocusBorder() {
            if (System.getSecurityManager() != null) {
                return this.SAFE_NO_FOCUS_BORDER;
            }
            return this.noFocusBorder;
        }
    }

    private class UploadInfo {
        protected final DBFieldInfo fieldInfo;
        protected final int sequence;

        public UploadInfo(DBFieldInfo fieldInfo, int sequence) {
            this.fieldInfo = fieldInfo;
            this.sequence = sequence;
        }

        public DBFieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        public int getSequence() {
            return this.sequence;
        }
    }
}

