/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.tasks.subpane.wb.TableListItemIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TableInfoListRenderer
implements ListCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    protected IconManager.IconSize iconSize;
    protected JPanel display;
    protected JLabel icon1;
    protected JLabel label;
    protected ImageIcon checkmarkIcon = IconManager.getIcon("Checkmark", IconManager.IconSize.Std16);
    protected ImageIcon blankIcon = IconManager.getIcon("BlankIcon", IconManager.STD_ICON_SIZE);

    public TableInfoListRenderer(IconManager.IconSize iconSize) {
        this.iconSize = iconSize;
        PanelBuilder builder = new PanelBuilder(new FormLayout(String.valueOf(this.blankIcon.getIconWidth()) + "px,2px,f:p:g", "c:p"));
        CellConstraints cc = new CellConstraints();
        this.icon1 = UIHelper.createLabel("");
        builder.add((Component)this.icon1, cc.xy(1, 1));
        this.label = UIHelper.createLabel("");
        builder.add((Component)this.label, cc.xy(3, 1));
        this.display = builder.getPanel();
        this.display.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
        this.display.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        TableListItemIFace ti = (TableListItemIFace)value;
        if (ti.isExpandable()) {
            this.icon1.setIcon(ti.getIcon());
        } else {
            this.icon1.setIcon(IconManager.getIcon("BlankIcon", this.iconSize));
            this.icon1.setIcon(ti.isChecked() ? this.checkmarkIcon : this.blankIcon);
        }
        this.label.setText(ti.getText());
        if (isSelected) {
            this.display.setBackground(list.getSelectionBackground());
            this.label.setForeground(list.getSelectionForeground());
        } else {
            this.display.setBackground(list.getBackground());
            this.label.setForeground(list.getForeground());
        }
        this.display.setEnabled(list.isEnabled());
        this.display.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = TableInfoListRenderer.getNoFocusBorder();
        }
        this.display.setBorder(border);
        return this.display;
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }
}

