/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectNewOrExistingDlg<T>
extends CustomDialog {
    protected JRadioButton createNewRB;
    protected JRadioButton useExistingRB;
    protected JList list;
    protected Vector<T> items;

    public SelectNewOrExistingDlg(Frame frame, String titleKey, String createNewLabelKey, String useExistingLabelKey, String helpContext, List<T> list) throws HeadlessException {
        super(frame, UIRegistry.getResourceString(titleKey), true, 7, null);
        this.helpContext = helpContext;
        this.items = new Vector<T>(list);
        this.createNewRB = new JRadioButton(UIRegistry.getResourceString(createNewLabelKey));
        this.useExistingRB = new JRadioButton(UIRegistry.getResourceString(useExistingLabelKey));
    }

    @Override
    public void createUI() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.createNewRB);
        group.add(this.useExistingRB);
        this.list = new JList<T>(this.items);
        PanelBuilder panel = new PanelBuilder(new FormLayout("f:max(300px;p):g", "p,2px,p,2px,p"));
        CellConstraints cc = new CellConstraints();
        panel.add((Component)this.createNewRB, cc.xy(1, 1));
        panel.add((Component)this.useExistingRB, cc.xy(1, 3));
        panel.add((Component)UIHelper.createScrollPane(this.list), cc.xy(1, 5));
        this.createNewRB.setSelected(true);
        this.list.setEnabled(false);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.contentPanel = panel.getPanel();
        super.createUI();
        this.pack();
        this.createNewRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectNewOrExistingDlg.this.list.setEnabled(false);
                SelectNewOrExistingDlg.this.okBtn.setEnabled(true);
            }
        });
        this.useExistingRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectNewOrExistingDlg.this.list.setEnabled(true);
                if (SelectNewOrExistingDlg.this.items.size() == 1) {
                    SelectNewOrExistingDlg.this.list.setSelectedIndex(0);
                }
                SelectNewOrExistingDlg.this.okBtn.setEnabled(SelectNewOrExistingDlg.this.list.getSelectedIndex() > -1);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SelectNewOrExistingDlg.this.okBtn.setEnabled(SelectNewOrExistingDlg.this.list.getSelectedIndex() > -1);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SelectNewOrExistingDlg.this.list.getSelectedIndex() > -1 && e.getClickCount() == 2) {
                    SelectNewOrExistingDlg.this.okBtn.doClick();
                }
            }
        });
    }

    public boolean isCreateNew() {
        return this.createNewRB.isSelected();
    }

    public T getSelectedObject() {
        int inx = this.list.getSelectedIndex();
        if (inx != -1) {
            return this.items.get(inx);
        }
        return null;
    }
}

