/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.google.common.collect.ImmutableList;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.sgr.Match;
import edu.ku.brc.sgr.MatchResults;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchDataItem;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.plugins.sgr.SGRColors;
import edu.ku.brc.specify.plugins.sgr.SGRColumnOrdering;
import edu.ku.brc.specify.plugins.sgr.SGRPluginImpl;
import edu.ku.brc.specify.plugins.sgr.Workbench2SGR;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SGRResultsForForm
extends JPanel {
    private static final Logger log = Logger.getLogger(SGRResultsForForm.class);
    private Workbench workbench;
    private WorkbenchPaneSS workbenchPaneSS;
    private final SGRPluginImpl sgrPlugin;
    private SGRColumnOrdering columnOrdering = SGRColumnOrdering.getInstance();
    public final JScrollPane scrollPane;
    private int currentIndex = -1;
    private MatchResults results;

    public SGRResultsForForm(WorkbenchPaneSS workbenchPaneSS, Workbench workbench) {
        this.workbench = workbench;
        this.workbenchPaneSS = workbenchPaneSS;
        this.sgrPlugin = (SGRPluginImpl)workbenchPaneSS.getPlugin(SGRPluginImpl.class);
        this.scrollPane = new JScrollPane(this);
        this.setLayout(new BorderLayout());
    }

    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    public void newRecordAdded() {
    }

    public void indexChanged(int newIndex) {
        this.currentIndex = newIndex;
        this.refresh();
    }

    private void showMessage(String key) {
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        String msg = UIRegistry.getResourceString(key);
        UIRegistry.popResourceBundle();
        this.setLayout(new BorderLayout());
        JLabel label = UIHelper.createLabel(msg, 0);
        this.add((Component)label, "Center");
        this.getParent().validate();
    }

    public void refresh() {
        if (this.currentIndex < 0) {
            return;
        }
        this.removeAll();
        this.repaint();
        if (!this.sgrPlugin.isReady()) {
            this.showMessage("SGR_NO_MATCHER");
            return;
        }
        this.setCursor(new Cursor(3));
        new SwingWorker<MatchResults, Void>(){
            private int index;
            {
                this.index = SGRResultsForForm.this.currentIndex;
            }

            @Override
            protected MatchResults doInBackground() throws Exception {
                int modelIndex = SGRResultsForForm.this.workbenchPaneSS.getSpreadSheet().convertRowIndexToModel(this.index);
                WorkbenchRow row = SGRResultsForForm.this.workbench.getRow(modelIndex);
                return SGRResultsForForm.this.isEmpty(row) ? null : SGRResultsForForm.this.sgrPlugin.doQuery(row);
            }

            @Override
            protected void done() {
                if (this.index != SGRResultsForForm.this.currentIndex) {
                    return;
                }
                try {
                    SGRResultsForForm.this.results = (MatchResults)this.get();
                }
                catch (CancellationException e) {
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (ExecutionException e) {
                    SGRResultsForForm.this.sgrFailed(e);
                    SGRResultsForForm.this.setCursor(new Cursor(0));
                    return;
                }
                SGRResultsForForm.this.setCursor(new Cursor(0));
                if (SGRResultsForForm.this.results == null || ((SGRResultsForForm)SGRResultsForForm.this).results.matches.size() < 1) {
                    SGRResultsForForm.this.showMessage("SGR_NO_RESULTS");
                    return;
                }
                float maxScore = SGRResultsForForm.this.sgrPlugin.getColorizer().getMaxScore();
                if (maxScore == 0.0f) {
                    maxScore = 22.0f;
                }
                StringBuilder columns = new StringBuilder("right:max(50dlu;p)");
                for (Match result : SGRResultsForForm.this.results) {
                    columns.append(", 4dlu, 150dlu:grow");
                }
                String[] fields = SGRResultsForForm.this.columnOrdering.getFields();
                StringBuilder rows = new StringBuilder();
                int i = 0;
                while (i < fields.length - 1) {
                    rows.append("p, 4dlu,");
                    ++i;
                }
                rows.append("p");
                FormLayout layout = new FormLayout(columns.toString(), rows.toString());
                PanelBuilder builder = new PanelBuilder(layout, (JPanel)SGRResultsForForm.this);
                CellConstraints cc = new CellConstraints();
                int y = 1;
                String[] stringArray = SGRResultsForForm.this.columnOrdering.getHeadings();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String heading = stringArray[n2];
                    builder.addLabel(String.valueOf(heading) + ":", cc.xy(1, y));
                    y += 2;
                    ++n2;
                }
                int x = 3;
                for (Match result : SGRResultsForForm.this.results) {
                    y = 1;
                    String[] stringArray2 = fields;
                    int n3 = fields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Color color;
                        String value;
                        String field = stringArray2[n4];
                        if (field.equals("id")) {
                            value = result.match.id;
                            color = SGRColors.colorForScore(result.score, maxScore);
                        } else if (field.equals("score")) {
                            value = String.format("%1$.2f", Float.valueOf(result.score));
                            color = SGRColors.colorForScore(result.score, maxScore);
                        } else {
                            value = StringUtils.join((Object[])result.match.getFieldValues(field).toArray(), (String)"; ");
                            Float fieldContribution = (Float)result.fieldScoreContributions().get((Object)field);
                            color = SGRColors.colorForScore(result.score, maxScore, fieldContribution);
                        }
                        JTextField textField = new JTextField(value);
                        textField.setBackground(color);
                        textField.setEditable(false);
                        textField.setCaretPosition(0);
                        builder.add((Component)textField, cc.xy(x, y));
                        y += 2;
                        ++n4;
                    }
                    x += 2;
                }
                SGRResultsForForm.this.getParent().validate();
            }
        }.execute();
        UsageTracker.incrUsageCount("SGR.MatchRow");
    }

    public void copyDataIntoWB() {
        if (this.results == null) {
            return;
        }
        Iterator iterator = this.results.iterator();
        if (iterator.hasNext()) {
            Match result = (Match)iterator.next();
            String[] stringArray = this.columnOrdering.getFields();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                ImmutableList values = result.match.getFieldValues(field);
                if (field.equals("latitude")) {
                    this.copyFieldIntoRow("latitude1", (List<String>)values);
                } else if (field.equals("longitude")) {
                    this.copyFieldIntoRow("longitude1", (List<String>)values);
                } else if (field.equals("locality")) {
                    this.copyFieldIntoRow("localityName", (List<String>)values);
                } else if (field.equals("county_name")) {
                    this.copyFieldIntoRow("county", (List<String>)values);
                } else if (field.equals("state_name")) {
                    this.copyFieldIntoRow("state", (List<String>)values);
                } else if (field.equals("country_name")) {
                    this.copyFieldIntoRow("country", (List<String>)values);
                }
                ++n2;
            }
        }
        this.workbenchPaneSS.setChanged(true);
        this.workbenchPaneSS.getFormPane().indexChanged(this.currentIndex);
    }

    private void copyFieldIntoRow(String field, List<String> values) {
        int modelIndex = this.workbenchPaneSS.getSpreadSheet().convertRowIndexToModel(this.currentIndex);
        WorkbenchRow row = this.workbench.getRow(modelIndex);
        Workbench2SGR wb2sgr = this.sgrPlugin.getWorkbench2SGR();
        for (short i : wb2sgr.getFieldsFor(field)) {
            row.setData(StringUtils.join((Object[])values.toArray()), i, true);
        }
    }

    protected void sgrFailed(ExecutionException e) {
        log.error((Object)"Failed to get SGR results.", (Throwable)e);
        UIRegistry.loadAndPushResourceBundle("specify_plugins");
        UIRegistry.showLocalizedError("SGR_ERROR_SERVER_FAIL");
        UIRegistry.popResourceBundle();
    }

    public void cleanup() {
        this.removeAll();
        this.scrollPane.removeAll();
        this.workbench = null;
        this.workbenchPaneSS = null;
    }

    private boolean isEmpty(WorkbenchRow row) {
        for (WorkbenchDataItem item : row.getItems().values()) {
            if (StringUtils.isBlank((String)item.getCellData())) continue;
            return false;
        }
        return true;
    }
}

