/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValCheckBox;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.datamodel.WorkbenchTemplateMappingItem;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import edu.ku.brc.ui.dnd.ShadowFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InputPanel
extends JPanel
implements GhostActionable {
    public static final DataFlavor INPUTPANEL_FLAVOR = new DataFlavor(InputPanel.class, "InputPanel");
    protected static final Cursor handCursor = new Cursor(12);
    protected WorkbenchTemplateMappingItem wbtmi;
    protected JLabel label;
    protected JComponent comp;
    protected BufferedImage sizeBufImg = null;
    protected Dimension preferredSize = new Dimension(0, 0);
    protected Vector<ActionListener> listeners = new Vector();
    protected GhostMouseInputAdapter mouseDropAdapter = null;
    protected static final int SHADOW_SIZE = 10;
    protected RenderingHints hints = null;
    protected BufferedImage shadowBuffer = null;
    protected BufferedImage buffer = null;
    protected double ratio = 0.0;
    protected Dimension prefferedRenderSize = new Dimension(0, 0);
    protected boolean verticalLayout = false;
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    protected List<DataFlavor> dragFlavors = new ArrayList<DataFlavor>();
    protected int textFieldOffset = 0;

    public InputPanel(WorkbenchTemplateMappingItem wbtmi, String label, JComponent comp, Component droppable, MouseAdapter clickable) {
        this.setLayout(null);
        this.wbtmi = wbtmi;
        this.comp = comp;
        this.label = comp instanceof ValCheckBox ? UIHelper.createLabel("   ", 4) : UIHelper.createI18NFormLabel(label);
        this.label.setCursor(handCursor);
        this.add(this.label);
        this.add(this.comp);
        if (wbtmi.getXCoord() != null && wbtmi.getYCoord() != null && wbtmi.getXCoord() > -1 && wbtmi.getYCoord() > -1) {
            this.setLocation(wbtmi.getXCoord().shortValue(), wbtmi.getYCoord().shortValue());
        }
        this.doLayout();
        this.dragFlavors.add(INPUTPANEL_FLAVOR);
        this.createMouseInputAdapter();
        this.mouseDropAdapter.setDropCanvas(droppable);
        if (clickable != null) {
            this.label.addMouseListener(clickable);
        }
    }

    public void setComp(JComponent newComp) {
        this.remove(this.comp);
        this.comp = newComp;
        this.add(this.comp);
        this.doLayout();
        this.repaint();
    }

    @Override
    public void doLayout() {
        Dimension labelSize = this.label.getPreferredSize();
        Dimension compSize = this.comp.getPreferredSize();
        Rectangle r = new Rectangle(0, 0, labelSize.width, compSize.height);
        this.label.setBounds(r);
        r.y = 0;
        r.x = r.width + 2;
        r.width = compSize.width;
        r.height = compSize.height;
        this.comp.setBounds(r);
        this.textFieldOffset = r.x;
        this.setSize(r.x + r.width, r.height);
        this.setPreferredSize(new Dimension(r.x + r.width, r.height));
    }

    public int getTextFieldOffset() {
        return this.textFieldOffset;
    }

    public String getControlTitle() {
        return this.wbtmi.getCaption();
    }

    public Component getComp() {
        if (this.comp instanceof JScrollPane) {
            return ((JScrollPane)this.comp).getViewport().getView();
        }
        return this.comp;
    }

    public Component getScrollPane() {
        if (this.comp instanceof JScrollPane) {
            return this.comp;
        }
        return null;
    }

    public String getLabelText() {
        if (this.comp instanceof ValCheckBox) {
            return ((ValCheckBox)this.comp).getText();
        }
        return this.label.getText();
    }

    public void setLabelText(String text) {
        if (this.comp instanceof ValCheckBox) {
            ((ValCheckBox)this.comp).setText(text);
        } else {
            this.label.setText(text);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public WorkbenchTemplateMappingItem getWbtmi() {
        return this.wbtmi;
    }

    public void setWbtmi(WorkbenchTemplateMappingItem wbtmi) {
        this.wbtmi = wbtmi;
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void addDragDataFlavor(DataFlavor dataFlavor) {
        this.dragFlavors.add(dataFlavor);
    }

    public void addDropDataFlavor(DataFlavor dataFlavor) {
        this.dropFlavors.add(dataFlavor);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.buffer = null;
        this.shadowBuffer = null;
        super.setPreferredSize(preferredSize);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.buffer = null;
        this.shadowBuffer = null;
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.buffer = null;
        this.shadowBuffer = null;
        super.setBounds(r);
    }

    @Override
    public void setSize(Dimension d) {
        this.buffer = null;
        this.shadowBuffer = null;
        super.setSize(d);
    }

    @Override
    public void doAction(GhostActionable src) {
    }

    @Override
    public void setData(Object data) {
        if (this.comp instanceof JTextField) {
            ((JTextField)this.comp).setText(data.toString());
        }
    }

    @Override
    public Object getData() {
        if (this.comp instanceof JTextField) {
            ((JTextField)this.comp).getText();
        }
        return "";
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return UIHelper.getDataForClass(String.class, classObj);
    }

    @Override
    public void createMouseInputAdapter() {
        this.mouseDropAdapter = new GhostMouseInputAdapter(UIRegistry.getGlassPane(), "action", this);
        this.mouseDropAdapter.setPaintPositionMode(GhostGlassPane.ImagePaintMode.ABSOLUTE);
        this.mouseDropAdapter.setDoAnimationOnDrop(false);
        this.addMouseListener(this.mouseDropAdapter);
        this.addMouseMotionListener(this.mouseDropAdapter);
        this.label.addMouseListener(this.mouseDropAdapter);
        this.label.addMouseMotionListener(this.mouseDropAdapter);
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return this.mouseDropAdapter;
    }

    @Override
    public void setActive(boolean isActive) {
    }

    public int getItemWidth() {
        return this.getSize().width + 10;
    }

    public int getItemHeight() {
        return this.getSize().height;
    }

    private void createRenderingHints() {
        if (this.hints == null) {
            this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            try {
                Field declaredField = RenderingHints.class.getDeclaredField("VALUE_TEXT_ANTIALIAS_LCD_HRGB");
                value = declaredField.get(null);
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(InputPanel.class, e);
            }
            this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
        }
    }

    private void renderOffscreen() {
        this.createRenderingHints();
        BufferedImage bgBufImg = this.getBackgroundImageBuffer();
        this.buffer = new BufferedImage(bgBufImg.getWidth(), bgBufImg.getHeight(), 2);
        Graphics2D g2 = this.buffer.createGraphics();
        g2.setRenderingHints(this.hints);
        this.paint(g2);
        g2.setColor(Color.GRAY);
        Rectangle r = this.getBounds();
        g2.drawRect(0, 0, r.width - 1, r.height - 1);
        g2.dispose();
    }

    @Override
    public BufferedImage getBufferedImage() {
        if (this.buffer == null) {
            this.renderOffscreen();
        }
        return this.buffer;
    }

    private BufferedImage getBackgroundImageBuffer() {
        if (this.shadowBuffer == null) {
            this.createRenderingHints();
            ShadowFactory factory = new ShadowFactory(10, 0.17f, Color.BLACK);
            BufferedImage image = new BufferedImage(this.getItemWidth(), this.getItemHeight(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            this.shadowBuffer = factory.createShadow(image);
        }
        return this.shadowBuffer;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return this.dragFlavors;
    }

    public void cleanUp() {
        this.removeAll();
        UIHelper.removeMouseListeners(this.label);
        UIHelper.removeMouseListeners(this);
        if (this.comp instanceof UIValidatable) {
            ((UIValidatable)((Object)this.comp)).cleanUp();
        }
        this.wbtmi = null;
        this.label = null;
        this.comp = null;
        this.mouseDropAdapter.cleanUp();
        this.listeners.clear();
        this.dropFlavors.clear();
        this.dragFlavors.clear();
        this.sizeBufImg = null;
        this.preferredSize = null;
        this.mouseDropAdapter = null;
        this.shadowBuffer = null;
        this.buffer = null;
    }
}

