/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.rstools.ExportFileConfigurationFactory;
import edu.ku.brc.specify.tasks.subpane.wb.CSVImport;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureCSV;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataBase;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureExternalDataIFace;
import edu.ku.brc.specify.tasks.subpane.wb.ConfigureXLS;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportIFace;
import edu.ku.brc.specify.tasks.subpane.wb.DataImportTruncation;
import edu.ku.brc.specify.tasks.subpane.wb.ImportColumnInfo;
import edu.ku.brc.specify.tasks.subpane.wb.XLSImport;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.apache.commons.io.FilenameUtils;

public class ImportDataFileInfo {
    protected static String MODIFIED_IMPORT_DATA = "WB_MODIFIED_IMPORT_DATA";
    protected DataImportIFace importer;
    protected ConfigureExternalDataBase config;

    public boolean load(File file) {
        this.importer = null;
        boolean isValid = false;
        String mimeType = this.getMimeType(file);
        if (mimeType == ExportFileConfigurationFactory.XLS_MIME_TYPE) {
            this.config = new ConfigureXLS(file);
            if (this.config.getStatus() == ConfigureExternalDataIFace.Status.Valid) {
                this.importer = new XLSImport(this.config);
                isValid = true;
            }
        } else if (mimeType == ExportFileConfigurationFactory.CSV_MIME_TYPE) {
            this.config = new ConfigureCSV(file);
            if (this.config.getStatus() == ConfigureExternalDataIFace.Status.Valid) {
                this.importer = new CSVImport(this.config);
                isValid = true;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    protected void showModifiedData() {
        JPanel mainPane;
        if (this.importer.getTruncations().size() > 0) {
            mainPane = new JPanel(new BorderLayout());
            JLabel msg = UIHelper.createLabel(UIRegistry.getResourceString("WB_TRUNCATIONS"));
            msg.setFont(msg.getFont().deriveFont(1));
            mainPane.add((Component)msg, "North");
            Object[] heads = new String[3];
            Object[][] vals = new String[this.importer.getTruncations().size()][3];
            heads[0] = UIRegistry.getResourceString("WB_ROW");
            heads[1] = UIRegistry.getResourceString("WB_COLUMN");
            heads[2] = UIRegistry.getResourceString("WB_TRUNCATED");
            int row = 0;
            for (DataImportTruncation trunc : this.importer.getTruncations()) {
                vals[row][0] = String.valueOf(trunc.getRow());
                vals[row][1] = trunc.getColHeader();
                if (((String)vals[row][1]).equals("")) {
                    vals[row][1] = String.valueOf(trunc.getCol() + 1);
                }
                vals[row++][2] = trunc.getExcluded();
            }
            JTable mods = new JTable(vals, heads);
            mods.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
            mainPane.add((Component)UIHelper.createScrollPane(mods), "Center");
            CustomFrame cwin = new CustomFrame(UIRegistry.getResourceString(MODIFIED_IMPORT_DATA), 5, mainPane);
            cwin.setHelpContext("WorkbenchImportData");
            cwin.setDefaultCloseOperation(2);
            UIHelper.centerAndShow(cwin);
        }
        if (this.importer.getMessages().size() > 0) {
            mainPane = new JPanel(new BorderLayout());
            JTextArea msgs = new JTextArea();
            msgs.setRows(this.importer.getMessages().size());
            for (String msg : this.importer.getMessages()) {
                msgs.append(msg);
                msgs.append("\n");
            }
            mainPane.add((Component)msgs, "Center");
            CustomFrame cwin = new CustomFrame(UIRegistry.getResourceString(MODIFIED_IMPORT_DATA), 5, mainPane);
            cwin.setHelpContext("WorkbenchImportData");
            cwin.setDefaultCloseOperation(2);
            UIHelper.centerAndShow(cwin);
        }
    }

    public DataImportIFace.Status loadData(Workbench workbench) {
        DataImportIFace.Status result = this.importer.getData(workbench);
        if (result == DataImportIFace.Status.Modified) {
            this.showModifiedData();
        }
        return result;
    }

    public Vector<ImportColumnInfo> getColInfo() {
        return this.importer.getConfig().getColInfo();
    }

    private String getMimeType(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName()).toLowerCase();
        if (extension.equalsIgnoreCase("xls")) {
            return ExportFileConfigurationFactory.XLS_MIME_TYPE;
        }
        if (extension.equalsIgnoreCase("csv") || extension.equalsIgnoreCase("txt")) {
            return ExportFileConfigurationFactory.CSV_MIME_TYPE;
        }
        return "";
    }

    public DataImportIFace getImporter() {
        return this.importer;
    }

    public ConfigureExternalDataBase getConfig() {
        return this.config;
    }
}

