/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.specify.tasks.subpane.wb.DataImport;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class ImportColumnInfo
implements Comparable<ImportColumnInfo> {
    protected final Integer colInx;
    protected final ColumnType disciplinee;
    protected final String colName;
    protected final String colTitle;
    protected String data;
    protected String mapToTbl = null;
    protected String mapToFld = null;
    protected int formXCoord = -1;
    protected int formYCoord = -1;
    protected int frmFieldType = 1;
    protected String caption = null;
    protected String frmMetaData = null;
    protected final boolean isSystemCol;

    public ImportColumnInfo(int colInx, ColumnType disciplinee, String colName, String colTitle, String mapToTbl, String mapToFld, String data) {
        this.colInx = colInx;
        this.disciplinee = disciplinee;
        this.colName = colName;
        this.isSystemCol = this.colName.equals(DataImport.GEO_DATA_HEADING) || this.colName.equals(DataImport.IMAGE_PATH_HEADING);
        this.colTitle = colTitle;
        this.caption = colTitle;
        this.mapToTbl = mapToTbl;
        this.mapToFld = mapToFld;
        this.data = data;
    }

    public boolean getIsSystemCol() {
        return this.isSystemCol;
    }

    public String getColName() {
        return this.colName;
    }

    public ColumnType getColType() {
        return this.disciplinee;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Integer getColInx() {
        return this.colInx;
    }

    public String getColTitle() {
        return this.colTitle;
    }

    @Override
    public int compareTo(ImportColumnInfo obj) {
        return this.colInx.compareTo(obj.colInx);
    }

    public String toString() {
        return this.colName;
    }

    public static ColumnType getType(Class<?> type) {
        if (type != null) {
            if (type.equals(Integer.class)) {
                return ColumnType.Integer;
            }
            if (type.equals(Float.class)) {
                return ColumnType.Float;
            }
            if (type.equals(Double.class)) {
                return ColumnType.Double;
            }
            if (type.equals(Short.class)) {
                return ColumnType.Short;
            }
            if (type.equals(Calendar.class) || type.equals(Date.class)) {
                return ColumnType.Date;
            }
            if (type.equals(BigDecimal.class)) {
                return ColumnType.Double;
            }
        }
        return ColumnType.String;
    }

    public String getMapToTbl() {
        return this.mapToTbl;
    }

    public String getMapToFld() {
        return this.mapToFld;
    }

    public void setMapToTbl(String mapToTbl) {
        this.mapToTbl = mapToTbl;
    }

    public void setMapToFld(String mapToFld) {
        this.mapToFld = mapToFld;
    }

    public int getFormXCoord() {
        return this.formXCoord;
    }

    public void setFormXCoord(int formXCoord) {
        this.formXCoord = formXCoord;
    }

    public int getFormYCoord() {
        return this.formYCoord;
    }

    public void setFormYCoord(int formYCoord) {
        this.formYCoord = formYCoord;
    }

    public int getFrmFieldType() {
        return this.frmFieldType;
    }

    public void setFrmFieldType(int frmFieldType) {
        this.frmFieldType = frmFieldType;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getFrmMetaData() {
        return this.frmMetaData;
    }

    public void setFrmMetaData(String frmMetaData) {
        this.frmMetaData = frmMetaData;
    }

    public static enum ColumnType {
        Integer,
        Float,
        Double,
        Short,
        Boolean,
        Date,
        String;

    }
}

