/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import edu.ku.brc.helpers.ImageFilter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.lang.StringUtils;

public abstract class ImageTransferable
extends TransferHandler {
    private final String MIME_TYPE = "text/uri-list";
    private ImageFilter filter = new ImageFilter();

    protected abstract void processImages(Vector<File> var1);

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        DataFlavor[] dataFlavorArray = transferFlavors;
        int n = transferFlavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (df.getHumanPresentableName().equals("text/uri-list") && df.getRepresentationClass() == String.class) {
                return true;
            }
            ++n2;
        }
        System.out.println("canImport1: false");
        return false;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] flavors;
        Transferable trans = support.getTransferable();
        DataFlavor[] dataFlavorArray = flavors = trans.getTransferDataFlavors();
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            if (df.getHumanPresentableName().equals("text/uri-list") && df.getRepresentationClass() == String.class) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Vector<File> fileList = new Vector<File>();
        try {
            DataFlavor[] flavors;
            Transferable trans = support.getTransferable();
            DataFlavor[] dataFlavorArray = flavors = trans.getTransferDataFlavors();
            int n = flavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor df = dataFlavorArray[n2];
                if (df.getHumanPresentableName().equals("text/uri-list") && df.getRepresentationClass() == String.class) {
                    String[] filePaths;
                    String uris = (String)trans.getTransferData(df);
                    String[] stringArray = filePaths = StringUtils.split((String)uris, (String)"\r\n");
                    int n3 = filePaths.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String path = stringArray[n4];
                        URI uri = URI.create(path);
                        File f = new File(uri);
                        if (this.filter.isImageFile(path)) {
                            fileList.add(f);
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fileList.size() > 0) {
            this.processImages(fileList);
            return true;
        }
        return false;
    }
}

