/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;

public class ImageImportFrame
extends CustomFrame {
    protected WorkbenchPaneSS wbPane;
    protected Workbench workbench;
    protected boolean allowCloseWindow = true;
    protected JRadioButton oneImagePerRow;

    public ImageImportFrame(final WorkbenchPaneSS wbPane, Workbench workbench) {
        super("Import Images", 1, null);
        this.setOkLabel(UIRegistry.getResourceString("CLOSE"));
        this.wbPane = wbPane;
        this.workbench = workbench;
        this.setIconImage(IconManager.getImage("AppIcon").getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ImageImportFrame.this.allowCloseWindow) {
                    wbPane.toggleImageFrameVisible();
                }
            }
        });
        HelpMgr.setHelpID(this, "WorkbenchWorkingWithImages");
    }

    @Override
    public void createUI() {
        super.createUI();
        PanelBuilder builder = new PanelBuilder(new FormLayout("p, f:p:g", "p,2px,p,8px,p,8px,p"));
        CellConstraints cc = new CellConstraints();
        this.oneImagePerRow = new JRadioButton("One Image Per Row");
        JRadioButton allImagesPerRow = new JRadioButton("All Images In One Row");
        ButtonGroup grp = new ButtonGroup();
        grp.add(allImagesPerRow);
        grp.add(this.oneImagePerRow);
        JButton fileDlg = UIHelper.createI18NButton("FIles...");
        builder.add((Component)this.oneImagePerRow, cc.xyw(1, 1, 2));
        builder.add((Component)allImagesPerRow, cc.xyw(1, 3, 2));
        builder.addSeparator("", cc.xyw(1, 5, 2));
        builder.add((Component)fileDlg, cc.xy(1, 7));
        builder.setDefaultDialogBorder();
        this.contentPanel = builder.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.oneImagePerRow.setSelected(true);
        fileDlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((WorkbenchTask)ImageImportFrame.this.wbPane.getTask()).importCardImages(ImageImportFrame.this.workbench, ImageImportFrame.this.isOneImagePerRow());
            }
        });
    }

    public boolean isOneImagePerRow() {
        return this.oneImagePerRow.isSelected();
    }
}

