/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.tasks.subpane.wb;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.ImageFilter;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.datamodel.WorkbenchRow;
import edu.ku.brc.specify.datamodel.WorkbenchRowImage;
import edu.ku.brc.specify.tasks.WorkbenchTask;
import edu.ku.brc.specify.tasks.subpane.wb.WorkbenchPaneSS;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.ChooseFromListDlg;
import edu.ku.brc.ui.DefaultModifiableListModel;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.thumbnails.ImageThumbnailGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ImageFrame
extends JFrame
implements PropertyChangeListener {
    private static final Logger log = Logger.getLogger(ImageFrame.class);
    protected JProgressBar progress = UIHelper.createProgressBar();
    protected WorkbenchRow row;
    protected WorkbenchPaneSS wbPane;
    protected int imageIndex = -1;
    protected Workbench workbench;
    protected WorkbenchTask workbenchTask;
    protected JLabel cardImageLabel = UIHelper.createLabel("", 0);
    protected JPanel noCardImageMessagePanel;
    protected JPanel noRowSelectedMessagePanel;
    protected JButton loadImgBtn;
    protected JPanel mainPane;
    protected JScrollPane scrollPane;
    protected JStatusBar statusBar;
    protected ThumbnailTray tray;
    protected JMenu viewMenu;
    protected JMenu imageMenu;
    protected JMenuItem closeMI;
    protected JMenuItem replaceMI;
    protected JMenuItem deleteMI;
    protected JMenuItem addMI;
    protected JCheckBoxMenuItem alwaysOnTopMI;
    protected JRadioButtonMenuItem origMI;
    protected JRadioButtonMenuItem reduceMI;
    protected ImageIcon defaultThumbIcon;
    protected ImageThumbnailGenerator thumbnailer;
    protected boolean allowCloseWindow;
    protected static int REDUCED_SIZE = -1;
    protected static int FULL_SIZE = 1;
    protected Hashtable<Integer, Integer> rowToImageSizeHash = new Hashtable();

    public ImageFrame(int mapSize, final WorkbenchPaneSS wbPane, Workbench workbench, Taskable task, boolean isReadOnly) {
        this.wbPane = wbPane;
        this.workbench = workbench;
        try {
            this.workbenchTask = (WorkbenchTask)task;
        }
        catch (ClassCastException e) {
            this.workbenchTask = null;
        }
        this.allowCloseWindow = true;
        this.defaultThumbIcon = IconManager.getIcon("image", IconManager.IconSize.Std32);
        this.setIconImage(IconManager.getImage("AppIcon").getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ImageFrame.this.allowCloseWindow) {
                    wbPane.toggleImageFrameVisible();
                }
            }
        });
        Dimension minSize = new Dimension(mapSize, mapSize);
        this.cardImageLabel.setHorizontalTextPosition(0);
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g,c:p,f:p:g", "f:p:g,p,5px,p,f:p:g"));
        CellConstraints cc = new CellConstraints();
        this.loadImgBtn = UIHelper.createButton(UIRegistry.getResourceString("WB_LOAD_NEW_IMAGE"));
        builder.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("WB_NO_IMAGE_ROW"), 0), cc.xy(2, 2));
        builder.add((Component)this.loadImgBtn, cc.xy(2, 4));
        this.loadImgBtn.setVisible(!isReadOnly);
        this.noCardImageMessagePanel = builder.getPanel();
        this.noCardImageMessagePanel.setPreferredSize(minSize);
        this.noCardImageMessagePanel.setSize(minSize);
        builder = new PanelBuilder(new FormLayout("f:p:g,c:p,f:p:g", "f:p:g,c:p,f:p:g"));
        builder.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("WB_NO_ROW_SELECTED"), 0), cc.xy(2, 2));
        this.noRowSelectedMessagePanel = builder.getPanel();
        this.noRowSelectedMessagePanel.setPreferredSize(minSize);
        this.noRowSelectedMessagePanel.setSize(minSize);
        this.mainPane = new JPanel(new BorderLayout());
        this.mainPane.setSize(minSize);
        this.mainPane.setPreferredSize(minSize);
        this.mainPane.setMinimumSize(minSize);
        this.mainPane.add((Component)this.cardImageLabel, "Center");
        this.scrollPane = new JScrollPane(this.mainPane, 20, 30);
        this.statusBar = new JStatusBar();
        this.thumbnailer = new ImageThumbnailGenerator();
        this.thumbnailer.setMaxHeight(32);
        this.thumbnailer.setMaxWidth(32);
        this.thumbnailer.setQuality(1.0f);
        this.tray = new ThumbnailTray();
        this.tray.getModel().removeAllElements();
        this.tray.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ImageFrame.this.setImageIndex(ImageFrame.this.tray.getSelectedIndex());
            }
        });
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)this.tray, "Center");
        southPanel.add((Component)this.statusBar, "South");
        JPanel basePanel = new JPanel();
        basePanel.setLayout(new BorderLayout());
        basePanel.add((Component)this.scrollPane, "Center");
        basePanel.add((Component)southPanel, "South");
        this.setContentPane(basePanel);
        JMenuBar menuBar = new JMenuBar();
        String title = "FileMenu";
        String mneu = "FileMneu";
        JMenu fileMenu = UIHelper.createLocalizedMenu(menuBar, title, mneu);
        title = "WB_IMPORT_CARDS_TO_DATASET";
        mneu = "WB_IMPORT_CARDS_MNEU";
        if (!isReadOnly) {
            JMenuItem importImagesMI = UIHelper.createLocalizedMenuItem(fileMenu, title, mneu, "", true, null);
            importImagesMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ImageFrame.this.importImages();
                }
            });
        }
        title = "ImageFrame.CLOSE";
        mneu = "ImageFrame.CloseMneu";
        this.closeMI = UIHelper.createLocalizedMenuItem(fileMenu, title, mneu, "", true, null);
        this.closeMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageFrame.this.setVisible(false);
            }
        });
        title = "ImageFrame.View";
        mneu = "ImageFrame.ViewMneu";
        this.viewMenu = UIHelper.createLocalizedMenu(menuBar, title, mneu);
        this.reduceMI = UIHelper.createRadioButtonMenuItem(this.viewMenu, "WB_REDUCED_SIZE", "ImageFrame.ReducedSizeMneu", "", true, null);
        this.reduceMI.setSelected(true);
        this.reduceMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageFrame.this.row == null) {
                    return;
                }
                ImageFrame.this.rowToImageSizeHash.put(ImageFrame.this.row.hashCode(), REDUCED_SIZE);
                ImageFrame.this.showImage();
            }
        });
        this.origMI = UIHelper.createRadioButtonMenuItem(this.viewMenu, "WB_ORIG_SIZE", "ImageFrame.OrigMneu", "", true, null);
        this.origMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageFrame.this.row == null) {
                    return;
                }
                ImageFrame.this.rowToImageSizeHash.put(ImageFrame.this.row.hashCode(), FULL_SIZE);
                ImageFrame.this.showImage();
            }
        });
        ButtonGroup btnGrp = new ButtonGroup();
        btnGrp.add(this.reduceMI);
        btnGrp.add(this.origMI);
        this.viewMenu.addSeparator();
        this.alwaysOnTopMI = UIHelper.createCheckBoxMenuItem(this.viewMenu, "WB_ALWAYS_ON_TOP", null, "", true, null);
        this.alwaysOnTopMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageFrame.this.setAlwaysOnTop(ImageFrame.this.alwaysOnTopMI.isSelected());
            }
        });
        this.addPropertyChangeListener("alwaysOnTop", this);
        if (!isReadOnly) {
            ActionListener deleteImg = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ImageFrame.this.deleteImage();
                }
            };
            ActionListener replaceImg = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ImageFrame.this.replaceImage();
                }
            };
            ActionListener addImg = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ImageFrame.this.addImages();
                }
            };
            title = "ImageFrame.Image";
            mneu = "ImageFrame.ImageMneu";
            this.imageMenu = UIHelper.createLocalizedMenu(menuBar, title, mneu);
            title = "WB_ADD_IMG";
            mneu = "WB_ADD_IMG_MNEM";
            this.addMI = UIHelper.createLocalizedMenuItem(this.imageMenu, title, mneu, "", true, addImg);
            title = "WB_REPLACE_IMG";
            mneu = "WB_REPLACE_IMG_MNEU";
            this.replaceMI = UIHelper.createLocalizedMenuItem(this.imageMenu, title, mneu, "", true, replaceImg);
            title = "WB_DEL_IMG_LINK";
            mneu = "WB_DEL_IMG_LINK_MNEU";
            this.deleteMI = UIHelper.createLocalizedMenuItem(this.imageMenu, title, mneu, "", true, deleteImg);
            this.loadImgBtn.addActionListener(addImg);
        }
        JMenu helpMenu = new JMenu(UIRegistry.getResourceString("HELP"));
        menuBar.add(HelpMgr.createHelpMenuItem(helpMenu, UIRegistry.getResourceString("WB_IMAGE_WINDOW")));
        this.enableMenus(false);
        this.setJMenuBar(menuBar);
        this.pack();
        HelpMgr.setHelpID(this, "WorkbenchWorkingWithImages");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("alwaysOnTop") && evt.getSource() == this) {
            this.alwaysOnTopMI.setSelected(this.isAlwaysOnTop());
        }
    }

    public void setWorkbench(Workbench workbench) {
        this.workbench = workbench;
    }

    protected void importImages() {
        if (this.workbenchTask != null) {
            this.workbenchTask.importCardImages(this.workbench, true);
        }
    }

    public void setStatusBarText(String text) {
        this.statusBar.setText(text);
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public void setImageIndex(int imageIndex) {
        this.imageIndex = imageIndex;
        this.tray.setSelectedIndex(imageIndex);
        this.showImage();
    }

    protected void showImage() {
        if (this.row == null) {
            return;
        }
        Set<WorkbenchRowImage> rowImages = this.row.getWorkbenchRowImages();
        if (rowImages == null || rowImages.size() == 0) {
            this.noImagesLinked();
            return;
        }
        if (this.imageIndex < 0) {
            this.imageIndex = 0;
            this.tray.setSelectedIndex(this.imageIndex);
        } else if (this.imageIndex > rowImages.size() - 1) {
            this.imageIndex = rowImages.size() - 1;
            this.tray.setSelectedIndex(this.imageIndex);
        }
        WorkbenchRowImage rowImage = this.row.getRowImage(this.imageIndex);
        if (rowImage == null) {
            rowImage = rowImages.iterator().next();
            this.imageIndex = 0;
            this.tray.setSelectedIndex(this.imageIndex);
            this.statusBar.setWarningMessage("Unable to locate an image with the proper index.  Showing first image.");
        }
        String fullFilePath = rowImage.getCardImageFullPath();
        String filename = FilenameUtils.getName((String)fullFilePath);
        this.setTitle(String.valueOf(String.format(UIRegistry.getResourceString("WB_IMAGE_X_OF_Y"), this.imageIndex + 1, rowImages.size())) + (filename != null ? ": " + filename : ""));
        this.setStatusBarText(fullFilePath);
        ImageIcon image = null;
        Integer lastDisplayedSize = this.rowToImageSizeHash.get(this.row.hashCode());
        if (lastDisplayedSize == null || lastDisplayedSize == REDUCED_SIZE) {
            image = rowImage.getReducedImage();
            this.reduceMI.setSelected(true);
        } else {
            image = rowImage.getFullSizeImage();
            this.origMI.setSelected(true);
        }
        this.cardImageLabel.setIcon(image);
        if (image == null) {
            this.statusBar.setErrorMessage("Unable to load image");
        } else {
            this.mainPane.remove(this.noRowSelectedMessagePanel);
            this.mainPane.remove(this.noCardImageMessagePanel);
            this.mainPane.remove(this.cardImageLabel);
            this.mainPane.add(this.cardImageLabel);
            int w = image.getIconWidth();
            int h = image.getIconHeight();
            this.cardImageLabel.setText(null);
            this.cardImageLabel.setSize(w, h);
            this.mainPane.setSize(w, h);
            this.mainPane.setPreferredSize(new Dimension(w, h));
            this.enableMenus(true);
            this.mainPane.validate();
            this.mainPane.repaint();
        }
    }

    protected void noImagesLinked() {
        this.mainPane.remove(this.noRowSelectedMessagePanel);
        this.mainPane.remove(this.noCardImageMessagePanel);
        this.mainPane.remove(this.cardImageLabel);
        this.mainPane.add(this.noCardImageMessagePanel);
        this.tray.getModel().removeAllElements();
        this.setTitle(UIRegistry.getResourceString("WB_NO_IMAGES_LINKED"));
        this.setStatusBarText(null);
        this.enableMenus(false);
        Dimension prefSize = this.noCardImageMessagePanel.getPreferredSize();
        this.mainPane.setSize(prefSize);
        this.mainPane.setPreferredSize(prefSize);
        this.validate();
        this.repaint();
    }

    protected void noRowSelected() {
        this.mainPane.remove(this.noRowSelectedMessagePanel);
        this.mainPane.remove(this.noCardImageMessagePanel);
        this.mainPane.remove(this.cardImageLabel);
        this.mainPane.add(this.noRowSelectedMessagePanel);
        this.tray.getModel().removeAllElements();
        this.setTitle(UIRegistry.getResourceString("WB_NO_ROW_SELECTED"));
        this.setStatusBarText(null);
        this.enableMenus(false);
        Dimension prefSize = this.noRowSelectedMessagePanel.getPreferredSize();
        this.mainPane.setSize(prefSize);
        this.mainPane.setPreferredSize(prefSize);
        this.validate();
        this.repaint();
    }

    protected void enableMenus(boolean enable) {
        if (this.addMI != null) {
            this.addMI.setEnabled(enable);
        }
        if (this.deleteMI != null) {
            this.deleteMI.setEnabled(enable);
        }
        if (this.replaceMI != null) {
            this.replaceMI.setEnabled(enable);
        }
        this.origMI.setEnabled(enable);
        this.reduceMI.setEnabled(enable);
    }

    public static boolean testImageFile(String srcFile) {
        try {
            byte[] bytes = GraphicsUtils.readImage(srcFile);
            if (bytes != null) {
                ImageIcon testIcon = new ImageIcon(bytes);
                return testIcon.getIconHeight() > 0 && testIcon.getIconWidth() > 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    protected String getAttachToTableName() {
        String attachToTableName = null;
        List<UploadTable> attachableTbls = this.wbPane.getAttachableTables();
        if (attachableTbls != null && attachableTbls.size() != 0) {
            if (attachableTbls.size() == 1) {
                attachToTableName = attachableTbls.get(0).getTable().getName();
            } else {
                Vector<Pair<String, String>> titleNamePairs = new Vector<Pair<String, String>>();
                Vector<String> titles = new Vector<String>();
                for (UploadTable ut : attachableTbls) {
                    String tblTitle;
                    String string = tblTitle = ut.getTblClass().equals(Agent.class) ? ut.toString() : ut.getTblTitle();
                    if (!titles.contains(tblTitle)) {
                        // empty if block
                    }
                    String tblSpec = ut.getTable().getName();
                    if (ut.getTblClass().equals(Agent.class) && ut.getRelationship() != null) {
                        tblSpec = String.valueOf(tblSpec) + "." + ut.getRelationship().getRelatedField().getTable().getTableInfo().getName();
                    }
                    titleNamePairs.add(new Pair<String, String>(tblTitle, tblSpec));
                    titles.add(tblTitle);
                }
                ChooseFromListDlg dlg = new ChooseFromListDlg((Frame)UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("ImageFrame.ChooseAttachTableDlgTitle"), titles);
                UIHelper.centerAndShow(dlg);
                if (!dlg.isCancelled()) {
                    for (Pair pair : titleNamePairs) {
                        if (!((String)pair.getFirst()).equals(dlg.getSelectedObject())) continue;
                        attachToTableName = (String)pair.getSecond();
                        break;
                    }
                } else {
                    attachToTableName = "";
                }
                dlg.dispose();
            }
        }
        return attachToTableName;
    }

    public void addImages() {
        UsageTracker.incrUsageCount("WB.AddWBRowImage");
        final WorkbenchRow wbRow = this.row;
        final String attachToTableName = this.getAttachToTableName();
        if ("".equals(attachToTableName)) {
            return;
        }
        final File[] imageFiles = this.askUserForImageFiles();
        if (imageFiles == null || imageFiles.length == 0) {
            return;
        }
        File[] fileArray = imageFiles;
        int n = imageFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!ImageFrame.testImageFile(f.getAbsolutePath())) {
                JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), String.format(UIRegistry.getResourceString("WB_WRONG_IMAGE_TYPE_OR_CORRUPTED_IMAGE"), f.getAbsolutePath()), UIRegistry.getResourceString("WARNING"), 0);
                return;
            }
            ++n2;
        }
        this.allowCloseWindow = false;
        this.setEnabled(false);
        log.debug((Object)("addImages: " + imageFiles.length + " files selected"));
        this.loadImgBtn.setEnabled(false);
        SwingWorker loadImagesTask = new SwingWorker(){
            private List<WorkbenchRowImage> rowImagesNeedingThumbnails = new Vector<WorkbenchRowImage>();

            @Override
            public Object construct() {
                Vector<Integer> newIndexes = new Vector<Integer>();
                int i = 0;
                while (i < imageFiles.length) {
                    final int index = i;
                    File f = imageFiles[i];
                    try {
                        int newIndex = wbRow.addImage(f);
                        if (newIndex > -1) {
                            newIndexes.add(newIndex);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    UIRegistry.writeGlassPaneMsg(String.format(UIRegistry.getResourceString("WB_ADDING_IMAGE_X_OF_Y"), index + 1, imageFiles.length), 24);
                                }
                            });
                            WorkbenchRowImage rowImage = ImageFrame.this.row.getRowImage(newIndex);
                            rowImage.setAttachToTableName(attachToTableName);
                            this.rowImagesNeedingThumbnails.add(rowImage);
                            ImageFrame.this.wbPane.setChanged(true);
                        }
                    }
                    catch (IOException e) {
                        ImageFrame.this.statusBar.setErrorMessage("Exception while adding a new image", e);
                    }
                    ++i;
                }
                Collections.sort(newIndexes);
                return newIndexes;
            }

            @Override
            public void finished() {
                ImageFrame.this.loadImgBtn.setEnabled(true);
                Object retVal = this.get();
                if (retVal != null && retVal instanceof List && ((List)retVal).size() > 0) {
                    Vector newIndexes = (Vector)retVal;
                    int lowestNewIndex = (Integer)newIndexes.get(0);
                    int i = 0;
                    while (i < newIndexes.size()) {
                        ImageFrame.this.tray.getModel().add(ImageFrame.this.defaultThumbIcon);
                        ++i;
                    }
                    ImageFrame.this.wbPane.setChanged(true);
                    if (lowestNewIndex < ImageFrame.this.row.getWorkbenchRowImages().size()) {
                        ImageFrame.this.imageIndex = lowestNewIndex;
                        ImageFrame.this.tray.setSelectedIndex(ImageFrame.this.imageIndex);
                        ImageFrame.this.showImage();
                    }
                    ImageFrame.this.generateThumbnailsInBackground(this.rowImagesNeedingThumbnails);
                }
                UIRegistry.clearGlassPaneMsg();
                ImageFrame.this.setEnabled(true);
                ImageFrame.this.allowCloseWindow = true;
                ImageFrame.this.wbPane.repaint();
            }
        };
        loadImagesTask.start();
    }

    public void replaceImage() {
        UsageTracker.incrUsageCount("WB.EditWBRowImage");
        File imageFile = this.askUserForImageFile();
        if (imageFile == null) {
            return;
        }
        log.debug((Object)("replaceImage: " + imageFile.getAbsolutePath()));
        try {
            this.row.setImage(this.imageIndex, imageFile);
            this.wbPane.setChanged(true);
            WorkbenchRowImage rowImage = this.row.getRowImage(this.imageIndex);
            Vector<WorkbenchRowImage> needNewThumbs = new Vector<WorkbenchRowImage>();
            needNewThumbs.add(rowImage);
            this.generateThumbnailsInBackground(needNewThumbs);
            this.showImage();
        }
        catch (IOException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImageFrame.class, e);
            this.statusBar.setErrorMessage("Exception while replacing image", e);
        }
    }

    public void deleteImage() {
        UsageTracker.incrUsageCount("WB.DeleteWBRowImage");
        this.row.deleteImage(this.imageIndex);
        this.tray.getModel().remove(this.imageIndex);
        --this.imageIndex;
        this.tray.setSelectedIndex(this.imageIndex);
        this.showImage();
        this.wbPane.setChanged(true);
        this.wbPane.repaint();
    }

    protected File askUserForImageFile() {
        String fullPath;
        ImageFilter imageFilter = new ImageFilter();
        JFileChooser fileChooser = new JFileChooser(WorkbenchTask.getDefaultDirPath("wb.imagepath"));
        fileChooser.setFileFilter(imageFilter);
        fileChooser.setDialogTitle(UIRegistry.getResourceString("WB_CHOOSE_IMAGE"));
        fileChooser.setFileSelectionMode(0);
        int userAction = fileChooser.showOpenDialog(this);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.put("wb.imagepath", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (userAction == 0 && imageFilter.isImageFile(fullPath = fileChooser.getSelectedFile().getAbsolutePath())) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    protected File[] askUserForImageFiles() {
        ImageFilter imageFilter = new ImageFilter();
        JFileChooser fileChooser = new JFileChooser(WorkbenchTask.getDefaultDirPath("wb.imagepath"));
        fileChooser.setFileFilter(imageFilter);
        fileChooser.setDialogTitle(UIRegistry.getResourceString("WB_CHOOSE_IMAGES"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        int userAction = fileChooser.showOpenDialog(this);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.put("wb.imagepath", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (userAction == 0) {
            return fileChooser.getSelectedFiles();
        }
        return null;
    }

    public void setRow(WorkbenchRow row) {
        if (row != null && this.row == row) {
            return;
        }
        this.row = row;
        if (row == null) {
            this.noRowSelected();
            return;
        }
        this.refreshImages();
    }

    public void refreshImages() {
        this.tray.getModel().removeAllElements();
        if (this.row != null) {
            Set<WorkbenchRowImage> rowImages = this.row.getWorkbenchRowImages();
            int i = 0;
            while (i < rowImages.size()) {
                this.tray.getModel().add(this.defaultThumbIcon);
                ++i;
            }
            Vector<WorkbenchRowImage> rowImagesNeedingThumbnails = new Vector<WorkbenchRowImage>();
            for (WorkbenchRowImage img : rowImages) {
                ImageIcon thumb = img.getThumbnail();
                if (thumb != null) {
                    this.tray.getModel().set(img.getImageOrder(), (ImageIcon)thumb);
                    continue;
                }
                log.debug((Object)("Workbench row image is missing its thumbnail.  Adding it to the list of row images for thumbnail generation work.  " + img));
                rowImagesNeedingThumbnails.add(img);
            }
            if (rowImagesNeedingThumbnails.size() > 0) {
                this.generateThumbnailsInBackground(rowImagesNeedingThumbnails);
            }
            this.imageIndex = 0;
            this.tray.setSelectedIndex(this.imageIndex);
            this.showImage();
        }
    }

    protected ImageIcon generateThumbnail(WorkbenchRowImage rowImage) throws IOException {
        File orig;
        byte[] origData;
        if (this.thumbnailer != null && (origData = GraphicsUtils.readImage(orig = new File(rowImage.getCardImageFullPath()))) != null) {
            byte[] thumbData = this.thumbnailer.generateThumbnail(origData, true);
            return new ImageIcon(thumbData);
        }
        return null;
    }

    protected void generateThumbnailsInBackground(final List<WorkbenchRowImage> rowImages) {
        Collections.sort(rowImages);
        Thread thumbGenTask = new Thread(){

            @Override
            public void run() {
                WorkbenchRowImage[] imgs = new WorkbenchRowImage[rowImages.size()];
                rowImages.toArray(imgs);
                WorkbenchRowImage[] workbenchRowImageArray = imgs;
                int n = imgs.length;
                int n2 = 0;
                while (n2 < n) {
                    WorkbenchRowImage rowImage;
                    final WorkbenchRowImage ri = rowImage = workbenchRowImageArray[n2];
                    try {
                        final ImageIcon thumb = ImageFrame.this.generateThumbnail(rowImage);
                        rowImage.setThumbnail(thumb);
                        Runnable updateTrayUI = new Runnable(){

                            @Override
                            public void run() {
                                log.info((Object)("Thumbnail generation complete.  Updating the UI.  " + ri));
                                if ((this).ImageFrame.this.row == ri.getWorkbenchRow()) {
                                    (this).ImageFrame.this.tray.getModel().set(ri.getImageOrder(), (ImageIcon)thumb);
                                    (this).ImageFrame.this.tray.repaint();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(updateTrayUI);
                    }
                    catch (IOException e) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ImageFrame.class, e);
                        log.warn((Object)("Failed to generate a thumbnail for " + rowImage.getCardImageFullPath()), (Throwable)e);
                    }
                    ++n2;
                }
            }
        };
        thumbGenTask.setName("GenThumbs");
        thumbGenTask.setDaemon(true);
        thumbGenTask.setPriority(1);
        thumbGenTask.start();
    }

    @Override
    public void setVisible(boolean b) {
        this.row = null;
        this.cardImageLabel.setIcon(null);
        this.cardImageLabel.setText(null);
        super.setVisible(b);
    }

    public void cleanUp() {
        this.setJMenuBar(null);
        this.removeAll();
        this.progress = null;
        this.row = null;
        this.wbPane = null;
        this.workbench = null;
        this.workbenchTask = null;
        this.defaultThumbIcon = null;
        this.mainPane = null;
        this.scrollPane = null;
        this.statusBar = null;
        this.tray = null;
        this.thumbnailer = null;
        this.setIconImage(null);
    }

    class ThumbnailTray
    extends JPanel {
        protected JList listWidget;
        protected DefaultModifiableListModel<Icon> listModel = new DefaultModifiableListModel();
        protected JScrollPane listScrollPane;
        protected int minHeight = 64;

        public ThumbnailTray() {
            DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof Icon) {
                        l.setText(null);
                        l.setIcon((Icon)value);
                    }
                    return l;
                }
            };
            this.listWidget = new JList<Icon>(this.listModel);
            this.listWidget.setCellRenderer(renderer);
            this.listWidget.setLayoutOrientation(2);
            this.listWidget.setVisibleRowCount(1);
            this.listWidget.setSelectionMode(0);
            JPanel listPanel = new JPanel();
            listPanel.setBackground(this.listWidget.getBackground());
            listPanel.setLayout(new BoxLayout(listPanel, 2));
            listPanel.add(Box.createHorizontalGlue());
            listPanel.add(this.listWidget);
            listPanel.add(Box.createHorizontalGlue());
            this.listScrollPane = new JScrollPane(listPanel, 21, 32);
            this.setLayout(new BorderLayout());
            this.add((Component)this.listScrollPane, "Center");
        }

        public DefaultModifiableListModel<Icon> getModel() {
            return this.listModel;
        }

        public synchronized void setFixedCellHeight(int height) {
            this.listWidget.setFixedCellHeight(height);
        }

        @Override
        public Dimension getPreferredSize() {
            int height = this.minHeight;
            Dimension d = super.getPreferredSize();
            if ((int)d.getHeight() > height) {
                height = (int)d.getHeight();
            }
            return new Dimension(this.getWidth(), height);
        }

        public int getSelectedIndex() {
            return this.listWidget.getSelectedIndex();
        }

        public void setSelectedIndex(int index) {
            if (ImageFrame.this.row == null || index < 0 || index > ImageFrame.this.row.getWorkbenchRowImages().size() - 1) {
                return;
            }
            this.listWidget.setSelectedIndex(index);
            Rectangle cellBounds = this.listWidget.getUI().getCellBounds(this.listWidget, index, index);
            if (cellBounds != null) {
                this.listWidget.scrollRectToVisible(cellBounds);
            }
        }

        public void addListSelectionListener(ListSelectionListener listener) {
            this.listWidget.addListSelectionListener(listener);
        }

        public void removeListSelectionListener(ListSelectionListener listener) {
            this.listWidget.removeListSelectionListener(listener);
        }
    }
}

